/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.indexing;

import java.io.IOException;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.jsdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.wst.jsdt.internal.core.index.Index;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IndexManager;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IndexRequest;
import org.eclipse.wst.jsdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.wst.jsdt.internal.core.search.indexing.SaveIndex;
import org.eclipse.wst.jsdt.internal.core.search.processing.JobManager;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class IndexBinaryFolder
extends IndexRequest {
    IContainer folder;

    public IndexBinaryFolder(IContainer iContainer, IndexManager indexManager) {
        super(iContainer.getFullPath(), indexManager);
        this.folder = iContainer;
    }

    public boolean equals(Object object) {
        if (object instanceof IndexBinaryFolder) {
            return this.folder.equals((Object)((IndexBinaryFolder)object).folder);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(IProgressMonitor iProgressMonitor) {
        if (this.isCancelled) return true;
        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            return true;
        }
        if (!this.folder.isAccessible()) {
            return true;
        }
        Index index = this.manager.getIndexForUpdate(this.containerPath, true, true);
        if (index == null) {
            return true;
        }
        ReadWriteMonitor readWriteMonitor = index.monitor;
        if (readWriteMonitor == null) {
            return true;
        }
        try {
            block23: {
                try {
                    readWriteMonitor.enterRead();
                    String[] stringArray = index.queryDocumentNames("");
                    int n = stringArray == null ? 0 : stringArray.length;
                    final SimpleLookupTable simpleLookupTable = new SimpleLookupTable(n == 0 ? 33 : n + 11);
                    if (stringArray == null) {
                        this.folder.accept(new IResourceProxyVisitor(){

                            public boolean visit(IResourceProxy iResourceProxy) {
                                if (IndexBinaryFolder.this.isCancelled) {
                                    return false;
                                }
                                if (iResourceProxy.getType() == 1) {
                                    if (org.eclipse.wst.jsdt.internal.compiler.util.Util.isClassFileName(iResourceProxy.getName())) {
                                        IFile iFile = (IFile)iResourceProxy.requestResource();
                                        String string = Util.relativePath(iFile.getFullPath(), IndexBinaryFolder.this.containerPath.segmentCount());
                                        simpleLookupTable.put(string, iFile);
                                    }
                                    return false;
                                }
                                return true;
                            }
                        }, 0);
                    } else {
                        int n2 = 0;
                        while (true) {
                            if (n2 >= n) {
                                final long l = index.getIndexFile().lastModified();
                                this.folder.accept(new IResourceProxyVisitor(){

                                    public boolean visit(IResourceProxy iResourceProxy) throws CoreException {
                                        if (IndexBinaryFolder.this.isCancelled) {
                                            return false;
                                        }
                                        if (iResourceProxy.getType() == 1) {
                                            IFile iFile;
                                            URI uRI;
                                            if (org.eclipse.wst.jsdt.internal.compiler.util.Util.isClassFileName(iResourceProxy.getName()) && (uRI = (iFile = (IFile)iResourceProxy.requestResource()).getLocationURI()) != null) {
                                                String string;
                                                simpleLookupTable.put(string, simpleLookupTable.get(string = Util.relativePath(iFile.getFullPath(), IndexBinaryFolder.this.containerPath.segmentCount())) == null || l < EFS.getStore((URI)uRI).fetchInfo().getLastModified() ? iFile : "OK");
                                            }
                                            return false;
                                        }
                                        return true;
                                    }
                                }, 0);
                                break;
                            }
                            simpleLookupTable.put(stringArray[n2], "DELETED");
                            ++n2;
                        }
                    }
                    Object[] objectArray = simpleLookupTable.keyTable;
                    Object[] objectArray2 = simpleLookupTable.valueTable;
                    int n3 = 0;
                    int n4 = objectArray.length;
                    while (true) {
                        if (n3 >= n4) {
                            this.manager.request(new SaveIndex(this.containerPath, this.manager));
                            break block23;
                        }
                        String string = (String)objectArray[n3];
                        if (string != null) {
                            if (this.isCancelled) {
                                break;
                            }
                            Object object = objectArray2[n3];
                            if (object != "OK") {
                                if (object == "DELETED") {
                                    this.manager.remove(string, this.containerPath);
                                } else {
                                    this.manager.addBinary((IFile)object, this.containerPath);
                                }
                            }
                        }
                        ++n3;
                    }
                }
                catch (CoreException coreException) {
                    if (JobManager.VERBOSE) {
                        Util.verbose("-> failed to index " + this.folder + " because of the following exception:", System.err);
                        coreException.printStackTrace();
                    }
                    this.manager.removeIndex(this.containerPath);
                }
                catch (IOException iOException) {
                    if (JobManager.VERBOSE) {
                        Util.verbose("-> failed to index " + this.folder + " because of the following exception:", System.err);
                        iOException.printStackTrace();
                    }
                    this.manager.removeIndex(this.containerPath);
                }
                Object var13_17 = null;
                readWriteMonitor.exitRead();
                return false;
            }
            Object var13_19 = null;
            readWriteMonitor.exitRead();
            return true;
        }
        catch (Throwable throwable) {
            Object var13_18 = null;
            readWriteMonitor.exitRead();
            throw throwable;
        }
    }

    public int hashCode() {
        return this.folder.hashCode();
    }

    protected Integer updatedIndexState() {
        return IndexManager.REBUILDING_STATE;
    }

    public String toString() {
        return "indexing binary folder " + this.folder.getFullPath();
    }
}

