/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.matching;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.Argument;
import org.eclipse.wst.jsdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.JavadocMessageSend;
import org.eclipse.wst.jsdt.internal.compiler.ast.MessageSend;
import org.eclipse.wst.jsdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.core.search.matching.ConstructorPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.MatchLocator;
import org.eclipse.wst.jsdt.internal.core.search.matching.MatchingNodeSet;
import org.eclipse.wst.jsdt.internal.core.search.matching.PatternLocator;

public class ConstructorLocator
extends PatternLocator {
    protected ConstructorPattern pattern;

    public ConstructorLocator(ConstructorPattern constructorPattern) {
        super(constructorPattern);
        this.pattern = constructorPattern;
    }

    public int match(ASTNode aSTNode, MatchingNodeSet matchingNodeSet) {
        if (!this.pattern.findReferences) {
            return 0;
        }
        if (!(aSTNode instanceof ExplicitConstructorCall)) {
            return 0;
        }
        if (!this.matchParametersCount(aSTNode, ((ExplicitConstructorCall)aSTNode).arguments)) {
            return 0;
        }
        return matchingNodeSet.addMatch(aSTNode, this.pattern.mustResolve ? 2 : 3);
    }

    public int match(ConstructorDeclaration constructorDeclaration, MatchingNodeSet matchingNodeSet) {
        int n = this.pattern.findReferences ? this.matchLevelForReferences(constructorDeclaration) : 0;
        int n2 = this.pattern.findDeclarations ? this.matchLevelForDeclarations(constructorDeclaration) : 0;
        return matchingNodeSet.addMatch(constructorDeclaration, n >= n2 ? n : n2);
    }

    public int match(Expression expression, MatchingNodeSet matchingNodeSet) {
        if (!this.pattern.findReferences) {
            return 0;
        }
        if (!(expression instanceof AllocationExpression)) {
            return 0;
        }
        AllocationExpression allocationExpression = (AllocationExpression)expression;
        char[][] cArray = allocationExpression.type.getTypeName();
        if (this.pattern.declaringSimpleName != null && !this.matchesName(this.pattern.declaringSimpleName, cArray[cArray.length - 1])) {
            return 0;
        }
        if (!this.matchParametersCount(expression, allocationExpression.arguments)) {
            return 0;
        }
        return matchingNodeSet.addMatch(expression, this.pattern.mustResolve ? 2 : 3);
    }

    public int match(FieldDeclaration fieldDeclaration, MatchingNodeSet matchingNodeSet) {
        if (!this.pattern.findReferences) {
            return 0;
        }
        if (fieldDeclaration.type != null || !(fieldDeclaration.initialization instanceof AllocationExpression)) {
            return 0;
        }
        AllocationExpression allocationExpression = (AllocationExpression)fieldDeclaration.initialization;
        if (fieldDeclaration.binding != null && fieldDeclaration.binding.declaringClass != null && this.pattern.declaringSimpleName != null && !this.matchesName(this.pattern.declaringSimpleName, fieldDeclaration.binding.declaringClass.sourceName())) {
            return 0;
        }
        if (!this.matchParametersCount(fieldDeclaration, allocationExpression.arguments)) {
            return 0;
        }
        return matchingNodeSet.addMatch(fieldDeclaration, this.pattern.mustResolve ? 2 : 3);
    }

    public int match(MessageSend messageSend, MatchingNodeSet matchingNodeSet) {
        if ((messageSend.bits & 0x8000) == 0) {
            return 0;
        }
        if (this.pattern.declaringSimpleName == null || CharOperation.equals(messageSend.selector, this.pattern.declaringSimpleName)) {
            return matchingNodeSet.addMatch(messageSend, this.pattern.mustResolve ? 2 : 3);
        }
        return 0;
    }

    public int match(TypeDeclaration typeDeclaration, MatchingNodeSet matchingNodeSet) {
        if (!this.pattern.findReferences) {
            return 0;
        }
        return matchingNodeSet.addMatch(typeDeclaration, this.pattern.mustResolve ? 2 : 3);
    }

    protected int matchConstructor(MethodBinding methodBinding) {
        if (!methodBinding.isConstructor()) {
            return 0;
        }
        int n = this.resolveLevelForType(this.pattern.declaringSimpleName, this.pattern.declaringQualification, methodBinding.declaringClass);
        if (n == 0) {
            return 0;
        }
        int n2 = this.pattern.parameterCount;
        if (n2 > -1) {
            if (methodBinding.parameters == null) {
                return 1;
            }
            if (n2 != methodBinding.parameters.length) {
                return 0;
            }
            int n3 = 0;
            while (n3 < n2) {
                int n4 = this.resolveLevelForType(this.pattern.parameterSimpleNames[n3], this.pattern.parameterQualifications[n3], methodBinding.parameters[n3]);
                if (n > n4) {
                    if (n4 == 0) {
                        return 0;
                    }
                    n = n4;
                }
                ++n3;
            }
        }
        return n;
    }

    protected int matchContainer() {
        if (this.pattern.findReferences) {
            return 15;
        }
        return 2;
    }

    protected int matchLevelForReferences(ConstructorDeclaration constructorDeclaration) {
        ExplicitConstructorCall explicitConstructorCall = constructorDeclaration.constructorCall;
        if (explicitConstructorCall == null || explicitConstructorCall.accessMode != 1) {
            return 0;
        }
        if (this.pattern.parameterSimpleNames != null) {
            int n;
            int n2 = this.pattern.parameterSimpleNames.length;
            Expression[] expressionArray = explicitConstructorCall.arguments;
            int n3 = n = expressionArray == null ? 0 : expressionArray.length;
            if (n2 != n) {
                return 0;
            }
        }
        return this.pattern.mustResolve ? 2 : 3;
    }

    protected int matchLevelForDeclarations(ConstructorDeclaration constructorDeclaration) {
        if (this.pattern.declaringSimpleName != null && !this.matchesName(this.pattern.declaringSimpleName, constructorDeclaration.selector)) {
            return 0;
        }
        if (this.pattern.parameterSimpleNames != null) {
            int n;
            int n2 = this.pattern.parameterSimpleNames.length;
            Argument[] argumentArray = constructorDeclaration.arguments;
            int n3 = n = argumentArray == null ? 0 : argumentArray.length;
            if (n2 != n) {
                return 0;
            }
        }
        if (this.pattern.hasConstructorArguments() && (constructorDeclaration.typeParameters == null || constructorDeclaration.typeParameters.length != this.pattern.constructorArguments.length)) {
            return 0;
        }
        return this.pattern.mustResolve ? 2 : 3;
    }

    boolean matchParametersCount(ASTNode aSTNode, Expression[] expressionArray) {
        if (!(this.pattern.parameterSimpleNames == null || this.pattern.varargs && (aSTNode.bits & 0x8000) == 0)) {
            int n;
            int n2 = this.pattern.parameterCount;
            if (n2 < 0) {
                n2 = this.pattern.parameterSimpleNames.length;
            }
            int n3 = n = expressionArray == null ? 0 : expressionArray.length;
            if (n2 != n) {
                return false;
            }
        }
        return true;
    }

    protected void matchReportReference(ASTNode aSTNode, IJavaElement iJavaElement, Binding binding, int n, MatchLocator matchLocator) throws CoreException {
        boolean bl;
        Object object;
        Object object2;
        MethodBinding methodBinding = null;
        boolean bl2 = false;
        if (aSTNode instanceof ExplicitConstructorCall) {
            object2 = (ExplicitConstructorCall)aSTNode;
            bl2 = ((ExplicitConstructorCall)object2).isImplicitSuper();
            methodBinding = ((ExplicitConstructorCall)object2).binding;
        } else if (aSTNode instanceof AllocationExpression) {
            object2 = (AllocationExpression)aSTNode;
            methodBinding = ((AllocationExpression)object2).binding;
        } else if (aSTNode instanceof TypeDeclaration || aSTNode instanceof FieldDeclaration) {
            super.matchReportReference(aSTNode, iJavaElement, binding, n, matchLocator);
            if (this.match != null) {
                return;
            }
        }
        this.match = matchLocator.newMethodReferenceMatch(iJavaElement, binding, n, -1, -1, true, bl2, aSTNode);
        if (methodBinding instanceof ParameterizedGenericMethodBinding) {
            object2 = (ParameterizedGenericMethodBinding)methodBinding;
            this.match.setRaw(((ParameterizedGenericMethodBinding)object2).isRaw);
            TypeBinding[] typeBindingArray = ((ParameterizedGenericMethodBinding)object2).isRaw ? null : ((ParameterizedGenericMethodBinding)object2).typeArguments;
            this.updateMatch(typeBindingArray, matchLocator, this.pattern.constructorArguments, this.pattern.hasConstructorParameters());
            if (methodBinding.declaringClass.isParameterizedType() || methodBinding.declaringClass.isRawType()) {
                object = (ParameterizedTypeBinding)methodBinding.declaringClass;
                if (!(!this.pattern.hasTypeArguments() && this.pattern.hasConstructorArguments() || ((TypeBinding)object).isParameterizedWithOwnVariables())) {
                    if (this.pattern.hasTypeArguments() && !this.pattern.hasConstructorArguments()) {
                        this.updateMatch((ParameterizedTypeBinding)object, this.pattern.getTypeArguments(), this.pattern.hasTypeParameters(), 0, matchLocator);
                    } else {
                        this.updateMatch((ParameterizedTypeBinding)object, this.pattern.getTypeArguments(), this.pattern.hasTypeParameters(), 0, matchLocator);
                    }
                }
            } else if (this.pattern.hasTypeArguments()) {
                this.match.setRule(16);
            }
        } else if (methodBinding instanceof ParameterizedMethodBinding) {
            if (methodBinding.declaringClass.isParameterizedType() || methodBinding.declaringClass.isRawType()) {
                object2 = (ParameterizedTypeBinding)methodBinding.declaringClass;
                if (!this.pattern.hasTypeArguments() && this.pattern.hasConstructorArguments()) {
                    this.updateMatch((ParameterizedTypeBinding)object2, new char[][][]{this.pattern.constructorArguments}, this.pattern.hasTypeParameters(), 0, matchLocator);
                } else if (!((TypeBinding)object2).isParameterizedWithOwnVariables()) {
                    this.updateMatch((ParameterizedTypeBinding)object2, this.pattern.getTypeArguments(), this.pattern.hasTypeParameters(), 0, matchLocator);
                }
            } else if (this.pattern.hasTypeArguments()) {
                this.match.setRule(16);
            }
        } else if (this.pattern.hasConstructorArguments()) {
            this.match.setRule(16);
        }
        if (this.match.getRule() == 0) {
            return;
        }
        boolean bl3 = bl = this.isErasureMatch && this.match.isErasure() || this.isEquivalentMatch && this.match.isEquivalent() || this.match.isExact();
        if (!bl) {
            return;
        }
        int n2 = aSTNode.sourceStart;
        this.match.setOffset(n2);
        this.match.setLength(aSTNode.sourceEnd - n2 + 1);
        if (aSTNode instanceof FieldDeclaration) {
            object = (FieldDeclaration)aSTNode;
            if (((FieldDeclaration)object).initialization instanceof QualifiedAllocationExpression) {
                matchLocator.reportAccurateEnumConstructorReference(this.match, (FieldDeclaration)object, (QualifiedAllocationExpression)((FieldDeclaration)object).initialization);
                return;
            }
        }
        matchLocator.report(this.match);
    }

    public SearchMatch newDeclarationMatch(ASTNode aSTNode, IJavaElement iJavaElement, Binding binding, int n, int n2, MatchLocator matchLocator) {
        this.match = null;
        int n3 = aSTNode.sourceStart;
        if (this.pattern.findReferences) {
            if (aSTNode instanceof TypeDeclaration) {
                TypeDeclaration typeDeclaration = (TypeDeclaration)aSTNode;
                AbstractMethodDeclaration[] abstractMethodDeclarationArray = typeDeclaration.methods;
                if (abstractMethodDeclarationArray != null) {
                    int n4 = 0;
                    int n5 = abstractMethodDeclarationArray.length;
                    while (n4 < n5) {
                        AbstractMethodDeclaration abstractMethodDeclaration = abstractMethodDeclarationArray[n4];
                        boolean bl = abstractMethodDeclaration.isDefaultConstructor() && abstractMethodDeclaration.sourceStart < typeDeclaration.bodyStart;
                        this.match = matchLocator.newMethodReferenceMatch(iJavaElement, binding, n, n3, n2, abstractMethodDeclaration.isConstructor(), bl, abstractMethodDeclaration);
                        ++n4;
                    }
                }
            } else if (aSTNode instanceof ConstructorDeclaration) {
                ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)aSTNode;
                ExplicitConstructorCall explicitConstructorCall = constructorDeclaration.constructorCall;
                boolean bl = explicitConstructorCall != null && explicitConstructorCall.isImplicitSuper();
                this.match = matchLocator.newMethodReferenceMatch(iJavaElement, binding, n, n3, n2, constructorDeclaration.isConstructor(), bl, constructorDeclaration);
            }
        }
        if (this.match != null) {
            return this.match;
        }
        return matchLocator.newDeclarationMatch(iJavaElement, binding, n, aSTNode.sourceStart, n2);
    }

    public int resolveLevel(ASTNode aSTNode) {
        if (this.pattern.findReferences) {
            if (aSTNode instanceof AllocationExpression) {
                return this.resolveLevel((AllocationExpression)aSTNode);
            }
            if (aSTNode instanceof ExplicitConstructorCall) {
                return this.resolveLevel(((ExplicitConstructorCall)aSTNode).binding);
            }
            if (aSTNode instanceof TypeDeclaration) {
                return this.resolveLevel((TypeDeclaration)aSTNode);
            }
            if (aSTNode instanceof FieldDeclaration) {
                return this.resolveLevel((FieldDeclaration)aSTNode);
            }
            if (aSTNode instanceof JavadocMessageSend) {
                return this.resolveLevel(((JavadocMessageSend)aSTNode).binding);
            }
        }
        if (aSTNode instanceof ConstructorDeclaration) {
            return this.resolveLevel((ConstructorDeclaration)aSTNode, true);
        }
        return 0;
    }

    protected int referenceType() {
        return 9;
    }

    protected int resolveLevel(AllocationExpression allocationExpression) {
        char[][] cArray = allocationExpression.type.getTypeName();
        if (this.pattern.declaringSimpleName != null && !this.matchesName(this.pattern.declaringSimpleName, cArray[cArray.length - 1])) {
            return 0;
        }
        return this.resolveLevel(allocationExpression.binding);
    }

    protected int resolveLevel(FieldDeclaration fieldDeclaration) {
        if (fieldDeclaration.type != null || fieldDeclaration.binding == null) {
            return 0;
        }
        if (this.pattern.declaringSimpleName != null && !this.matchesName(this.pattern.declaringSimpleName, fieldDeclaration.binding.type.sourceName())) {
            return 0;
        }
        if (!(fieldDeclaration.initialization instanceof AllocationExpression) || fieldDeclaration.initialization.resolvedType.isLocalType()) {
            return 0;
        }
        return this.resolveLevel(((AllocationExpression)fieldDeclaration.initialization).binding);
    }

    public int resolveLevel(Binding binding) {
        if (binding == null) {
            return 1;
        }
        if (!(binding instanceof MethodBinding)) {
            return 0;
        }
        MethodBinding methodBinding = (MethodBinding)binding;
        int n = this.matchConstructor(methodBinding);
        if (n == 0 && methodBinding != methodBinding.original()) {
            n = this.matchConstructor(methodBinding.original());
        }
        return n;
    }

    protected int resolveLevel(ConstructorDeclaration constructorDeclaration, boolean bl) {
        ExplicitConstructorCall explicitConstructorCall;
        int n = 0;
        if (this.pattern.findReferences && (explicitConstructorCall = constructorDeclaration.constructorCall) != null && explicitConstructorCall.accessMode == 1) {
            int n2;
            int n3 = explicitConstructorCall.arguments == null ? 0 : explicitConstructorCall.arguments.length;
            int n4 = n2 = this.pattern.parameterSimpleNames == null ? 0 : this.pattern.parameterSimpleNames.length;
            if (n2 != n3) {
                n = 0;
            } else {
                n = this.resolveLevel(explicitConstructorCall.binding);
                if (n == 3) {
                    return 3;
                }
            }
        }
        if (!bl) {
            return n;
        }
        int n5 = this.pattern.findDeclarations ? this.resolveLevel(constructorDeclaration.binding) : 0;
        return n >= n5 ? n : n5;
    }

    protected int resolveLevel(TypeDeclaration typeDeclaration) {
        AbstractMethodDeclaration[] abstractMethodDeclarationArray = typeDeclaration.methods;
        if (abstractMethodDeclarationArray != null) {
            int n = 0;
            int n2 = abstractMethodDeclarationArray.length;
            while (n < n2) {
                AbstractMethodDeclaration abstractMethodDeclaration = abstractMethodDeclarationArray[n];
                if (abstractMethodDeclaration.isDefaultConstructor() && abstractMethodDeclaration.sourceStart < typeDeclaration.bodyStart) {
                    return this.resolveLevel((ConstructorDeclaration)abstractMethodDeclaration, false);
                }
                ++n;
            }
        }
        return 0;
    }

    public String toString() {
        return "Locator for " + this.pattern.toString();
    }
}

