/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.matching;

import org.eclipse.wst.jsdt.core.BindingKey;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeParameter;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class JavaSearchPattern
extends SearchPattern
implements IIndexConstants {
    boolean isCaseSensitive;
    boolean isCamelCase;
    int matchMode;
    int matchCompatibility;
    public static final int MATCH_MODE_MASK = 7;
    public static final int MATCH_COMPATIBILITY_MASK = 112;
    char[][] typeSignatures;
    private char[][][] typeArguments;
    private int flags = 0;
    static final int HAS_TYPE_ARGUMENTS = 1;

    protected JavaSearchPattern(int n, int n2) {
        super(n2);
        this.kind = n;
        int n3 = this.getMatchRule();
        this.isCaseSensitive = (n3 & 8) != 0;
        this.isCamelCase = (n3 & 0x80) != 0;
        this.matchCompatibility = n3 & 0x70;
        this.matchMode = n3 & 7;
    }

    public SearchPattern getBlankPattern() {
        return null;
    }

    int getMatchMode() {
        return this.matchMode;
    }

    boolean isCamelCase() {
        return this.isCamelCase;
    }

    boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    boolean isErasureMatch() {
        return (this.matchCompatibility & 0x10) != 0;
    }

    boolean isEquivalentMatch() {
        return (this.matchCompatibility & 0x20) != 0;
    }

    char[][] extractMethodArguments(IMethod iMethod) {
        int n;
        BindingKey bindingKey;
        String[] stringArray = null;
        if (!iMethod.isResolved() || !(bindingKey = new BindingKey(iMethod.getKey())).isParameterizedType()) {
            try {
                int n2;
                ITypeParameter[] iTypeParameterArray = iMethod.getTypeParameters();
                if (iTypeParameterArray != null && (n2 = iTypeParameterArray.length) > 0) {
                    char[][] cArrayArray = new char[n2][];
                    int n3 = 0;
                    while (n3 < n2) {
                        cArrayArray[n3] = Signature.createTypeSignature(iTypeParameterArray[n3].getElementName(), false).toCharArray();
                        ++n3;
                    }
                    return cArrayArray;
                }
            }
            catch (JavaModelException javaModelException) {}
            return null;
        }
        stringArray = bindingKey.getTypeArguments();
        if (stringArray != null && (n = stringArray.length) > 0) {
            char[][] cArrayArray = new char[n][];
            int n4 = 0;
            while (n4 < n) {
                cArrayArray[n4] = stringArray[n4].toCharArray();
                CharOperation.replace(cArrayArray[n4], new char[]{'$', '/'}, '.');
                ++n4;
            }
            return cArrayArray;
        }
        return null;
    }

    final char[][][] getTypeArguments() {
        return this.typeArguments;
    }

    public final boolean hasSignatures() {
        return this.typeSignatures != null && this.typeSignatures.length > 0;
    }

    public final boolean hasTypeArguments() {
        return (this.flags & 1) != 0;
    }

    public final boolean hasTypeParameters() {
        return !this.hasSignatures() && this.hasTypeArguments();
    }

    boolean matchDifferentTypeSuffixes(int n, int n2) {
        switch (n) {
            case 67: {
                switch (n2) {
                    case 9: 
                    case 10: {
                        return true;
                    }
                }
                return false;
            }
            case 73: {
                switch (n2) {
                    case 10: 
                    case 11: {
                        return true;
                    }
                }
                return false;
            }
            case 69: {
                return n2 == 9;
            }
            case 65: {
                return n2 == 11;
            }
            case 10: {
                switch (n2) {
                    case 67: 
                    case 73: {
                        return true;
                    }
                }
                return false;
            }
            case 9: {
                switch (n2) {
                    case 67: 
                    case 69: {
                        return true;
                    }
                }
                return false;
            }
            case 11: {
                switch (n2) {
                    case 65: 
                    case 73: {
                        return true;
                    }
                }
                return false;
            }
        }
        return true;
    }

    protected StringBuffer print(StringBuffer stringBuffer) {
        stringBuffer.append(", ");
        if (this.hasTypeArguments() && this.hasSignatures()) {
            stringBuffer.append("signature:\"");
            stringBuffer.append(this.typeSignatures[0]);
            stringBuffer.append("\", ");
        }
        if (this.isCamelCase) {
            stringBuffer.append("camel case + ");
        }
        switch (this.getMatchMode()) {
            case 0: {
                stringBuffer.append("exact match,");
                break;
            }
            case 1: {
                stringBuffer.append("prefix match,");
                break;
            }
            case 2: {
                stringBuffer.append("pattern match,");
                break;
            }
            case 4: {
                stringBuffer.append("regexp match, ");
            }
        }
        if (this.isCaseSensitive()) {
            stringBuffer.append(" case sensitive");
        } else {
            stringBuffer.append(" case insensitive");
        }
        if ((this.matchCompatibility & 0x10) != 0) {
            stringBuffer.append(", erasure only");
        }
        if ((this.matchCompatibility & 0x20) != 0) {
            stringBuffer.append(", equivalent oronly");
        }
        return stringBuffer;
    }

    final void setTypeArguments(char[][][] cArray) {
        this.typeArguments = cArray;
        if (this.typeArguments != null) {
            int n = this.typeArguments.length;
            int n2 = 0;
            while (n2 < n) {
                if (this.typeArguments[n2] != null && this.typeArguments[n2].length > 0) {
                    this.flags |= 1;
                    break;
                }
                ++n2;
            }
        }
    }

    void storeTypeSignaturesAndArguments(IType iType) {
        BindingKey bindingKey;
        if (iType.isResolved() && (bindingKey = new BindingKey(iType.getKey())).isParameterizedType()) {
            String string = bindingKey.toSignature();
            this.typeSignatures = Util.splitTypeLevelsSignature(string);
            this.setTypeArguments(Util.getAllTypeArguments(this.typeSignatures));
        } else {
            char[][][] cArrayArray = new char[10][][];
            int n = -1;
            boolean bl = false;
            try {
                IJavaElement iJavaElement = iType;
                ITypeParameter[] iTypeParameterArray = null;
                while (iJavaElement != null && iJavaElement.getElementType() == 7) {
                    int n2;
                    IType iType2;
                    if (++n > cArrayArray.length) {
                        char[][][] cArrayArray2 = cArrayArray;
                        cArrayArray = new char[cArrayArray.length + 10][][];
                        System.arraycopy(cArrayArray2, 0, cArrayArray, 0, n);
                    }
                    if ((iTypeParameterArray = (iType2 = iJavaElement).getTypeParameters()) != null && (n2 = iTypeParameterArray.length) > 0) {
                        bl = true;
                        cArrayArray[n] = new char[n2][];
                        int n3 = 0;
                        while (n3 < n2) {
                            cArrayArray[n][n3] = Signature.createTypeSignature(iTypeParameterArray[n3].getElementName(), false).toCharArray();
                            ++n3;
                        }
                    }
                    iJavaElement = iJavaElement.getParent();
                }
            }
            catch (JavaModelException javaModelException) {
                return;
            }
            if (bl) {
                if (++n < cArrayArray.length) {
                    char[][][] cArrayArray3 = cArrayArray;
                    cArrayArray = new char[n][][];
                    System.arraycopy(cArrayArray3, 0, cArrayArray, 0, n);
                }
                this.setTypeArguments(cArrayArray);
            }
        }
    }

    public final String toString() {
        return this.print(new StringBuffer(30)).toString();
    }
}

