/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchParticipant;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.core.index.Index;
import org.eclipse.wst.jsdt.internal.core.search.IndexQueryRequestor;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.wst.jsdt.internal.core.search.matching.JavaSearchPattern;

public class OrPattern
extends SearchPattern
implements IIndexConstants {
    protected SearchPattern[] patterns;
    int matchCompatibility;

    public OrPattern(SearchPattern searchPattern, SearchPattern searchPattern2) {
        super(Math.max(searchPattern.getMatchRule(), searchPattern2.getMatchRule()));
        this.kind = 256;
        this.mustResolve = searchPattern.mustResolve || searchPattern2.mustResolve;
        SearchPattern[] searchPatternArray = searchPattern instanceof OrPattern ? ((OrPattern)searchPattern).patterns : null;
        SearchPattern[] searchPatternArray2 = searchPattern2 instanceof OrPattern ? ((OrPattern)searchPattern2).patterns : null;
        int n = searchPatternArray == null ? 1 : searchPatternArray.length;
        int n2 = searchPatternArray2 == null ? 1 : searchPatternArray2.length;
        this.patterns = new SearchPattern[n + n2];
        if (searchPatternArray == null) {
            this.patterns[0] = searchPattern;
        } else {
            System.arraycopy(searchPatternArray, 0, this.patterns, 0, n);
        }
        if (searchPatternArray2 == null) {
            this.patterns[n] = searchPattern2;
        } else {
            System.arraycopy(searchPatternArray2, 0, this.patterns, n, n2);
        }
        this.matchCompatibility = 0;
        int n3 = 0;
        int n4 = this.patterns.length;
        while (n3 < n4) {
            this.matchCompatibility |= ((JavaSearchPattern)this.patterns[n3]).matchCompatibility;
            ++n3;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void findIndexMatches(Index index, IndexQueryRequestor indexQueryRequestor, SearchParticipant searchParticipant, IJavaSearchScope iJavaSearchScope, IProgressMonitor iProgressMonitor) throws IOException {
        try {
            index.startQuery();
            int n = 0;
            int n2 = this.patterns.length;
            while (n < n2) {
                this.patterns[n].findIndexMatches(index, indexQueryRequestor, searchParticipant, iJavaSearchScope, iProgressMonitor);
                ++n;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            index.stopQuery();
            throw throwable;
        }
        {
            Object var8_10 = null;
            index.stopQuery();
            return;
        }
    }

    public SearchPattern getBlankPattern() {
        return null;
    }

    boolean isErasureMatch() {
        return (this.matchCompatibility & 0x10) != 0;
    }

    boolean isPolymorphicSearch() {
        int n = 0;
        int n2 = this.patterns.length;
        while (n < n2) {
            if (this.patterns[n].isPolymorphicSearch()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public final boolean hasSignatures() {
        boolean bl = this.isErasureMatch();
        int n = 0;
        int n2 = this.patterns.length;
        while (n < n2 && !bl) {
            if (((JavaSearchPattern)this.patterns[n]).hasSignatures()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.patterns[0].toString());
        int n = 1;
        int n2 = this.patterns.length;
        while (n < n2) {
            stringBuffer.append("\n| ");
            stringBuffer.append(this.patterns[n].toString());
            ++n;
        }
        return stringBuffer.toString();
    }
}

