/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.matching;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.core.search.matching.MatchLocator;
import org.eclipse.wst.jsdt.internal.core.search.matching.MatchingNodeSet;
import org.eclipse.wst.jsdt.internal.core.search.matching.PatternLocator;
import org.eclipse.wst.jsdt.internal.core.search.matching.SuperTypeReferencePattern;

public class SuperTypeReferenceLocator
extends PatternLocator {
    protected SuperTypeReferencePattern pattern;

    public SuperTypeReferenceLocator(SuperTypeReferencePattern superTypeReferencePattern) {
        super(superTypeReferencePattern);
        this.pattern = superTypeReferencePattern;
    }

    public int match(TypeReference typeReference, MatchingNodeSet matchingNodeSet) {
        if (this.pattern.superSimpleName == null) {
            return matchingNodeSet.addMatch(typeReference, this.pattern.mustResolve ? 2 : 3);
        }
        char[] cArray = null;
        if (typeReference instanceof SingleTypeReference) {
            cArray = ((SingleTypeReference)typeReference).token;
        } else {
            char[][] cArray2 = ((QualifiedTypeReference)typeReference).tokens;
            cArray = cArray2[cArray2.length - 1];
        }
        if (this.matchesName(this.pattern.superSimpleName, cArray)) {
            return matchingNodeSet.addMatch(typeReference, this.pattern.mustResolve ? 2 : 3);
        }
        return 0;
    }

    protected int matchContainer() {
        return 2;
    }

    protected void matchReportReference(ASTNode aSTNode, IJavaElement iJavaElement, Binding binding, int n, MatchLocator matchLocator) throws CoreException {
        if (binding instanceof ReferenceBinding) {
            ReferenceBinding referenceBinding = (ReferenceBinding)binding;
            if (referenceBinding.isClass() && this.pattern.typeSuffix == 'I') {
                return;
            }
            if (referenceBinding.isInterface() && this.pattern.typeSuffix == 'C') {
                return;
            }
        }
        super.matchReportReference(aSTNode, iJavaElement, binding, n, matchLocator);
    }

    protected int referenceType() {
        return 7;
    }

    public int resolveLevel(ASTNode aSTNode) {
        if (!(aSTNode instanceof TypeReference)) {
            return 0;
        }
        TypeReference typeReference = (TypeReference)aSTNode;
        TypeBinding typeBinding = typeReference.resolvedType;
        if (typeBinding == null) {
            return 1;
        }
        return this.resolveLevelForType(this.pattern.superSimpleName, this.pattern.superQualification, typeBinding);
    }

    public int resolveLevel(Binding binding) {
        if (binding == null) {
            return 1;
        }
        if (!(binding instanceof ReferenceBinding)) {
            return 0;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)binding;
        int n = 0;
        if (this.pattern.superRefKind != 1 && (n = this.resolveLevelForType(this.pattern.superSimpleName, this.pattern.superQualification, referenceBinding.superclass())) == 3) {
            return 3;
        }
        if (this.pattern.superRefKind != 2) {
            ReferenceBinding[] referenceBindingArray = referenceBinding.superInterfaces();
            int n2 = 0;
            int n3 = referenceBindingArray.length;
            while (n2 < n3) {
                int n4 = this.resolveLevelForType(this.pattern.superSimpleName, this.pattern.superQualification, referenceBindingArray[n2]);
                if (n4 > n) {
                    if (n4 == 3) {
                        return 3;
                    }
                    n = n4;
                }
                ++n2;
            }
        }
        return n;
    }

    public String toString() {
        return "Locator for " + this.pattern.toString();
    }
}

