/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.util;

import org.eclipse.wst.jsdt.core.util.ClassFormatException;
import org.eclipse.wst.jsdt.core.util.IAnnotation;
import org.eclipse.wst.jsdt.core.util.IAnnotationComponentValue;
import org.eclipse.wst.jsdt.core.util.IConstantPool;
import org.eclipse.wst.jsdt.core.util.IConstantPoolEntry;
import org.eclipse.wst.jsdt.internal.core.util.Annotation;
import org.eclipse.wst.jsdt.internal.core.util.ClassFileStruct;

public class AnnotationComponentValue
extends ClassFileStruct
implements IAnnotationComponentValue {
    private static final IAnnotationComponentValue[] NO_VALUES = new AnnotationComponentValue[0];
    private IAnnotationComponentValue[] annotationComponentValues;
    private IAnnotation annotationValue;
    private IConstantPoolEntry classInfo;
    private int classFileInfoIndex = -1;
    private IConstantPoolEntry constantValue;
    private int constantValueIndex = -1;
    private int enumConstantTypeNameIndex = -1;
    private int enumConstantNameIndex = -1;
    private char[] enumConstantTypeName;
    private char[] enumConstantName;
    private int readOffset;
    private int tag;
    private int valuesNumber;

    public AnnotationComponentValue(byte[] byArray, IConstantPool iConstantPool, int n) throws ClassFormatException {
        int n2;
        this.tag = n2 = this.u1At(byArray, 0, n);
        this.readOffset = 1;
        switch (n2) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                int n3;
                this.constantValueIndex = n3 = this.u2At(byArray, this.readOffset, n);
                if (n3 != 0) {
                    IConstantPoolEntry iConstantPoolEntry = iConstantPool.decodeEntry(n3);
                    switch (iConstantPoolEntry.getKind()) {
                        case 1: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: {
                            break;
                        }
                        default: {
                            throw new ClassFormatException(3);
                        }
                    }
                    this.constantValue = iConstantPoolEntry;
                }
                this.readOffset += 2;
                break;
            }
            case 101: {
                IConstantPoolEntry iConstantPoolEntry;
                int n4;
                this.enumConstantTypeNameIndex = n4 = this.u2At(byArray, this.readOffset, n);
                if (n4 != 0) {
                    iConstantPoolEntry = iConstantPool.decodeEntry(n4);
                    if (iConstantPoolEntry.getKind() != 1) {
                        throw new ClassFormatException(3);
                    }
                    this.enumConstantTypeName = iConstantPoolEntry.getUtf8Value();
                }
                this.readOffset += 2;
                this.enumConstantNameIndex = n4 = this.u2At(byArray, this.readOffset, n);
                if (n4 != 0) {
                    iConstantPoolEntry = iConstantPool.decodeEntry(n4);
                    if (iConstantPoolEntry.getKind() != 1) {
                        throw new ClassFormatException(3);
                    }
                    this.enumConstantName = iConstantPoolEntry.getUtf8Value();
                }
                this.readOffset += 2;
                break;
            }
            case 99: {
                int n5;
                this.classFileInfoIndex = n5 = this.u2At(byArray, this.readOffset, n);
                if (n5 != 0) {
                    IConstantPoolEntry iConstantPoolEntry = iConstantPool.decodeEntry(n5);
                    if (iConstantPoolEntry.getKind() != 1) {
                        throw new ClassFormatException(3);
                    }
                    this.classInfo = iConstantPoolEntry;
                }
                this.readOffset += 2;
                break;
            }
            case 64: {
                Annotation annotation = new Annotation(byArray, iConstantPool, this.readOffset + n);
                this.annotationValue = annotation;
                this.readOffset += annotation.sizeInBytes();
                break;
            }
            case 91: {
                int n6;
                this.valuesNumber = n6 = this.u2At(byArray, this.readOffset, n);
                if (n6 != 0) {
                    this.readOffset += 2;
                    this.annotationComponentValues = new IAnnotationComponentValue[n6];
                    int n7 = 0;
                    while (n7 < n6) {
                        AnnotationComponentValue annotationComponentValue = new AnnotationComponentValue(byArray, iConstantPool, n + this.readOffset);
                        this.annotationComponentValues[n7] = annotationComponentValue;
                        this.readOffset += annotationComponentValue.sizeInBytes();
                        ++n7;
                    }
                    break;
                }
                this.annotationComponentValues = NO_VALUES;
            }
        }
    }

    public IAnnotationComponentValue[] getAnnotationComponentValues() {
        return this.annotationComponentValues;
    }

    public IAnnotation getAnnotationValue() {
        return this.annotationValue;
    }

    public IConstantPoolEntry getClassInfo() {
        return this.classInfo;
    }

    public int getClassInfoIndex() {
        return this.classFileInfoIndex;
    }

    public IConstantPoolEntry getConstantValue() {
        return this.constantValue;
    }

    public int getConstantValueIndex() {
        return this.constantValueIndex;
    }

    public char[] getEnumConstantName() {
        return this.enumConstantName;
    }

    public int getEnumConstantNameIndex() {
        return this.enumConstantNameIndex;
    }

    public char[] getEnumConstantTypeName() {
        return this.enumConstantTypeName;
    }

    public int getEnumConstantTypeNameIndex() {
        return this.enumConstantTypeNameIndex;
    }

    public int getTag() {
        return this.tag;
    }

    public int getValuesNumber() {
        return this.valuesNumber;
    }

    int sizeInBytes() {
        return this.readOffset;
    }
}

