/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.util;

import org.eclipse.wst.jsdt.core.util.ClassFormatException;
import org.eclipse.wst.jsdt.core.util.IAttributeNamesConstants;
import org.eclipse.wst.jsdt.core.util.IBytecodeVisitor;
import org.eclipse.wst.jsdt.core.util.IClassFileAttribute;
import org.eclipse.wst.jsdt.core.util.ICodeAttribute;
import org.eclipse.wst.jsdt.core.util.IConstantPool;
import org.eclipse.wst.jsdt.core.util.IConstantPoolEntry;
import org.eclipse.wst.jsdt.core.util.IExceptionTableEntry;
import org.eclipse.wst.jsdt.core.util.ILineNumberAttribute;
import org.eclipse.wst.jsdt.core.util.ILocalVariableAttribute;
import org.eclipse.wst.jsdt.internal.core.util.ClassFileAttribute;
import org.eclipse.wst.jsdt.internal.core.util.ExceptionTableEntry;
import org.eclipse.wst.jsdt.internal.core.util.LineNumberAttribute;
import org.eclipse.wst.jsdt.internal.core.util.LocalVariableAttribute;
import org.eclipse.wst.jsdt.internal.core.util.LocalVariableTypeAttribute;
import org.eclipse.wst.jsdt.internal.core.util.StackMapAttribute;
import org.eclipse.wst.jsdt.internal.core.util.StackMapTableAttribute;

public class CodeAttribute
extends ClassFileAttribute
implements ICodeAttribute {
    private static final IExceptionTableEntry[] NO_EXCEPTION_TABLE = new IExceptionTableEntry[0];
    private IClassFileAttribute[] attributes;
    private int attributesCount;
    private byte[] bytecodes;
    private byte[] classFileBytes;
    private long codeLength;
    private int codeOffset;
    private IConstantPool constantPool;
    private IExceptionTableEntry[] exceptionTableEntries;
    private int exceptionTableLength;
    private ILineNumberAttribute lineNumberAttribute;
    private ILocalVariableAttribute localVariableAttribute;
    private int maxLocals;
    private int maxStack;

    CodeAttribute(byte[] byArray, IConstantPool iConstantPool, int n) throws ClassFormatException {
        super(byArray, iConstantPool, n);
        int n2;
        this.classFileBytes = byArray;
        this.constantPool = iConstantPool;
        this.maxStack = this.u2At(byArray, 6, n);
        this.maxLocals = this.u2At(byArray, 8, n);
        this.codeLength = this.u4At(byArray, 10, n);
        this.codeOffset = n + 14;
        int n3 = (int)(14L + this.codeLength);
        this.exceptionTableLength = this.u2At(byArray, n3, n);
        n3 += 2;
        this.exceptionTableEntries = NO_EXCEPTION_TABLE;
        if (this.exceptionTableLength != 0) {
            this.exceptionTableEntries = new ExceptionTableEntry[this.exceptionTableLength];
            n2 = 0;
            while (n2 < this.exceptionTableLength) {
                this.exceptionTableEntries[n2] = new ExceptionTableEntry(byArray, iConstantPool, n + n3);
                n3 += 8;
                ++n2;
            }
        }
        this.attributesCount = this.u2At(byArray, n3, n);
        this.attributes = ClassFileAttribute.NO_ATTRIBUTES;
        if (this.attributesCount != 0) {
            this.attributes = new IClassFileAttribute[this.attributesCount];
        }
        n2 = 0;
        n3 += 2;
        int n4 = 0;
        while (n4 < this.attributesCount) {
            IConstantPoolEntry iConstantPoolEntry = iConstantPool.decodeEntry(this.u2At(byArray, n3, n));
            if (iConstantPoolEntry.getKind() != 1) {
                throw new ClassFormatException(3);
            }
            char[] cArray = iConstantPoolEntry.getUtf8Value();
            if (this.equals(cArray, IAttributeNamesConstants.LINE_NUMBER)) {
                this.lineNumberAttribute = new LineNumberAttribute(byArray, iConstantPool, n + n3);
                this.attributes[n2++] = this.lineNumberAttribute;
            } else if (this.equals(cArray, IAttributeNamesConstants.LOCAL_VARIABLE)) {
                this.localVariableAttribute = new LocalVariableAttribute(byArray, iConstantPool, n + n3);
                this.attributes[n2++] = this.localVariableAttribute;
            } else {
                this.attributes[n2++] = this.equals(cArray, IAttributeNamesConstants.LOCAL_VARIABLE_TYPE_TABLE) ? new LocalVariableTypeAttribute(byArray, iConstantPool, n + n3) : (this.equals(cArray, IAttributeNamesConstants.STACK_MAP_TABLE) ? new StackMapTableAttribute(byArray, iConstantPool, n + n3) : (this.equals(cArray, IAttributeNamesConstants.STACK_MAP) ? new StackMapAttribute(byArray, iConstantPool, n + n3) : new ClassFileAttribute(byArray, iConstantPool, n + n3)));
            }
            n3 = (int)((long)n3 + (6L + this.u4At(byArray, n3 + 2, n)));
            ++n4;
        }
    }

    public IClassFileAttribute[] getAttributes() {
        return this.attributes;
    }

    public int getAttributesCount() {
        return this.attributesCount;
    }

    public byte[] getBytecodes() {
        if (this.bytecodes == null) {
            this.bytecodes = new byte[(int)this.codeLength];
            System.arraycopy(this.classFileBytes, this.codeOffset, this.bytecodes, 0, (int)this.codeLength);
        }
        return this.bytecodes;
    }

    public long getCodeLength() {
        return this.codeLength;
    }

    public IExceptionTableEntry[] getExceptionTable() {
        return this.exceptionTableEntries;
    }

    public int getExceptionTableLength() {
        return this.exceptionTableLength;
    }

    public ILineNumberAttribute getLineNumberAttribute() {
        return this.lineNumberAttribute;
    }

    public ILocalVariableAttribute getLocalVariableAttribute() {
        return this.localVariableAttribute;
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }

    public int getMaxStack() {
        return this.maxStack;
    }

    public void traverse(IBytecodeVisitor iBytecodeVisitor) throws ClassFormatException {
        int n = this.codeOffset;
        do {
            int n2 = this.u1At(this.classFileBytes, 0, n);
            switch (n2) {
                case 0: {
                    iBytecodeVisitor._nop(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 1: {
                    iBytecodeVisitor._aconst_null(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 2: {
                    iBytecodeVisitor._iconst_m1(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 3: {
                    iBytecodeVisitor._iconst_0(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 4: {
                    iBytecodeVisitor._iconst_1(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 5: {
                    iBytecodeVisitor._iconst_2(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 6: {
                    iBytecodeVisitor._iconst_3(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 7: {
                    iBytecodeVisitor._iconst_4(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 8: {
                    iBytecodeVisitor._iconst_5(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 9: {
                    iBytecodeVisitor._lconst_0(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 10: {
                    iBytecodeVisitor._lconst_1(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 11: {
                    iBytecodeVisitor._fconst_0(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 12: {
                    iBytecodeVisitor._fconst_1(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 13: {
                    iBytecodeVisitor._fconst_2(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 14: {
                    iBytecodeVisitor._dconst_0(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 15: {
                    iBytecodeVisitor._dconst_1(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 16: {
                    iBytecodeVisitor._bipush(n - this.codeOffset, (byte)this.i1At(this.classFileBytes, 1, n));
                    n += 2;
                    break;
                }
                case 17: {
                    iBytecodeVisitor._sipush(n - this.codeOffset, (short)this.i2At(this.classFileBytes, 1, n));
                    n += 3;
                    break;
                }
                case 18: {
                    int n3 = this.u1At(this.classFileBytes, 1, n);
                    IConstantPoolEntry iConstantPoolEntry = this.constantPool.decodeEntry(n3);
                    if (iConstantPoolEntry.getKind() != 4 && iConstantPoolEntry.getKind() != 3 && iConstantPoolEntry.getKind() != 8 && iConstantPoolEntry.getKind() != 7) {
                        throw new ClassFormatException(3);
                    }
                    iBytecodeVisitor._ldc(n - this.codeOffset, n3, iConstantPoolEntry);
                    n += 2;
                    break;
                }
                case 19: {
                    int n3 = this.u2At(this.classFileBytes, 1, n);
                    IConstantPoolEntry iConstantPoolEntry = this.constantPool.decodeEntry(n3);
                    if (iConstantPoolEntry.getKind() != 4 && iConstantPoolEntry.getKind() != 3 && iConstantPoolEntry.getKind() != 8 && iConstantPoolEntry.getKind() != 7) {
                        throw new ClassFormatException(3);
                    }
                    iBytecodeVisitor._ldc_w(n - this.codeOffset, n3, iConstantPoolEntry);
                    n += 3;
                    break;
                }
                case 20: {
                    int n3 = this.u2At(this.classFileBytes, 1, n);
                    IConstantPoolEntry iConstantPoolEntry = this.constantPool.decodeEntry(n3);
                    if (iConstantPoolEntry.getKind() != 6 && iConstantPoolEntry.getKind() != 5) {
                        throw new ClassFormatException(3);
                    }
                    iBytecodeVisitor._ldc2_w(n - this.codeOffset, n3, iConstantPoolEntry);
                    n += 3;
                    break;
                }
                case 21: {
                    int n3 = this.u1At(this.classFileBytes, 1, n);
                    iBytecodeVisitor._iload(n - this.codeOffset, n3);
                    n += 2;
                    break;
                }
                case 22: {
                    int n3 = this.u1At(this.classFileBytes, 1, n);
                    iBytecodeVisitor._lload(n - this.codeOffset, n3);
                    n += 2;
                    break;
                }
                case 23: {
                    int n3 = this.u1At(this.classFileBytes, 1, n);
                    iBytecodeVisitor._fload(n - this.codeOffset, n3);
                    n += 2;
                    break;
                }
                case 24: {
                    int n3 = this.u1At(this.classFileBytes, 1, n);
                    iBytecodeVisitor._dload(n - this.codeOffset, n3);
                    n += 2;
                    break;
                }
                case 25: {
                    int n3 = this.u1At(this.classFileBytes, 1, n);
                    iBytecodeVisitor._aload(n - this.codeOffset, n3);
                    n += 2;
                    break;
                }
                case 26: {
                    iBytecodeVisitor._iload_0(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 27: {
                    iBytecodeVisitor._iload_1(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 28: {
                    iBytecodeVisitor._iload_2(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 29: {
                    iBytecodeVisitor._iload_3(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 30: {
                    iBytecodeVisitor._lload_0(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 31: {
                    iBytecodeVisitor._lload_1(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 32: {
                    iBytecodeVisitor._lload_2(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 33: {
                    iBytecodeVisitor._lload_3(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 34: {
                    iBytecodeVisitor._fload_0(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 35: {
                    iBytecodeVisitor._fload_1(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 36: {
                    iBytecodeVisitor._fload_2(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 37: {
                    iBytecodeVisitor._fload_3(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 38: {
                    iBytecodeVisitor._dload_0(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 39: {
                    iBytecodeVisitor._dload_1(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 40: {
                    iBytecodeVisitor._dload_2(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 41: {
                    iBytecodeVisitor._dload_3(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 42: {
                    iBytecodeVisitor._aload_0(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 43: {
                    iBytecodeVisitor._aload_1(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 44: {
                    iBytecodeVisitor._aload_2(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 45: {
                    iBytecodeVisitor._aload_3(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 46: {
                    iBytecodeVisitor._iaload(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 47: {
                    iBytecodeVisitor._laload(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 48: {
                    iBytecodeVisitor._faload(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 49: {
                    iBytecodeVisitor._daload(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 50: {
                    iBytecodeVisitor._aaload(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 51: {
                    iBytecodeVisitor._baload(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 52: {
                    iBytecodeVisitor._caload(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 53: {
                    iBytecodeVisitor._saload(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 54: {
                    int n3 = this.u1At(this.classFileBytes, 1, n);
                    iBytecodeVisitor._istore(n - this.codeOffset, n3);
                    n += 2;
                    break;
                }
                case 55: {
                    int n3 = this.u1At(this.classFileBytes, 1, n);
                    iBytecodeVisitor._lstore(n - this.codeOffset, n3);
                    n += 2;
                    break;
                }
                case 56: {
                    int n3 = this.u1At(this.classFileBytes, 1, n);
                    iBytecodeVisitor._fstore(n - this.codeOffset, n3);
                    n += 2;
                    break;
                }
                case 57: {
                    int n3 = this.u1At(this.classFileBytes, 1, n);
                    iBytecodeVisitor._dstore(n - this.codeOffset, n3);
                    n += 2;
                    break;
                }
                case 58: {
                    int n3 = this.u1At(this.classFileBytes, 1, n);
                    iBytecodeVisitor._astore(n - this.codeOffset, n3);
                    n += 2;
                    break;
                }
                case 59: {
                    iBytecodeVisitor._istore_0(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 60: {
                    iBytecodeVisitor._istore_1(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 61: {
                    iBytecodeVisitor._istore_2(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 62: {
                    iBytecodeVisitor._istore_3(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 63: {
                    iBytecodeVisitor._lstore_0(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 64: {
                    iBytecodeVisitor._lstore_1(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 65: {
                    iBytecodeVisitor._lstore_2(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 66: {
                    iBytecodeVisitor._lstore_3(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 67: {
                    iBytecodeVisitor._fstore_0(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 68: {
                    iBytecodeVisitor._fstore_1(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 69: {
                    iBytecodeVisitor._fstore_2(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 70: {
                    iBytecodeVisitor._fstore_3(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 71: {
                    iBytecodeVisitor._dstore_0(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 72: {
                    iBytecodeVisitor._dstore_1(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 73: {
                    iBytecodeVisitor._dstore_2(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 74: {
                    iBytecodeVisitor._dstore_3(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 75: {
                    iBytecodeVisitor._astore_0(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 76: {
                    iBytecodeVisitor._astore_1(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 77: {
                    iBytecodeVisitor._astore_2(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 78: {
                    iBytecodeVisitor._astore_3(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 79: {
                    iBytecodeVisitor._iastore(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 80: {
                    iBytecodeVisitor._lastore(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 81: {
                    iBytecodeVisitor._fastore(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 82: {
                    iBytecodeVisitor._dastore(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 83: {
                    iBytecodeVisitor._aastore(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 84: {
                    iBytecodeVisitor._bastore(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 85: {
                    iBytecodeVisitor._castore(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 86: {
                    iBytecodeVisitor._sastore(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 87: {
                    iBytecodeVisitor._pop(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 88: {
                    iBytecodeVisitor._pop2(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 89: {
                    iBytecodeVisitor._dup(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 90: {
                    iBytecodeVisitor._dup_x1(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 91: {
                    iBytecodeVisitor._dup_x2(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 92: {
                    iBytecodeVisitor._dup2(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 93: {
                    iBytecodeVisitor._dup2_x1(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 94: {
                    iBytecodeVisitor._dup2_x2(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 95: {
                    iBytecodeVisitor._swap(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 96: {
                    iBytecodeVisitor._iadd(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 97: {
                    iBytecodeVisitor._ladd(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 98: {
                    iBytecodeVisitor._fadd(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 99: {
                    iBytecodeVisitor._dadd(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 100: {
                    iBytecodeVisitor._isub(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 101: {
                    iBytecodeVisitor._lsub(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 102: {
                    iBytecodeVisitor._fsub(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 103: {
                    iBytecodeVisitor._dsub(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 104: {
                    iBytecodeVisitor._imul(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 105: {
                    iBytecodeVisitor._lmul(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 106: {
                    iBytecodeVisitor._fmul(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 107: {
                    iBytecodeVisitor._dmul(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 108: {
                    iBytecodeVisitor._idiv(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 109: {
                    iBytecodeVisitor._ldiv(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 110: {
                    iBytecodeVisitor._fdiv(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 111: {
                    iBytecodeVisitor._ddiv(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 112: {
                    iBytecodeVisitor._irem(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 113: {
                    iBytecodeVisitor._lrem(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 114: {
                    iBytecodeVisitor._frem(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 115: {
                    iBytecodeVisitor._drem(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 116: {
                    iBytecodeVisitor._ineg(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 117: {
                    iBytecodeVisitor._lneg(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 118: {
                    iBytecodeVisitor._fneg(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 119: {
                    iBytecodeVisitor._dneg(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 120: {
                    iBytecodeVisitor._ishl(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 121: {
                    iBytecodeVisitor._lshl(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 122: {
                    iBytecodeVisitor._ishr(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 123: {
                    iBytecodeVisitor._lshr(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 124: {
                    iBytecodeVisitor._iushr(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 125: {
                    iBytecodeVisitor._lushr(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 126: {
                    iBytecodeVisitor._iand(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 127: {
                    iBytecodeVisitor._land(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 128: {
                    iBytecodeVisitor._ior(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 129: {
                    iBytecodeVisitor._lor(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 130: {
                    iBytecodeVisitor._ixor(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 131: {
                    iBytecodeVisitor._lxor(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 132: {
                    int n3 = this.u1At(this.classFileBytes, 1, n);
                    int n4 = this.i1At(this.classFileBytes, 2, n);
                    iBytecodeVisitor._iinc(n - this.codeOffset, n3, n4);
                    n += 3;
                    break;
                }
                case 133: {
                    iBytecodeVisitor._i2l(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 134: {
                    iBytecodeVisitor._i2f(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 135: {
                    iBytecodeVisitor._i2d(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 136: {
                    iBytecodeVisitor._l2i(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 137: {
                    iBytecodeVisitor._l2f(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 138: {
                    iBytecodeVisitor._l2d(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 139: {
                    iBytecodeVisitor._f2i(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 140: {
                    iBytecodeVisitor._f2l(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 141: {
                    iBytecodeVisitor._f2d(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 142: {
                    iBytecodeVisitor._d2i(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 143: {
                    iBytecodeVisitor._d2l(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 144: {
                    iBytecodeVisitor._d2f(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 145: {
                    iBytecodeVisitor._i2b(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 146: {
                    iBytecodeVisitor._i2c(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 147: {
                    iBytecodeVisitor._i2s(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 148: {
                    iBytecodeVisitor._lcmp(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 149: {
                    iBytecodeVisitor._fcmpl(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 150: {
                    iBytecodeVisitor._fcmpg(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 151: {
                    iBytecodeVisitor._dcmpl(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 152: {
                    iBytecodeVisitor._dcmpg(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 153: {
                    int n5 = this.i2At(this.classFileBytes, 1, n);
                    iBytecodeVisitor._ifeq(n - this.codeOffset, n5);
                    n += 3;
                    break;
                }
                case 154: {
                    int n5 = this.i2At(this.classFileBytes, 1, n);
                    iBytecodeVisitor._ifne(n - this.codeOffset, n5);
                    n += 3;
                    break;
                }
                case 155: {
                    int n5 = this.i2At(this.classFileBytes, 1, n);
                    iBytecodeVisitor._iflt(n - this.codeOffset, n5);
                    n += 3;
                    break;
                }
                case 156: {
                    int n5 = this.i2At(this.classFileBytes, 1, n);
                    iBytecodeVisitor._ifge(n - this.codeOffset, n5);
                    n += 3;
                    break;
                }
                case 157: {
                    int n5 = this.i2At(this.classFileBytes, 1, n);
                    iBytecodeVisitor._ifgt(n - this.codeOffset, n5);
                    n += 3;
                    break;
                }
                case 158: {
                    int n5 = this.i2At(this.classFileBytes, 1, n);
                    iBytecodeVisitor._ifle(n - this.codeOffset, n5);
                    n += 3;
                    break;
                }
                case 159: {
                    int n5 = this.i2At(this.classFileBytes, 1, n);
                    iBytecodeVisitor._if_icmpeq(n - this.codeOffset, n5);
                    n += 3;
                    break;
                }
                case 160: {
                    int n5 = this.i2At(this.classFileBytes, 1, n);
                    iBytecodeVisitor._if_icmpne(n - this.codeOffset, n5);
                    n += 3;
                    break;
                }
                case 161: {
                    int n5 = this.i2At(this.classFileBytes, 1, n);
                    iBytecodeVisitor._if_icmplt(n - this.codeOffset, n5);
                    n += 3;
                    break;
                }
                case 162: {
                    int n5 = this.i2At(this.classFileBytes, 1, n);
                    iBytecodeVisitor._if_icmpge(n - this.codeOffset, n5);
                    n += 3;
                    break;
                }
                case 163: {
                    int n5 = this.i2At(this.classFileBytes, 1, n);
                    iBytecodeVisitor._if_icmpgt(n - this.codeOffset, n5);
                    n += 3;
                    break;
                }
                case 164: {
                    int n5 = this.i2At(this.classFileBytes, 1, n);
                    iBytecodeVisitor._if_icmple(n - this.codeOffset, n5);
                    n += 3;
                    break;
                }
                case 165: {
                    int n5 = this.i2At(this.classFileBytes, 1, n);
                    iBytecodeVisitor._if_acmpeq(n - this.codeOffset, n5);
                    n += 3;
                    break;
                }
                case 166: {
                    int n5 = this.i2At(this.classFileBytes, 1, n);
                    iBytecodeVisitor._if_acmpne(n - this.codeOffset, n5);
                    n += 3;
                    break;
                }
                case 167: {
                    int n5 = this.i2At(this.classFileBytes, 1, n);
                    iBytecodeVisitor._goto(n - this.codeOffset, n5);
                    n += 3;
                    break;
                }
                case 168: {
                    int n5 = this.i2At(this.classFileBytes, 1, n);
                    iBytecodeVisitor._jsr(n - this.codeOffset, n5);
                    n += 3;
                    break;
                }
                case 169: {
                    int n3 = this.u1At(this.classFileBytes, 1, n);
                    iBytecodeVisitor._ret(n - this.codeOffset, n3);
                    n += 2;
                    break;
                }
                case 170: {
                    int n6 = n++;
                    while ((n - this.codeOffset & 3) != 0) {
                        ++n;
                    }
                    int n7 = this.i4At(this.classFileBytes, 0, n);
                    int n8 = this.i4At(this.classFileBytes, 0, n += 4);
                    int n9 = this.i4At(this.classFileBytes, 0, n += 4);
                    n += 4;
                    int n10 = n9 - n8 + 1;
                    int[] nArray = new int[n10];
                    int n11 = 0;
                    while (n11 < n10) {
                        nArray[n11] = this.i4At(this.classFileBytes, 0, n);
                        n += 4;
                        ++n11;
                    }
                    iBytecodeVisitor._tableswitch(n6 - this.codeOffset, n7, n8, n9, nArray);
                    break;
                }
                case 171: {
                    int n6 = n++;
                    while ((n - this.codeOffset & 3) != 0) {
                        ++n;
                    }
                    int n7 = this.i4At(this.classFileBytes, 0, n);
                    int n11 = (int)this.u4At(this.classFileBytes, 0, n += 4);
                    int[][] nArray = new int[n11][2];
                    n += 4;
                    int n12 = 0;
                    while (n12 < n11) {
                        nArray[n12][0] = this.i4At(this.classFileBytes, 0, n);
                        nArray[n12][1] = this.i4At(this.classFileBytes, 0, n += 4);
                        n += 4;
                        ++n12;
                    }
                    iBytecodeVisitor._lookupswitch(n6 - this.codeOffset, n7, n11, nArray);
                    break;
                }
                case 172: {
                    iBytecodeVisitor._ireturn(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 173: {
                    iBytecodeVisitor._lreturn(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 174: {
                    iBytecodeVisitor._freturn(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 175: {
                    iBytecodeVisitor._dreturn(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 176: {
                    iBytecodeVisitor._areturn(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 177: {
                    iBytecodeVisitor._return(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 178: {
                    int n3 = this.u2At(this.classFileBytes, 1, n);
                    IConstantPoolEntry iConstantPoolEntry = this.constantPool.decodeEntry(n3);
                    if (iConstantPoolEntry.getKind() != 9) {
                        throw new ClassFormatException(3);
                    }
                    iBytecodeVisitor._getstatic(n - this.codeOffset, n3, iConstantPoolEntry);
                    n += 3;
                    break;
                }
                case 179: {
                    int n3 = this.u2At(this.classFileBytes, 1, n);
                    IConstantPoolEntry iConstantPoolEntry = this.constantPool.decodeEntry(n3);
                    if (iConstantPoolEntry.getKind() != 9) {
                        throw new ClassFormatException(3);
                    }
                    iBytecodeVisitor._putstatic(n - this.codeOffset, n3, iConstantPoolEntry);
                    n += 3;
                    break;
                }
                case 180: {
                    int n3 = this.u2At(this.classFileBytes, 1, n);
                    IConstantPoolEntry iConstantPoolEntry = this.constantPool.decodeEntry(n3);
                    if (iConstantPoolEntry.getKind() != 9) {
                        throw new ClassFormatException(3);
                    }
                    iBytecodeVisitor._getfield(n - this.codeOffset, n3, iConstantPoolEntry);
                    n += 3;
                    break;
                }
                case 181: {
                    int n3 = this.u2At(this.classFileBytes, 1, n);
                    IConstantPoolEntry iConstantPoolEntry = this.constantPool.decodeEntry(n3);
                    if (iConstantPoolEntry.getKind() != 9) {
                        throw new ClassFormatException(3);
                    }
                    iBytecodeVisitor._putfield(n - this.codeOffset, n3, iConstantPoolEntry);
                    n += 3;
                    break;
                }
                case 182: {
                    int n3 = this.u2At(this.classFileBytes, 1, n);
                    IConstantPoolEntry iConstantPoolEntry = this.constantPool.decodeEntry(n3);
                    if (iConstantPoolEntry.getKind() != 10) {
                        throw new ClassFormatException(3);
                    }
                    iBytecodeVisitor._invokevirtual(n - this.codeOffset, n3, iConstantPoolEntry);
                    n += 3;
                    break;
                }
                case 183: {
                    int n3 = this.u2At(this.classFileBytes, 1, n);
                    IConstantPoolEntry iConstantPoolEntry = this.constantPool.decodeEntry(n3);
                    if (iConstantPoolEntry.getKind() != 10) {
                        throw new ClassFormatException(3);
                    }
                    iBytecodeVisitor._invokespecial(n - this.codeOffset, n3, iConstantPoolEntry);
                    n += 3;
                    break;
                }
                case 184: {
                    int n3 = this.u2At(this.classFileBytes, 1, n);
                    IConstantPoolEntry iConstantPoolEntry = this.constantPool.decodeEntry(n3);
                    if (iConstantPoolEntry.getKind() != 10) {
                        throw new ClassFormatException(3);
                    }
                    iBytecodeVisitor._invokestatic(n - this.codeOffset, n3, iConstantPoolEntry);
                    n += 3;
                    break;
                }
                case 185: {
                    int n3 = this.u2At(this.classFileBytes, 1, n);
                    IConstantPoolEntry iConstantPoolEntry = this.constantPool.decodeEntry(n3);
                    if (iConstantPoolEntry.getKind() != 11) {
                        throw new ClassFormatException(3);
                    }
                    int n12 = this.u1At(this.classFileBytes, 3, n);
                    int n13 = this.u1At(this.classFileBytes, 4, n);
                    if (n13 != 0) {
                        throw new ClassFormatException(5);
                    }
                    iBytecodeVisitor._invokeinterface(n - this.codeOffset, n3, (byte)n12, iConstantPoolEntry);
                    n += 5;
                    break;
                }
                case 187: {
                    int n3 = this.u2At(this.classFileBytes, 1, n);
                    IConstantPoolEntry iConstantPoolEntry = this.constantPool.decodeEntry(n3);
                    if (iConstantPoolEntry.getKind() != 7) {
                        throw new ClassFormatException(3);
                    }
                    iBytecodeVisitor._new(n - this.codeOffset, n3, iConstantPoolEntry);
                    n += 3;
                    break;
                }
                case 188: {
                    int n14 = this.u1At(this.classFileBytes, 1, n);
                    iBytecodeVisitor._newarray(n - this.codeOffset, n14);
                    n += 2;
                    break;
                }
                case 189: {
                    int n3 = this.u2At(this.classFileBytes, 1, n);
                    IConstantPoolEntry iConstantPoolEntry = this.constantPool.decodeEntry(n3);
                    if (iConstantPoolEntry.getKind() != 7) {
                        throw new ClassFormatException(3);
                    }
                    iBytecodeVisitor._anewarray(n - this.codeOffset, n3, iConstantPoolEntry);
                    n += 3;
                    break;
                }
                case 190: {
                    iBytecodeVisitor._arraylength(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 191: {
                    iBytecodeVisitor._athrow(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 192: {
                    int n3 = this.u2At(this.classFileBytes, 1, n);
                    IConstantPoolEntry iConstantPoolEntry = this.constantPool.decodeEntry(n3);
                    if (iConstantPoolEntry.getKind() != 7) {
                        throw new ClassFormatException(3);
                    }
                    iBytecodeVisitor._checkcast(n - this.codeOffset, n3, iConstantPoolEntry);
                    n += 3;
                    break;
                }
                case 193: {
                    int n3 = this.u2At(this.classFileBytes, 1, n);
                    IConstantPoolEntry iConstantPoolEntry = this.constantPool.decodeEntry(n3);
                    if (iConstantPoolEntry.getKind() != 7) {
                        throw new ClassFormatException(3);
                    }
                    iBytecodeVisitor._instanceof(n - this.codeOffset, n3, iConstantPoolEntry);
                    n += 3;
                    break;
                }
                case 194: {
                    iBytecodeVisitor._monitorenter(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 195: {
                    iBytecodeVisitor._monitorexit(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 196: {
                    int n4;
                    int n3;
                    n2 = this.u1At(this.classFileBytes, 1, n);
                    if (n2 == 132) {
                        n3 = this.u2At(this.classFileBytes, 2, n);
                        n4 = this.i2At(this.classFileBytes, 4, n);
                        iBytecodeVisitor._wide(n - this.codeOffset, n2, n3, n4);
                        n += 6;
                        break;
                    }
                    n3 = this.u2At(this.classFileBytes, 2, n);
                    iBytecodeVisitor._wide(n - this.codeOffset, n2, n3);
                    n += 4;
                    break;
                }
                case 197: {
                    int n3 = this.u2At(this.classFileBytes, 1, n);
                    IConstantPoolEntry iConstantPoolEntry = this.constantPool.decodeEntry(n3);
                    if (iConstantPoolEntry.getKind() != 7) {
                        throw new ClassFormatException(3);
                    }
                    int n15 = this.u1At(this.classFileBytes, 3, n);
                    iBytecodeVisitor._multianewarray(n - this.codeOffset, n3, n15, iConstantPoolEntry);
                    n += 4;
                    break;
                }
                case 198: {
                    int n5 = this.i2At(this.classFileBytes, 1, n);
                    iBytecodeVisitor._ifnull(n - this.codeOffset, n5);
                    n += 3;
                    break;
                }
                case 199: {
                    int n5 = this.i2At(this.classFileBytes, 1, n);
                    iBytecodeVisitor._ifnonnull(n - this.codeOffset, n5);
                    n += 3;
                    break;
                }
                case 200: {
                    int n5 = this.i4At(this.classFileBytes, 1, n);
                    iBytecodeVisitor._goto_w(n - this.codeOffset, n5);
                    n += 5;
                    break;
                }
                case 201: {
                    int n5 = this.i4At(this.classFileBytes, 1, n);
                    iBytecodeVisitor._jsr_w(n - this.codeOffset, n5);
                    n += 5;
                    break;
                }
                case 202: {
                    iBytecodeVisitor._breakpoint(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 254: {
                    iBytecodeVisitor._impdep1(n - this.codeOffset);
                    ++n;
                    break;
                }
                case 255: {
                    iBytecodeVisitor._impdep2(n - this.codeOffset);
                    ++n;
                    break;
                }
                default: {
                    throw new ClassFormatException(6);
                }
            }
        } while ((long)n < this.codeLength + (long)this.codeOffset);
    }
}

