/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.util;

import java.util.Locale;
import java.util.Map;
import org.eclipse.wst.jsdt.core.compiler.CategorizedProblem;
import org.eclipse.wst.jsdt.internal.compiler.CompilationResult;
import org.eclipse.wst.jsdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.wst.jsdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.wst.jsdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.wst.jsdt.internal.core.util.CommentRecorderParser;
import org.eclipse.wst.jsdt.internal.core.util.RecordedParsingInformation;

public class CodeSnippetParsingUtil {
    public RecordedParsingInformation recordedParsingInformation;

    private RecordedParsingInformation getRecordedParsingInformation(CompilationResult compilationResult, CommentRecorderParser commentRecorderParser) {
        int n = compilationResult.problemCount;
        CategorizedProblem[] categorizedProblemArray = null;
        if (n != 0) {
            CategorizedProblem[] categorizedProblemArray2 = compilationResult.problems;
            if (categorizedProblemArray2.length == n) {
                categorizedProblemArray = categorizedProblemArray2;
            } else {
                categorizedProblemArray = new CategorizedProblem[n];
                System.arraycopy(categorizedProblemArray2, 0, categorizedProblemArray, 0, n);
            }
        }
        return new RecordedParsingInformation(categorizedProblemArray, compilationResult.getLineSeparatorPositions(), commentRecorderParser.getCommentsPositions());
    }

    public ASTNode[] parseClassBodyDeclarations(char[] cArray, Map map, boolean bl) {
        return this.parseClassBodyDeclarations(cArray, 0, cArray.length, map, bl);
    }

    public ASTNode[] parseClassBodyDeclarations(char[] cArray, int n, int n2, Map map, boolean bl) {
        if (cArray == null) {
            throw new IllegalArgumentException();
        }
        CompilerOptions compilerOptions = new CompilerOptions(map);
        ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), compilerOptions, new DefaultProblemFactory(Locale.getDefault()));
        CommentRecorderParser commentRecorderParser = new CommentRecorderParser(problemReporter, false);
        commentRecorderParser.setMethodsFullRecovery(false);
        commentRecorderParser.setStatementsRecovery(false);
        CompilationUnit compilationUnit = new CompilationUnit(cArray, "", compilerOptions.defaultEncoding);
        CompilationResult compilationResult = new CompilationResult(compilationUnit, 0, 0, compilerOptions.maxProblemsPerUnit);
        CompilationUnitDeclaration compilationUnitDeclaration = new CompilationUnitDeclaration(problemReporter, compilationResult, cArray.length);
        ASTNode[] aSTNodeArray = commentRecorderParser.parseClassBodyDeclarations(cArray, n, n2, compilationUnitDeclaration);
        if (bl) {
            this.recordedParsingInformation = this.getRecordedParsingInformation(compilationResult, commentRecorderParser);
        }
        return aSTNodeArray;
    }

    public CompilationUnitDeclaration parseCompilationUnit(char[] cArray, Map map, boolean bl) {
        if (cArray == null) {
            throw new IllegalArgumentException();
        }
        CompilerOptions compilerOptions = new CompilerOptions(map);
        CommentRecorderParser commentRecorderParser = new CommentRecorderParser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), compilerOptions, new DefaultProblemFactory(Locale.getDefault())), false);
        CompilationUnit compilationUnit = new CompilationUnit(cArray, "", compilerOptions.defaultEncoding);
        CompilationResult compilationResult = new CompilationResult(compilationUnit, 0, 0, compilerOptions.maxProblemsPerUnit);
        CompilationUnitDeclaration compilationUnitDeclaration = commentRecorderParser.dietParse(compilationUnit, compilationResult);
        if (bl) {
            this.recordedParsingInformation = this.getRecordedParsingInformation(compilationResult, commentRecorderParser);
        }
        if (compilationUnitDeclaration.ignoreMethodBodies) {
            compilationUnitDeclaration.ignoreFurtherInvestigation = true;
            return compilationUnitDeclaration;
        }
        commentRecorderParser.scanner.setSource(compilationResult);
        TypeDeclaration[] typeDeclarationArray = compilationUnitDeclaration.types;
        if (typeDeclarationArray != null) {
            int n = typeDeclarationArray.length;
            while (--n >= 0) {
                typeDeclarationArray[n].parseMethod(commentRecorderParser, compilationUnitDeclaration);
            }
        }
        if (bl) {
            this.recordedParsingInformation.updateRecordedParsingInformation(compilationResult);
        }
        return compilationUnitDeclaration;
    }

    public Expression parseExpression(char[] cArray, Map map, boolean bl) {
        return this.parseExpression(cArray, 0, cArray.length, map, bl);
    }

    public Expression parseExpression(char[] cArray, int n, int n2, Map map, boolean bl) {
        if (cArray == null) {
            throw new IllegalArgumentException();
        }
        CompilerOptions compilerOptions = new CompilerOptions(map);
        ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), compilerOptions, new DefaultProblemFactory(Locale.getDefault()));
        CommentRecorderParser commentRecorderParser = new CommentRecorderParser(problemReporter, false);
        CompilationUnit compilationUnit = new CompilationUnit(cArray, "", compilerOptions.defaultEncoding);
        CompilationResult compilationResult = new CompilationResult(compilationUnit, 0, 0, compilerOptions.maxProblemsPerUnit);
        Expression expression = commentRecorderParser.parseExpression(cArray, n, n2, new CompilationUnitDeclaration(problemReporter, compilationResult, cArray.length));
        if (bl) {
            this.recordedParsingInformation = this.getRecordedParsingInformation(compilationResult, commentRecorderParser);
        }
        return expression;
    }

    public ConstructorDeclaration parseStatements(char[] cArray, Map map, boolean bl, boolean bl2) {
        return this.parseStatements(cArray, 0, cArray.length, map, bl, bl2);
    }

    public ConstructorDeclaration parseStatements(char[] cArray, int n, int n2, Map map, boolean bl, boolean bl2) {
        if (cArray == null) {
            throw new IllegalArgumentException();
        }
        CompilerOptions compilerOptions = new CompilerOptions(map);
        ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), compilerOptions, new DefaultProblemFactory(Locale.getDefault()));
        CommentRecorderParser commentRecorderParser = new CommentRecorderParser(problemReporter, false);
        commentRecorderParser.setMethodsFullRecovery(false);
        commentRecorderParser.setStatementsRecovery(bl2);
        CompilationUnit compilationUnit = new CompilationUnit(cArray, "", compilerOptions.defaultEncoding);
        CompilationResult compilationResult = new CompilationResult(compilationUnit, 0, 0, compilerOptions.maxProblemsPerUnit);
        CompilationUnitDeclaration compilationUnitDeclaration = new CompilationUnitDeclaration(problemReporter, compilationResult, n2);
        ConstructorDeclaration constructorDeclaration = new ConstructorDeclaration(compilationResult);
        constructorDeclaration.sourceEnd = -1;
        constructorDeclaration.declarationSourceEnd = n + n2 - 1;
        constructorDeclaration.bodyStart = n;
        constructorDeclaration.bodyEnd = n + n2 - 1;
        commentRecorderParser.scanner.setSource(compilationResult);
        commentRecorderParser.scanner.resetTo(n, n + n2);
        commentRecorderParser.parse(constructorDeclaration, compilationUnitDeclaration, true);
        if (bl) {
            this.recordedParsingInformation = this.getRecordedParsingInformation(compilationResult, commentRecorderParser);
        }
        return constructorDeclaration;
    }
}

