/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.util;

import org.eclipse.wst.jsdt.core.util.ClassFormatException;
import org.eclipse.wst.jsdt.core.util.IConstantPool;
import org.eclipse.wst.jsdt.core.util.IStackMapFrame;
import org.eclipse.wst.jsdt.core.util.IStackMapTableAttribute;
import org.eclipse.wst.jsdt.internal.core.util.ClassFileAttribute;
import org.eclipse.wst.jsdt.internal.core.util.StackMapFrame;

public class StackMapTableAttribute
extends ClassFileAttribute
implements IStackMapTableAttribute {
    private static final IStackMapFrame[] NO_FRAMES = new IStackMapFrame[0];
    private static final byte[] NO_ENTRIES = new byte[0];
    private int numberOfEntries;
    private IStackMapFrame[] frames;
    private byte[] bytes;

    public StackMapTableAttribute(byte[] byArray, IConstantPool iConstantPool, int n) throws ClassFormatException {
        super(byArray, iConstantPool, n);
        int n2;
        int n3;
        this.numberOfEntries = n3 = this.u2At(byArray, 6, n);
        if (n3 != 0) {
            n2 = 8;
            this.frames = new IStackMapFrame[n3];
            int n4 = 0;
            while (n4 < n3) {
                StackMapFrame stackMapFrame = new StackMapFrame(byArray, iConstantPool, n + n2);
                this.frames[n4] = stackMapFrame;
                n2 += stackMapFrame.sizeInBytes();
                ++n4;
            }
        } else {
            this.frames = NO_FRAMES;
        }
        n2 = (int)this.u4At(byArray, 2, n);
        if (n3 != 0) {
            this.bytes = new byte[n2];
            System.arraycopy(byArray, n + 6, this.bytes, 0, n2);
        } else {
            this.bytes = NO_ENTRIES;
        }
    }

    public int getNumberOfEntries() {
        return this.numberOfEntries;
    }

    public IStackMapFrame[] getStackMapFrame() {
        return this.frames;
    }

    public byte[] getBytes() {
        return this.bytes;
    }
}

