/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaConventions;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.dom.ArrayType;
import org.eclipse.wst.jsdt.core.dom.InferredType;
import org.eclipse.wst.jsdt.core.dom.ParameterizedType;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.QualifiedType;
import org.eclipse.wst.jsdt.core.dom.SimpleType;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.WildcardType;
import org.eclipse.wst.jsdt.core.util.IClassFileAttribute;
import org.eclipse.wst.jsdt.core.util.IClassFileReader;
import org.eclipse.wst.jsdt.core.util.ICodeAttribute;
import org.eclipse.wst.jsdt.core.util.IFieldInfo;
import org.eclipse.wst.jsdt.core.util.IMethodInfo;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Argument;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.wst.jsdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.wst.jsdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.wst.jsdt.internal.compiler.parser.ScannerHelper;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.PackageFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.util.CharArrayBuffer;
import org.eclipse.wst.jsdt.internal.core.util.KeyToSignature;
import org.eclipse.wst.jsdt.internal.core.util.SimpleDocument;
import org.eclipse.wst.jsdt.internal.infer.InferEngine;

public class Util {
    private static final String ARGUMENTS_DELIMITER = "#";
    private static final String EMPTY_ARGUMENT = "   ";
    private static char[][] JAVA_LIKE_EXTENSIONS;
    public static boolean ENABLE_JAVA_LIKE_EXTENSIONS;
    private static final char[] BOOLEAN;
    private static final char[] BYTE;
    private static final char[] CHAR;
    private static final char[] DOUBLE;
    private static final char[] FLOAT;
    private static final char[] INT;
    private static final char[] LONG;
    private static final char[] SHORT;
    private static final char[] VOID;
    private static final char[] INIT;
    public static final String ANONYMOUS_MARKER;
    public static final String ANONYMOUS_LABEL = "{}";

    static {
        ENABLE_JAVA_LIKE_EXTENSIONS = true;
        BOOLEAN = "boolean".toCharArray();
        BYTE = "byte".toCharArray();
        CHAR = "char".toCharArray();
        DOUBLE = "double".toCharArray();
        FLOAT = "float".toCharArray();
        INT = "int".toCharArray();
        LONG = "long".toCharArray();
        SHORT = "short".toCharArray();
        VOID = "void".toCharArray();
        INIT = "<init>".toCharArray();
        ANONYMOUS_MARKER = new String(CharOperation.concat(InferEngine.ANONYMOUS_PREFIX, InferEngine.ANONYMOUS_CLASS_ID));
    }

    private Util() {
    }

    public static boolean isSameResourceString(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        int n = string.toLowerCase().indexOf(string2.toLowerCase());
        return n > -1 && n + string2.length() == string.length();
    }

    public static boolean isSameResourceString(IPath iPath, IPath iPath2) {
        return Util.isSameResourceString(iPath.toString(), iPath2.toString());
    }

    public static final String[] arrayConcat(String[] stringArray, String string) {
        if (string == null) {
            return stringArray;
        }
        if (stringArray == null) {
            return new String[]{string};
        }
        int n = stringArray.length;
        if (stringArray.length == 0) {
            return new String[]{string};
        }
        String[] stringArray2 = new String[n + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        stringArray2[n] = string;
        return stringArray2;
    }

    private static int checkTypeSignature(String string, int n, int n2, boolean bl) {
        if (n >= n2) {
            return -1;
        }
        int n3 = n;
        char c = string.charAt(n3++);
        int n4 = 0;
        while (c == '[') {
            ++n4;
            if (n3 >= n2) {
                return -1;
            }
            c = string.charAt(n3++);
        }
        switch (c) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                break;
            }
            case 'V': {
                if (!bl) {
                    return -1;
                }
                if (n4 == 0) break;
                return -1;
            }
            case 'L': {
                int n5 = string.indexOf(59, n3);
                if (n5 <= n3 || n5 >= n2) {
                    return -1;
                }
                n3 = n5 + 1;
                break;
            }
            default: {
                return -1;
            }
        }
        return n3;
    }

    public static int combineHashCodes(int n, int n2) {
        return n * 17 + n2;
    }

    public static int compare(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return 0;
        }
        if (byArray == null) {
            return -1;
        }
        if (byArray2 == null) {
            return 1;
        }
        int n = Math.min(byArray.length, byArray2.length);
        int n2 = 0;
        while (n2 < n) {
            int n3 = byArray[n2] - byArray2[n2];
            if (n3 != 0) {
                return n3;
            }
            ++n2;
        }
        if (byArray.length > n) {
            return 1;
        }
        if (byArray2.length > n) {
            return -1;
        }
        return 0;
    }

    public static int compare(char[] cArray, char[] cArray2) {
        int n = cArray.length;
        int n2 = cArray2.length;
        int n3 = Math.min(n, n2);
        int n4 = 0;
        while (n3-- != 0) {
            char c;
            char c2 = cArray[n4];
            if (c2 == (c = cArray2[n4++])) continue;
            return c2 - c;
        }
        return n - n2;
    }

    public static String concat(String string, char c, String string2) {
        if (string == null) {
            string = "null";
        }
        if (string2 == null) {
            string2 = "null";
        }
        int n = string.length();
        int n2 = string2.length();
        char[] cArray = new char[n + 1 + n2];
        string.getChars(0, n, cArray, 0);
        cArray[n] = c;
        string2.getChars(0, n2, cArray, n + 1);
        return new String(cArray);
    }

    public static String concat(String string, String string2) {
        if (string == null) {
            string = "null";
        }
        if (string2 == null) {
            string2 = "null";
        }
        int n = string.length();
        int n2 = string2.length();
        char[] cArray = new char[n + n2];
        string.getChars(0, n, cArray, 0);
        string2.getChars(0, n2, cArray, n);
        return new String(cArray);
    }

    public static final String concatWith(String[] stringArray, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            stringBuffer.append(stringArray[n]);
            if (n < n2 - 1) {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static final String concatWith(String[] stringArray, String string, char c) {
        if (stringArray == null || stringArray.length == 0) {
            return string;
        }
        if (string == null || string.length() == 0) {
            return Util.concatWith(stringArray, c);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            stringBuffer.append(stringArray[n]);
            stringBuffer.append(c);
            ++n;
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static String concat(String string, String string2, String string3) {
        if (string == null) {
            string = "null";
        }
        if (string2 == null) {
            string2 = "null";
        }
        if (string3 == null) {
            string3 = "null";
        }
        int n = string.length();
        int n2 = string2.length();
        int n3 = string3.length();
        char[] cArray = new char[n + n2 + n3];
        string.getChars(0, n, cArray, 0);
        string2.getChars(0, n2, cArray, n);
        string3.getChars(0, n3, cArray, n + n2);
        return new String(cArray);
    }

    public static String convertTypeSignature(char[] cArray, int n, int n2) {
        return new String(cArray, n, n2).replace('/', '.');
    }

    public static String defaultJavaExtension() {
        return ".js";
    }

    public static final String editedString(String string, TextEdit textEdit) {
        if (textEdit == null) {
            return string;
        }
        SimpleDocument simpleDocument = new SimpleDocument(string);
        try {
            textEdit.apply((IDocument)simpleDocument, 0);
            return simpleDocument.get();
        }
        catch (MalformedTreeException malformedTreeException) {
            malformedTreeException.printStackTrace();
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        return string;
    }

    public static final boolean endsWithIgnoreCase(String string, String string2) {
        int n;
        int n2 = string == null ? 0 : string.length();
        int n3 = n = string2 == null ? 0 : string2.length();
        if (n > n2) {
            return false;
        }
        int n4 = 1;
        while (n4 <= n) {
            if (ScannerHelper.toLowerCase(string2.charAt(n - n4)) != ScannerHelper.toLowerCase(string.charAt(n2 - n4))) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    public static boolean equalArrays(Object[] objectArray, Object[] objectArray2, int n) {
        if (objectArray == objectArray2) {
            return true;
        }
        if (objectArray.length < n || objectArray2.length < n) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (objectArray[n2] == null ? objectArray2[n2] != null : !objectArray[n2].equals(objectArray2[n2])) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean equalArraysOrNull(int[] nArray, int[] nArray2) {
        if (nArray == nArray2) {
            return true;
        }
        if (nArray == null || nArray2 == null) {
            return false;
        }
        int n = nArray.length;
        if (n != nArray2.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (nArray[n2] != nArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean equalArraysOrNull(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == objectArray2) {
            return true;
        }
        if (objectArray == null || objectArray2 == null) {
            return false;
        }
        int n = objectArray.length;
        if (n != objectArray2.length) {
            return false;
        }
        int n2 = n - 1;
        while (n2 >= 0) {
            if (objectArray[n2] == null ? objectArray2[n2] != null : !objectArray[n2].equals(objectArray2[n2])) {
                return false;
            }
            --n2;
        }
        return true;
    }

    public static boolean equalArraysOrNullSortFirst(Comparable[] comparableArray, Comparable[] comparableArray2) {
        if (comparableArray == comparableArray2) {
            return true;
        }
        if (comparableArray == null || comparableArray2 == null) {
            return false;
        }
        int n = comparableArray.length;
        if (n != comparableArray2.length) {
            return false;
        }
        if (n >= 2) {
            comparableArray = Util.sortCopy(comparableArray);
            comparableArray2 = Util.sortCopy(comparableArray2);
        }
        int n2 = 0;
        while (n2 < n) {
            if (!comparableArray[n2].equals(comparableArray2[n2])) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean equalArraysOrNullSortFirst(String[] stringArray, String[] stringArray2) {
        if (stringArray == stringArray2) {
            return true;
        }
        if (stringArray == null || stringArray2 == null) {
            return false;
        }
        int n = stringArray.length;
        if (n != stringArray2.length) {
            return false;
        }
        if (n >= 2) {
            stringArray = Util.sortCopy(stringArray);
            stringArray2 = Util.sortCopy(stringArray2);
        }
        int n2 = 0;
        while (n2 < n) {
            if (!stringArray[n2].equals(stringArray2[n2])) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean equalOrNull(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        return object.equals(object2);
    }

    public static boolean equalsIgnoreJavaLikeExtension(String string, String string2) {
        int n;
        int n2 = string.length();
        if (n2 < (n = string2.length())) {
            return false;
        }
        int n3 = 0;
        while (n3 < n) {
            if (string.charAt(n3) != string2.charAt(n3)) {
                return false;
            }
            ++n3;
        }
        char[][] cArray = Util.getJavaLikeExtensions();
        int n4 = 0;
        int n5 = cArray.length;
        while (n4 < n5) {
            block7: {
                int n6 = n + 1;
                char[] cArray2 = cArray[n4];
                if (n6 + cArray2.length == n2 && string.charAt(n) == '.') {
                    int n7 = n6;
                    while (n7 < n2) {
                        if (string.charAt(n7) == cArray2[n7 - n6]) {
                            ++n7;
                            continue;
                        }
                        break block7;
                    }
                    return true;
                }
            }
            ++n4;
        }
        return false;
    }

    public static String extractLastName(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    public static String[] extractParameterTypes(char[] cArray) {
        char c;
        int n = Util.getParameterCount(cArray);
        String[] stringArray = new String[n];
        if (n == 0) {
            return stringArray;
        }
        int n2 = CharOperation.indexOf('(', cArray) + 1;
        n = 0;
        int n3 = cArray.length;
        int n4 = n2;
        while (n2 != n3 && (c = cArray[n2]) != ')') {
            if (c == '[') {
                ++n2;
                continue;
            }
            if (c == 'L') {
                Assert.isTrue(((n2 = CharOperation.indexOf(';', cArray, n2 + 1) + 1) != 0 ? 1 : 0) != 0);
                stringArray[n++] = Util.convertTypeSignature(cArray, n4, n2 - n4);
                n4 = n2;
                continue;
            }
            stringArray[n++] = Util.convertTypeSignature(cArray, n4, ++n2 - n4);
            n4 = n2;
        }
        return stringArray;
    }

    public static String extractReturnType(String string) {
        int n = string.lastIndexOf(41);
        Assert.isTrue((n != -1 ? 1 : 0) != 0);
        return string.substring(n + 1);
    }

    private static IFile findFirstClassFile(IFolder iFolder) {
        try {
            IResource[] iResourceArray = iFolder.members();
            int n = 0;
            int n2 = iResourceArray.length;
            while (n < n2) {
                IResource iResource = iResourceArray[n];
                if (iResource.getType() == 2) {
                    return Util.findFirstClassFile((IFolder)iResource);
                }
                if (org.eclipse.wst.jsdt.internal.compiler.util.Util.isClassFileName(iResource.getName())) {
                    return (IFile)iResource;
                }
                ++n;
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    public static String findLineSeparator(char[] cArray) {
        int n = cArray.length;
        if (n > 0) {
            int n2 = cArray[0];
            int n3 = 0;
            while (n3 < n) {
                int n4 = n2;
                n2 = n3 < n - 1 ? cArray[n3 + 1] : 32;
                switch (n4) {
                    case 10: {
                        return "\n";
                    }
                    case 13: {
                        return n2 == 10 ? "\r\n" : "\r";
                    }
                }
                ++n3;
            }
        }
        return null;
    }

    public static IClassFileAttribute getAttribute(IClassFileReader iClassFileReader, char[] cArray) {
        IClassFileAttribute[] iClassFileAttributeArray = iClassFileReader.getAttributes();
        int n = 0;
        int n2 = iClassFileAttributeArray.length;
        while (n < n2) {
            if (CharOperation.equals(iClassFileAttributeArray[n].getAttributeName(), cArray)) {
                return iClassFileAttributeArray[n];
            }
            ++n;
        }
        return null;
    }

    public static IClassFileAttribute getAttribute(ICodeAttribute iCodeAttribute, char[] cArray) {
        IClassFileAttribute[] iClassFileAttributeArray = iCodeAttribute.getAttributes();
        int n = 0;
        int n2 = iClassFileAttributeArray.length;
        while (n < n2) {
            if (CharOperation.equals(iClassFileAttributeArray[n].getAttributeName(), cArray)) {
                return iClassFileAttributeArray[n];
            }
            ++n;
        }
        return null;
    }

    public static IClassFileAttribute getAttribute(IFieldInfo iFieldInfo, char[] cArray) {
        IClassFileAttribute[] iClassFileAttributeArray = iFieldInfo.getAttributes();
        int n = 0;
        int n2 = iClassFileAttributeArray.length;
        while (n < n2) {
            if (CharOperation.equals(iClassFileAttributeArray[n].getAttributeName(), cArray)) {
                return iClassFileAttributeArray[n];
            }
            ++n;
        }
        return null;
    }

    public static IClassFileAttribute getAttribute(IMethodInfo iMethodInfo, char[] cArray) {
        IClassFileAttribute[] iClassFileAttributeArray = iMethodInfo.getAttributes();
        int n = 0;
        int n2 = iClassFileAttributeArray.length;
        while (n < n2) {
            if (CharOperation.equals(iClassFileAttributeArray[n].getAttributeName(), cArray)) {
                return iClassFileAttributeArray[n];
            }
            ++n;
        }
        return null;
    }

    public static char[][] getJavaLikeExtensions() {
        if (JAVA_LIKE_EXTENSIONS == null) {
            if (!ENABLE_JAVA_LIKE_EXTENSIONS) {
                JAVA_LIKE_EXTENSIONS = new char[][]{"js".toCharArray()};
            } else {
                IContentType iContentType = Platform.getContentTypeManager().getContentType("org.eclipse.wst.jsdt.core.jsSource");
                HashSet<String> hashSet = new HashSet<String>();
                IContentType[] iContentTypeArray = Platform.getContentTypeManager().getAllContentTypes();
                int n = 0;
                int n2 = iContentTypeArray.length;
                while (n < n2) {
                    if (iContentTypeArray[n].isKindOf(iContentType)) {
                        String[] stringArray = iContentTypeArray[n].getFileSpecs(8);
                        int n3 = 0;
                        int n4 = stringArray.length;
                        while (n3 < n4) {
                            hashSet.add(stringArray[n3]);
                            ++n3;
                        }
                    }
                    ++n;
                }
                n = hashSet.size();
                char[][] cArrayArray = new char[n][];
                cArrayArray[0] = "js".toCharArray();
                int n5 = 1;
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    if ("js".equals(string)) continue;
                    cArrayArray[n5++] = string.toCharArray();
                }
                JAVA_LIKE_EXTENSIONS = cArrayArray;
            }
        }
        return JAVA_LIKE_EXTENSIONS;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getJdkLevel(Object object) {
        try {
            ClassFileReader classFileReader = null;
            if (object instanceof IFolder) {
                IFile iFile = Util.findFirstClassFile((IFolder)object);
                if (iFile != null) {
                    classFileReader = Util.newClassFileReader((IResource)iFile);
                }
            } else {
                ZipFile zipFile = null;
                try {
                    block16: {
                        try {
                            Object object2;
                            IPath iPath = null;
                            if (object instanceof IResource) {
                                iPath = ((IResource)object).getFullPath();
                            } else if (object instanceof File && !((File)(object2 = (File)object)).isDirectory()) {
                                iPath = new Path(((File)object).getPath());
                            }
                            if (iPath == null) break block16;
                            zipFile = JavaModelManager.getJavaModelManager().getZipFile(iPath);
                            object2 = zipFile.entries();
                            while (object2.hasMoreElements()) {
                                ZipEntry zipEntry = (ZipEntry)object2.nextElement();
                                String string = zipEntry.getName();
                                if (!org.eclipse.wst.jsdt.internal.compiler.util.Util.isClassFileName(string)) continue;
                                classFileReader = ClassFileReader.read(zipFile, string);
                                break;
                            }
                        }
                        catch (CoreException coreException) {}
                    }
                    Object var7_10 = null;
                    JavaModelManager.getJavaModelManager().closeZipFile(zipFile);
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    JavaModelManager.getJavaModelManager().closeZipFile(zipFile);
                    throw throwable;
                }
            }
            if (classFileReader == null) return 0L;
            return classFileReader.getVersion();
        }
        catch (CoreException coreException) {
            return 0L;
        }
        catch (ClassFormatException classFormatException) {
            return 0L;
        }
        catch (IOException iOException) {}
        return 0L;
    }

    public static String getNameWithoutJavaLikeExtension(String string) {
        int n = Util.indexOfJavaLikeExtension(string);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String getLineSeparator(String string, IJavaProject iJavaProject) {
        IScopeContext[] iScopeContextArray;
        String string2 = null;
        if (string != null && string.length() != 0 && (string2 = Util.findLineSeparator(string.toCharArray())) != null) {
            return string2;
        }
        if (iJavaProject != null) {
            iScopeContextArray = new IScopeContext[]{new ProjectScope(iJavaProject.getProject())};
            string2 = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, iScopeContextArray);
            if (string2 != null) {
                return string2;
            }
        }
        iScopeContextArray = new IScopeContext[]{new InstanceScope()};
        string2 = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, iScopeContextArray);
        if (string2 != null) {
            return string2;
        }
        return org.eclipse.wst.jsdt.internal.compiler.util.Util.LINE_SEPARATOR;
    }

    private static String getLineSeparator(char[] cArray, char[] cArray2) {
        String string = Util.findLineSeparator(cArray2);
        if (string == null && (string = Util.findLineSeparator(cArray)) == null) {
            return Util.getLineSeparator(null, null);
        }
        return string;
    }

    public static int getParameterCount(char[] cArray) {
        char c;
        int n = CharOperation.indexOf('(', cArray) + 1;
        Assert.isTrue((n != 0 ? 1 : 0) != 0);
        int n2 = 0;
        int n3 = cArray.length;
        while (n != n3 && (c = cArray[n]) != ')') {
            if (c == '[') {
                ++n;
                continue;
            }
            if (c == 'L') {
                ++n2;
                Assert.isTrue(((n = CharOperation.indexOf(';', cArray, n + 1) + 1) != 0 ? 1 : 0) != 0);
                continue;
            }
            ++n2;
            ++n;
        }
        return n2;
    }

    public static String getProblemArgumentsForMarker(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append(stringArray.length);
        stringBuffer.append(':');
        int n = 0;
        while (n < stringArray.length) {
            if (n != 0) {
                stringBuffer.append(ARGUMENTS_DELIMITER);
            }
            if (stringArray[n].length() == 0) {
                stringBuffer.append(EMPTY_ARGUMENT);
            } else {
                stringBuffer.append(stringArray[n]);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String[] getProblemArgumentsFromMarker(String string) {
        int n;
        if (string == null) {
            return null;
        }
        int n2 = string.indexOf(58);
        if (n2 == -1) {
            return null;
        }
        int n3 = string.length();
        try {
            n = Integer.parseInt(string.substring(0, n2));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        string = string.substring(n2 + 1, n3);
        String[] stringArray = new String[n3];
        int n4 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ARGUMENTS_DELIMITER);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals(EMPTY_ARGUMENT)) {
                string2 = "";
            }
            stringArray[n4++] = string2;
        }
        if (n4 != n) {
            return null;
        }
        String[] stringArray2 = stringArray;
        stringArray = new String[n4];
        System.arraycopy(stringArray2, 0, stringArray, 0, n4);
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getResourceContentsAsByteArray(IFile iFile) throws JavaModelException {
        byte[] byArray;
        InputStream inputStream = null;
        try {
            inputStream = iFile.getContents(true);
        }
        catch (CoreException coreException) {
            throw new JavaModelException(coreException);
        }
        try {
            try {
                byArray = org.eclipse.wst.jsdt.internal.compiler.util.Util.getInputStreamAsByteArray(inputStream, -1);
                Object var3_5 = null;
            }
            catch (IOException iOException) {
                throw new JavaModelException(iOException, 985);
            }
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {}
        inputStream.close();
        return byArray;
    }

    public static char[] getResourceContentsAsCharArray(IFile iFile) throws JavaModelException {
        String string;
        try {
            string = iFile.getCharset();
        }
        catch (CoreException coreException) {
            string = null;
        }
        return Util.getResourceContentsAsCharArray(iFile, string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static char[] getResourceContentsAsCharArray(IFile iFile, String string) throws JavaModelException {
        char[] cArray;
        long l;
        IPath iPath = iFile.getLocation();
        if (iPath == null) {
            try {
                l = EFS.getStore((URI)iFile.getLocationURI()).fetchInfo().getLength();
            }
            catch (CoreException coreException) {
                throw new JavaModelException(coreException);
            }
        } else {
            l = iPath.toFile().length();
        }
        InputStream inputStream = null;
        try {
            inputStream = iFile.getContents(true);
        }
        catch (CoreException coreException) {
            throw new JavaModelException(coreException, 969);
        }
        try {
            try {
                cArray = org.eclipse.wst.jsdt.internal.compiler.util.Util.getInputStreamAsCharArray(inputStream, (int)l, string);
                Object var7_9 = null;
            }
            catch (IOException iOException) {
                throw new JavaModelException(iOException, 985);
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {}
        inputStream.close();
        return cArray;
    }

    public static String getSignature(Type type) {
        StringBuffer stringBuffer = new StringBuffer();
        Util.getFullyQualifiedName(type, stringBuffer);
        return Signature.createTypeSignature(stringBuffer.toString(), false);
    }

    public static String getSourceAttachmentProperty(IPath iPath) throws JavaModelException {
        Map map = JavaModelManager.getJavaModelManager().rootPathToAttachments;
        String string = (String)map.get(iPath);
        if (string == null) {
            block5: {
                try {
                    string = ResourcesPlugin.getWorkspace().getRoot().getPersistentProperty(Util.getSourceAttachmentPropertyName(iPath));
                    if (string != null) break block5;
                    map.put(iPath, "");
                    return null;
                }
                catch (CoreException coreException) {
                    throw new JavaModelException(coreException);
                }
            }
            map.put(iPath, string);
            return string;
        }
        if (string.equals("")) {
            return null;
        }
        return string;
    }

    private static QualifiedName getSourceAttachmentPropertyName(IPath iPath) {
        return new QualifiedName("org.eclipse.wst.jsdt.core", "sourceattachment: " + iPath.toOSString());
    }

    public static void setSourceAttachmentProperty(IPath iPath, String string) {
        JavaModelManager.getJavaModelManager().rootPathToAttachments.put(iPath, string);
        try {
            ResourcesPlugin.getWorkspace().getRoot().setPersistentProperty(Util.getSourceAttachmentPropertyName(iPath), string);
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }

    public static String getDeclaringTypeSignature(String string) {
        KeyToSignature keyToSignature = new KeyToSignature(string, 2);
        keyToSignature.parse();
        return keyToSignature.signature.toString();
    }

    private static void getFullyQualifiedName(Type type, StringBuffer stringBuffer) {
        switch (type.getNodeType()) {
            case 5: {
                ArrayType arrayType = (ArrayType)type;
                Util.getFullyQualifiedName(arrayType.getElementType(), stringBuffer);
                int n = 0;
                int n2 = arrayType.getDimensions();
                while (n < n2) {
                    stringBuffer.append('[');
                    stringBuffer.append(']');
                    ++n;
                }
                break;
            }
            case 74: {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Util.getFullyQualifiedName(parameterizedType.getType(), stringBuffer);
                stringBuffer.append('<');
                Iterator iterator = parameterizedType.typeArguments().iterator();
                boolean bl = true;
                while (iterator.hasNext()) {
                    if (!bl) {
                        stringBuffer.append(',');
                    } else {
                        bl = false;
                    }
                    Type type2 = (Type)iterator.next();
                    Util.getFullyQualifiedName(type2, stringBuffer);
                }
                stringBuffer.append('>');
                break;
            }
            case 39: {
                stringBuffer.append(((PrimitiveType)type).getPrimitiveTypeCode().toString());
                break;
            }
            case 75: {
                stringBuffer.append(((QualifiedType)type).getName().getFullyQualifiedName());
                break;
            }
            case 43: {
                stringBuffer.append(((SimpleType)type).getName().getFullyQualifiedName());
                break;
            }
            case 89: {
                stringBuffer.append(((InferredType)type).getType());
                break;
            }
            case 76: {
                stringBuffer.append('?');
                WildcardType wildcardType = (WildcardType)type;
                Type type3 = wildcardType.getBound();
                if (type3 == null) {
                    return;
                }
                if (wildcardType.isUpperBound()) {
                    stringBuffer.append(" extends ");
                } else {
                    stringBuffer.append(" super ");
                }
                Util.getFullyQualifiedName(type3, stringBuffer);
            }
        }
    }

    public static String[] getTrimmedSimpleNames(String string) {
        String[] stringArray = Signature.getSimpleNames(string);
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            stringArray[n] = stringArray[n].trim();
            ++n;
        }
        return stringArray;
    }

    public static int indexOfEnclosingPath(IPath iPath, IPath[] iPathArray, int n) {
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        while (n4 < n) {
            int n5;
            if (!iPathArray[n4].equals((Object)iPath) && iPathArray[n4].isPrefixOf(iPath) && (n5 = iPathArray[n4].segmentCount()) > n3) {
                n3 = n5;
                n2 = n4;
            }
            ++n4;
        }
        return n2;
    }

    public static int indexOfJavaLikeExtension(String string) {
        int n = string.length();
        char[][] cArray = Util.getJavaLikeExtensions();
        int n2 = 0;
        int n3 = cArray.length;
        while (n2 < n3) {
            block4: {
                char[] cArray2 = cArray[n2];
                int n4 = cArray2.length;
                int n5 = n - n4;
                int n6 = n5 - 1;
                if (n6 >= 0 && string.charAt(n6) == '.') {
                    int n7 = 0;
                    while (n7 < n4) {
                        if (string.charAt(n5 + n7) == cArray2[n7]) {
                            ++n7;
                            continue;
                        }
                        break block4;
                    }
                    return n6;
                }
            }
            ++n2;
        }
        return -1;
    }

    public static int indexOfMatchingPath(IPath iPath, IPath[] iPathArray, int n) {
        int n2 = 0;
        while (n2 < n) {
            if (iPathArray[n2].equals((Object)iPath)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public static int indexOfNestedPath(IPath iPath, IPath[] iPathArray, int n) {
        int n2 = 0;
        while (n2 < n) {
            if (!iPath.equals((Object)iPathArray[n2]) && iPath.isPrefixOf(iPathArray[n2])) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    protected static boolean isAttributeSupported(int n) {
        return (EFS.getLocalFileSystem().attributes() & n) != 0;
    }

    public static boolean isReadOnly(IResource iResource) {
        if (Util.isReadOnlySupported()) {
            ResourceAttributes resourceAttributes = iResource.getResourceAttributes();
            if (resourceAttributes == null) {
                return false;
            }
            return resourceAttributes.isReadOnly();
        }
        return false;
    }

    public static boolean isReadOnlySupported() {
        return Util.isAttributeSupported(2);
    }

    public static final boolean isExcluded(IJavaElement iJavaElement) {
        int n = iJavaElement.getElementType();
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                return false;
            }
            case 4: {
                PackageFragmentRoot packageFragmentRoot = (PackageFragmentRoot)iJavaElement.getAncestor(3);
                IResource iResource = iJavaElement.getResource();
                return iResource != null && Util.isExcluded(iResource, packageFragmentRoot.fullInclusionPatternChars(), packageFragmentRoot.fullExclusionPatternChars());
            }
            case 5: {
                PackageFragmentRoot packageFragmentRoot = (PackageFragmentRoot)iJavaElement.getAncestor(3);
                IResource iResource = iJavaElement.getResource();
                if (iResource == null) {
                    return false;
                }
                if (Util.isExcluded(iResource, packageFragmentRoot.fullInclusionPatternChars(), packageFragmentRoot.fullExclusionPatternChars())) {
                    return true;
                }
                return Util.isExcluded(iJavaElement.getParent());
            }
        }
        IJavaElement iJavaElement2 = iJavaElement.getAncestor(5);
        return iJavaElement2 != null && Util.isExcluded(iJavaElement2);
    }

    public static final boolean isExcluded(IPath iPath, char[][] cArray, char[][] cArray2, boolean bl) {
        if (cArray == null && cArray2 == null) {
            return false;
        }
        return org.eclipse.wst.jsdt.internal.compiler.util.Util.isExcluded(iPath.toString().toCharArray(), cArray, cArray2, bl);
    }

    public static final boolean isExcluded(IResource iResource, char[][] cArray, char[][] cArray2) {
        IPath iPath = iResource.getFullPath();
        int n = iResource.getType();
        return Util.isExcluded(iPath, cArray, cArray2, n == 2 || n == 4);
    }

    public static final boolean isExcluded(IPath iPath, char[][] cArray, char[][] cArray2) {
        return Util.isExcluded(iPath, cArray, cArray2, iPath.toFile().isDirectory());
    }

    public static boolean isValidClassFileName(String string, String string2, String string3) {
        return JavaConventions.validateClassFileName(string, string2, string3).getSeverity() != 4;
    }

    public static boolean isValidCompilationUnitName(String string, String string2, String string3) {
        return JavaConventions.validateCompilationUnitName(string, string2, string3).getSeverity() != 4;
    }

    public static boolean isValidFolderNameForPackage(String string, String string2, String string3) {
        return JavaConventions.validateIdentifier(string, string2, string3).getSeverity() != 4;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isValidMethodSignature(String var0) {
        var1_1 = var0.length();
        if (var1_1 == 0) {
            return false;
        }
        var2_2 = 0;
        if ((var3_3 = var0.charAt(var2_2++)) != '(') {
            return false;
        }
        if (var2_2 < var1_1) ** GOTO lbl13
        return false;
lbl-1000:
        // 1 sources

        {
            if ((var2_2 = Util.checkTypeSignature(var0, var2_2, var1_1, false)) == -1) {
                return false;
            }
            if (var2_2 < var1_1) continue;
            return false;
lbl13:
            // 2 sources

            ** while (var0.charAt((int)var2_2) != ')')
        }
lbl14:
        // 1 sources

        ++var2_2;
        return (var2_2 = Util.checkTypeSignature(var0, var2_2, var1_1, true)) == var1_1;
    }

    public static boolean isValidTypeSignature(String string, boolean bl) {
        int n = string.length();
        return Util.checkTypeSignature(string, 0, n, bl) == n;
    }

    public static String localTypeName(String string, int n, int n2) {
        if (n > 0 && string.charAt(n - 1) == '$') {
            return string;
        }
        int n3 = n + 1;
        while (n3 < n2 && Character.isDigit(string.charAt(n3))) {
            ++n3;
        }
        return string.substring(n3, n2);
    }

    public static void log(Throwable throwable, String string) {
        Throwable throwable2;
        if (throwable instanceof JavaModelException && (throwable2 = ((JavaModelException)((Object)throwable)).getException()) != null) {
            throwable = throwable2;
        }
        Status status = new Status(4, "org.eclipse.wst.jsdt.core", 4, string, throwable);
        JavaCore.getPlugin().getLog().log((IStatus)status);
    }

    public static ClassFileReader newClassFileReader(IResource iResource) throws CoreException, ClassFormatException, IOException {
        ClassFileReader classFileReader;
        block2: {
            InputStream inputStream = null;
            try {
                inputStream = ((IFile)iResource).getContents(true);
                classFileReader = ClassFileReader.read(inputStream, iResource.getFullPath().toString());
                Object var2_3 = null;
                if (inputStream == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var2_4 = null;
                    if (inputStream == null) break block3;
                    inputStream.close();
                }
                throw throwable;
            }
            inputStream.close();
        }
        return classFileReader;
    }

    public static char[] normalizeCRs(char[] cArray, char[] cArray2) {
        int n;
        CharArrayBuffer charArrayBuffer = new CharArrayBuffer();
        int n2 = 0;
        int n3 = cArray.length;
        if (n3 == 0) {
            return cArray;
        }
        String string = Util.getLineSeparator(cArray, cArray2);
        int n4 = cArray[0];
        int n5 = 0;
        while (n5 < n3) {
            n = n4;
            n4 = n5 < n3 - 1 ? cArray[n5 + 1] : 32;
            switch (n) {
                case 10: {
                    int n6 = n5 - n2;
                    char[] cArray3 = new char[n6];
                    System.arraycopy(cArray, n2, cArray3, 0, n6);
                    charArrayBuffer.append(cArray3);
                    charArrayBuffer.append(string);
                    n2 = n5 + 1;
                    break;
                }
                case 13: {
                    char[] cArray3;
                    int n6 = n5 - n2;
                    if (n6 >= 0) {
                        cArray3 = new char[n6];
                        System.arraycopy(cArray, n2, cArray3, 0, n6);
                        charArrayBuffer.append(cArray3);
                        charArrayBuffer.append(string);
                        if (n4 == 10) {
                            n4 = 32;
                            n2 = n5 + 2;
                            break;
                        }
                        n2 = n5 + 1;
                        break;
                    }
                    n2 = n5 + 1;
                }
            }
            ++n5;
        }
        if (n2 > 0) {
            n = n3 - n2;
            if (n > 0) {
                char[] cArray4 = new char[n];
                System.arraycopy(cArray, n2, cArray4, 0, n);
                charArrayBuffer.append(cArray4);
            }
            return charArrayBuffer.getContents();
        }
        return cArray;
    }

    public static String normalizeCRs(String string, String string2) {
        return new String(Util.normalizeCRs(string.toCharArray(), string2.toCharArray()));
    }

    public static String packageName(IPath iPath, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        int n2 = iPath.segmentCount();
        while (n < n2) {
            String string3 = iPath.segment(n);
            if (!Util.isValidFolderNameForPackage(string3, string, string2)) {
                return null;
            }
            stringBuffer.append(string3);
            if (n < iPath.segmentCount() - 1) {
                stringBuffer.append(".");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static int prefixLength(char[] cArray, char[] cArray2) {
        int n = 0;
        int n2 = Math.min(cArray.length, cArray2.length);
        int n3 = 0;
        while (n3 < n2 && cArray[n3] == cArray2[n3]) {
            ++n;
            ++n3;
        }
        return n;
    }

    public static int prefixLength(String string, String string2) {
        int n = 0;
        int n2 = Math.min(string.length(), string2.length());
        int n3 = 0;
        while (n3 < n2 && string.charAt(n3) == string2.charAt(n3)) {
            ++n;
            ++n3;
        }
        return n;
    }

    private static void quickSort(char[][] cArray, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        char[] cArray2 = cArray[n + (n2 - n) / 2];
        while (true) {
            if (Util.compare(cArray[n], cArray2) < 0) {
                ++n;
                continue;
            }
            while (Util.compare(cArray2, cArray[n2]) < 0) {
                --n2;
            }
            if (n <= n2) {
                char[] cArray3 = cArray[n];
                cArray[n] = cArray[n2];
                cArray[n2] = cArray3;
                ++n;
                --n2;
            }
            if (n > n2) break;
        }
        if (n3 < n2) {
            Util.quickSort(cArray, n3, n2);
        }
        if (n < n4) {
            Util.quickSort(cArray, n, n4);
        }
    }

    private static void quickSort(Comparable[] comparableArray, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        Comparable comparable = comparableArray[n + (n2 - n) / 2];
        while (true) {
            if (comparableArray[n].compareTo(comparable) < 0) {
                ++n;
                continue;
            }
            while (comparable.compareTo(comparableArray[n2]) < 0) {
                --n2;
            }
            if (n <= n2) {
                Comparable comparable2 = comparableArray[n];
                comparableArray[n] = comparableArray[n2];
                comparableArray[n2] = comparable2;
                ++n;
                --n2;
            }
            if (n > n2) break;
        }
        if (n3 < n2) {
            Util.quickSort(comparableArray, n3, n2);
        }
        if (n < n4) {
            Util.quickSort(comparableArray, n, n4);
        }
    }

    private static void quickSort(int[] nArray, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        int n5 = nArray[n + (n2 - n) / 2];
        while (true) {
            if (nArray[n] < n5) {
                ++n;
                continue;
            }
            while (n5 < nArray[n2]) {
                --n2;
            }
            if (n <= n2) {
                int n6 = nArray[n];
                nArray[n] = nArray[n2];
                nArray[n2] = n6;
                ++n;
                --n2;
            }
            if (n > n2) break;
        }
        if (n3 < n2) {
            Util.quickSort(nArray, n3, n2);
        }
        if (n < n4) {
            Util.quickSort(nArray, n, n4);
        }
    }

    private static void quickSort(Object[] objectArray, int n, int n2, Comparer comparer) {
        int n3 = n;
        int n4 = n2;
        Object object = objectArray[n + (n2 - n) / 2];
        while (true) {
            if (comparer.compare(objectArray[n], object) < 0) {
                ++n;
                continue;
            }
            while (comparer.compare(object, objectArray[n2]) < 0) {
                --n2;
            }
            if (n <= n2) {
                Object object2 = objectArray[n];
                objectArray[n] = objectArray[n2];
                objectArray[n2] = object2;
                ++n;
                --n2;
            }
            if (n > n2) break;
        }
        if (n3 < n2) {
            Util.quickSort(objectArray, n3, n2, comparer);
        }
        if (n < n4) {
            Util.quickSort(objectArray, n, n4, comparer);
        }
    }

    private static void quickSort(String[] stringArray, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        String string = stringArray[n + (n2 - n) / 2];
        while (true) {
            if (stringArray[n].compareTo(string) < 0) {
                ++n;
                continue;
            }
            while (string.compareTo(stringArray[n2]) < 0) {
                --n2;
            }
            if (n <= n2) {
                String string2 = stringArray[n];
                stringArray[n] = stringArray[n2];
                stringArray[n2] = string2;
                ++n;
                --n2;
            }
            if (n > n2) break;
        }
        if (n3 < n2) {
            Util.quickSort(stringArray, n3, n2);
        }
        if (n < n4) {
            Util.quickSort(stringArray, n, n4);
        }
    }

    public static String relativePath(IPath iPath, int n) {
        boolean bl = iPath.hasTrailingSeparator();
        String[] stringArray = iPath.segments();
        int n2 = 0;
        int n3 = stringArray.length;
        if (n3 > n) {
            int n4 = n;
            while (n4 < n3) {
                n2 += stringArray[n4].length();
                ++n4;
            }
            n2 += n3 - n - 1;
        }
        if (bl) {
            ++n2;
        }
        char[] cArray = new char[n2];
        int n5 = 0;
        int n6 = stringArray.length - 1;
        if (n6 >= n) {
            int n7 = n;
            while (n7 < n6) {
                int n8 = stringArray[n7].length();
                stringArray[n7].getChars(0, n8, cArray, n5);
                n5 += n8;
                cArray[n5++] = 47;
                ++n7;
            }
            n7 = stringArray[n6].length();
            stringArray[n6].getChars(0, n7, cArray, n5);
            n5 += n7;
        }
        if (bl) {
            cArray[n5++] = 47;
        }
        return new String(cArray);
    }

    public static void resetJavaLikeExtensions() {
        JAVA_LIKE_EXTENSIONS = null;
    }

    public static final String[] splitOn(char c, String string, int n, int n2) {
        int n3;
        int n4 = n3 = string == null ? 0 : string.length();
        if (n3 == 0 || n > n2) {
            return CharOperation.NO_STRINGS;
        }
        int n5 = 1;
        int n6 = n;
        while (n6 < n2) {
            if (string.charAt(n6) == c) {
                ++n5;
            }
            ++n6;
        }
        String[] stringArray = new String[n5];
        int n7 = n;
        int n8 = 0;
        int n9 = n;
        while (n9 < n2) {
            if (string.charAt(n9) == c) {
                stringArray[n8++] = string.substring(n7, n9);
                n7 = n9 + 1;
            }
            ++n9;
        }
        stringArray[n8] = string.substring(n7, n2);
        return stringArray;
    }

    public static void setReadOnly(IResource iResource, boolean bl) {
        if (Util.isReadOnlySupported()) {
            ResourceAttributes resourceAttributes = iResource.getResourceAttributes();
            if (resourceAttributes == null) {
                return;
            }
            resourceAttributes.setReadOnly(bl);
            try {
                iResource.setResourceAttributes(resourceAttributes);
            }
            catch (CoreException coreException) {}
        }
    }

    public static void sort(char[][] cArray) {
        if (cArray.length > 1) {
            Util.quickSort(cArray, 0, cArray.length - 1);
        }
    }

    public static void sort(Comparable[] comparableArray) {
        if (comparableArray.length > 1) {
            Util.quickSort(comparableArray, 0, comparableArray.length - 1);
        }
    }

    public static void sort(int[] nArray) {
        if (nArray.length > 1) {
            Util.quickSort(nArray, 0, nArray.length - 1);
        }
    }

    public static void sort(Object[] objectArray, Comparer comparer) {
        if (objectArray.length > 1) {
            Util.quickSort(objectArray, 0, objectArray.length - 1, comparer);
        }
    }

    public static void sort(String[] stringArray) {
        if (stringArray.length > 1) {
            Util.quickSort(stringArray, 0, stringArray.length - 1);
        }
    }

    public static Comparable[] sortCopy(Comparable[] comparableArray) {
        int n = comparableArray.length;
        Comparable[] comparableArray2 = new Comparable[n];
        System.arraycopy(comparableArray, 0, comparableArray2, 0, n);
        Util.sort(comparableArray2);
        return comparableArray2;
    }

    public static IJavaElement[] sortCopy(IJavaElement[] iJavaElementArray) {
        int n = iJavaElementArray.length;
        Object[] objectArray = new IJavaElement[n];
        System.arraycopy(iJavaElementArray, 0, objectArray, 0, n);
        Util.sort(objectArray, new Comparer(){

            public int compare(Object object, Object object2) {
                return ((JavaElement)object).toStringWithAncestors().compareTo(((JavaElement)object2).toStringWithAncestors());
            }
        });
        return objectArray;
    }

    public static Object[] sortCopy(Object[] objectArray, Comparer comparer) {
        int n = objectArray.length;
        Object[] objectArray2 = new Object[n];
        System.arraycopy(objectArray, 0, objectArray2, 0, n);
        Util.sort(objectArray2, comparer);
        return objectArray2;
    }

    public static String[] sortCopy(String[] stringArray) {
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        Util.sort(stringArray2);
        return stringArray2;
    }

    public static boolean startsWithIgnoreCase(String[] stringArray, String[] stringArray2) {
        int n = stringArray2.length;
        int n2 = stringArray.length;
        if (n > n2) {
            return false;
        }
        int n3 = 0;
        while (n3 < n - 1) {
            if (!stringArray[n3].equalsIgnoreCase(stringArray2[n3])) {
                return false;
            }
            ++n3;
        }
        return stringArray[n - 1].toLowerCase().startsWith(stringArray2[n - 1].toLowerCase());
    }

    public static boolean matchesWithIgnoreCase(String[] stringArray, String string) {
        if (string.equals("*")) {
            return true;
        }
        int n = stringArray.length;
        if (string.length() == 0) {
            return n == 0;
        }
        if (n == 0) {
            return false;
        }
        int n2 = n - 1;
        int n3 = 0;
        while (n3 < n) {
            n2 += stringArray[n3].length();
            ++n3;
        }
        char[] cArray = new char[n2];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            if (n4 > 0) {
                cArray[n4++] = 46;
            }
            char[] cArray2 = stringArray[n5].toCharArray();
            int n6 = cArray2.length;
            System.arraycopy(cArray2, 0, cArray, n4, n6);
            n4 += n6;
            ++n5;
        }
        return CharOperation.match(string.toCharArray(), cArray, false);
    }

    public static char[][] toCharArrays(String[] stringArray) {
        int n = stringArray.length;
        if (n == 0) {
            return CharOperation.NO_CHAR_CHAR;
        }
        char[][] cArrayArray = new char[n][];
        int n2 = 0;
        while (n2 < n) {
            cArrayArray[n2] = stringArray[n2].toCharArray();
            ++n2;
        }
        return cArrayArray;
    }

    public static char[][] toCompoundChars(String string) {
        int n = string.length();
        if (n == 0) {
            return CharOperation.NO_CHAR_CHAR;
        }
        int n2 = 1;
        int n3 = string.indexOf(46);
        while (n3 != -1) {
            ++n2;
            n3 = string.indexOf(46, n3 + 1);
        }
        char[][] cArrayArray = new char[n2][];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            int n6 = string.indexOf(46, n4);
            int n7 = n6 == -1 ? string.length() : n6;
            cArrayArray[n5] = new char[n7 - n4];
            string.getChars(n4, n7, cArrayArray[n5], 0);
            n4 = n7 + 1;
            ++n5;
        }
        return cArrayArray;
    }

    public static File toLocalFile(URI uRI, IProgressMonitor iProgressMonitor) throws CoreException {
        IFileStore iFileStore = EFS.getStore((URI)uRI);
        File file = iFileStore.toLocalFile(0, iProgressMonitor);
        if (file == null) {
            file = iFileStore.toLocalFile(4096, iProgressMonitor);
        }
        return file;
    }

    public static String toString(char[][] cArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = cArray.length;
        while (n < n2) {
            if (n != 0) {
                stringBuffer.append('.');
            }
            stringBuffer.append(cArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String toString(char[][] cArray, char[] cArray2) {
        if (cArray == null) {
            return new String(cArray2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = cArray.length;
        while (n < n2) {
            stringBuffer.append(cArray[n]);
            stringBuffer.append('.');
            ++n;
        }
        stringBuffer.append(cArray2);
        return stringBuffer.toString();
    }

    public static String[] toStrings(char[][] cArray) {
        int n = cArray.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = new String(cArray[n2]);
            ++n2;
        }
        return stringArray;
    }

    private static void appendArrayTypeSignature(char[] cArray, int n, StringBuffer stringBuffer, boolean bl) {
        int n2 = cArray.length;
        if (n >= n2 - 1) {
            throw new IllegalArgumentException();
        }
        char c = cArray[n];
        if (c != '[') {
            throw new IllegalArgumentException();
        }
        int n3 = n;
        c = cArray[++n3];
        while (c == '[') {
            if (n3 >= n2 - 1) {
                throw new IllegalArgumentException();
            }
            c = cArray[++n3];
        }
        Util.appendTypeSignature(cArray, n3, stringBuffer, bl);
        int n4 = 0;
        int n5 = n3 - n;
        while (n4 < n5) {
            stringBuffer.append('[').append(']');
            ++n4;
        }
    }

    private static void appendClassTypeSignature(char[] cArray, int n, StringBuffer stringBuffer, boolean bl) {
        char c = cArray[n];
        if (c != 'L') {
            return;
        }
        int n2 = n + 1;
        int n3 = stringBuffer.length();
        while (true) {
            c = cArray[n2];
            switch (c) {
                case ';': {
                    return;
                }
                case '.': 
                case '/': {
                    if (bl) {
                        stringBuffer.setLength(n3);
                        break;
                    }
                    stringBuffer.append('.');
                    break;
                }
                case '$': {
                    stringBuffer.append('.');
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
    }

    static void appendTypeSignature(char[] cArray, int n, StringBuffer stringBuffer, boolean bl) {
        char c = cArray[n];
        switch (c) {
            case '[': {
                Util.appendArrayTypeSignature(cArray, n, stringBuffer, bl);
                break;
            }
            case 'L': {
                Util.appendClassTypeSignature(cArray, n, stringBuffer, bl);
                break;
            }
            case 'T': {
                int n2 = Util.scanTypeVariableSignature(cArray, n);
                stringBuffer.append(cArray, n + 1, n2 - n - 1);
                break;
            }
            case 'Z': {
                stringBuffer.append(BOOLEAN);
                break;
            }
            case 'B': {
                stringBuffer.append(BYTE);
                break;
            }
            case 'C': {
                stringBuffer.append(CHAR);
                break;
            }
            case 'D': {
                stringBuffer.append(DOUBLE);
                break;
            }
            case 'F': {
                stringBuffer.append(FLOAT);
                break;
            }
            case 'I': {
                stringBuffer.append(INT);
                break;
            }
            case 'J': {
                stringBuffer.append(LONG);
                break;
            }
            case 'S': {
                stringBuffer.append(SHORT);
                break;
            }
            case 'V': {
                stringBuffer.append(VOID);
            }
        }
    }

    public static String toString(char[] cArray, char[] cArray2, char[] cArray3, boolean bl, boolean bl2) {
        int n;
        Object object;
        boolean bl3 = CharOperation.equals(cArray2, INIT);
        int n2 = CharOperation.indexOf('(', cArray3);
        if (n2 == -1) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(cArray3.length + 10);
        if (cArray.length > 0) {
            object = null;
            if (cArray[0] == '[') {
                CharOperation.replace(cArray, '/', '.');
                object = Signature.toCharArray(cArray);
            } else {
                CharOperation.replace(cArray, '/', '.');
                object = cArray;
            }
            n = CharOperation.lastIndexOf('.', object);
            if (bl2 && n != -1) {
                stringBuffer.append((char[])object, n + 1, ((char[])object).length - n - 1);
            } else {
                stringBuffer.append((char[])object);
            }
        }
        if (!bl3) {
            stringBuffer.append('.');
            if (cArray2 != null) {
                stringBuffer.append(cArray2);
            }
        }
        stringBuffer.append('(');
        object = Signature.getParameterTypes(cArray3);
        n = 0;
        int n3 = ((char[])object).length;
        while (n < n3) {
            Util.appendTypeSignature((char[])object[n], 0, stringBuffer, bl2);
            if (n != ((char[])object).length - 1) {
                stringBuffer.append(',');
                stringBuffer.append(' ');
            }
            ++n;
        }
        stringBuffer.append(')');
        if (!bl3) {
            stringBuffer.append(" : ");
            if (bl) {
                char[] cArray4 = Signature.getReturnType(cArray3);
                Util.appendTypeSignature(cArray4, 0, stringBuffer, bl2);
            }
        }
        return String.valueOf(stringBuffer);
    }

    public static String[] typeParameterSignatures(AbstractMethodDeclaration abstractMethodDeclaration) {
        Argument[] argumentArray = abstractMethodDeclaration.arguments;
        if (argumentArray != null) {
            int n = argumentArray.length;
            String[] stringArray = new String[n];
            int n2 = 0;
            while (n2 < argumentArray.length) {
                Argument argument = argumentArray[n2];
                stringArray[n2] = Util.typeSignature(argument.type);
                ++n2;
            }
            return stringArray;
        }
        return CharOperation.NO_STRINGS;
    }

    public static String typeSignature(TypeReference typeReference) {
        if (typeReference == null) {
            return "A";
        }
        char[][] cArray = typeReference.getParameterizedTypeName();
        char[] cArray2 = CharOperation.concatWith(cArray, '.');
        String string = Signature.createTypeSignature(cArray2, false);
        return string;
    }

    public static void validateMethodSignature(String string) {
        Assert.isTrue((boolean)Util.isValidMethodSignature(string));
    }

    public static void validateTypeSignature(String string, boolean bl) {
        Assert.isTrue((boolean)Util.isValidTypeSignature(string, bl));
    }

    public static void verbose(String string) {
        Util.verbose(string, System.out);
    }

    public static synchronized void verbose(String string, PrintStream printStream) {
        int n;
        int n2 = 0;
        do {
            n = string.indexOf(10, n2);
            printStream.print(Thread.currentThread());
            printStream.print(" ");
            printStream.print(string.substring(n2, n == -1 ? string.length() : n + 1));
        } while ((n2 = n + 1) != 0);
        printStream.println();
    }

    public static final boolean isJavaLikeFileName(String string) {
        if (string == null) {
            return false;
        }
        return Util.indexOfJavaLikeExtension(string) != -1;
    }

    public static final boolean isJavaLikeFileName(char[] cArray) {
        if (cArray == null) {
            return false;
        }
        int n = cArray.length;
        char[][] cArray2 = Util.getJavaLikeExtensions();
        int n2 = 0;
        int n3 = cArray2.length;
        while (n2 < n3) {
            block5: {
                char[] cArray3 = cArray2[n2];
                int n4 = cArray3.length;
                int n5 = n - n4;
                if (n5 - 1 >= 0 && cArray[n5 - 1] == '.') {
                    int n6 = 0;
                    while (n6 < n4) {
                        if (cArray[n5 + n6] == cArray3[n6]) {
                            ++n6;
                            continue;
                        }
                        break block5;
                    }
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    public static int scanTypeSignature(char[] cArray, int n) {
        if (n >= cArray.length) {
            throw new IllegalArgumentException();
        }
        char c = cArray[n];
        switch (c) {
            case '[': {
                return Util.scanArrayTypeSignature(cArray, n);
            }
            case 'L': 
            case 'Q': {
                return Util.scanClassTypeSignature(cArray, n);
            }
            case 'T': {
                return Util.scanTypeVariableSignature(cArray, n);
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'V': 
            case 'Z': {
                return Util.scanBaseTypeSignature(cArray, n);
            }
            case '!': {
                return Util.scanCaptureTypeSignature(cArray, n);
            }
            case '*': 
            case '+': 
            case '-': {
                return Util.scanTypeBoundSignature(cArray, n);
            }
        }
        throw new IllegalArgumentException();
    }

    public static int scanBaseTypeSignature(char[] cArray, int n) {
        if (n >= cArray.length) {
            throw new IllegalArgumentException();
        }
        char c = cArray[n];
        if ("BCDFIJSVZA".indexOf(c) >= 0) {
            return n;
        }
        throw new IllegalArgumentException();
    }

    public static int scanArrayTypeSignature(char[] cArray, int n) {
        int n2 = cArray.length;
        if (n >= n2 - 1) {
            throw new IllegalArgumentException();
        }
        char c = cArray[n];
        if (c != '[') {
            throw new IllegalArgumentException();
        }
        c = cArray[++n];
        while (c == '[') {
            if (n >= n2 - 1) {
                throw new IllegalArgumentException();
            }
            c = cArray[++n];
        }
        return Util.scanTypeSignature(cArray, n);
    }

    public static int scanCaptureTypeSignature(char[] cArray, int n) {
        if (n >= cArray.length - 1) {
            throw new IllegalArgumentException();
        }
        char c = cArray[n];
        if (c != '!') {
            throw new IllegalArgumentException();
        }
        return Util.scanTypeBoundSignature(cArray, n + 1);
    }

    public static int scanTypeVariableSignature(char[] cArray, int n) {
        if (n >= cArray.length - 2) {
            throw new IllegalArgumentException();
        }
        char c = cArray[n];
        if (c != 'T') {
            throw new IllegalArgumentException();
        }
        int n2 = Util.scanIdentifier(cArray, n + 1);
        c = cArray[n2 + 1];
        if (c == ';') {
            return n2 + 1;
        }
        throw new IllegalArgumentException();
    }

    public static int scanIdentifier(char[] cArray, int n) {
        if (n >= cArray.length) {
            throw new IllegalArgumentException();
        }
        int n2 = n;
        do {
            char c;
            if ((c = cArray[n2]) != '<' && c != '>' && c != ':' && c != ';' && c != '.' && c != '/') continue;
            return n2 - 1;
        } while (++n2 != cArray.length);
        return n2 - 1;
    }

    public static int scanClassTypeSignature(char[] cArray, int n) {
        if (n >= cArray.length - 2) {
            throw new IllegalArgumentException();
        }
        char c = cArray[n];
        if (c != 'L' && c != 'Q') {
            return -1;
        }
        int n2 = n + 1;
        while (true) {
            int n3;
            if (n2 >= cArray.length) {
                throw new IllegalArgumentException();
            }
            c = cArray[n2];
            if (c == ';') {
                return n2;
            }
            if (c == '<') {
                n2 = n3 = Util.scanTypeArgumentSignatures(cArray, n2);
            } else if (c == '.' || c == '/') {
                n2 = n3 = Util.scanIdentifier(cArray, n2 + 1);
            }
            ++n2;
        }
    }

    public static int scanTypeBoundSignature(char[] cArray, int n) {
        if (n >= cArray.length) {
            throw new IllegalArgumentException();
        }
        char c = cArray[n];
        switch (c) {
            case '*': {
                return n;
            }
            case '+': 
            case '-': {
                if (n < cArray.length - 2) break;
                throw new IllegalArgumentException();
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        c = cArray[++n];
        switch (c) {
            case '!': {
                return Util.scanCaptureTypeSignature(cArray, n);
            }
            case '+': 
            case '-': {
                return Util.scanTypeBoundSignature(cArray, n);
            }
            case 'L': 
            case 'Q': {
                return Util.scanClassTypeSignature(cArray, n);
            }
            case 'T': {
                return Util.scanTypeVariableSignature(cArray, n);
            }
            case '[': {
                return Util.scanArrayTypeSignature(cArray, n);
            }
            case '*': {
                return n;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int scanTypeArgumentSignatures(char[] cArray, int n) {
        if (n >= cArray.length - 1) {
            throw new IllegalArgumentException();
        }
        char c = cArray[n];
        if (c != '<') {
            throw new IllegalArgumentException();
        }
        int n2 = n + 1;
        while (true) {
            if (n2 >= cArray.length) {
                throw new IllegalArgumentException();
            }
            c = cArray[n2];
            if (c == '>') {
                return n2;
            }
            int n3 = Util.scanTypeArgumentSignature(cArray, n2);
            n2 = n3 + 1;
        }
    }

    public static int scanTypeArgumentSignature(char[] cArray, int n) {
        if (n >= cArray.length) {
            throw new IllegalArgumentException();
        }
        char c = cArray[n];
        switch (c) {
            case '*': {
                return n;
            }
            case '+': 
            case '-': {
                return Util.scanTypeBoundSignature(cArray, n);
            }
        }
        return Util.scanTypeSignature(cArray, n);
    }

    public static final char[][][] getAllTypeArguments(char[][] cArray) {
        if (cArray == null) {
            return null;
        }
        int n = cArray.length;
        char[][][] cArrayArray = new char[n][][];
        int n2 = 0;
        while (n2 < n) {
            cArrayArray[n2] = Signature.getTypeArguments(cArray[n2]);
            ++n2;
        }
        return cArrayArray;
    }

    public static final char[][] splitTypeLevelsSignature(String string) {
        char[] cArray = Signature.removeCapture(string.toCharArray());
        CharOperation.replace(cArray, '$', '.');
        char[][] cArrayArray = new char[10][];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = cArray.length;
        while (n4 < n5) {
            switch (cArray[n4]) {
                case '>': {
                    if (--n3 != 0) break;
                    if (n == cArrayArray.length) {
                        char[][] cArrayArray2 = cArrayArray;
                        cArrayArray = new char[n + 10][];
                        System.arraycopy(cArrayArray2, 0, cArrayArray, 0, n);
                    }
                    n2 = 0;
                    break;
                }
                case '<': {
                    if (++n3 != 1) break;
                    n2 = 1;
                    break;
                }
                case '*': 
                case ';': {
                    if (n3 != 1) break;
                    ++n2;
                    break;
                }
                case '.': {
                    if (n3 != 0) break;
                    if (n == cArrayArray.length) {
                        char[][] cArrayArray3 = cArrayArray;
                        cArrayArray = new char[n + 10][];
                        System.arraycopy(cArrayArray3, 0, cArrayArray, 0, n);
                    }
                    cArrayArray[n] = new char[n4 + 1];
                    System.arraycopy(cArray, 0, cArrayArray[n], 0, n4);
                    cArrayArray[n][n4] = 59;
                    ++n;
                    break;
                }
                case '/': {
                    cArray[n4] = 46;
                }
            }
            ++n4;
        }
        char[][] cArrayArray4 = new char[n + 1][];
        cArrayArray4[0] = cArray;
        n5 = 1;
        int n6 = n - 1;
        while (n5 <= n) {
            cArrayArray4[n5] = cArrayArray[n6];
            ++n5;
            --n6;
        }
        return cArrayArray4;
    }

    public static String toAnchor(char[] cArray, String string, boolean bl) {
        try {
            return new String(Util.toAnchor(cArray, string.toCharArray(), bl));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private static char[] toAnchor(char[] cArray, char[] cArray2, boolean bl) {
        int n = CharOperation.indexOf('(', cArray);
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        StringBuffer stringBuffer = new StringBuffer(cArray.length + 10);
        if (cArray2 != null) {
            stringBuffer.append(cArray2);
        }
        stringBuffer.append('(');
        char[][] cArray3 = Signature.getParameterTypes(cArray);
        int n2 = 0;
        int n3 = cArray3.length;
        while (n2 < n3) {
            if (n2 == n3 - 1) {
                Util.appendTypeSignatureForAnchor(cArray3[n2], 0, stringBuffer, bl);
            } else {
                Util.appendTypeSignatureForAnchor(cArray3[n2], 0, stringBuffer, false);
            }
            if (n2 != cArray3.length - 1) {
                stringBuffer.append(',');
                stringBuffer.append(' ');
            }
            ++n2;
        }
        stringBuffer.append(')');
        char[] cArray4 = new char[stringBuffer.length()];
        stringBuffer.getChars(0, stringBuffer.length(), cArray4, 0);
        return cArray4;
    }

    private static int appendTypeSignatureForAnchor(char[] cArray, int n, StringBuffer stringBuffer, boolean bl) {
        if (n >= cArray.length) {
            throw new IllegalArgumentException();
        }
        char c = cArray[n];
        if (bl) {
            switch (c) {
                case '[': {
                    return Util.appendArrayTypeSignatureForAnchor(cArray, n, stringBuffer, true);
                }
            }
            throw new IllegalArgumentException();
        }
        switch (c) {
            case '[': {
                return Util.appendArrayTypeSignatureForAnchor(cArray, n, stringBuffer, false);
            }
            case 'L': {
                return Util.appendClassTypeSignatureForAnchor(cArray, n, stringBuffer);
            }
            case 'T': {
                int n2 = Util.scanTypeVariableSignature(cArray, n);
                stringBuffer.append(cArray, n + 1, n2 - n - 1);
                return n2;
            }
            case 'Z': {
                stringBuffer.append(BOOLEAN);
                return n;
            }
            case 'B': {
                stringBuffer.append(BYTE);
                return n;
            }
            case 'C': {
                stringBuffer.append(CHAR);
                return n;
            }
            case 'D': {
                stringBuffer.append(DOUBLE);
                return n;
            }
            case 'F': {
                stringBuffer.append(FLOAT);
                return n;
            }
            case 'I': {
                stringBuffer.append(INT);
                return n;
            }
            case 'J': {
                stringBuffer.append(LONG);
                return n;
            }
            case 'S': {
                stringBuffer.append(SHORT);
                return n;
            }
            case 'V': {
                stringBuffer.append(VOID);
                return n;
            }
            case '!': {
                return Util.appendCaptureTypeSignatureForAnchor(cArray, n, stringBuffer);
            }
            case '*': 
            case '+': 
            case '-': {
                return Util.appendTypeArgumentSignatureForAnchor(cArray, n, stringBuffer);
            }
        }
        throw new IllegalArgumentException();
    }

    private static int appendTypeArgumentSignatureForAnchor(char[] cArray, int n, StringBuffer stringBuffer) {
        if (n >= cArray.length) {
            throw new IllegalArgumentException();
        }
        char c = cArray[n];
        switch (c) {
            case '*': {
                return n;
            }
            case '+': {
                return Util.appendTypeSignatureForAnchor(cArray, n + 1, stringBuffer, false);
            }
            case '-': {
                return Util.appendTypeSignatureForAnchor(cArray, n + 1, stringBuffer, false);
            }
        }
        return Util.appendTypeSignatureForAnchor(cArray, n, stringBuffer, false);
    }

    private static int appendCaptureTypeSignatureForAnchor(char[] cArray, int n, StringBuffer stringBuffer) {
        if (n >= cArray.length - 1) {
            throw new IllegalArgumentException();
        }
        char c = cArray[n];
        if (c != '!') {
            throw new IllegalArgumentException();
        }
        return Util.appendTypeArgumentSignatureForAnchor(cArray, n + 1, stringBuffer);
    }

    private static int appendArrayTypeSignatureForAnchor(char[] cArray, int n, StringBuffer stringBuffer, boolean bl) {
        int n2 = cArray.length;
        if (n >= n2 - 1) {
            throw new IllegalArgumentException();
        }
        char c = cArray[n];
        if (c != '[') {
            throw new IllegalArgumentException();
        }
        int n3 = n;
        c = cArray[++n3];
        while (c == '[') {
            if (n3 >= n2 - 1) {
                throw new IllegalArgumentException();
            }
            c = cArray[++n3];
        }
        int n4 = Util.appendTypeSignatureForAnchor(cArray, n3, stringBuffer, false);
        int n5 = 1;
        int n6 = n3 - n;
        while (n5 < n6) {
            stringBuffer.append('[').append(']');
            ++n5;
        }
        if (bl) {
            stringBuffer.append('.').append('.').append('.');
        } else {
            stringBuffer.append('[').append(']');
        }
        return n4;
    }

    private static int appendClassTypeSignatureForAnchor(char[] cArray, int n, StringBuffer stringBuffer) {
        if (n >= cArray.length - 2) {
            throw new IllegalArgumentException();
        }
        char c = cArray[n];
        if (c != 'L' && c != 'Q') {
            throw new IllegalArgumentException();
        }
        int n2 = n + 1;
        while (true) {
            if (n2 >= cArray.length) {
                throw new IllegalArgumentException();
            }
            c = cArray[n2];
            switch (c) {
                case ';': {
                    return n2;
                }
                case '<': {
                    int n3;
                    n2 = n3 = Util.scanGenericEnd(cArray, n2 + 1);
                    break;
                }
                case '.': {
                    stringBuffer.append('.');
                    break;
                }
                case '/': {
                    stringBuffer.append('/');
                    break;
                }
                case '$': {
                    stringBuffer.append('.');
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
    }

    private static int scanGenericEnd(char[] cArray, int n) {
        if (cArray[n] == '>') {
            return n;
        }
        int n2 = cArray.length;
        int n3 = 1;
        ++n;
        while (n <= n2) {
            switch (cArray[n]) {
                case '>': {
                    if (--n3 != 0) break;
                    return n;
                }
                case '<': {
                    ++n3;
                }
            }
            ++n;
        }
        return n;
    }

    public static void insertTypeLabel(char[] cArray, StringBuffer stringBuffer) {
        Util.insertTypeLabel(new String(cArray), stringBuffer);
    }

    public static void insertTypeLabel(String string, StringBuffer stringBuffer) {
        if (string.startsWith(ANONYMOUS_MARKER)) {
            stringBuffer.append(ANONYMOUS_LABEL);
        } else {
            stringBuffer.append(string);
        }
    }

    public static interface Comparable {
        public int compareTo(Comparable var1);
    }

    public static interface Comparer {
        public int compare(Object var1, Object var2);
    }
}

