/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.formatter;

import java.util.Arrays;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.Annotation;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.parser.Scanner;
import org.eclipse.wst.jsdt.internal.compiler.parser.ScannerHelper;
import org.eclipse.wst.jsdt.internal.compiler.util.Util;
import org.eclipse.wst.jsdt.internal.core.util.CodeSnippetParsingUtil;
import org.eclipse.wst.jsdt.internal.core.util.RecordedParsingInformation;
import org.eclipse.wst.jsdt.internal.formatter.AbortFormatting;
import org.eclipse.wst.jsdt.internal.formatter.CodeFormatterVisitor;
import org.eclipse.wst.jsdt.internal.formatter.Location;
import org.eclipse.wst.jsdt.internal.formatter.OptimizedReplaceEdit;
import org.eclipse.wst.jsdt.internal.formatter.align.Alignment;
import org.eclipse.wst.jsdt.internal.formatter.align.AlignmentException;

public class Scribe {
    private static final int INITIAL_SIZE = 100;
    private boolean checkLineWrapping;
    public int column;
    private int[][] commentPositions;
    public Alignment currentAlignment;
    public int currentToken;
    private OptimizedReplaceEdit[] edits;
    public int editsIndex;
    public CodeFormatterVisitor formatter;
    public int indentationLevel;
    public int lastNumberOfNewLines;
    public int line;
    private int[] lineEnds;
    private String lineSeparator;
    public Alignment memberAlignment;
    public boolean needSpace = false;
    public int nlsTagCounter;
    public int pageWidth;
    public boolean pendingSpace = false;
    public Scanner scanner;
    public int scannerEndPosition;
    public int tabLength;
    public int indentationSize;
    private int textRegionEnd;
    private int textRegionStart;
    public int tabChar;
    public int numberOfIndentations;
    private boolean useTabsOnlyForLeadingIndents;
    private final boolean indentEmptyLines;
    private final boolean formatJavadocComment;
    private final boolean formatBlockComment;

    Scribe(CodeFormatterVisitor codeFormatterVisitor, long l, int n, int n2, CodeSnippetParsingUtil codeSnippetParsingUtil) {
        RecordedParsingInformation recordedParsingInformation;
        this.scanner = new Scanner(true, true, false, l, null, null, true);
        this.formatter = codeFormatterVisitor;
        this.pageWidth = codeFormatterVisitor.preferences.page_width;
        this.tabLength = codeFormatterVisitor.preferences.tab_size;
        this.indentationLevel = 0;
        this.numberOfIndentations = 0;
        this.useTabsOnlyForLeadingIndents = codeFormatterVisitor.preferences.use_tabs_only_for_leading_indentations;
        this.indentEmptyLines = codeFormatterVisitor.preferences.indent_empty_lines;
        this.tabChar = codeFormatterVisitor.preferences.tab_char;
        this.indentationSize = this.tabChar == 4 ? codeFormatterVisitor.preferences.indentation_size : this.tabLength;
        this.lineSeparator = codeFormatterVisitor.preferences.line_separator;
        this.indentationLevel = codeFormatterVisitor.preferences.initial_indentation_level * this.indentationSize;
        this.textRegionStart = n;
        this.textRegionEnd = n + n2 - 1;
        if (codeSnippetParsingUtil != null && (recordedParsingInformation = codeSnippetParsingUtil.recordedParsingInformation) != null) {
            this.lineEnds = recordedParsingInformation.lineEnds;
            this.commentPositions = recordedParsingInformation.commentPositions;
        }
        this.formatBlockComment = codeFormatterVisitor.preferences.comment_format_block_comment;
        this.formatJavadocComment = codeFormatterVisitor.preferences.comment_format_javadoc_comment;
        this.reset();
    }

    private final void addDeleteEdit(int n, int n2) {
        if (this.edits.length == this.editsIndex) {
            this.resize();
        }
        this.addOptimizedReplaceEdit(n, n2 - n + 1, Util.EMPTY_STRING);
    }

    public final void addInsertEdit(int n, String string) {
        if (this.edits.length == this.editsIndex) {
            this.resize();
        }
        this.addOptimizedReplaceEdit(n, 0, string);
    }

    private final void addOptimizedReplaceEdit(int n, int n2, String string) {
        if (this.editsIndex > 0) {
            OptimizedReplaceEdit optimizedReplaceEdit = this.edits[this.editsIndex - 1];
            int n3 = optimizedReplaceEdit.offset;
            int n4 = optimizedReplaceEdit.length;
            int n5 = n3 + n4;
            int n6 = string.length();
            String string2 = optimizedReplaceEdit.replacement;
            int n7 = string2.length();
            if (n3 == n && n4 == n2 && (n6 == 0 || n7 == 0)) {
                if (this.currentAlignment != null) {
                    Location location = this.currentAlignment.location;
                    if (location.editsIndex == this.editsIndex) {
                        --location.editsIndex;
                        location.textEdit = optimizedReplaceEdit;
                    }
                }
                --this.editsIndex;
                return;
            }
            if (n5 == n) {
                if (n2 != 0) {
                    if (n6 != 0) {
                        this.edits[this.editsIndex - 1] = new OptimizedReplaceEdit(n3, n4 + n2, String.valueOf(string2) + string);
                    } else if (n4 + n2 == n7) {
                        boolean bl = true;
                        int n8 = n3;
                        while (n8 < n3 + n7) {
                            if (this.scanner.source[n8] != string2.charAt(n8 - n3)) {
                                this.edits[this.editsIndex - 1] = new OptimizedReplaceEdit(n3, n7, string2);
                                bl = false;
                                break;
                            }
                            ++n8;
                        }
                        if (bl) {
                            if (this.currentAlignment != null) {
                                Location location = this.currentAlignment.location;
                                if (location.editsIndex == this.editsIndex) {
                                    --location.editsIndex;
                                    location.textEdit = optimizedReplaceEdit;
                                }
                            }
                            --this.editsIndex;
                        }
                    } else {
                        this.edits[this.editsIndex - 1] = new OptimizedReplaceEdit(n3, n4 + n2, string2);
                    }
                } else if (n6 != 0) {
                    this.edits[this.editsIndex - 1] = new OptimizedReplaceEdit(n3, n4, String.valueOf(string2) + string);
                }
            } else if (n + n2 == n3 && n4 + n2 == n6 + n7) {
                boolean bl = true;
                String string3 = String.valueOf(string) + string2;
                int n9 = 0;
                while (n9 < n4 + n2) {
                    if (this.scanner.source[n9 + n] != string3.charAt(n9)) {
                        this.edits[this.editsIndex - 1] = new OptimizedReplaceEdit(n, n4 + n2, string3);
                        bl = false;
                        break;
                    }
                    ++n9;
                }
                if (bl) {
                    if (this.currentAlignment != null) {
                        Location location = this.currentAlignment.location;
                        if (location.editsIndex == this.editsIndex) {
                            --location.editsIndex;
                            location.textEdit = optimizedReplaceEdit;
                        }
                    }
                    --this.editsIndex;
                }
            } else {
                this.edits[this.editsIndex++] = new OptimizedReplaceEdit(n, n2, string);
            }
        } else {
            this.edits[this.editsIndex++] = new OptimizedReplaceEdit(n, n2, string);
        }
    }

    public final void addReplaceEdit(int n, int n2, String string) {
        if (this.edits.length == this.editsIndex) {
            this.resize();
        }
        this.addOptimizedReplaceEdit(n, n2 - n + 1, string);
    }

    public void alignFragment(Alignment alignment, int n) {
        alignment.fragmentIndex = n;
        alignment.checkColumn();
        alignment.performFragmentEffect();
    }

    public void checkNLSTag(int n) {
        if (this.hasNLSTag(n)) {
            ++this.nlsTagCounter;
        }
    }

    public void consumeNextToken() {
        this.printComment();
        try {
            this.currentToken = this.scanner.getNextToken();
            this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
        }
        catch (InvalidInputException invalidInputException) {
            throw new AbortFormatting(invalidInputException);
        }
    }

    public Alignment createAlignment(String string, int n, int n2, int n3) {
        return this.createAlignment(string, n, 2, n2, n3);
    }

    public Alignment createAlignment(String string, int n, int n2, int n3, boolean bl) {
        return this.createAlignment(string, n, 2, n2, n3, bl);
    }

    public Alignment createAlignment(String string, int n, int n2, int n3, int n4) {
        return this.createAlignment(string, n, n2, n3, n4, this.formatter.preferences.continuation_indentation, false);
    }

    public Alignment createAlignment(String string, int n, int n2, int n3, int n4, boolean bl) {
        return this.createAlignment(string, n, 2, n2, n3, n4, bl);
    }

    public Alignment createAlignment(String string, int n, int n2, int n3, int n4, int n5, boolean bl) {
        Alignment alignment = new Alignment(string, n, n2, this, n3, n4, n5);
        if (bl && this.memberAlignment != null) {
            Alignment alignment2 = this.memberAlignment;
            while (alignment2.enclosing != null) {
                alignment2 = alignment2.enclosing;
            }
            if ((alignment2.mode & 0x100) != 0) {
                int n6 = this.indentationSize;
                switch (alignment2.chunkKind) {
                    case 2: 
                    case 3: {
                        alignment.breakIndentationLevel = (n & 4) != 0 ? this.indentationLevel + n6 : this.indentationLevel + n5 * n6;
                        alignment.update();
                        break;
                    }
                    case 1: {
                        alignment.breakIndentationLevel = (n & 4) != 0 ? alignment2.originalIndentationLevel + n6 : alignment2.originalIndentationLevel + n5 * n6;
                        alignment.update();
                    }
                }
            } else {
                block4 : switch (alignment2.mode & 0x70) {
                    case 16: 
                    case 32: 
                    case 48: 
                    case 64: 
                    case 80: {
                        int n7 = this.indentationSize;
                        switch (alignment2.chunkKind) {
                            case 2: 
                            case 3: {
                                alignment.breakIndentationLevel = (n & 4) != 0 ? this.indentationLevel + n7 : this.indentationLevel + n5 * n7;
                                alignment.update();
                                break block4;
                            }
                            case 1: {
                                alignment.breakIndentationLevel = (n & 4) != 0 ? alignment2.originalIndentationLevel + n7 : alignment2.originalIndentationLevel + n5 * n7;
                                alignment.update();
                            }
                        }
                    }
                }
            }
        }
        return alignment;
    }

    public Alignment createMemberAlignment(String string, int n, int n2, int n3) {
        Alignment alignment = this.createAlignment(string, n, 2, n2, n3);
        alignment.breakIndentationLevel = this.indentationLevel;
        return alignment;
    }

    public void enterAlignment(Alignment alignment) {
        alignment.enclosing = this.currentAlignment;
        alignment.location.lastLocalDeclarationSourceStart = this.formatter.lastLocalDeclarationSourceStart;
        this.currentAlignment = alignment;
    }

    public void enterMemberAlignment(Alignment alignment) {
        alignment.enclosing = this.memberAlignment;
        alignment.location.lastLocalDeclarationSourceStart = this.formatter.lastLocalDeclarationSourceStart;
        this.memberAlignment = alignment;
    }

    public void exitAlignment(Alignment alignment, boolean bl) {
        Alignment alignment2 = this.currentAlignment;
        while (alignment2 != null) {
            if (alignment2 == alignment) break;
            alignment2 = alignment2.enclosing;
        }
        if (alignment2 == null) {
            throw new AbortFormatting("could not find matching alignment: " + alignment);
        }
        this.indentationLevel = alignment.location.outputIndentationLevel;
        this.numberOfIndentations = alignment.location.numberOfIndentations;
        this.formatter.lastLocalDeclarationSourceStart = alignment.location.lastLocalDeclarationSourceStart;
        if (bl) {
            this.currentAlignment = alignment.enclosing;
        }
    }

    public void exitMemberAlignment(Alignment alignment) {
        Alignment alignment2 = this.memberAlignment;
        while (alignment2 != null) {
            if (alignment2 == alignment) break;
            alignment2 = alignment2.enclosing;
        }
        if (alignment2 == null) {
            throw new AbortFormatting("could not find matching alignment: " + alignment);
        }
        this.indentationLevel = alignment2.location.outputIndentationLevel;
        this.numberOfIndentations = alignment2.location.numberOfIndentations;
        this.formatter.lastLocalDeclarationSourceStart = alignment.location.lastLocalDeclarationSourceStart;
        this.memberAlignment = alignment2.enclosing;
    }

    public Alignment getAlignment(String string) {
        if (this.currentAlignment != null) {
            return this.currentAlignment.getAlignment(string);
        }
        return null;
    }

    public int getColumnIndentationLevel() {
        return this.column - 1;
    }

    public final int getCommentIndex(int n) {
        if (this.commentPositions == null) {
            return -1;
        }
        int n2 = this.commentPositions.length;
        if (n2 == 0) {
            return -1;
        }
        int n3 = 0;
        int n4 = n2 - 1;
        int n5 = 0;
        while (n3 <= n4) {
            n5 = n3 + (n4 - n3) / 2;
            int n6 = this.commentPositions[n5][1];
            if (n6 < 0) {
                n6 = -n6;
            }
            if (n6 < n) {
                n3 = n5 + 1;
                continue;
            }
            if (n6 > n) {
                n4 = n5 - 1;
                continue;
            }
            return n5;
        }
        return -(n3 + 1);
    }

    private int getCurrentCommentOffset(int n) {
        int n2 = -Arrays.binarySearch(this.lineEnds, n);
        int n3 = 0;
        int n4 = this.getLineEnd(n2 - 1);
        if (n4 == -1) {
            n4 = 0;
        }
        int n5 = n;
        char[] cArray = this.scanner.source;
        while (n4 > n5) {
            if (n2 > 0) {
                n4 = this.getLineEnd(--n2);
                continue;
            }
            n4 = 0;
            break;
        }
        int n6 = n5 - 1;
        while (n6 >= n4) {
            char c = cArray[n6];
            switch (c) {
                case '\t': {
                    n3 += this.tabLength;
                    break;
                }
                case ' ': {
                    ++n3;
                    break;
                }
                case '\n': 
                case '\r': {
                    break;
                }
                default: {
                    return n3;
                }
            }
            --n6;
        }
        return n3;
    }

    public String getEmptyLines(int n) {
        if (this.nlsTagCounter > 0) {
            return Util.EMPTY_STRING;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.lastNumberOfNewLines == 0) {
            ++n;
            int n2 = 0;
            while (n2 < n) {
                if (this.indentEmptyLines) {
                    this.printIndentationIfNecessary(stringBuffer);
                }
                stringBuffer.append(this.lineSeparator);
                ++n2;
            }
            this.lastNumberOfNewLines += n;
            this.line += n;
            this.column = 1;
            this.needSpace = false;
            this.pendingSpace = false;
        } else if (this.lastNumberOfNewLines == 1) {
            int n3 = 0;
            while (n3 < n) {
                if (this.indentEmptyLines) {
                    this.printIndentationIfNecessary(stringBuffer);
                }
                stringBuffer.append(this.lineSeparator);
                ++n3;
            }
            this.lastNumberOfNewLines += n;
            this.line += n;
            this.column = 1;
            this.needSpace = false;
            this.pendingSpace = false;
        } else {
            if (this.lastNumberOfNewLines - 1 >= n) {
                return Util.EMPTY_STRING;
            }
            int n4 = n - this.lastNumberOfNewLines + 1;
            int n5 = 0;
            while (n5 < n4) {
                if (this.indentEmptyLines) {
                    this.printIndentationIfNecessary(stringBuffer);
                }
                stringBuffer.append(this.lineSeparator);
                ++n5;
            }
            this.lastNumberOfNewLines += n4;
            this.line += n4;
            this.column = 1;
            this.needSpace = false;
            this.pendingSpace = false;
        }
        return String.valueOf(stringBuffer);
    }

    public OptimizedReplaceEdit getLastEdit() {
        if (this.editsIndex > 0) {
            return this.edits[this.editsIndex - 1];
        }
        return null;
    }

    public final int getLineEnd(int n) {
        if (this.lineEnds == null) {
            return -1;
        }
        if (n >= this.lineEnds.length + 1) {
            return this.scannerEndPosition;
        }
        if (n <= 0) {
            return -1;
        }
        return this.lineEnds[n - 1];
    }

    Alignment getMemberAlignment() {
        return this.memberAlignment;
    }

    public String getNewLine() {
        if (this.nlsTagCounter > 0) {
            return Util.EMPTY_STRING;
        }
        if (this.lastNumberOfNewLines >= 1) {
            this.column = 1;
            return Util.EMPTY_STRING;
        }
        ++this.line;
        this.lastNumberOfNewLines = 1;
        this.column = 1;
        this.needSpace = false;
        this.pendingSpace = false;
        return this.lineSeparator;
    }

    public int getNextIndentationLevel(int n) {
        int n2 = n - 1;
        if (n2 == 0) {
            return this.indentationLevel;
        }
        if (this.tabChar == 1) {
            if (this.useTabsOnlyForLeadingIndents) {
                return n2;
            }
            int n3 = n2 % this.indentationSize;
            int n4 = n3 == 0 ? 0 : this.indentationSize - n3;
            return n2 + n4;
        }
        return n2;
    }

    private String getPreserveEmptyLines(int n) {
        if (n > 0) {
            if (this.formatter.preferences.number_of_empty_lines_to_preserve != 0) {
                int n2 = Math.min(n, this.formatter.preferences.number_of_empty_lines_to_preserve);
                return this.getEmptyLines(n2);
            }
            return this.getNewLine();
        }
        return Util.EMPTY_STRING;
    }

    public TextEdit getRootEdit() {
        MultiTextEdit multiTextEdit = null;
        int n = this.textRegionEnd - this.textRegionStart + 1;
        multiTextEdit = this.textRegionStart <= 0 ? (n <= 0 ? new MultiTextEdit(0, 0) : new MultiTextEdit(0, this.textRegionEnd + 1)) : new MultiTextEdit(this.textRegionStart, this.textRegionEnd - this.textRegionStart + 1);
        int n2 = 0;
        int n3 = this.editsIndex;
        while (n2 < n3) {
            OptimizedReplaceEdit optimizedReplaceEdit = this.edits[n2];
            if (this.isValidEdit(optimizedReplaceEdit)) {
                multiTextEdit.addChild((TextEdit)new ReplaceEdit(optimizedReplaceEdit.offset, optimizedReplaceEdit.length, optimizedReplaceEdit.replacement));
            }
            ++n2;
        }
        this.edits = null;
        return multiTextEdit;
    }

    public void handleLineTooLong() {
        int n = 0;
        int n2 = -1;
        Alignment alignment = this.currentAlignment;
        while (alignment != null) {
            if (alignment.tieBreakRule == 1 && alignment.couldBreak()) {
                n2 = n;
            }
            alignment = alignment.enclosing;
            ++n;
        }
        if (n2 >= 0) {
            throw new AlignmentException(1, n2);
        }
        n = 0;
        alignment = this.currentAlignment;
        while (alignment != null) {
            if (alignment.couldBreak()) {
                throw new AlignmentException(1, n);
            }
            alignment = alignment.enclosing;
            ++n;
        }
    }

    private boolean hasNLSTag(int n) {
        if (this.lineEnds == null) {
            return false;
        }
        int n2 = Arrays.binarySearch(this.lineEnds, n);
        int n3 = this.getLineEnd(-n2);
        if (n3 != -1) {
            int n4;
            int n5;
            int n6 = this.getCommentIndex(n3);
            if (n6 < 0) {
                n6 = -n6 - 2;
            }
            if (n6 >= 0 && n6 < this.commentPositions.length && (n5 = this.commentPositions[n6][0]) < 0 && (n4 = Arrays.binarySearch(this.lineEnds, n5 = -n5)) == n2) {
                return CharOperation.indexOf(Scanner.TAG_PREFIX, this.scanner.source, true, n5, n3) != -1;
            }
        }
        return false;
    }

    public void indent() {
        this.indentationLevel += this.indentationSize;
        ++this.numberOfIndentations;
    }

    public void initializeScanner(char[] cArray) {
        this.scanner.setSource(cArray);
        this.scannerEndPosition = cArray.length;
        this.scanner.resetTo(0, this.scannerEndPosition - 1);
        this.edits = new OptimizedReplaceEdit[100];
    }

    private boolean isOnFirstColumn(int n) {
        if (this.lineEnds == null) {
            return n == 0;
        }
        int n2 = Arrays.binarySearch(this.lineEnds, n);
        int n3 = this.getLineEnd(-n2 - 1);
        return n3 != -1 && n3 == n - 1;
    }

    private boolean isValidEdit(OptimizedReplaceEdit optimizedReplaceEdit) {
        int n = optimizedReplaceEdit.length;
        int n2 = optimizedReplaceEdit.replacement.length();
        int n3 = optimizedReplaceEdit.offset;
        if (n != 0) {
            if (this.textRegionStart <= n3 && n3 + n - 1 <= this.textRegionEnd) {
                if (n2 != 0 && n == n2) {
                    int n4 = n3;
                    int n5 = n3 + n;
                    while (n4 < n5) {
                        if (this.scanner.source[n4] != optimizedReplaceEdit.replacement.charAt(n4 - n3)) {
                            return true;
                        }
                        ++n4;
                    }
                    return false;
                }
                return true;
            }
            if (n3 + n == this.textRegionStart) {
                int n6 = n3;
                int n7 = n3 + n;
                while (n6 < n7) {
                    int n8 = n6 - n3;
                    if (n8 >= n2 || this.scanner.source[n6] != optimizedReplaceEdit.replacement.charAt(n8)) break;
                    ++n6;
                }
                if (n6 - n3 != n2 && n6 != n3 + n - 1) {
                    optimizedReplaceEdit.offset = this.textRegionStart;
                    optimizedReplaceEdit.length = 0;
                    optimizedReplaceEdit.replacement = optimizedReplaceEdit.replacement.substring(n6 - n3);
                    return true;
                }
            }
        } else {
            if (this.textRegionStart <= n3 && n3 <= this.textRegionEnd) {
                return true;
            }
            if (n3 == this.scannerEndPosition && n3 == this.textRegionEnd + 1) {
                return true;
            }
        }
        return false;
    }

    private void preserveEmptyLines(int n, int n2) {
        if (n > 0) {
            if (this.formatter.preferences.number_of_empty_lines_to_preserve != 0) {
                int n3 = Math.min(n, this.formatter.preferences.number_of_empty_lines_to_preserve);
                this.printEmptyLines(n3, n2);
            } else {
                this.printNewLine(n2);
            }
        }
    }

    private void print(char[] cArray, boolean bl) {
        if (this.checkLineWrapping && cArray.length + this.column > this.pageWidth) {
            this.handleLineTooLong();
        }
        this.lastNumberOfNewLines = 0;
        if (this.indentationLevel != 0) {
            this.printIndentationIfNecessary();
        }
        if (bl) {
            this.space();
        }
        if (this.pendingSpace) {
            this.addInsertEdit(this.scanner.getCurrentTokenStartPosition(), " ");
        }
        this.pendingSpace = false;
        this.needSpace = false;
        this.column += cArray.length;
        this.needSpace = true;
    }

    private void printBlockComment(char[] cArray, boolean bl) {
        int n;
        int n2 = this.scanner.getCurrentTokenStartPosition();
        int n3 = this.scanner.getCurrentTokenEndPosition() + 1;
        this.scanner.resetTo(n2, n3 - 1);
        boolean bl2 = false;
        int n4 = n2;
        int n5 = n2;
        int n6 = n2;
        boolean bl3 = this.isOnFirstColumn(n4);
        boolean bl4 = false;
        if (!(this.indentationLevel == 0 || !bl && this.formatter.preferences.never_indent_block_comments_on_first_column && bl3)) {
            bl4 = true;
            this.printIndentationIfNecessary();
        }
        if (this.pendingSpace) {
            this.addInsertEdit(n2, " ");
        }
        this.needSpace = false;
        this.pendingSpace = false;
        int n7 = bl3 ? 0 : this.getCurrentCommentOffset(n4);
        boolean bl5 = bl && this.formatJavadocComment || !bl && this.formatBlockComment;
        while (n5 <= n3 && (n = this.scanner.getNextChar()) != -1) {
            n5 = this.scanner.currentPosition;
            switch (n) {
                case 13: {
                    n4 = n6;
                    bl2 = true;
                    if (!this.scanner.getNextChar('\n')) break;
                    n = 10;
                    n5 = this.scanner.currentPosition;
                    break;
                }
                case 10: {
                    n4 = n6;
                    bl2 = true;
                    n5 = this.scanner.currentPosition;
                    break;
                }
                default: {
                    if (bl2) {
                        int n8;
                        this.column = 1;
                        ++this.line;
                        bl2 = false;
                        StringBuffer stringBuffer = new StringBuffer();
                        if (bl3) {
                            stringBuffer.append(this.lineSeparator);
                            if (bl4) {
                                this.printIndentationIfNecessary(stringBuffer);
                            }
                            if (bl5) {
                                if (ScannerHelper.isWhitespace((char)n)) {
                                    n8 = this.scanner.currentPosition;
                                    while (n != -1 && n != 13 && n != 10 && ScannerHelper.isWhitespace((char)n)) {
                                        n6 = n5;
                                        n8 = this.scanner.currentPosition;
                                        n = this.scanner.getNextChar();
                                        n5 = this.scanner.currentPosition;
                                    }
                                    if (n == 13 || n == 10) {
                                        n5 = n8;
                                    }
                                }
                                if (n != 13 && n != 10) {
                                    stringBuffer.append(' ');
                                }
                            }
                        } else {
                            int n9;
                            if (ScannerHelper.isWhitespace((char)n)) {
                                n8 = this.scanner.currentPosition;
                                n9 = 0;
                                while (n != -1 && n != 13 && n != 10 && ScannerHelper.isWhitespace((char)n)) {
                                    if (n9 >= n7) break;
                                    n6 = n5;
                                    n8 = this.scanner.currentPosition;
                                    switch (n) {
                                        case 9: {
                                            n9 += this.tabLength;
                                            break;
                                        }
                                        default: {
                                            ++n9;
                                        }
                                    }
                                    n = this.scanner.getNextChar();
                                    n5 = this.scanner.currentPosition;
                                }
                                if (n == 13 || n == 10) {
                                    n5 = n8;
                                }
                            }
                            stringBuffer.append(this.lineSeparator);
                            if (bl4) {
                                this.printIndentationIfNecessary(stringBuffer);
                            }
                            if (bl5) {
                                n8 = n6;
                                n9 = n5;
                                while (n != -1 && n != 13 && n != 10 && ScannerHelper.isWhitespace((char)n)) {
                                    n6 = n5;
                                    n = this.scanner.getNextChar();
                                    n5 = this.scanner.currentPosition;
                                }
                                if (n == 42) {
                                    stringBuffer.append(' ');
                                } else {
                                    n6 = n8;
                                    n5 = n9;
                                }
                                this.scanner.currentPosition = n5;
                            }
                        }
                        this.addReplaceEdit(n4, n6 - 1, String.valueOf(stringBuffer));
                        break;
                    }
                    this.column += n5 - n6;
                }
            }
            n6 = n5;
            this.scanner.currentPosition = n5;
        }
        this.lastNumberOfNewLines = 0;
        this.needSpace = false;
        this.scanner.resetTo(n3, this.scannerEndPosition - 1);
        if (bl) {
            this.printNewLine();
        }
    }

    public void printEndOfCompilationUnit() {
        try {
            int n = this.scanner.currentPosition;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            int n2 = 0;
            block14: while (true) {
                this.currentToken = this.scanner.getNextToken();
                switch (this.currentToken) {
                    case 1000: {
                        char[] cArray = this.scanner.getCurrentTokenSource();
                        n2 = 0;
                        int n3 = 0;
                        int n4 = cArray.length;
                        while (n3 < n4) {
                            switch (cArray[n3]) {
                                case '\r': {
                                    if (n3 + 1 < n4 && cArray[n3 + 1] == '\n') {
                                        ++n3;
                                    }
                                    ++n2;
                                    break;
                                }
                                case '\n': {
                                    ++n2;
                                }
                            }
                            ++n3;
                        }
                        if (n2 == 0) {
                            bl3 = true;
                            this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        } else if (bl) {
                            if (n2 == 1) {
                                this.printNewLine(this.scanner.getCurrentTokenStartPosition());
                            } else {
                                this.preserveEmptyLines(n2 - 1, this.scanner.getCurrentTokenStartPosition());
                            }
                            this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        } else if (bl2) {
                            this.preserveEmptyLines(n2, this.scanner.getCurrentTokenStartPosition());
                            this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        } else {
                            this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        }
                        n = this.scanner.currentPosition;
                        continue block14;
                    }
                    case 1001: {
                        if (n2 >= 1) {
                            if (n2 > 1) {
                                this.preserveEmptyLines(n2 - 1, this.scanner.getCurrentTokenStartPosition());
                            } else if (n2 == 1) {
                                this.printNewLine(this.scanner.getCurrentTokenStartPosition());
                            }
                        } else if (bl3) {
                            this.space();
                        }
                        bl3 = false;
                        this.printLineComment(this.scanner.getRawTokenSource());
                        n = this.scanner.currentPosition;
                        bl2 = true;
                        n2 = 0;
                        continue block14;
                    }
                    case 1002: {
                        if (n2 >= 1) {
                            if (n2 > 1) {
                                this.preserveEmptyLines(n2 - 1, this.scanner.getCurrentTokenStartPosition());
                            } else if (n2 == 1) {
                                this.printNewLine(this.scanner.getCurrentTokenStartPosition());
                            }
                        } else if (bl3) {
                            this.space();
                        }
                        bl3 = false;
                        this.printBlockComment(this.scanner.getRawTokenSource(), false);
                        n = this.scanner.currentPosition;
                        bl2 = false;
                        bl = true;
                        n2 = 0;
                        continue block14;
                    }
                    case 1003: {
                        if (n2 >= 1) {
                            if (n2 > 1) {
                                this.preserveEmptyLines(n2 - 1, this.scanner.getCurrentTokenStartPosition());
                            } else if (n2 == 1) {
                                this.printNewLine(this.scanner.getCurrentTokenStartPosition());
                            }
                        } else if (bl3) {
                            this.space();
                        }
                        bl3 = false;
                        this.printBlockComment(this.scanner.getRawTokenSource(), true);
                        n = this.scanner.currentPosition;
                        bl2 = false;
                        bl = true;
                        n2 = 0;
                        continue block14;
                    }
                    case 31: {
                        char[] cArray = this.scanner.getRawTokenSource();
                        this.print(cArray, this.formatter.preferences.insert_space_before_semicolon);
                        continue block14;
                    }
                    case 55: {
                        if (n2 >= 1 || this.formatter.preferences.insert_new_line_at_end_of_file_if_missing) {
                            this.printNewLine(this.scannerEndPosition);
                        }
                        return;
                    }
                }
                break;
            }
            this.scanner.resetTo(n, this.scannerEndPosition - 1);
            return;
        }
        catch (InvalidInputException invalidInputException) {
            throw new AbortFormatting(invalidInputException);
        }
    }

    public void printComment() {
        try {
            int n = this.scanner.currentPosition;
            int n2 = this.scanner.currentToken;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            int n3 = 0;
            while ((this.currentToken = this.scanner.getNextToken()) != 55) {
                switch (this.currentToken) {
                    case 1000: {
                        char[] cArray = this.scanner.getCurrentTokenSource();
                        n3 = 0;
                        int n4 = 0;
                        int n5 = cArray.length;
                        while (n4 < n5) {
                            switch (cArray[n4]) {
                                case '\r': {
                                    if (n4 + 1 < n5 && cArray[n4 + 1] == '\n') {
                                        ++n4;
                                    }
                                    ++n3;
                                    break;
                                }
                                case '\n': {
                                    ++n3;
                                }
                            }
                            ++n4;
                        }
                        if (n3 == 0) {
                            bl3 = true;
                            this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        } else if (bl) {
                            if (n3 == 1) {
                                this.printNewLine(this.scanner.getCurrentTokenStartPosition());
                            } else {
                                this.preserveEmptyLines(n3 - 1, this.scanner.getCurrentTokenStartPosition());
                            }
                            this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        } else if (bl2) {
                            this.preserveEmptyLines(n3, this.scanner.getCurrentTokenStartPosition());
                            this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        } else if (n3 != 0 && this.formatter.preferences.number_of_empty_lines_to_preserve != 0) {
                            this.addReplaceEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition(), this.getPreserveEmptyLines(n3 - 1));
                        } else {
                            this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        }
                        n = this.scanner.currentPosition;
                        n2 = this.scanner.currentToken;
                        break;
                    }
                    case 1001: {
                        if (n3 >= 1) {
                            if (n3 > 1) {
                                this.preserveEmptyLines(n3 - 1, this.scanner.getCurrentTokenStartPosition());
                            } else if (n3 == 1) {
                                this.printNewLine(this.scanner.getCurrentTokenStartPosition());
                            }
                        } else if (bl3) {
                            this.space();
                        }
                        bl3 = false;
                        this.printLineComment(this.scanner.getRawTokenSource());
                        n = this.scanner.currentPosition;
                        n2 = this.scanner.currentToken;
                        bl2 = true;
                        n3 = 0;
                        break;
                    }
                    case 1002: {
                        if (n3 >= 1) {
                            if (n3 > 1) {
                                this.preserveEmptyLines(n3 - 1, this.scanner.getCurrentTokenStartPosition());
                            } else if (n3 == 1) {
                                this.printNewLine(this.scanner.getCurrentTokenStartPosition());
                            }
                        } else if (bl3) {
                            this.space();
                        }
                        bl3 = false;
                        this.printBlockComment(this.scanner.getRawTokenSource(), false);
                        n = this.scanner.currentPosition;
                        n2 = this.scanner.currentToken;
                        bl2 = false;
                        bl = true;
                        n3 = 0;
                        break;
                    }
                    case 1003: {
                        if (n3 >= 1) {
                            if (n3 > 1) {
                                this.preserveEmptyLines(n3 - 1, this.scanner.getCurrentTokenStartPosition());
                            } else if (n3 == 1) {
                                this.printNewLine(this.scanner.getCurrentTokenStartPosition());
                            }
                        } else if (bl3) {
                            this.space();
                        }
                        bl3 = false;
                        this.printBlockComment(this.scanner.getRawTokenSource(), true);
                        n2 = this.scanner.currentToken;
                        n = this.scanner.currentPosition;
                        bl2 = false;
                        bl = true;
                        n3 = 0;
                        break;
                    }
                    default: {
                        this.scanner.resetTo(n, this.scannerEndPosition - 1, n2);
                        return;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            throw new AbortFormatting(invalidInputException);
        }
    }

    private void printLineComment(char[] cArray) {
        int n;
        int n2;
        int n3 = this.scanner.getCurrentTokenStartPosition();
        if (CharOperation.indexOf(Scanner.TAG_PREFIX, this.scanner.source, true, n3, n2 = this.scanner.getCurrentTokenEndPosition() + 1) != -1) {
            this.nlsTagCounter = 0;
        }
        this.scanner.resetTo(n3, n2 - 1);
        int n4 = n3;
        int n5 = n3;
        if (!(this.indentationLevel == 0 || this.formatter.preferences.never_indent_line_comments_on_first_column && this.isOnFirstColumn(n4))) {
            this.printIndentationIfNecessary();
        }
        if (this.pendingSpace) {
            this.addInsertEdit(n3, " ");
        }
        this.needSpace = false;
        this.pendingSpace = false;
        int n6 = n3;
        block4: while (n5 <= n2 && (n = this.scanner.getNextChar()) != -1) {
            n5 = this.scanner.currentPosition;
            switch (n) {
                case 13: {
                    n4 = n6;
                    break block4;
                }
                case 10: {
                    n4 = n6;
                    break block4;
                }
                default: {
                    n6 = n5;
                }
            }
        }
        if (n4 != n3) {
            this.addReplaceEdit(n4, n2 - 1, this.lineSeparator);
            ++this.line;
            this.column = 1;
            this.lastNumberOfNewLines = 1;
        }
        this.needSpace = false;
        this.pendingSpace = false;
        if (this.currentAlignment != null) {
            if (this.memberAlignment != null) {
                if (this.currentAlignment.location.inputOffset > this.memberAlignment.location.inputOffset) {
                    if (this.currentAlignment.couldBreak() && this.currentAlignment.wasSplit) {
                        this.currentAlignment.performFragmentEffect();
                    }
                } else {
                    this.indentationLevel = Math.max(this.indentationLevel, this.memberAlignment.breakIndentationLevel);
                }
            } else if (this.currentAlignment.couldBreak() && this.currentAlignment.wasSplit) {
                this.currentAlignment.performFragmentEffect();
            }
        }
        this.scanner.resetTo(n2, this.scannerEndPosition - 1);
    }

    public void printEmptyLines(int n) {
        this.printEmptyLines(n, this.scanner.getCurrentTokenEndPosition() + 1);
    }

    private void printEmptyLines(int n, int n2) {
        String string = this.getEmptyLines(n);
        if (Util.EMPTY_STRING == string) {
            return;
        }
        this.addInsertEdit(n2, string);
    }

    void printIndentationIfNecessary() {
        StringBuffer stringBuffer = new StringBuffer();
        this.printIndentationIfNecessary(stringBuffer);
        if (stringBuffer.length() > 0) {
            this.addInsertEdit(this.scanner.getCurrentTokenStartPosition(), stringBuffer.toString());
            this.pendingSpace = false;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void printIndentationIfNecessary(StringBuffer var1_1) {
        switch (this.tabChar) {
            case 1: {
                var2_2 = this.useTabsOnlyForLeadingIndents;
                var3_4 = this.numberOfIndentations;
                var4_6 = 0;
                if (!var2_2) ** GOTO lbl27
                while (this.column <= this.indentationLevel) {
                    if (var4_6 < var3_4) {
                        var1_1.append('\t');
                        ++var4_6;
                        var5_8 = this.tabLength - (this.column - 1) % this.tabLength;
                        this.column += var5_8;
                        this.needSpace = false;
                        continue;
                    }
                    var1_1.append(' ');
                    ++this.column;
                    this.needSpace = false;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    var1_1.append('\t');
                    var5_9 = this.tabLength - (this.column - 1) % this.tabLength;
                    this.column += var5_9;
                    this.needSpace = false;
lbl27:
                    // 2 sources

                    ** while (this.column <= this.indentationLevel)
                }
lbl28:
                // 1 sources

                break;
            }
            case 2: {
                while (this.column <= this.indentationLevel) {
                    var1_1.append(' ');
                    ++this.column;
                    this.needSpace = false;
                }
                break;
            }
            case 4: {
                var2_3 = this.useTabsOnlyForLeadingIndents;
                var3_5 = this.numberOfIndentations;
                var4_7 = false;
                if (!var2_3) ** GOTO lbl94
                var5_10 = var3_5 * this.indentationSize;
                while (this.column <= this.indentationLevel) {
                    if (this.column <= var5_10) {
                        if (this.column - 1 + this.tabLength <= this.indentationLevel) {
                            var1_1.append('\t');
                            this.column += this.tabLength;
                        } else if (this.column - 1 + this.indentationSize <= this.indentationLevel) {
                            var6_12 = 0;
                            var7_14 = this.indentationSize;
                            while (var6_12 < var7_14) {
                                var1_1.append(' ');
                                ++this.column;
                                ++var6_12;
                            }
                        } else {
                            var1_1.append(' ');
                            ++this.column;
                        }
                    } else {
                        var6_12 = this.column;
                        var7_14 = this.indentationLevel;
                        while (var6_12 <= var7_14) {
                            var1_1.append(' ');
                            ++this.column;
                            ++var6_12;
                        }
                    }
                    this.needSpace = false;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    if (this.column - 1 + this.tabLength <= this.indentationLevel) {
                        var1_1.append('\t');
                        this.column += this.tabLength;
                    } else if (this.column - 1 + this.indentationSize <= this.indentationLevel) {
                        var5_11 = 0;
                        var6_13 = this.indentationSize;
                        while (var5_11 < var6_13) {
                            var1_1.append(' ');
                            ++this.column;
                            ++var5_11;
                        }
                    } else {
                        var1_1.append(' ');
                        ++this.column;
                    }
                    this.needSpace = false;
lbl94:
                    // 2 sources

                    ** while (this.column <= this.indentationLevel)
                }
            }
        }
lbl95:
        // 6 sources

    }

    public void printModifiers(Annotation[] annotationArray, ASTVisitor aSTVisitor) {
        try {
            int n = annotationArray != null ? annotationArray.length : 0;
            int n2 = 0;
            boolean bl = true;
            int n3 = this.scanner.currentPosition;
            int n4 = this.scanner.currentToken;
            boolean bl2 = false;
            boolean bl3 = false;
            while ((this.currentToken = this.scanner.getNextToken()) != 55) {
                switch (this.currentToken) {
                    case 87: 
                    case 98: 
                    case 107: 
                    case 109: 
                    case 110: 
                    case 111: 
                    case 113: 
                    case 114: 
                    case 116: 
                    case 118: 
                    case 119: {
                        bl3 = true;
                        this.print(this.scanner.getRawTokenSource(), !bl);
                        bl = false;
                        n3 = this.scanner.currentPosition;
                        n4 = this.scanner.currentToken;
                        break;
                    }
                    case 120: {
                        bl3 = true;
                        if (!bl) {
                            this.space();
                        }
                        this.scanner.resetTo(this.scanner.getCurrentTokenStartPosition(), this.scannerEndPosition - 1);
                        if (n2 < n) {
                            annotationArray[n2++].traverse(aSTVisitor, (BlockScope)null);
                            if (this.formatter.preferences.insert_new_line_after_annotation) {
                                this.printNewLine();
                            }
                        } else {
                            return;
                        }
                        bl = false;
                        n3 = this.scanner.currentPosition;
                        n4 = this.scanner.currentToken;
                        break;
                    }
                    case 1002: {
                        this.printBlockComment(this.scanner.getRawTokenSource(), false);
                        n3 = this.scanner.currentPosition;
                        n4 = this.scanner.currentToken;
                        bl2 = true;
                        break;
                    }
                    case 1003: {
                        this.printBlockComment(this.scanner.getRawTokenSource(), true);
                        n3 = this.scanner.currentPosition;
                        n4 = this.scanner.currentToken;
                        bl2 = true;
                        break;
                    }
                    case 1001: {
                        this.printLineComment(this.scanner.getRawTokenSource());
                        n3 = this.scanner.currentPosition;
                        n4 = this.scanner.currentToken;
                        break;
                    }
                    case 1000: {
                        this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        int n5 = 0;
                        char[] cArray = this.scanner.getCurrentTokenSource();
                        int n6 = 0;
                        int n7 = cArray.length;
                        while (n6 < n7) {
                            switch (cArray[n6]) {
                                case '\r': {
                                    if (n6 + 1 < n7 && cArray[n6 + 1] == '\n') {
                                        ++n6;
                                    }
                                    ++n5;
                                    break;
                                }
                                case '\n': {
                                    ++n5;
                                }
                            }
                            ++n6;
                        }
                        if (n5 >= 1 && bl2) {
                            this.printNewLine();
                        }
                        n3 = this.scanner.currentPosition;
                        n4 = this.scanner.currentToken;
                        bl2 = false;
                        break;
                    }
                    default: {
                        if (bl3) {
                            this.space();
                        }
                        this.scanner.resetTo(n3, this.scannerEndPosition - 1, n4);
                        return;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            throw new AbortFormatting(invalidInputException);
        }
    }

    public void printNewLine() {
        if (this.nlsTagCounter > 0) {
            return;
        }
        if (this.lastNumberOfNewLines >= 1) {
            this.column = 1;
            return;
        }
        this.addInsertEdit(this.scanner.getCurrentTokenEndPosition() + 1, this.lineSeparator);
        ++this.line;
        this.lastNumberOfNewLines = 1;
        this.column = 1;
        this.needSpace = false;
        this.pendingSpace = false;
    }

    public void printNewLine(int n) {
        if (this.nlsTagCounter > 0) {
            return;
        }
        if (this.lastNumberOfNewLines >= 1) {
            this.column = 1;
            return;
        }
        this.addInsertEdit(n, this.lineSeparator);
        ++this.line;
        this.lastNumberOfNewLines = 1;
        this.column = 1;
        this.needSpace = false;
        this.pendingSpace = false;
    }

    public void printNextToken(int n) {
        this.printNextToken(n, false);
    }

    public void printNextToken(int n, boolean bl) {
        this.printComment();
        try {
            this.currentToken = this.scanner.getNextToken();
            char[] cArray = this.scanner.getRawTokenSource();
            if (n != this.currentToken) {
                throw new AbortFormatting("unexpected token type, expecting:" + n + ", actual:" + this.currentToken);
            }
            this.print(cArray, bl);
        }
        catch (InvalidInputException invalidInputException) {
            throw new AbortFormatting(invalidInputException);
        }
    }

    public void printNextToken(int[] nArray) {
        this.printNextToken(nArray, false);
    }

    public void printNextToken(int[] nArray, boolean bl) {
        this.printComment();
        try {
            this.currentToken = this.scanner.getNextToken();
            char[] cArray = this.scanner.getRawTokenSource();
            if (Arrays.binarySearch(nArray, this.currentToken) < 0) {
                StringBuffer stringBuffer = new StringBuffer(5);
                int n = 0;
                while (n < nArray.length) {
                    if (n > 0) {
                        stringBuffer.append(',');
                    }
                    stringBuffer.append(nArray[n]);
                    ++n;
                }
                throw new AbortFormatting("unexpected token type, expecting:[" + stringBuffer.toString() + "], actual:" + this.currentToken);
            }
            this.print(cArray, bl);
        }
        catch (InvalidInputException invalidInputException) {
            throw new AbortFormatting(invalidInputException);
        }
    }

    public void printOptionalNextToken(int n, boolean bl) {
        this.printComment();
        try {
            int n2 = this.scanner.currentPosition;
            this.currentToken = this.scanner.getNextToken();
            char[] cArray = this.scanner.getRawTokenSource();
            if (n != this.currentToken) {
                this.scanner.resetTo(n2, this.scannerEndPosition - 1);
            } else {
                this.print(cArray, bl);
            }
        }
        catch (InvalidInputException invalidInputException) {
            throw new AbortFormatting(invalidInputException);
        }
    }

    public void printArrayQualifiedReference(int n, int n2) {
        int n3 = this.scanner.currentPosition;
        int n4 = this.scanner.currentToken;
        int n5 = 0;
        try {
            block10: do {
                this.printComment();
                this.currentToken = this.scanner.getNextToken();
                switch (this.currentToken) {
                    case 55: {
                        return;
                    }
                    case 1000: {
                        this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        n3 = this.scanner.currentPosition;
                        n4 = this.scanner.currentToken;
                        break;
                    }
                    case 1002: 
                    case 1003: {
                        this.printBlockComment(this.scanner.getRawTokenSource(), false);
                        n3 = this.scanner.currentPosition;
                        n4 = this.scanner.currentToken;
                        break;
                    }
                    case 1001: {
                        this.printLineComment(this.scanner.getRawTokenSource());
                        n3 = this.scanner.currentPosition;
                        n4 = this.scanner.currentToken;
                        break;
                    }
                    case 32: {
                        this.print(this.scanner.getRawTokenSource(), false);
                        n3 = this.scanner.currentPosition;
                        n4 = this.scanner.currentToken;
                        if (++n5 != n) continue block10;
                        this.scanner.resetTo(n3, this.scannerEndPosition - 1);
                        return;
                    }
                    case 23: {
                        this.print(this.scanner.getRawTokenSource(), false);
                        n3 = this.scanner.currentPosition;
                        n4 = this.scanner.currentToken;
                        break;
                    }
                    default: {
                        this.scanner.resetTo(n3, this.scannerEndPosition - 1, n4);
                        return;
                    }
                }
            } while (this.scanner.currentPosition <= n2);
        }
        catch (InvalidInputException invalidInputException) {
            throw new AbortFormatting(invalidInputException);
        }
    }

    public void printQualifiedReference(int n) {
        int n2 = this.scanner.currentPosition;
        int n3 = this.scanner.currentToken;
        try {
            do {
                this.printComment();
                this.currentToken = this.scanner.getNextToken();
                switch (this.currentToken) {
                    case 55: {
                        return;
                    }
                    case 1000: {
                        this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        n2 = this.scanner.currentPosition;
                        n3 = this.scanner.currentToken;
                        break;
                    }
                    case 1002: 
                    case 1003: {
                        this.printBlockComment(this.scanner.getRawTokenSource(), false);
                        n2 = this.scanner.currentPosition;
                        n3 = this.scanner.currentToken;
                        break;
                    }
                    case 1001: {
                        this.printLineComment(this.scanner.getRawTokenSource());
                        n2 = this.scanner.currentPosition;
                        n3 = this.scanner.currentToken;
                        break;
                    }
                    case 23: 
                    case 32: {
                        this.print(this.scanner.getRawTokenSource(), false);
                        n2 = this.scanner.currentPosition;
                        n3 = this.scanner.currentToken;
                        break;
                    }
                    default: {
                        this.scanner.resetTo(n2, this.scannerEndPosition - 1, n3);
                        return;
                    }
                }
            } while (this.scanner.currentPosition <= n);
        }
        catch (InvalidInputException invalidInputException) {
            throw new AbortFormatting(invalidInputException);
        }
    }

    private void printRule(StringBuffer stringBuffer) {
        int n = 0;
        while (n < this.pageWidth) {
            if (n % this.tabLength == 0) {
                stringBuffer.append('+');
            } else {
                stringBuffer.append('-');
            }
            ++n;
        }
        stringBuffer.append(this.lineSeparator);
        n = 0;
        while (n < this.pageWidth / this.tabLength) {
            stringBuffer.append(n);
            stringBuffer.append('\t');
            ++n;
        }
    }

    public void printTrailingComment(int n) {
        try {
            int n2 = this.scanner.currentPosition;
            int n3 = this.scanner.currentToken;
            boolean bl = false;
            boolean bl2 = false;
            while ((this.currentToken = this.scanner.getNextToken()) != 55) {
                switch (this.currentToken) {
                    case 1000: {
                        int n4 = 0;
                        char[] cArray = this.scanner.getCurrentTokenSource();
                        int n5 = 0;
                        int n6 = cArray.length;
                        while (n5 < n6) {
                            switch (cArray[n5]) {
                                case '\r': {
                                    if (n5 + 1 < n6 && cArray[n5 + 1] == '\n') {
                                        ++n5;
                                    }
                                    ++n4;
                                    break;
                                }
                                case '\n': {
                                    ++n4;
                                }
                            }
                            ++n5;
                        }
                        if (bl2) {
                            if (n4 >= 1) {
                                n2 = this.scanner.getCurrentTokenStartPosition();
                                this.preserveEmptyLines(n, n2);
                                this.addDeleteEdit(n2, this.scanner.getCurrentTokenEndPosition());
                                this.scanner.resetTo(this.scanner.currentPosition, this.scannerEndPosition - 1);
                                return;
                            }
                            this.scanner.resetTo(n2, this.scannerEndPosition - 1, n3);
                            return;
                        }
                        if (n4 > 1) {
                            this.printEmptyLines(n, this.scanner.getCurrentTokenStartPosition());
                            this.scanner.resetTo(n2, this.scannerEndPosition - 1, n3);
                            return;
                        }
                        bl = true;
                        n2 = this.scanner.currentPosition;
                        n3 = this.scanner.currentToken;
                        this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        break;
                    }
                    case 1001: {
                        if (bl) {
                            this.space();
                        }
                        this.printLineComment(this.scanner.getRawTokenSource());
                        n2 = this.scanner.currentPosition;
                        n3 = this.scanner.currentToken;
                        bl2 = true;
                        break;
                    }
                    case 1002: {
                        if (bl) {
                            this.space();
                        }
                        this.printBlockComment(this.scanner.getRawTokenSource(), false);
                        n2 = this.scanner.currentPosition;
                        n3 = this.scanner.currentToken;
                        break;
                    }
                    default: {
                        this.scanner.resetTo(n2, this.scannerEndPosition - 1, n3);
                        return;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            throw new AbortFormatting(invalidInputException);
        }
    }

    public void printTrailingComment() {
        try {
            int n = this.scanner.currentPosition;
            int n2 = this.scanner.currentToken;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            while ((this.currentToken = this.scanner.getNextToken()) != 55) {
                switch (this.currentToken) {
                    case 1000: {
                        int n3 = 0;
                        char[] cArray = this.scanner.getCurrentTokenSource();
                        int n4 = 0;
                        int n5 = cArray.length;
                        while (n4 < n5) {
                            switch (cArray[n4]) {
                                case '\r': {
                                    if (n4 + 1 < n5 && cArray[n4 + 1] == '\n') {
                                        ++n4;
                                    }
                                    ++n3;
                                    break;
                                }
                                case '\n': {
                                    ++n3;
                                }
                            }
                            ++n4;
                        }
                        if (bl3) {
                            if (n3 >= 1) {
                                n = this.scanner.getCurrentTokenStartPosition();
                                this.preserveEmptyLines(n3, n);
                                this.addDeleteEdit(n, this.scanner.getCurrentTokenEndPosition());
                                this.scanner.resetTo(this.scanner.currentPosition, this.scannerEndPosition - 1);
                                return;
                            }
                            this.scanner.resetTo(n, this.scannerEndPosition - 1, n2);
                            return;
                        }
                        if (n3 >= 1) {
                            if (bl2) {
                                this.printNewLine(this.scanner.getCurrentTokenStartPosition());
                            }
                            this.scanner.resetTo(n, this.scannerEndPosition - 1, n2);
                            return;
                        }
                        bl = true;
                        n = this.scanner.currentPosition;
                        n2 = this.scanner.currentToken;
                        this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        break;
                    }
                    case 1001: {
                        if (bl) {
                            this.space();
                        }
                        this.printLineComment(this.scanner.getRawTokenSource());
                        n = this.scanner.currentPosition;
                        n2 = this.scanner.currentToken;
                        bl3 = true;
                        break;
                    }
                    case 1002: {
                        if (bl) {
                            this.space();
                        }
                        this.printBlockComment(this.scanner.getRawTokenSource(), false);
                        n = this.scanner.currentPosition;
                        n2 = this.scanner.currentToken;
                        bl2 = true;
                        break;
                    }
                    default: {
                        this.scanner.resetTo(n, this.scannerEndPosition - 1, n2);
                        return;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            throw new AbortFormatting(invalidInputException);
        }
    }

    void redoAlignment(AlignmentException alignmentException) {
        if (alignmentException.relativeDepth > 0) {
            --alignmentException.relativeDepth;
            this.currentAlignment = this.currentAlignment.enclosing;
            throw alignmentException;
        }
        this.resetAt(this.currentAlignment.location);
        this.scanner.resetTo(this.currentAlignment.location.inputOffset, this.scanner.eofPosition, this.currentAlignment.location.inputToken);
        this.currentAlignment.chunkKind = 0;
    }

    void redoMemberAlignment(AlignmentException alignmentException) {
        this.resetAt(this.memberAlignment.location);
        this.scanner.resetTo(this.memberAlignment.location.inputOffset, this.scanner.eofPosition, this.memberAlignment.location.inputToken);
        this.memberAlignment.chunkKind = 0;
    }

    public void reset() {
        this.checkLineWrapping = true;
        this.line = 0;
        this.column = 1;
        this.editsIndex = 0;
        this.nlsTagCounter = 0;
    }

    private void resetAt(Location location) {
        this.line = location.outputLine;
        this.column = location.outputColumn;
        this.indentationLevel = location.outputIndentationLevel;
        this.numberOfIndentations = location.numberOfIndentations;
        this.lastNumberOfNewLines = location.lastNumberOfNewLines;
        this.needSpace = location.needSpace;
        this.pendingSpace = location.pendingSpace;
        this.editsIndex = location.editsIndex;
        this.nlsTagCounter = location.nlsTagCounter;
        if (this.editsIndex > 0) {
            this.edits[this.editsIndex - 1] = location.textEdit;
        }
        this.formatter.lastLocalDeclarationSourceStart = location.lastLocalDeclarationSourceStart;
    }

    private void resize() {
        this.edits = new OptimizedReplaceEdit[this.editsIndex * 2];
        System.arraycopy(this.edits, 0, this.edits, 0, this.editsIndex);
    }

    public void space() {
        if (!this.needSpace) {
            return;
        }
        this.lastNumberOfNewLines = 0;
        this.pendingSpace = true;
        ++this.column;
        this.needSpace = false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(page width = " + this.pageWidth + ") - (tabChar = ");
        switch (this.tabChar) {
            case 1: {
                stringBuffer.append("TAB");
                break;
            }
            case 2: {
                stringBuffer.append("SPACE");
                break;
            }
            default: {
                stringBuffer.append("MIXED");
            }
        }
        stringBuffer.append(") - (tabSize = " + this.tabLength + ")").append(this.lineSeparator).append("(line = " + this.line + ") - (column = " + this.column + ") - (identationLevel = " + this.indentationLevel + ")").append(this.lineSeparator).append("(needSpace = " + this.needSpace + ") - (lastNumberOfNewLines = " + this.lastNumberOfNewLines + ") - (checkLineWrapping = " + this.checkLineWrapping + ")").append(this.lineSeparator).append("==================================================================================").append(this.lineSeparator);
        this.printRule(stringBuffer);
        return stringBuffer.toString();
    }

    public void unIndent() {
        this.indentationLevel -= this.indentationSize;
        --this.numberOfIndentations;
    }
}

