/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.infer;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.wst.jsdt.internal.infer.InferEngine;

public class InferOptions {
    public static final String OPTION_UseAssignments = "org.eclipse.wst.jsdt.core.infer.useAssignments";
    public static final String OPTION_UseInitMethod = "org.eclipse.wst.jsdt.core.infer.useInitMethod";
    public char[][] systemClassMethod = null;
    public boolean useAssignments = true;
    public boolean useInitMethod;
    public String engineClass;

    public InferOptions() {
        this.setDefaultOptions();
    }

    public InferOptions(Map map) {
        if (map == null) {
            return;
        }
        this.set(map);
    }

    public void setDefaultOptions() {
        this.useAssignments = true;
        this.useInitMethod = true;
    }

    public Map getMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>(30);
        hashMap.put(OPTION_UseAssignments, this.useAssignments ? "true" : "false");
        hashMap.put(OPTION_UseInitMethod, this.useInitMethod ? "true" : "false");
        return hashMap;
    }

    public void set(Map map) {
        Object v = map.get(OPTION_UseAssignments);
        if (v != null) {
            this.useAssignments = "true".equals(v);
        }
        if ((v = map.get(OPTION_UseInitMethod)) != null) {
            this.useInitMethod = "true".equals(v);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("InferOptions:");
        stringBuffer.append("\n\t- use assignments: ").append(this.useAssignments ? "ON" : " OFF");
        stringBuffer.append("\n\t- use initialization method : ").append(this.useInitMethod ? "ON" : " OFF");
        return stringBuffer.toString();
    }

    public InferEngine createEngine() {
        if (this.engineClass != null) {
            try {
                InferEngine inferEngine = (InferEngine)Class.forName(this.engineClass).newInstance();
                inferEngine.inferOptions = this;
                return inferEngine;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return new InferEngine(this);
    }
}

