/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.infer;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ClassScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.wst.jsdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.wst.jsdt.internal.infer.InferredAttribute;
import org.eclipse.wst.jsdt.internal.infer.InferredMethod;

public class InferredType
extends ASTNode {
    char[] name;
    public ArrayList methods;
    public InferredAttribute[] attributes = new InferredAttribute[5];
    public int numberAttributes = 0;
    HashtableOfObject attributesHash = new HashtableOfObject();
    public InferredType superClass;
    public InferredType referenceClass;
    public SourceTypeBinding binding;
    public boolean isDefinition;
    private TypeBinding resolvedType;
    public ClassScope scope;
    ReferenceBinding resolvedSuperType;
    public boolean isAnonymous = false;
    public static final char[] OBJECT_NAME = new char[]{'O', 'b', 'j', 'e', 'c', 't'};
    public static final char[] OBJECT_LITERAL_NAME = new char[]{'{', '}'};
    public static final char[] ARRAY_NAME = new char[]{'A', 'r', 'r', 'a', 'y'};

    public InferredType(char[] cArray) {
        this.name = cArray;
    }

    public char[] getName() {
        return this.name;
    }

    public char[] getSuperClassName() {
        return this.superClass != null ? this.superClass.getName() : OBJECT_NAME;
    }

    public InferredAttribute addAttribute(char[] cArray, ASTNode aSTNode) {
        InferredAttribute inferredAttribute = this.findAttribute(cArray);
        if (inferredAttribute == null) {
            inferredAttribute = new InferredAttribute(cArray, this, aSTNode.sourceStart, aSTNode.sourceEnd);
            if (this.numberAttributes == this.attributes.length) {
                this.attributes = new InferredAttribute[this.numberAttributes * 2];
                System.arraycopy(this.attributes, 0, this.attributes, 0, this.numberAttributes);
            }
            this.attributes[this.numberAttributes++] = inferredAttribute;
            this.attributesHash.put(cArray, inferredAttribute);
            if (!this.isAnonymous) {
                this.updatePositions(aSTNode.sourceStart, aSTNode.sourceEnd);
            }
        }
        return inferredAttribute;
    }

    public InferredAttribute findAttribute(char[] cArray) {
        return (InferredAttribute)this.attributesHash.get(cArray);
    }

    public InferredMethod addMethod(char[] cArray, MethodDeclaration methodDeclaration) {
        InferredMethod inferredMethod = this.findMethod(cArray, methodDeclaration);
        if (inferredMethod == null) {
            inferredMethod = new InferredMethod(cArray, methodDeclaration, this);
            if (this.methods == null) {
                this.methods = new ArrayList();
            }
            this.methods.add(inferredMethod);
            if (!this.isAnonymous) {
                this.updatePositions(methodDeclaration.sourceStart, methodDeclaration.sourceEnd);
            }
        }
        methodDeclaration.inferredMethod = inferredMethod;
        return inferredMethod;
    }

    public InferredMethod findMethod(char[] cArray, MethodDeclaration methodDeclaration) {
        if (cArray == TypeConstants.INIT) {
            cArray = this.name;
        }
        if (this.methods != null) {
            Iterator iterator = this.methods.iterator();
            while (iterator.hasNext()) {
                InferredMethod inferredMethod = (InferredMethod)iterator.next();
                if (!CharOperation.equals(cArray, inferredMethod.name)) continue;
                return inferredMethod;
            }
        }
        return null;
    }

    public TypeBinding resolveType(BlockScope blockScope, ASTNode aSTNode) {
        if (this.resolvedType != null) {
            return this.resolvedType.isValidBinding() ? this.resolvedType : null;
        }
        if (this.isArray()) {
            TypeBinding typeBinding;
            TypeBinding typeBinding2 = typeBinding = this.referenceClass != null ? this.referenceClass.resolveType(blockScope, aSTNode) : null;
            if (typeBinding == null) {
                typeBinding = TypeBinding.UNKNOWN;
            }
            this.resolvedType = new ArrayBinding(typeBinding, 1, blockScope.compilationUnitScope().environment);
        } else {
            this.resolvedType = blockScope.getType(this.name);
            if (!this.resolvedType.isValidBinding()) {
                this.resolvedType = null;
            }
        }
        if (this.resolvedType == null) {
            return null;
        }
        if (!this.resolvedType.isValidBinding()) {
            blockScope.problemReporter().invalidType(aSTNode, this.resolvedType);
            return null;
        }
        if (aSTNode.isTypeUseDeprecated(this.resolvedType, blockScope)) {
            blockScope.problemReporter().deprecatedType(this.resolvedType, aSTNode);
        }
        this.resolvedType = blockScope.environment().convertToRawType(this.resolvedType);
        if (this.isAnonymous) {
            this.resolvedType.tagBits |= 0x34L;
        }
        return this.resolvedType;
    }

    public void dumpReference(StringBuffer stringBuffer) {
        stringBuffer.append(this.name);
        if (this.referenceClass != null) {
            stringBuffer.append('(');
            this.referenceClass.dumpReference(stringBuffer);
            stringBuffer.append(')');
        }
    }

    public boolean containsMethod(AbstractMethodDeclaration abstractMethodDeclaration) {
        if (this.methods != null) {
            Iterator iterator = this.methods.iterator();
            while (iterator.hasNext()) {
                InferredMethod inferredMethod = (InferredMethod)iterator.next();
                if (inferredMethod.methodDeclaration != abstractMethodDeclaration) continue;
                return true;
            }
        }
        return false;
    }

    public ReferenceBinding resolveSuperType(ClassScope classScope) {
        if (this.resolvedSuperType != null) {
            return this.resolvedSuperType;
        }
        this.resolvedSuperType = (ReferenceBinding)classScope.getType(this.name);
        return this.resolvedSuperType;
    }

    public boolean isArray() {
        return ARRAY_NAME.equals(this.name);
    }

    public StringBuffer print(int n, StringBuffer stringBuffer) {
        InferredType.printIndent(n, stringBuffer);
        char[] cArray = this.getSuperClassName();
        stringBuffer.append("class ").append(this.name).append(" extends ").append(cArray).append("{\n");
        int n2 = 0;
        while (n2 < this.numberAttributes) {
            this.attributes[n2].print(n + 1, stringBuffer);
            stringBuffer.append(";\n");
            ++n2;
        }
        if (this.methods != null) {
            Iterator iterator = this.methods.iterator();
            while (iterator.hasNext()) {
                InferredMethod inferredMethod = (InferredMethod)iterator.next();
                inferredMethod.print(n + 1, stringBuffer);
                stringBuffer.append("\n");
            }
        }
        stringBuffer.append("}");
        return stringBuffer;
    }

    public boolean isInferred() {
        return true;
    }

    public void updatePositions(int n, int n2) {
        if (n >= 0 && n < this.sourceStart) {
            this.sourceStart = n;
        }
        if (n2 > 0 && n2 > this.sourceEnd) {
            this.sourceEnd = n2;
        }
    }

    public AbstractMethodDeclaration declarationOf(MethodBinding methodBinding) {
        if (methodBinding != null && this.methods != null) {
            int n = 0;
            int n2 = this.methods.size();
            while (n < n2) {
                InferredMethod inferredMethod = (InferredMethod)this.methods.get(n);
                if (inferredMethod.methodBinding == methodBinding) {
                    return inferredMethod.methodDeclaration;
                }
                ++n;
            }
        }
        return null;
    }
}

