/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.internal.autoedit;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ConfigurableLineTracker;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension3;
import org.eclipse.wst.html.core.internal.HTMLCorePlugin;
import org.eclipse.wst.jsdt.web.ui.internal.Logger;

public class AutoEditStrategyForTabs
implements IAutoEditStrategy {
    private final String TAB_CHARACTER = "\t";
    static /* synthetic */ Class class$0;

    public void customizeDocumentCommand(IDocument iDocument, DocumentCommand documentCommand) {
        if (!this.isSmartInsertMode()) {
            return;
        }
        if (documentCommand.length == 0 && documentCommand.text != null && documentCommand.text.length() > 0 && documentCommand.text.indexOf("\t") != -1) {
            this.smartInsertForTab(documentCommand, iDocument);
        }
    }

    private int getIndentationWidth() {
        int n = -1;
        Preferences preferences = HTMLCorePlugin.getDefault().getPluginPreferences();
        if ("space".equals(preferences.getString("indentationChar"))) {
            n = preferences.getInt("indentationSize");
        }
        return n;
    }

    private String getIndentString(int n, int n2, ILineTracker iLineTracker, int n3) {
        int n4;
        int n5;
        block8: {
            n5 = n;
            n4 = -1;
            if (iLineTracker != null) {
                try {
                    IRegion iRegion = iLineTracker.getLineInformationOfOffset(n3);
                    if (iRegion.getOffset() == 0 && n2 > -1) {
                        n4 = n2 + n3;
                        break block8;
                    }
                    n4 = n3 - iRegion.getOffset();
                }
                catch (BadLocationException badLocationException) {
                    Logger.log(202, badLocationException.getMessage(), badLocationException);
                }
            } else if (n2 > -1) {
                n4 = n2 + n3;
            }
        }
        if (n4 > -1 && n > 0) {
            int n6 = n4 % n;
            n5 = n - n6;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n7 = 0;
        while (n7 < n5) {
            stringBuffer.append(' ');
            ++n7;
        }
        return stringBuffer.toString();
    }

    private ILineTracker getLineTracker(IDocument iDocument, String string) {
        ConfigurableLineTracker configurableLineTracker = null;
        int[] nArray = TextUtilities.indexOf((String[])iDocument.getLegalLineDelimiters(), (String)string, (int)0);
        if (nArray[0] != -1 || nArray[1] != -1) {
            configurableLineTracker = new ConfigurableLineTracker(iDocument.getLegalLineDelimiters());
            configurableLineTracker.set(string);
        }
        return configurableLineTracker;
    }

    private boolean isSmartInsertMode() {
        IEditorPart iEditorPart;
        IWorkbenchPage iWorkbenchPage;
        boolean bl = false;
        ITextEditor iTextEditor = null;
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null && (iEditorPart = iWorkbenchPage.getActiveEditor()) != null) {
            if (iEditorPart instanceof ITextEditor) {
                iTextEditor = (ITextEditor)iEditorPart;
            } else {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.ITextEditor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                iTextEditor = (ITextEditor)iEditorPart.getAdapter((Class)clazz);
            }
        }
        if (iTextEditor instanceof ITextEditorExtension3 && ((ITextEditorExtension3)iTextEditor).getInsertMode() == ITextEditorExtension3.SMART_INSERT) {
            bl = true;
        }
        return bl;
    }

    private void smartInsertForTab(DocumentCommand documentCommand, IDocument iDocument) {
        int n = this.getIndentationWidth();
        if (n > -1) {
            IRegion iRegion;
            String string = documentCommand.text;
            StringBuffer stringBuffer = new StringBuffer(string);
            int n2 = -1;
            try {
                iRegion = iDocument.getLineInformationOfOffset(documentCommand.offset);
                n2 = documentCommand.offset - iRegion.getOffset();
            }
            catch (BadLocationException badLocationException) {
                Logger.log(202, badLocationException.getMessage(), badLocationException);
            }
            iRegion = this.getLineTracker(iDocument, string);
            int n3 = 0;
            int n4 = stringBuffer.indexOf("\t");
            while (n4 != -1) {
                String string2 = this.getIndentString(n, n2, (ILineTracker)iRegion, n4);
                stringBuffer.replace(n4, n4 + 1, string2);
                if (iRegion != null) {
                    try {
                        iRegion.replace(n4, 1, string2);
                    }
                    catch (BadLocationException badLocationException) {
                        iRegion.set(stringBuffer.toString());
                        Logger.log(202, badLocationException.getMessage(), badLocationException);
                    }
                }
                n3 = n4 + string2.length();
                n4 = stringBuffer.indexOf("\t", n3);
            }
            documentCommand.text = stringBuffer.toString();
        }
    }
}

