/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.codemanipulation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.NamingConventions;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.IPackageBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.Javadoc;
import org.eclipse.wst.jsdt.core.dom.MarkerAnnotation;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.ParameterizedType;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeParameter;
import org.eclipse.wst.jsdt.core.dom.WildcardType;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.ui.CodeGeneration;

public final class StubUtility2 {
    public static void addOverrideAnnotation(ASTRewrite aSTRewrite, MethodDeclaration methodDeclaration, IMethodBinding iMethodBinding) {
        String string = iMethodBinding.getJavaElement().getJavaProject().getOption("org.eclipse.wst.jsdt.core.compiler.compliance", true);
        if (!iMethodBinding.getDeclaringClass().isInterface() || !JavaModelUtil.isVersionLessThan(string, "1.6")) {
            MarkerAnnotation markerAnnotation = aSTRewrite.getAST().newMarkerAnnotation();
            markerAnnotation.setTypeName((Name)aSTRewrite.getAST().newSimpleName("Override"));
            aSTRewrite.getListRewrite((ASTNode)methodDeclaration, MethodDeclaration.MODIFIERS2_PROPERTY).insertFirst((ASTNode)markerAnnotation, null);
        }
    }

    public static MethodDeclaration createConstructorStub(ICompilationUnit iCompilationUnit, ASTRewrite aSTRewrite, ImportRewrite importRewrite, IMethodBinding iMethodBinding, String string, int n, boolean bl, boolean bl2, CodeGenerationSettings codeGenerationSettings) throws CoreException {
        SingleVariableDeclaration singleVariableDeclaration;
        Object object;
        Object object2;
        ITypeBinding[] iTypeBindingArray;
        Object object3;
        AST aST = aSTRewrite.getAST();
        MethodDeclaration methodDeclaration = aST.newMethodDeclaration();
        methodDeclaration.modifiers().addAll(ASTNodeFactory.newModifiers(aST, n & 0xFFFFFBFF & 0xFFFFFEFF));
        methodDeclaration.setName(aST.newSimpleName(string));
        methodDeclaration.setConstructor(true);
        ITypeBinding[] iTypeBindingArray2 = iMethodBinding.getTypeParameters();
        List list = methodDeclaration.typeParameters();
        int n2 = 0;
        while (n2 < iTypeBindingArray2.length) {
            object3 = iTypeBindingArray2[n2];
            iTypeBindingArray = aST.newTypeParameter();
            iTypeBindingArray.setName(aST.newSimpleName(object3.getName()));
            ITypeBinding[] iTypeBindingArray3 = object3.getTypeBounds();
            if (iTypeBindingArray3.length != 1 || !"java.lang.Object".equals(iTypeBindingArray3[0].getQualifiedName())) {
                object2 = iTypeBindingArray.typeBounds();
                int n3 = 0;
                while (n3 < iTypeBindingArray3.length) {
                    object2.add(importRewrite.addImport(iTypeBindingArray3[n3], aST));
                    ++n3;
                }
            }
            list.add(iTypeBindingArray);
            ++n2;
        }
        List list2 = StubUtility2.createParameters(iCompilationUnit, importRewrite, aST, iMethodBinding, methodDeclaration, null);
        object3 = methodDeclaration.thrownExceptions();
        iTypeBindingArray = iMethodBinding.getExceptionTypes();
        int n4 = 0;
        while (n4 < iTypeBindingArray.length) {
            object2 = importRewrite.addImport(iTypeBindingArray[n4]);
            object3.add(ASTNodeFactory.newName(aST, (String)object2));
            ++n4;
        }
        Block block = aST.newBlock();
        methodDeclaration.setBody(block);
        object2 = StubUtility.getLineDelimiterUsed((IJavaElement)iCompilationUnit);
        String string2 = "";
        if (!bl || !list2.isEmpty()) {
            object = aST.newSuperConstructorInvocation();
            singleVariableDeclaration = null;
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                singleVariableDeclaration = (SingleVariableDeclaration)iterator.next();
                object.arguments().add(aST.newSimpleName(singleVariableDeclaration.getName().getIdentifier()));
            }
            string2 = ASTNodes.asFormattedString((ASTNode)object, 0, (String)object2, iCompilationUnit.getJavaProject().getOptions(true));
        }
        if (bl2) {
            object = CodeGeneration.getMethodBodyContent(iCompilationUnit, string, iMethodBinding.getName(), true, string2, (String)object2);
            if (object != null) {
                singleVariableDeclaration = aSTRewrite.createStringPlaceholder((String)object, 41);
                block.statements().add(singleVariableDeclaration);
            }
        } else {
            object = aSTRewrite.createStringPlaceholder(string2, 41);
            block.statements().add(object);
        }
        if (codeGenerationSettings != null && codeGenerationSettings.createComments && (object = CodeGeneration.getMethodComment(iCompilationUnit, string, methodDeclaration, iMethodBinding, (String)object2)) != null) {
            singleVariableDeclaration = (Javadoc)aSTRewrite.createStringPlaceholder((String)object, 29);
            methodDeclaration.setJavadoc((Javadoc)singleVariableDeclaration);
        }
        return methodDeclaration;
    }

    public static MethodDeclaration createConstructorStub(ICompilationUnit iCompilationUnit, ASTRewrite aSTRewrite, ImportRewrite importRewrite, ITypeBinding iTypeBinding, AST aST, IMethodBinding iMethodBinding, IVariableBinding[] iVariableBindingArray, int n, CodeGenerationSettings codeGenerationSettings) throws CoreException {
        String string;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Block block;
        MethodDeclaration methodDeclaration = aST.newMethodDeclaration();
        methodDeclaration.modifiers().addAll(ASTNodeFactory.newModifiers(aST, n & 0xFFFFFBFF & 0xFFFFFEFF));
        methodDeclaration.setName(aST.newSimpleName(iTypeBinding.getName()));
        methodDeclaration.setConstructor(true);
        List list = methodDeclaration.parameters();
        if (iMethodBinding != null) {
            block = iMethodBinding.getTypeParameters();
            object4 = methodDeclaration.typeParameters();
            int n2 = 0;
            while (n2 < ((Block)block).length) {
                object3 = block[n2];
                TypeParameter typeParameter = aST.newTypeParameter();
                typeParameter.setName(aST.newSimpleName(object3.getName()));
                object2 = object3.getTypeBounds();
                if (((ITypeBinding[])object2).length != 1 || !"java.lang.Object".equals(object2[0].getQualifiedName())) {
                    List list2 = typeParameter.typeBounds();
                    int n3 = 0;
                    while (n3 < ((ITypeBinding[])object2).length) {
                        list2.add(importRewrite.addImport(object2[n3], aST));
                        ++n3;
                    }
                }
                object4.add(typeParameter);
                ++n2;
            }
            StubUtility2.createParameters(iCompilationUnit, importRewrite, aST, iMethodBinding, methodDeclaration, null);
            object = methodDeclaration.thrownExceptions();
            object3 = iMethodBinding.getExceptionTypes();
            int n4 = 0;
            while (n4 < ((Object)object3).length) {
                object2 = importRewrite.addImport((ITypeBinding)object3[n4]);
                object.add(ASTNodeFactory.newName(aST, (String)object2));
                ++n4;
            }
        }
        block = aST.newBlock();
        methodDeclaration.setBody(block);
        object4 = StubUtility.getLineDelimiterUsed((IJavaElement)iCompilationUnit);
        if (iMethodBinding != null) {
            object = aST.newSuperConstructorInvocation();
            object3 = null;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                object3 = (SingleVariableDeclaration)iterator.next();
                object.arguments().add(aST.newSimpleName(object3.getName().getIdentifier()));
            }
            block.statements().add(object);
        }
        object = new ArrayList();
        object3 = list.iterator();
        while (object3.hasNext()) {
            object.add(((SingleVariableDeclaration)object3.next()).getName().getIdentifier());
        }
        object3 = null;
        ArrayList<Object> arrayList = new ArrayList<Object>((Collection<Object>)object);
        object2 = null;
        int n5 = 0;
        while (n5 < iVariableBindingArray.length) {
            SingleVariableDeclaration singleVariableDeclaration = aST.newSingleVariableDeclaration();
            singleVariableDeclaration.setType(importRewrite.addImport(iVariableBindingArray[n5].getType(), aST));
            object2 = new String[arrayList.size()];
            arrayList.toArray((T[])object2);
            object3 = StubUtility2.getParameterName(iCompilationUnit, iVariableBindingArray[n5], (String[])object2);
            arrayList.add(object3);
            singleVariableDeclaration.setName(aST.newSimpleName((String)object3));
            list.add(singleVariableDeclaration);
            ++n5;
        }
        arrayList = new ArrayList(object);
        n5 = 0;
        while (n5 < iVariableBindingArray.length) {
            FieldAccess fieldAccess;
            object2 = new String[arrayList.size()];
            arrayList.toArray((T[])object2);
            String string2 = StubUtility2.getParameterName(iCompilationUnit, iVariableBindingArray[n5], (String[])object2);
            arrayList.add(string2);
            String string3 = iVariableBindingArray[n5].getName();
            SimpleName simpleName = null;
            if (string2.equals(string3) || codeGenerationSettings.useKeywordThis) {
                fieldAccess = aST.newFieldAccess();
                fieldAccess.setExpression((Expression)aST.newThisExpression());
                fieldAccess.setName(aST.newSimpleName(string3));
                simpleName = fieldAccess;
            } else {
                simpleName = aST.newSimpleName(string3);
            }
            fieldAccess = aST.newAssignment();
            fieldAccess.setLeftHandSide((Expression)simpleName);
            fieldAccess.setRightHandSide((Expression)aST.newSimpleName(string2));
            fieldAccess.setOperator(Assignment.Operator.ASSIGN);
            block.statements().add(aST.newExpressionStatement((Expression)fieldAccess));
            ++n5;
        }
        if (codeGenerationSettings != null && codeGenerationSettings.createComments && (string = CodeGeneration.getMethodComment(iCompilationUnit, iTypeBinding.getName(), methodDeclaration, iMethodBinding, (String)object4)) != null) {
            Javadoc javadoc = (Javadoc)aSTRewrite.createStringPlaceholder(string, 29);
            methodDeclaration.setJavadoc(javadoc);
        }
        return methodDeclaration;
    }

    public static MethodDeclaration createDelegationStub(ICompilationUnit iCompilationUnit, ASTRewrite aSTRewrite, ImportRewrite importRewrite, AST aST, IBinding[] iBindingArray, CodeGenerationSettings codeGenerationSettings) throws CoreException {
        ITypeBinding[] iTypeBindingArray;
        String[] stringArray;
        ITypeBinding[] iTypeBindingArray2;
        Assert.isNotNull((Object)iBindingArray);
        Assert.isNotNull((Object)codeGenerationSettings);
        Assert.isTrue((iBindingArray.length == 2 ? 1 : 0) != 0);
        Assert.isTrue((boolean)(iBindingArray[0] instanceof IVariableBinding));
        Assert.isTrue((boolean)(iBindingArray[1] instanceof IMethodBinding));
        IVariableBinding iVariableBinding = (IVariableBinding)iBindingArray[0];
        IMethodBinding iMethodBinding = (IMethodBinding)iBindingArray[1];
        MethodDeclaration methodDeclaration = aST.newMethodDeclaration();
        methodDeclaration.modifiers().addAll(ASTNodeFactory.newModifiers(aST, iMethodBinding.getModifiers() & 0xFFFFFFDF & 0xFFFFFBFF & 0xFFFFFEFF));
        methodDeclaration.setName(aST.newSimpleName(iMethodBinding.getName()));
        methodDeclaration.setConstructor(false);
        ITypeBinding[] iTypeBindingArray3 = iMethodBinding.getTypeParameters();
        List list = methodDeclaration.typeParameters();
        int n = 0;
        while (n < iTypeBindingArray3.length) {
            iTypeBindingArray2 = iTypeBindingArray3[n];
            stringArray = aST.newTypeParameter();
            stringArray.setName(aST.newSimpleName(iTypeBindingArray2.getName()));
            ITypeBinding[] iTypeBindingArray4 = iTypeBindingArray2.getTypeBounds();
            if (iTypeBindingArray4.length != 1 || !"java.lang.Object".equals(iTypeBindingArray4[0].getQualifiedName())) {
                iTypeBindingArray = stringArray.typeBounds();
                int n2 = 0;
                while (n2 < iTypeBindingArray4.length) {
                    iTypeBindingArray.add(importRewrite.addImport(iTypeBindingArray4[n2], aST));
                    ++n2;
                }
            }
            list.add(stringArray);
            ++n;
        }
        methodDeclaration.setReturnType2(importRewrite.addImport(iMethodBinding.getReturnType(), aST));
        List list2 = methodDeclaration.parameters();
        iTypeBindingArray2 = iMethodBinding.getParameterTypes();
        stringArray = StubUtility.suggestArgumentNames(iCompilationUnit.getJavaProject(), iMethodBinding);
        int n3 = 0;
        while (n3 < iTypeBindingArray2.length) {
            iTypeBindingArray = aST.newSingleVariableDeclaration();
            if (iTypeBindingArray2[n3].isWildcardType() && !iTypeBindingArray2[n3].isUpperbound()) {
                iTypeBindingArray.setType(importRewrite.addImport(iTypeBindingArray2[n3].getBound(), aST));
            } else if (iMethodBinding.isVarargs() && iTypeBindingArray2[n3].isArray() && n3 == iTypeBindingArray2.length - 1) {
                StringBuffer stringBuffer = new StringBuffer(importRewrite.addImport(iTypeBindingArray2[n3].getElementType()));
                int n4 = 1;
                while (n4 < iTypeBindingArray2[n3].getDimensions()) {
                    stringBuffer.append("[]");
                    ++n4;
                }
                iTypeBindingArray.setType(ASTNodeFactory.newType(aST, stringBuffer.toString()));
                iTypeBindingArray.setVarargs(true);
            } else {
                iTypeBindingArray.setType(importRewrite.addImport(iTypeBindingArray2[n3], aST));
            }
            iTypeBindingArray.setName(aST.newSimpleName(stringArray[n3]));
            list2.add(iTypeBindingArray);
            ++n3;
        }
        List list3 = methodDeclaration.thrownExceptions();
        iTypeBindingArray = iMethodBinding.getExceptionTypes();
        int n5 = 0;
        while (n5 < iTypeBindingArray.length) {
            String string = importRewrite.addImport(iTypeBindingArray[n5]);
            list3.add(ASTNodeFactory.newName(aST, string));
            ++n5;
        }
        Block block = aST.newBlock();
        methodDeclaration.setBody(block);
        String string = StubUtility.getLineDelimiterUsed((IJavaElement)iCompilationUnit);
        ReturnStatement returnStatement = null;
        MethodInvocation methodInvocation = aST.newMethodInvocation();
        methodInvocation.setName(aST.newSimpleName(iMethodBinding.getName()));
        List list4 = methodInvocation.arguments();
        int n6 = 0;
        while (n6 < iTypeBindingArray2.length) {
            list4.add(aST.newSimpleName(stringArray[n6]));
            ++n6;
        }
        if (codeGenerationSettings.useKeywordThis) {
            FieldAccess fieldAccess = aST.newFieldAccess();
            fieldAccess.setExpression((Expression)aST.newThisExpression());
            fieldAccess.setName(aST.newSimpleName(iVariableBinding.getName()));
            methodInvocation.setExpression((Expression)fieldAccess);
        } else {
            methodInvocation.setExpression((Expression)aST.newSimpleName(iVariableBinding.getName()));
        }
        if (iMethodBinding.getReturnType().isPrimitive() && iMethodBinding.getReturnType().getName().equals("void")) {
            returnStatement = aST.newExpressionStatement((Expression)methodInvocation);
        } else {
            ReturnStatement returnStatement2 = aST.newReturnStatement();
            returnStatement2.setExpression((Expression)methodInvocation);
            returnStatement = returnStatement2;
        }
        block.statements().add(returnStatement);
        ITypeBinding iTypeBinding = iVariableBinding.getDeclaringClass();
        if (iTypeBinding == null) {
            return methodDeclaration;
        }
        String string2 = iTypeBinding.getQualifiedName();
        IPackageBinding iPackageBinding = iTypeBinding.getPackage();
        if (iPackageBinding != null && iPackageBinding.getName().length() > 0 && string2.startsWith(iPackageBinding.getName())) {
            string2 = string2.substring(iPackageBinding.getName().length());
        }
        if (codeGenerationSettings.createComments) {
            iMethodBinding = iMethodBinding.getMethodDeclaration();
            String string3 = iMethodBinding.getDeclaringClass().getQualifiedName();
            String string4 = iMethodBinding.getName();
            String[] stringArray2 = StubUtility.getParameterTypeNamesForSeeTag(iMethodBinding);
            String string5 = StubUtility.getMethodComment(iCompilationUnit, string2, methodDeclaration, iMethodBinding.isDeprecated(), string4, string3, stringArray2, true, string);
            if (string5 != null) {
                Javadoc javadoc = (Javadoc)aSTRewrite.createStringPlaceholder(string5, 29);
                methodDeclaration.setJavadoc(javadoc);
            }
        }
        return methodDeclaration;
    }

    public static MethodDeclaration createImplementationStub(ICompilationUnit iCompilationUnit, ASTRewrite aSTRewrite, ImportRewrite importRewrite, AST aST, IMethodBinding iMethodBinding, String string, CodeGenerationSettings codeGenerationSettings, boolean bl, ImportRewrite.ImportRewriteContext importRewriteContext) throws CoreException {
        Object object;
        ITypeBinding[] iTypeBindingArray;
        Object object2;
        MethodDeclaration methodDeclaration = aST.newMethodDeclaration();
        methodDeclaration.modifiers().addAll(StubUtility2.getImplementationModifiers(aST, iMethodBinding, bl));
        methodDeclaration.setName(aST.newSimpleName(iMethodBinding.getName()));
        methodDeclaration.setConstructor(false);
        ITypeBinding[] iTypeBindingArray2 = iMethodBinding.getTypeParameters();
        List list = methodDeclaration.typeParameters();
        int n = 0;
        while (n < iTypeBindingArray2.length) {
            object2 = iTypeBindingArray2[n];
            iTypeBindingArray = aST.newTypeParameter();
            iTypeBindingArray.setName(aST.newSimpleName(object2.getName()));
            ITypeBinding[] iTypeBindingArray3 = object2.getTypeBounds();
            if (iTypeBindingArray3.length != 1 || !"java.lang.Object".equals(iTypeBindingArray3[0].getQualifiedName())) {
                object = iTypeBindingArray.typeBounds();
                int n2 = 0;
                while (n2 < iTypeBindingArray3.length) {
                    object.add(importRewrite.addImport(iTypeBindingArray3[n2], aST, importRewriteContext));
                    ++n2;
                }
            }
            list.add(iTypeBindingArray);
            ++n;
        }
        methodDeclaration.setReturnType2(importRewrite.addImport(iMethodBinding.getReturnType(), aST, importRewriteContext));
        List list2 = StubUtility2.createParameters(iCompilationUnit, importRewrite, aST, iMethodBinding, methodDeclaration, importRewriteContext);
        object2 = methodDeclaration.thrownExceptions();
        iTypeBindingArray = iMethodBinding.getExceptionTypes();
        int n3 = 0;
        while (n3 < iTypeBindingArray.length) {
            object = importRewrite.addImport(iTypeBindingArray[n3], importRewriteContext);
            object2.add(ASTNodeFactory.newName(aST, (String)object));
            ++n3;
        }
        String string2 = StubUtility.getLineDelimiterUsed((IJavaElement)iCompilationUnit);
        if (!bl) {
            ReturnStatement returnStatement;
            Object object3;
            object = iCompilationUnit.getJavaProject().getOptions(true);
            Block block = aST.newBlock();
            methodDeclaration.setBody(block);
            String string3 = "";
            ITypeBinding iTypeBinding = iMethodBinding.getDeclaringClass();
            if (Modifier.isAbstract((int)iMethodBinding.getModifiers()) || iTypeBinding.isAnnotation() || iTypeBinding.isInterface()) {
                object3 = ASTNodeFactory.newDefaultExpression(aST, methodDeclaration.getReturnType2(), methodDeclaration.getExtraDimensions());
                if (object3 != null) {
                    returnStatement = aST.newReturnStatement();
                    returnStatement.setExpression((Expression)object3);
                    string3 = ASTNodes.asFormattedString((ASTNode)returnStatement, 0, string2, (Map)object);
                }
            } else {
                object3 = aST.newSuperMethodInvocation();
                object3.setName(aST.newSimpleName(iMethodBinding.getName()));
                returnStatement = null;
                Object object4 = list2.iterator();
                while (object4.hasNext()) {
                    returnStatement = (SingleVariableDeclaration)object4.next();
                    object3.arguments().add(aST.newSimpleName(returnStatement.getName().getIdentifier()));
                }
                object4 = object3;
                Type type = methodDeclaration.getReturnType2();
                if (type != null && type instanceof PrimitiveType && ((PrimitiveType)type).getPrimitiveTypeCode().equals(PrimitiveType.VOID)) {
                    string3 = ASTNodes.asFormattedString((ASTNode)aST.newExpressionStatement((Expression)object4), 0, string2, (Map)object);
                } else {
                    ReturnStatement returnStatement2 = aST.newReturnStatement();
                    returnStatement2.setExpression((Expression)object4);
                    string3 = ASTNodes.asFormattedString((ASTNode)returnStatement2, 0, string2, (Map)object);
                }
            }
            if ((object3 = CodeGeneration.getMethodBodyContent(iCompilationUnit, string, iMethodBinding.getName(), false, string3, string2)) != null) {
                returnStatement = aSTRewrite.createStringPlaceholder((String)object3, 41);
                block.statements().add(returnStatement);
            }
        }
        if (codeGenerationSettings.createComments && (object = CodeGeneration.getMethodComment(iCompilationUnit, string, methodDeclaration, iMethodBinding, string2)) != null) {
            Javadoc javadoc = (Javadoc)aSTRewrite.createStringPlaceholder((String)object, 29);
            methodDeclaration.setJavadoc(javadoc);
        }
        if (codeGenerationSettings.overrideAnnotation && JavaModelUtil.is50OrHigher(iCompilationUnit.getJavaProject())) {
            StubUtility2.addOverrideAnnotation(aSTRewrite, methodDeclaration, iMethodBinding);
        }
        return methodDeclaration;
    }

    public static MethodDeclaration createImplementationStub(ICompilationUnit iCompilationUnit, ASTRewrite aSTRewrite, ImportRewrite importRewrite, IMethodBinding iMethodBinding, String string, boolean bl, CodeGenerationSettings codeGenerationSettings) throws CoreException {
        Object object;
        ITypeBinding[] iTypeBindingArray;
        Object object2;
        AST aST = aSTRewrite.getAST();
        MethodDeclaration methodDeclaration = aST.newMethodDeclaration();
        methodDeclaration.modifiers().addAll(StubUtility2.getImplementationModifiers(aST, iMethodBinding, bl));
        methodDeclaration.setName(aST.newSimpleName(iMethodBinding.getName()));
        methodDeclaration.setConstructor(false);
        ITypeBinding[] iTypeBindingArray2 = iMethodBinding.getTypeParameters();
        List list = methodDeclaration.typeParameters();
        int n = 0;
        while (n < iTypeBindingArray2.length) {
            object2 = iTypeBindingArray2[n];
            iTypeBindingArray = aST.newTypeParameter();
            iTypeBindingArray.setName(aST.newSimpleName(object2.getName()));
            ITypeBinding[] iTypeBindingArray3 = object2.getTypeBounds();
            if (iTypeBindingArray3.length != 1 || !"java.lang.Object".equals(iTypeBindingArray3[0].getQualifiedName())) {
                object = iTypeBindingArray.typeBounds();
                int n2 = 0;
                while (n2 < iTypeBindingArray3.length) {
                    object.add(StubUtility2.createTypeNode(importRewrite, iTypeBindingArray3[n2], aST));
                    ++n2;
                }
            }
            list.add(iTypeBindingArray);
            ++n;
        }
        methodDeclaration.setReturnType2(StubUtility2.createTypeNode(importRewrite, iMethodBinding.getReturnType(), aST));
        List list2 = StubUtility2.createParameters(iCompilationUnit, importRewrite, aST, iMethodBinding, methodDeclaration);
        object2 = methodDeclaration.thrownExceptions();
        iTypeBindingArray = iMethodBinding.getExceptionTypes();
        int n3 = 0;
        while (n3 < iTypeBindingArray.length) {
            object2.add(ASTNodeFactory.newName(aST, importRewrite != null ? importRewrite.addImport(iTypeBindingArray[n3]) : iTypeBindingArray[n3].getQualifiedName()));
            ++n3;
        }
        String string2 = StubUtility.getLineDelimiterUsed((IJavaElement)iCompilationUnit);
        if (!bl) {
            ReturnStatement returnStatement;
            Object object3;
            object = iCompilationUnit.getJavaProject().getOptions(true);
            Block block = aST.newBlock();
            methodDeclaration.setBody(block);
            String string3 = "";
            ITypeBinding iTypeBinding = iMethodBinding.getDeclaringClass();
            if (Modifier.isAbstract((int)iMethodBinding.getModifiers()) || iTypeBinding.isAnnotation() || iTypeBinding.isInterface()) {
                object3 = ASTNodeFactory.newDefaultExpression(aST, methodDeclaration.getReturnType2(), methodDeclaration.getExtraDimensions());
                if (object3 != null) {
                    returnStatement = aST.newReturnStatement();
                    returnStatement.setExpression((Expression)object3);
                    string3 = ASTNodes.asFormattedString((ASTNode)returnStatement, 0, string2, (Map)object);
                }
            } else {
                object3 = aST.newSuperMethodInvocation();
                object3.setName(aST.newSimpleName(iMethodBinding.getName()));
                returnStatement = null;
                Object object4 = list2.iterator();
                while (object4.hasNext()) {
                    returnStatement = (SingleVariableDeclaration)object4.next();
                    object3.arguments().add(aST.newSimpleName(returnStatement.getName().getIdentifier()));
                }
                object4 = object3;
                Type type = methodDeclaration.getReturnType2();
                if (type instanceof PrimitiveType && ((PrimitiveType)type).getPrimitiveTypeCode().equals(PrimitiveType.VOID)) {
                    string3 = ASTNodes.asFormattedString((ASTNode)aST.newExpressionStatement((Expression)object4), 0, string2, (Map)object);
                } else {
                    ReturnStatement returnStatement2 = aST.newReturnStatement();
                    returnStatement2.setExpression((Expression)object4);
                    string3 = ASTNodes.asFormattedString((ASTNode)returnStatement2, 0, string2, (Map)object);
                }
            }
            if ((object3 = CodeGeneration.getMethodBodyContent(iCompilationUnit, string, iMethodBinding.getName(), false, string3, string2)) != null) {
                returnStatement = aSTRewrite.createStringPlaceholder((String)object3, 41);
                block.statements().add(returnStatement);
            }
        }
        if (codeGenerationSettings != null && codeGenerationSettings.createComments && (object = CodeGeneration.getMethodComment(iCompilationUnit, string, methodDeclaration, iMethodBinding, string2)) != null) {
            Javadoc javadoc = (Javadoc)aSTRewrite.createStringPlaceholder((String)object, 29);
            methodDeclaration.setJavadoc(javadoc);
        }
        if (codeGenerationSettings != null && codeGenerationSettings.overrideAnnotation && JavaModelUtil.is50OrHigher(iCompilationUnit.getJavaProject())) {
            StubUtility2.addOverrideAnnotation(aSTRewrite, methodDeclaration, iMethodBinding);
        }
        return methodDeclaration;
    }

    private static List createParameters(ICompilationUnit iCompilationUnit, ImportRewrite importRewrite, AST aST, IMethodBinding iMethodBinding, MethodDeclaration methodDeclaration, ImportRewrite.ImportRewriteContext importRewriteContext) {
        List list = methodDeclaration.parameters();
        ITypeBinding[] iTypeBindingArray = iMethodBinding.getParameterTypes();
        String[] stringArray = StubUtility.suggestArgumentNames(iCompilationUnit.getJavaProject(), iMethodBinding);
        int n = 0;
        while (n < iTypeBindingArray.length) {
            SingleVariableDeclaration singleVariableDeclaration = aST.newSingleVariableDeclaration();
            if (iMethodBinding.isVarargs() && iTypeBindingArray[n].isArray() && n == iTypeBindingArray.length - 1) {
                StringBuffer stringBuffer = new StringBuffer(importRewrite.addImport(iTypeBindingArray[n].getElementType(), importRewriteContext));
                int n2 = 1;
                while (n2 < iTypeBindingArray[n].getDimensions()) {
                    stringBuffer.append("[]");
                    ++n2;
                }
                singleVariableDeclaration.setType(ASTNodeFactory.newType(aST, stringBuffer.toString()));
                singleVariableDeclaration.setVarargs(true);
            } else {
                singleVariableDeclaration.setType(importRewrite.addImport(iTypeBindingArray[n], aST, importRewriteContext));
            }
            singleVariableDeclaration.setName(aST.newSimpleName(stringArray[n]));
            list.add(singleVariableDeclaration);
            ++n;
        }
        return list;
    }

    private static List createParameters(ICompilationUnit iCompilationUnit, ImportRewrite importRewrite, AST aST, IMethodBinding iMethodBinding, MethodDeclaration methodDeclaration) {
        List list = methodDeclaration.parameters();
        ITypeBinding[] iTypeBindingArray = iMethodBinding.getParameterTypes();
        String[] stringArray = StubUtility.suggestArgumentNames(iCompilationUnit.getJavaProject(), iMethodBinding);
        int n = 0;
        while (n < iTypeBindingArray.length) {
            SingleVariableDeclaration singleVariableDeclaration = aST.newSingleVariableDeclaration();
            if (iMethodBinding.isVarargs() && iTypeBindingArray[n].isArray() && n == iTypeBindingArray.length - 1) {
                ITypeBinding iTypeBinding = iTypeBindingArray[n].getElementType();
                StringBuffer stringBuffer = new StringBuffer(importRewrite != null ? importRewrite.addImport(iTypeBinding) : iTypeBinding.getQualifiedName());
                int n2 = 1;
                while (n2 < iTypeBindingArray[n].getDimensions()) {
                    stringBuffer.append("[]");
                    ++n2;
                }
                singleVariableDeclaration.setType(ASTNodeFactory.newType(aST, stringBuffer.toString()));
                singleVariableDeclaration.setVarargs(true);
            } else {
                singleVariableDeclaration.setType(StubUtility2.createTypeNode(importRewrite, iTypeBindingArray[n], aST));
            }
            singleVariableDeclaration.setName(aST.newSimpleName(stringArray[n]));
            list.add(singleVariableDeclaration);
            ++n;
        }
        return list;
    }

    private static Type createTypeNode(ImportRewrite importRewrite, ITypeBinding iTypeBinding, AST aST) {
        if (importRewrite != null) {
            return importRewrite.addImport(iTypeBinding, aST);
        }
        return StubUtility2.createTypeNode(iTypeBinding, aST);
    }

    private static Type createTypeNode(ITypeBinding iTypeBinding, AST aST) {
        if (iTypeBinding.isPrimitive()) {
            return aST.newPrimitiveType(PrimitiveType.toCode((String)iTypeBinding.getName()));
        }
        ITypeBinding iTypeBinding2 = Bindings.normalizeTypeBinding(iTypeBinding);
        if (iTypeBinding2 == null) {
            return aST.newSimpleType((Name)aST.newSimpleName("invalid"));
        }
        if (iTypeBinding2.isTypeVariable()) {
            return aST.newSimpleType((Name)aST.newSimpleName(iTypeBinding.getName()));
        }
        if (iTypeBinding2.isWildcardType()) {
            WildcardType wildcardType = aST.newWildcardType();
            ITypeBinding iTypeBinding3 = iTypeBinding2.getBound();
            if (iTypeBinding3 != null) {
                wildcardType.setBound(StubUtility2.createTypeNode(iTypeBinding3, aST), iTypeBinding2.isUpperbound());
            }
            return wildcardType;
        }
        if (iTypeBinding2.isArray()) {
            return aST.newArrayType(StubUtility2.createTypeNode(iTypeBinding2.getElementType(), aST), iTypeBinding2.getDimensions());
        }
        String string = Bindings.getRawQualifiedName(iTypeBinding2);
        if (string.length() > 0) {
            ITypeBinding[] iTypeBindingArray = iTypeBinding2.getTypeArguments();
            if (iTypeBindingArray.length > 0) {
                ParameterizedType parameterizedType = aST.newParameterizedType((Type)aST.newSimpleType(ASTNodeFactory.newName(aST, string)));
                List list = parameterizedType.typeArguments();
                int n = 0;
                while (n < iTypeBindingArray.length) {
                    list.add(StubUtility2.createTypeNode(iTypeBindingArray[n], aST));
                    ++n;
                }
                return parameterizedType;
            }
            return aST.newSimpleType(ASTNodeFactory.newName(aST, string));
        }
        return aST.newSimpleType(ASTNodeFactory.newName(aST, Bindings.getRawName(iTypeBinding2)));
    }

    private static IMethodBinding findMethodBinding(IMethodBinding iMethodBinding, List list) {
        int n = 0;
        while (n < list.size()) {
            IMethodBinding iMethodBinding2 = (IMethodBinding)list.get(n);
            if (Bindings.isSubsignature(iMethodBinding, iMethodBinding2)) {
                return iMethodBinding2;
            }
            ++n;
        }
        return null;
    }

    private static IMethodBinding findOverridingMethod(IMethodBinding iMethodBinding, List list) {
        int n = 0;
        while (n < list.size()) {
            IMethodBinding iMethodBinding2 = (IMethodBinding)list.get(n);
            if (Bindings.areOverriddenMethods(iMethodBinding2, iMethodBinding) || Bindings.isSubsignature(iMethodBinding2, iMethodBinding)) {
                return iMethodBinding2;
            }
            ++n;
        }
        return null;
    }

    private static void findUnimplementedInterfaceMethods(ITypeBinding iTypeBinding, HashSet hashSet, ArrayList arrayList, IPackageBinding iPackageBinding, ArrayList arrayList2) {
        if (hashSet.add(iTypeBinding)) {
            IMethodBinding[] iMethodBindingArray = iTypeBinding.getDeclaredMethods();
            int n = 0;
            while (n < iMethodBindingArray.length) {
                IMethodBinding iMethodBinding = iMethodBindingArray[n];
                IMethodBinding iMethodBinding2 = StubUtility2.findMethodBinding(iMethodBinding, arrayList);
                if (iMethodBinding2 == null || !Bindings.isVisibleInHierarchy(iMethodBinding2, iPackageBinding)) {
                    if (iMethodBinding2 != null) {
                        arrayList.remove(iMethodBinding2);
                    }
                    arrayList2.add(iMethodBinding);
                    arrayList.add(iMethodBinding);
                }
                ++n;
            }
            ITypeBinding[] iTypeBindingArray = iTypeBinding.getInterfaces();
            int n2 = 0;
            while (n2 < iTypeBindingArray.length) {
                StubUtility2.findUnimplementedInterfaceMethods(iTypeBindingArray[n2], hashSet, arrayList, iPackageBinding, arrayList2);
                ++n2;
            }
        }
    }

    public static IBinding[][] getDelegatableMethods(AST aST, ITypeBinding iTypeBinding) {
        ArrayList arrayList = new ArrayList();
        ArrayList<IMethodBinding> arrayList2 = new ArrayList<IMethodBinding>();
        IMethodBinding[] iMethodBindingArray = iTypeBinding.getDeclaredMethods();
        int n = 0;
        while (n < iMethodBindingArray.length) {
            arrayList2.add(iMethodBindingArray[n]);
            ++n;
        }
        IVariableBinding[] iVariableBindingArray = iTypeBinding.getDeclaredFields();
        int n2 = 0;
        while (n2 < iVariableBindingArray.length) {
            IVariableBinding iVariableBinding = iVariableBindingArray[n2];
            if (iVariableBinding.isField() && !iVariableBinding.isEnumConstant() && !iVariableBinding.isSynthetic()) {
                StubUtility2.getDelegatableMethods(aST, arrayList, new ArrayList(arrayList2), iVariableBinding, iVariableBinding.getType(), iTypeBinding);
            }
            ++n2;
        }
        return (IBinding[][])arrayList.toArray((T[])new IBinding[arrayList.size()][2]);
    }

    private static void getDelegatableMethods(AST aST, List list, List list2, IVariableBinding iVariableBinding, ITypeBinding iTypeBinding, ITypeBinding iTypeBinding2) {
        boolean bl = false;
        if (iTypeBinding.isTypeVariable()) {
            ITypeBinding[] iTypeBindingArray = iTypeBinding.getTypeBounds();
            if (iTypeBindingArray == null || iTypeBindingArray.length == 0) {
                iTypeBindingArray = new ITypeBinding[]{aST.resolveWellKnownType("java.lang.Object")};
            }
            int n = 0;
            while (n < iTypeBindingArray.length) {
                int n2;
                ITypeBinding[] iTypeBindingArray2;
                IMethodBinding[] iMethodBindingArray = StubUtility2.getDelegateCandidates(iTypeBindingArray[n], iTypeBinding2);
                int n3 = 0;
                while (n3 < iMethodBindingArray.length) {
                    bl = false;
                    iTypeBindingArray2 = iMethodBindingArray[n3];
                    n2 = 0;
                    while (n2 < list2.size() && !bl) {
                        if (Bindings.areOverriddenMethods((IMethodBinding)list2.get(n2), (IMethodBinding)iTypeBindingArray2)) {
                            bl = true;
                        }
                        ++n2;
                    }
                    if (!bl) {
                        list.add(new IBinding[]{iVariableBinding, iTypeBindingArray2});
                        list2.add(iTypeBindingArray2);
                    }
                    ++n3;
                }
                ITypeBinding iTypeBinding3 = iTypeBindingArray[n].getSuperclass();
                if (iTypeBinding3 != null) {
                    StubUtility2.getDelegatableMethods(aST, list, list2, iVariableBinding, iTypeBinding3, iTypeBinding2);
                }
                iTypeBindingArray2 = iTypeBindingArray[n].getInterfaces();
                n2 = 0;
                while (n2 < iTypeBindingArray2.length) {
                    StubUtility2.getDelegatableMethods(aST, list, list2, iVariableBinding, iTypeBindingArray2[n2], iTypeBinding2);
                    ++n2;
                }
                ++n;
            }
        } else {
            int n;
            ITypeBinding[] iTypeBindingArray;
            IMethodBinding[] iMethodBindingArray = StubUtility2.getDelegateCandidates(iTypeBinding, iTypeBinding2);
            int n4 = 0;
            while (n4 < iMethodBindingArray.length) {
                bl = false;
                iTypeBindingArray = iMethodBindingArray[n4];
                n = 0;
                while (n < list2.size() && !bl) {
                    if (Bindings.areOverriddenMethods((IMethodBinding)list2.get(n), (IMethodBinding)iTypeBindingArray)) {
                        bl = true;
                    }
                    ++n;
                }
                if (!bl) {
                    list.add(new IBinding[]{iVariableBinding, iTypeBindingArray});
                    list2.add(iTypeBindingArray);
                }
                ++n4;
            }
            ITypeBinding iTypeBinding4 = iTypeBinding.getSuperclass();
            if (iTypeBinding4 != null) {
                StubUtility2.getDelegatableMethods(aST, list, list2, iVariableBinding, iTypeBinding4, iTypeBinding2);
            }
            iTypeBindingArray = iTypeBinding.getInterfaces();
            n = 0;
            while (n < iTypeBindingArray.length) {
                StubUtility2.getDelegatableMethods(aST, list, list2, iVariableBinding, iTypeBindingArray[n], iTypeBinding2);
                ++n;
            }
        }
    }

    private static IMethodBinding[] getDelegateCandidates(ITypeBinding iTypeBinding, ITypeBinding iTypeBinding2) {
        ArrayList<IMethodBinding> arrayList = new ArrayList<IMethodBinding>();
        boolean bl = iTypeBinding.isInterface();
        IMethodBinding[] iMethodBindingArray = iTypeBinding.getDeclaredMethods();
        int n = 0;
        while (n < iMethodBindingArray.length) {
            IMethodBinding iMethodBinding;
            int n2 = iMethodBindingArray[n].getModifiers();
            if (!(iMethodBindingArray[n].isConstructor() || Modifier.isStatic((int)n2) || !bl && !Modifier.isPublic((int)n2) || (iMethodBinding = Bindings.findOverriddenMethodInHierarchy(iTypeBinding2, iMethodBindingArray[n])) != null && Flags.isFinal((int)iMethodBinding.getModifiers()))) {
                ITypeBinding[] iTypeBindingArray = iMethodBindingArray[n].getParameterTypes();
                boolean bl2 = false;
                int n3 = 0;
                while (n3 < iTypeBindingArray.length) {
                    if (iTypeBindingArray[n3].isWildcardType() && iTypeBindingArray[n3].isUpperbound()) {
                        bl2 = true;
                    }
                    ++n3;
                }
                if (!bl2) {
                    arrayList.add(iMethodBindingArray[n]);
                }
            }
            ++n;
        }
        return arrayList.toArray(new IMethodBinding[arrayList.size()]);
    }

    private static List getImplementationModifiers(AST aST, IMethodBinding iMethodBinding, boolean bl) {
        int n = iMethodBinding.getModifiers() & 0xFFFFFBFF & 0xFFFFFEFF & 0xFFFFFFFD;
        if (bl) {
            n &= 0xFFFFFFFB;
            n |= 1;
        }
        return ASTNodeFactory.newModifiers(aST, n);
    }

    public static IMethodBinding[] getOverridableMethods(AST aST, ITypeBinding iTypeBinding, boolean bl) {
        int n;
        int n2;
        ArrayList<IMethodBinding> arrayList = new ArrayList<IMethodBinding>();
        IMethodBinding[] iMethodBindingArray = iTypeBinding.getDeclaredMethods();
        int n3 = 0;
        while (n3 < iMethodBindingArray.length) {
            n2 = iMethodBindingArray[n3].getModifiers();
            if (!(iMethodBindingArray[n3].isConstructor() || Modifier.isStatic((int)n2) || Modifier.isPrivate((int)n2))) {
                arrayList.add(iMethodBindingArray[n3]);
            }
            ++n3;
        }
        ITypeBinding iTypeBinding2 = iTypeBinding.getSuperclass();
        while (iTypeBinding2 != null) {
            IMethodBinding[] iMethodBindingArray2 = iTypeBinding2.getDeclaredMethods();
            n = 0;
            while (n < iMethodBindingArray2.length) {
                int n4 = iMethodBindingArray2[n].getModifiers();
                if (!(iMethodBindingArray2[n].isConstructor() || Modifier.isStatic((int)n4) || Modifier.isPrivate((int)n4) || StubUtility2.findOverridingMethod(iMethodBindingArray2[n], arrayList) != null)) {
                    arrayList.add(iMethodBindingArray2[n]);
                }
                ++n;
            }
            iTypeBinding2 = iTypeBinding2.getSuperclass();
        }
        iTypeBinding2 = iTypeBinding;
        while (iTypeBinding2 != null) {
            ITypeBinding[] iTypeBindingArray = iTypeBinding2.getInterfaces();
            n = 0;
            while (n < iTypeBindingArray.length) {
                StubUtility2.getOverridableMethods(aST, iTypeBindingArray[n], arrayList);
                ++n;
            }
            iTypeBinding2 = iTypeBinding2.getSuperclass();
        }
        if (iTypeBinding.isInterface()) {
            StubUtility2.getOverridableMethods(aST, aST.resolveWellKnownType("java.lang.Object"), arrayList);
        }
        if (!bl) {
            arrayList.removeAll(Arrays.asList(iMethodBindingArray));
        }
        n2 = 0;
        if (!iTypeBinding.isInterface()) {
            n = arrayList.size() - 1;
            while (n >= 0) {
                IMethodBinding iMethodBinding = (IMethodBinding)arrayList.get(n);
                n2 = iMethodBinding.getModifiers();
                if (Modifier.isFinal((int)n2)) {
                    arrayList.remove(n);
                }
                --n;
            }
        }
        return arrayList.toArray(new IMethodBinding[arrayList.size()]);
    }

    private static void getOverridableMethods(AST aST, ITypeBinding iTypeBinding, List list) {
        int n;
        IMethodBinding[] iMethodBindingArray = iTypeBinding.getDeclaredMethods();
        int n2 = 0;
        while (n2 < iMethodBindingArray.length) {
            n = iMethodBindingArray[n2].getModifiers();
            if (!(iMethodBindingArray[n2].isConstructor() || Modifier.isStatic((int)n) || Modifier.isPrivate((int)n) || StubUtility2.findOverridingMethod(iMethodBindingArray[n2], list) != null || Modifier.isStatic((int)n))) {
                list.add(iMethodBindingArray[n2]);
            }
            ++n2;
        }
        ITypeBinding[] iTypeBindingArray = iTypeBinding.getInterfaces();
        n = 0;
        while (n < iTypeBindingArray.length) {
            StubUtility2.getOverridableMethods(aST, iTypeBindingArray[n], list);
            ++n;
        }
    }

    private static String getParameterName(ICompilationUnit iCompilationUnit, IVariableBinding iVariableBinding, String[] stringArray) {
        String string = NamingConventions.removePrefixAndSuffixForFieldName((IJavaProject)iCompilationUnit.getJavaProject(), (String)iVariableBinding.getName(), (int)iVariableBinding.getModifiers());
        return StubUtility.suggestArgumentName(iCompilationUnit.getJavaProject(), string, stringArray);
    }

    public static IMethodBinding[] getUnimplementedMethods(ITypeBinding iTypeBinding) {
        int n;
        ArrayList<IMethodBinding> arrayList = new ArrayList<IMethodBinding>();
        ArrayList<IMethodBinding> arrayList2 = new ArrayList<IMethodBinding>();
        IMethodBinding[] iMethodBindingArray = iTypeBinding.getDeclaredMethods();
        int n2 = 0;
        while (n2 < iMethodBindingArray.length) {
            IMethodBinding iMethodBinding = iMethodBindingArray[n2];
            int n3 = iMethodBinding.getModifiers();
            if (!(iMethodBinding.isConstructor() || Modifier.isStatic((int)n3) || Modifier.isPrivate((int)n3))) {
                arrayList.add(iMethodBinding);
            }
            ++n2;
        }
        ITypeBinding iTypeBinding2 = iTypeBinding.getSuperclass();
        while (iTypeBinding2 != null) {
            iMethodBindingArray = iTypeBinding2.getDeclaredMethods();
            int n4 = 0;
            while (n4 < iMethodBindingArray.length) {
                IMethodBinding iMethodBinding = iMethodBindingArray[n4];
                n = iMethodBinding.getModifiers();
                if (!(iMethodBinding.isConstructor() || Modifier.isStatic((int)n) || Modifier.isPrivate((int)n) || StubUtility2.findMethodBinding(iMethodBinding, arrayList) != null)) {
                    arrayList.add(iMethodBinding);
                }
                ++n4;
            }
            iTypeBinding2 = iTypeBinding2.getSuperclass();
        }
        int n5 = 0;
        while (n5 < arrayList.size()) {
            IMethodBinding iMethodBinding = (IMethodBinding)arrayList.get(n5);
            n = iMethodBinding.getModifiers();
            if ((Modifier.isAbstract((int)n) || iMethodBinding.getDeclaringClass().isInterface()) && iTypeBinding != iMethodBinding.getDeclaringClass()) {
                arrayList2.add(iMethodBinding);
            }
            ++n5;
        }
        HashSet hashSet = new HashSet();
        ITypeBinding iTypeBinding3 = iTypeBinding;
        while (iTypeBinding3 != null) {
            ITypeBinding[] iTypeBindingArray = iTypeBinding3.getInterfaces();
            int n6 = 0;
            while (n6 < iTypeBindingArray.length) {
                StubUtility2.findUnimplementedInterfaceMethods(iTypeBindingArray[n6], hashSet, arrayList, iTypeBinding.getPackage(), arrayList2);
                ++n6;
            }
            iTypeBinding3 = iTypeBinding3.getSuperclass();
        }
        return arrayList2.toArray(new IMethodBinding[arrayList2.size()]);
    }

    public static IMethodBinding[] getVisibleConstructors(ITypeBinding iTypeBinding, boolean bl, boolean bl2) {
        IMethodBinding[] iMethodBindingArray;
        ArrayList arrayList = new ArrayList();
        ArrayList<IMethodBinding> arrayList2 = null;
        ITypeBinding iTypeBinding2 = iTypeBinding.getSuperclass();
        if (iTypeBinding2 == null) {
            return new IMethodBinding[0];
        }
        if (bl) {
            iMethodBindingArray = iTypeBinding.getDeclaredMethods();
            arrayList2 = new ArrayList<IMethodBinding>(iMethodBindingArray.length);
            int n = 0;
            while (n < iMethodBindingArray.length) {
                IMethodBinding iMethodBinding = iMethodBindingArray[n];
                if (iMethodBinding.isConstructor() && !iMethodBinding.isDefaultConstructor()) {
                    arrayList2.add(iMethodBinding);
                }
                ++n;
            }
        }
        if (arrayList2 != null) {
            arrayList.addAll(arrayList2);
        }
        iMethodBindingArray = iTypeBinding.getDeclaredMethods();
        IMethodBinding[] iMethodBindingArray2 = iTypeBinding2.getDeclaredMethods();
        int n = 0;
        while (n < iMethodBindingArray2.length) {
            IMethodBinding iMethodBinding = iMethodBindingArray2[n];
            if (iMethodBinding.isConstructor() && Bindings.isVisibleInHierarchy(iMethodBinding, iTypeBinding.getPackage()) && (!bl || !Bindings.containsSignatureEquivalentConstructor(iMethodBindingArray, iMethodBinding))) {
                arrayList.add(iMethodBinding);
            }
            ++n;
        }
        if (arrayList2 != null) {
            arrayList.removeAll(arrayList2);
        }
        if (arrayList.isEmpty()) {
            iTypeBinding2 = iTypeBinding;
            while (iTypeBinding2.getSuperclass() != null) {
                iTypeBinding2 = iTypeBinding2.getSuperclass();
            }
            IMethodBinding iMethodBinding = Bindings.findMethodInType(iTypeBinding2, "Object", new ITypeBinding[0]);
            if (!(iMethodBinding == null || !bl2 && bl && arrayList2 != null && !arrayList2.isEmpty() || bl && Bindings.containsSignatureEquivalentConstructor(iMethodBindingArray, iMethodBinding))) {
                arrayList.add(iMethodBinding);
            }
        }
        return arrayList.toArray(new IMethodBinding[arrayList.size()]);
    }

    private StubUtility2() {
    }
}

