/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.dom;

import java.util.ArrayList;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.BreakStatement;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.ContinueStatement;
import org.eclipse.wst.jsdt.core.dom.EnumDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.LabeledStatement;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;

public class LinkedNodeFinder {
    private static final int FIELD = 1;
    private static final int METHOD = 2;
    private static final int TYPE = 4;
    private static final int LABEL = 8;
    private static final int NAME = 5;

    private LinkedNodeFinder() {
    }

    public static SimpleName[] findByBinding(ASTNode aSTNode, IBinding iBinding) {
        ArrayList arrayList = new ArrayList();
        BindingFinder bindingFinder = new BindingFinder(iBinding, arrayList);
        aSTNode.accept((ASTVisitor)bindingFinder);
        return arrayList.toArray(new SimpleName[arrayList.size()]);
    }

    public static SimpleName[] findByNode(ASTNode aSTNode, SimpleName simpleName) {
        IBinding iBinding = simpleName.resolveBinding();
        if (iBinding != null) {
            return LinkedNodeFinder.findByBinding(aSTNode, iBinding);
        }
        SimpleName[] simpleNameArray = LinkedNodeFinder.findByProblems(aSTNode, simpleName);
        if (simpleNameArray != null) {
            return simpleNameArray;
        }
        int n = simpleName.getParent().getNodeType();
        if (n == 30 || n == 10 || n == 18) {
            ArrayList arrayList = new ArrayList();
            LabelFinder labelFinder = new LabelFinder(simpleName, arrayList);
            aSTNode.accept((ASTVisitor)labelFinder);
            return arrayList.toArray(new SimpleName[arrayList.size()]);
        }
        return new SimpleName[]{simpleName};
    }

    private static int getProblemKind(IProblem iProblem) {
        switch (iProblem.getID()) {
            case 33554502: {
                return 1;
            }
            case 0x4000064: 
            case 67108973: {
                return 2;
            }
            case 536871086: {
                return 8;
            }
            case 0x22000032: {
                return 5;
            }
            case 0x1000002: {
                return 4;
            }
        }
        return 0;
    }

    private static int getNameNodeProblemKind(IProblem[] iProblemArray, SimpleName simpleName) {
        int n = simpleName.getStartPosition();
        int n2 = n + simpleName.getLength() - 1;
        int n3 = 0;
        while (n3 < iProblemArray.length) {
            int n4;
            IProblem iProblem = iProblemArray[n3];
            if (iProblem.getSourceStart() == n && iProblem.getSourceEnd() == n2 && (n4 = LinkedNodeFinder.getProblemKind(iProblem)) != 0) {
                return n4;
            }
            ++n3;
        }
        return 0;
    }

    public static SimpleName[] findByProblems(ASTNode aSTNode, SimpleName simpleName) {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        ASTNode aSTNode2 = aSTNode.getRoot();
        if (!(aSTNode2 instanceof CompilationUnit)) {
            return null;
        }
        IProblem[] iProblemArray = ((CompilationUnit)aSTNode2).getProblems();
        int n = LinkedNodeFinder.getNameNodeProblemKind(iProblemArray, simpleName);
        if (n == 0) {
            return null;
        }
        int n2 = aSTNode.getStartPosition();
        int n3 = n2 + aSTNode.getLength();
        String string = simpleName.getIdentifier();
        int n4 = 0;
        while (n4 < iProblemArray.length) {
            ASTNode aSTNode3;
            int n5;
            IProblem iProblem = iProblemArray[n4];
            int n6 = iProblem.getSourceStart();
            int n7 = iProblem.getSourceEnd() + 1;
            if (n6 > n2 && n7 < n3 && (n & (n5 = LinkedNodeFinder.getProblemKind(iProblem))) != 0 && (aSTNode3 = NodeFinder.perform(aSTNode, n6, n7 - n6)) instanceof SimpleName && string.equals(((SimpleName)aSTNode3).getIdentifier())) {
                arrayList.add(aSTNode3);
            }
            ++n4;
        }
        return arrayList.toArray(new SimpleName[arrayList.size()]);
    }

    private static class BindingFinder
    extends ASTVisitor {
        private IBinding fBinding;
        private ArrayList fResult;

        public BindingFinder(IBinding iBinding, ArrayList arrayList) {
            super(true);
            this.fBinding = BindingFinder.getDeclaration(iBinding);
            this.fResult = arrayList;
        }

        public boolean visit(MethodDeclaration methodDeclaration) {
            ASTNode aSTNode;
            if (methodDeclaration.isConstructor() && this.fBinding.getKind() == 2 && (aSTNode = methodDeclaration.getParent()) instanceof AbstractTypeDeclaration && this.fBinding == ((AbstractTypeDeclaration)aSTNode).resolveBinding()) {
                this.fResult.add(methodDeclaration.getName());
            }
            return true;
        }

        public boolean visit(TypeDeclaration typeDeclaration) {
            IMethodBinding iMethodBinding;
            if (this.fBinding.getKind() == 4 && (iMethodBinding = (IMethodBinding)this.fBinding).isConstructor() && iMethodBinding.getDeclaringClass() == typeDeclaration.resolveBinding()) {
                this.fResult.add(typeDeclaration.getName());
            }
            return true;
        }

        public boolean visit(EnumDeclaration enumDeclaration) {
            IMethodBinding iMethodBinding;
            if (this.fBinding.getKind() == 4 && (iMethodBinding = (IMethodBinding)this.fBinding).isConstructor() && iMethodBinding.getDeclaringClass() == enumDeclaration.resolveBinding()) {
                this.fResult.add(enumDeclaration.getName());
            }
            return true;
        }

        public boolean visit(AnnotationTypeDeclaration annotationTypeDeclaration) {
            return true;
        }

        public boolean visit(SimpleName simpleName) {
            IMethodBinding iMethodBinding;
            IMethodBinding iMethodBinding2;
            IBinding iBinding = simpleName.resolveBinding();
            if (iBinding == null || iBinding.getKind() != this.fBinding.getKind()) {
                return false;
            }
            if (this.fBinding == (iBinding = BindingFinder.getDeclaration(iBinding))) {
                this.fResult.add(simpleName);
            } else if (iBinding.getKind() == 4 && ((iMethodBinding2 = (IMethodBinding)this.fBinding).overrides(iMethodBinding = (IMethodBinding)iBinding) || iMethodBinding.overrides(iMethodBinding2))) {
                this.fResult.add(simpleName);
            }
            return false;
        }

        private static IBinding getDeclaration(IBinding iBinding) {
            if (iBinding instanceof ITypeBinding) {
                return ((ITypeBinding)iBinding).getTypeDeclaration();
            }
            if (iBinding instanceof IMethodBinding) {
                return ((IMethodBinding)iBinding).getMethodDeclaration();
            }
            if (iBinding instanceof IVariableBinding) {
                return ((IVariableBinding)iBinding).getVariableDeclaration();
            }
            return iBinding;
        }
    }

    private static class LabelFinder
    extends ASTVisitor {
        private SimpleName fLabel;
        private ASTNode fDefiningLabel;
        private ArrayList fResult;

        public LabelFinder(SimpleName simpleName, ArrayList arrayList) {
            super(true);
            this.fLabel = simpleName;
            this.fResult = arrayList;
            this.fDefiningLabel = null;
        }

        private boolean isSameLabel(SimpleName simpleName) {
            return simpleName != null && this.fLabel.getIdentifier().equals(simpleName.getIdentifier());
        }

        public boolean visit(BreakStatement breakStatement) {
            SimpleName simpleName = breakStatement.getLabel();
            if (this.fDefiningLabel != null && this.isSameLabel(simpleName) && ASTNodes.isParent((ASTNode)simpleName, this.fDefiningLabel)) {
                this.fResult.add(simpleName);
            }
            return false;
        }

        public boolean visit(ContinueStatement continueStatement) {
            SimpleName simpleName = continueStatement.getLabel();
            if (this.fDefiningLabel != null && this.isSameLabel(simpleName) && ASTNodes.isParent((ASTNode)simpleName, this.fDefiningLabel)) {
                this.fResult.add(simpleName);
            }
            return false;
        }

        public boolean visit(LabeledStatement labeledStatement) {
            SimpleName simpleName;
            if (this.fDefiningLabel == null && (this.fLabel == (simpleName = labeledStatement.getLabel()) || this.isSameLabel(simpleName) && ASTNodes.isParent((ASTNode)this.fLabel, (ASTNode)labeledStatement))) {
                this.fDefiningLabel = labeledStatement;
                this.fResult.add(simpleName);
            }
            labeledStatement.getBody().accept((ASTVisitor)this);
            return false;
        }
    }
}

