/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.dom.fragments;

import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.InfixExpression;
import org.eclipse.wst.jsdt.internal.corext.SourceRange;
import org.eclipse.wst.jsdt.internal.corext.dom.HierarchicalASTVisitor;
import org.eclipse.wst.jsdt.internal.corext.dom.Selection;
import org.eclipse.wst.jsdt.internal.corext.dom.SelectionAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.dom.fragments.AssociativeInfixExpressionFragment;
import org.eclipse.wst.jsdt.internal.corext.dom.fragments.IASTFragment;
import org.eclipse.wst.jsdt.internal.corext.dom.fragments.IExpressionFragment;
import org.eclipse.wst.jsdt.internal.corext.dom.fragments.SimpleExpressionFragment;
import org.eclipse.wst.jsdt.internal.corext.dom.fragments.SimpleFragment;
import org.eclipse.wst.jsdt.internal.corext.dom.fragments.Util;

public class ASTFragmentFactory {
    public static IASTFragment createFragmentForFullSubtree(ASTNode aSTNode) {
        IASTFragment iASTFragment = FragmentForFullSubtreeFactory.createFragmentFor(aSTNode);
        Assert.isNotNull((Object)iASTFragment);
        return iASTFragment;
    }

    public static IASTFragment createFragmentForSourceRange(SourceRange sourceRange, ASTNode aSTNode, ICompilationUnit iCompilationUnit) throws JavaModelException {
        SelectionAnalyzer selectionAnalyzer = new SelectionAnalyzer(Selection.createFromStartLength(sourceRange.getOffset(), sourceRange.getLength()), false);
        aSTNode.accept((ASTVisitor)selectionAnalyzer);
        if (ASTFragmentFactory.isSingleNodeSelected(selectionAnalyzer, sourceRange, iCompilationUnit)) {
            return ASTFragmentFactory.createFragmentForFullSubtree(selectionAnalyzer.getFirstSelectedNode());
        }
        if (ASTFragmentFactory.isEmptySelectionCoveredByANode(sourceRange, selectionAnalyzer)) {
            return ASTFragmentFactory.createFragmentForFullSubtree(selectionAnalyzer.getLastCoveringNode());
        }
        return ASTFragmentFactory.createFragmentForSubPartBySourceRange(selectionAnalyzer.getLastCoveringNode(), sourceRange, iCompilationUnit);
    }

    private static boolean isEmptySelectionCoveredByANode(SourceRange sourceRange, SelectionAnalyzer selectionAnalyzer) {
        return sourceRange.getLength() == 0 && selectionAnalyzer.getFirstSelectedNode() == null && selectionAnalyzer.getLastCoveringNode() != null;
    }

    private static boolean isSingleNodeSelected(SelectionAnalyzer selectionAnalyzer, SourceRange sourceRange, ICompilationUnit iCompilationUnit) throws JavaModelException {
        return selectionAnalyzer.getSelectedNodes().length == 1 && !ASTFragmentFactory.rangeIncludesNonWhitespaceOutsideNode(sourceRange, selectionAnalyzer.getFirstSelectedNode(), iCompilationUnit);
    }

    private static boolean rangeIncludesNonWhitespaceOutsideNode(SourceRange sourceRange, ASTNode aSTNode, ICompilationUnit iCompilationUnit) throws JavaModelException {
        return Util.rangeIncludesNonWhitespaceOutsideRange(sourceRange, new SourceRange(aSTNode), iCompilationUnit.getBuffer());
    }

    private static IASTFragment createFragmentForSubPartBySourceRange(ASTNode aSTNode, SourceRange sourceRange, ICompilationUnit iCompilationUnit) throws JavaModelException {
        return FragmentForSubPartBySourceRangeFactory.createFragmentFor(aSTNode, sourceRange, iCompilationUnit);
    }

    private static abstract class FragmentFactory
    extends HierarchicalASTVisitor {
        private IASTFragment fFragment;

        private FragmentFactory() {
        }

        protected IASTFragment createFragment(ASTNode aSTNode) {
            this.fFragment = null;
            aSTNode.accept((ASTVisitor)this);
            return this.fFragment;
        }

        protected final IASTFragment getFragment() {
            return this.fFragment;
        }

        protected final void setFragment(IASTFragment iASTFragment) {
            Assert.isTrue((!this.isFragmentSet() ? 1 : 0) != 0);
            this.fFragment = iASTFragment;
        }

        protected final void clearFragment() {
            this.fFragment = null;
        }

        protected final boolean isFragmentSet() {
            return this.getFragment() != null;
        }
    }

    private static class FragmentForFullSubtreeFactory
    extends FragmentFactory {
        private FragmentForFullSubtreeFactory() {
        }

        public static IASTFragment createFragmentFor(ASTNode aSTNode) {
            return new FragmentForFullSubtreeFactory().createFragment(aSTNode);
        }

        public boolean visit(InfixExpression infixExpression) {
            IExpressionFragment iExpressionFragment = AssociativeInfixExpressionFragment.createFragmentForFullSubtree(infixExpression);
            if (iExpressionFragment == null) {
                return this.visit((Expression)infixExpression);
            }
            this.setFragment(iExpressionFragment);
            return false;
        }

        public boolean visit(Expression expression) {
            this.setFragment(new SimpleExpressionFragment(expression));
            return false;
        }

        public boolean visit(ASTNode aSTNode) {
            this.setFragment(new SimpleFragment(aSTNode));
            return false;
        }
    }

    private static class FragmentForSubPartBySourceRangeFactory
    extends FragmentFactory {
        private SourceRange fRange;
        private ICompilationUnit fCu;
        private JavaModelException javaModelException = null;

        private FragmentForSubPartBySourceRangeFactory() {
        }

        public static IASTFragment createFragmentFor(ASTNode aSTNode, SourceRange sourceRange, ICompilationUnit iCompilationUnit) throws JavaModelException {
            return new FragmentForSubPartBySourceRangeFactory().createFragment(aSTNode, sourceRange, iCompilationUnit);
        }

        public boolean visit(InfixExpression infixExpression) {
            try {
                this.setFragment(FragmentForSubPartBySourceRangeFactory.createInfixExpressionSubPartFragmentBySourceRange(infixExpression, this.fRange, this.fCu));
            }
            catch (JavaModelException javaModelException) {
                this.javaModelException = javaModelException;
            }
            return false;
        }

        public boolean visit(ASTNode aSTNode) {
            return false;
        }

        protected IASTFragment createFragment(ASTNode aSTNode, SourceRange sourceRange, ICompilationUnit iCompilationUnit) throws JavaModelException {
            this.fRange = sourceRange;
            this.fCu = iCompilationUnit;
            IASTFragment iASTFragment = this.createFragment(aSTNode);
            if (this.javaModelException != null) {
                throw this.javaModelException;
            }
            return iASTFragment;
        }

        private static IExpressionFragment createInfixExpressionSubPartFragmentBySourceRange(InfixExpression infixExpression, SourceRange sourceRange, ICompilationUnit iCompilationUnit) throws JavaModelException {
            return AssociativeInfixExpressionFragment.createSubPartFragmentBySourceRange(infixExpression, sourceRange, iCompilationUnit);
        }
    }
}

