/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.SuperFieldAccess;
import org.eclipse.wst.jsdt.core.dom.SwitchCase;
import org.eclipse.wst.jsdt.core.dom.ThisExpression;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.GenericVisitor;
import org.eclipse.wst.jsdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.fix.AbstractFix;
import org.eclipse.wst.jsdt.internal.corext.fix.FixMessages;
import org.eclipse.wst.jsdt.internal.corext.fix.IFixRewriteOperation;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ProblemLocation;
import org.eclipse.wst.jsdt.ui.text.java.IProblemLocation;

public class CodeStyleFix
extends AbstractFix {
    static /* synthetic */ Class class$0;

    public static CodeStyleFix[] createNonStaticAccessFixes(CompilationUnit compilationUnit, IProblemLocation iProblemLocation) throws CoreException {
        if (!CodeStyleFix.isNonStaticAccess(iProblemLocation)) {
            return null;
        }
        ToStaticAccessOperation[] toStaticAccessOperationArray = CodeStyleFix.createToStaticAccessOperations(compilationUnit, iProblemLocation);
        if (toStaticAccessOperationArray == null) {
            return null;
        }
        String string = Messages.format(FixMessages.CodeStyleFix_ChangeAccessToStatic_description, toStaticAccessOperationArray[0].getAccessorName());
        CodeStyleFix codeStyleFix = new CodeStyleFix(string, compilationUnit, new IFixRewriteOperation[]{toStaticAccessOperationArray[0]});
        if (toStaticAccessOperationArray.length > 1) {
            String string2 = Messages.format(FixMessages.CodeStyleFix_ChangeAccessToStaticUsingInstanceType_description, toStaticAccessOperationArray[1].getAccessorName());
            CodeStyleFix codeStyleFix2 = new CodeStyleFix(string2, compilationUnit, new IFixRewriteOperation[]{toStaticAccessOperationArray[1]});
            return new CodeStyleFix[]{codeStyleFix, codeStyleFix2};
        }
        return new CodeStyleFix[]{codeStyleFix};
    }

    public static CodeStyleFix createAddFieldQualifierFix(CompilationUnit compilationUnit, IProblemLocation iProblemLocation) throws CoreException {
        if (570425423 != iProblemLocation.getProblemId()) {
            return null;
        }
        AddThisQualifierOperation addThisQualifierOperation = CodeStyleFix.getUnqualifiedFieldAccessResolveOperation(compilationUnit, iProblemLocation);
        if (addThisQualifierOperation == null) {
            return null;
        }
        String string = addThisQualifierOperation.getDescription();
        return new CodeStyleFix(string, compilationUnit, new IFixRewriteOperation[]{addThisQualifierOperation});
    }

    public static CodeStyleFix createIndirectAccessToStaticFix(CompilationUnit compilationUnit, IProblemLocation iProblemLocation) throws CoreException {
        if (!CodeStyleFix.isIndirectStaticAccess(iProblemLocation)) {
            return null;
        }
        ToStaticAccessOperation[] toStaticAccessOperationArray = CodeStyleFix.createToStaticAccessOperations(compilationUnit, iProblemLocation);
        if (toStaticAccessOperationArray == null) {
            return null;
        }
        String string = Messages.format(FixMessages.CodeStyleFix_ChangeStaticAccess_description, toStaticAccessOperationArray[0].getAccessorName());
        return new CodeStyleFix(string, compilationUnit, new IFixRewriteOperation[]{toStaticAccessOperationArray[0]});
    }

    public static CodeStyleFix createCleanUp(CompilationUnit compilationUnit, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8) throws CoreException {
        Object object;
        if (!(bl || bl2 || bl3 || bl4 || bl5 || bl6 || bl7 || bl8)) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        if (bl || bl3 || bl5 || bl6) {
            object = new CodeStyleVisitor(compilationUnit, bl, bl3, bl5, bl6, arrayList);
            compilationUnit.accept((ASTVisitor)object);
        }
        object = compilationUnit.getProblems();
        IProblemLocation[] iProblemLocationArray = new IProblemLocation[((IProblem[])object).length];
        int n = 0;
        while (n < ((IProblem[])object).length) {
            iProblemLocationArray[n] = new ProblemLocation(object[n]);
            ++n;
        }
        CodeStyleFix.addToStaticAccessOperations(compilationUnit, iProblemLocationArray, bl2, bl4, arrayList);
        if (bl7 || bl8) {
            ThisQualifierVisitor thisQualifierVisitor = new ThisQualifierVisitor(bl7, bl8, compilationUnit, arrayList);
            compilationUnit.accept((ASTVisitor)thisQualifierVisitor);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        IFixRewriteOperation[] iFixRewriteOperationArray = arrayList.toArray(new IFixRewriteOperation[arrayList.size()]);
        return new CodeStyleFix(FixMessages.CodeStyleFix_change_name, compilationUnit, iFixRewriteOperationArray);
    }

    public static CodeStyleFix createCleanUp(CompilationUnit compilationUnit, IProblemLocation[] iProblemLocationArray, boolean bl, boolean bl2, boolean bl3) throws CoreException {
        if (!(bl || bl2 || bl3)) {
            return null;
        }
        ArrayList<AddThisQualifierOperation> arrayList = new ArrayList<AddThisQualifierOperation>();
        if (bl) {
            int n = 0;
            while (n < iProblemLocationArray.length) {
                AddThisQualifierOperation addThisQualifierOperation;
                IProblemLocation iProblemLocation = iProblemLocationArray[n];
                if (iProblemLocation.getProblemId() == 570425423 && (addThisQualifierOperation = CodeStyleFix.getUnqualifiedFieldAccessResolveOperation(compilationUnit, iProblemLocation)) != null) {
                    arrayList.add(addThisQualifierOperation);
                }
                ++n;
            }
        }
        CodeStyleFix.addToStaticAccessOperations(compilationUnit, iProblemLocationArray, bl2, bl3, arrayList);
        if (arrayList.isEmpty()) {
            return null;
        }
        IFixRewriteOperation[] iFixRewriteOperationArray = arrayList.toArray(new IFixRewriteOperation[arrayList.size()]);
        return new CodeStyleFix(FixMessages.CodeStyleFix_change_name, compilationUnit, iFixRewriteOperationArray);
    }

    private static void addToStaticAccessOperations(CompilationUnit compilationUnit, IProblemLocation[] iProblemLocationArray, boolean bl, boolean bl2, List list) {
        Object object;
        Hashtable<Expression, ToStaticAccessOperation> hashtable = new Hashtable<Expression, ToStaticAccessOperation>();
        if (bl || bl2) {
            int n = 0;
            while (n < iProblemLocationArray.length) {
                ToStaticAccessOperation[] toStaticAccessOperationArray;
                boolean bl3;
                object = iProblemLocationArray[n];
                boolean bl4 = bl && CodeStyleFix.isNonStaticAccess((IProblemLocation)object);
                boolean bl5 = bl3 = bl2 && CodeStyleFix.isIndirectStaticAccess((IProblemLocation)object);
                if ((bl4 || bl3) && (toStaticAccessOperationArray = CodeStyleFix.createToStaticAccessOperations(compilationUnit, (IProblemLocation)object)) != null) {
                    ToStaticAccessOperation toStaticAccessOperation = toStaticAccessOperationArray[0];
                    hashtable.put(toStaticAccessOperation.fQualifier, toStaticAccessOperation);
                }
                ++n;
            }
        }
        Iterator iterator = hashtable.values().iterator();
        while (iterator.hasNext()) {
            object = (ToStaticAccessOperation)iterator.next();
            if (hashtable.containsKey(((ToStaticAccessOperation)object).fQualifier.getParent())) continue;
            list.add(object);
        }
    }

    private static boolean isIndirectStaticAccess(IProblemLocation iProblemLocation) {
        return iProblemLocation.getProblemId() == 570425422 || iProblemLocation.getProblemId() == 603979895;
    }

    private static boolean isNonStaticAccess(IProblemLocation iProblemLocation) {
        return iProblemLocation.getProblemId() == 570425420 || iProblemLocation.getProblemId() == 603979893;
    }

    private static ToStaticAccessOperation[] createToStaticAccessOperations(CompilationUnit compilationUnit, IProblemLocation iProblemLocation) {
        FieldAccess fieldAccess;
        Object object;
        ASTNode aSTNode = iProblemLocation.getCoveringNode(compilationUnit);
        if (aSTNode == null) {
            return null;
        }
        Name name = null;
        IBinding iBinding = null;
        if (aSTNode instanceof QualifiedName) {
            object = (QualifiedName)aSTNode;
            name = object.getQualifier();
            iBinding = object.resolveBinding();
        } else if (aSTNode instanceof SimpleName) {
            object = aSTNode.getParent();
            if (object instanceof FieldAccess) {
                fieldAccess = (FieldAccess)object;
                name = fieldAccess.getExpression();
                iBinding = fieldAccess.getName().resolveBinding();
            } else if (object instanceof QualifiedName) {
                fieldAccess = object;
                name = fieldAccess.getQualifier();
                iBinding = fieldAccess.getName().resolveBinding();
            }
        } else if (aSTNode instanceof MethodInvocation) {
            object = (MethodInvocation)aSTNode;
            name = object.getExpression();
            fieldAccess = object.getName();
            if (fieldAccess != null) {
                iBinding = fieldAccess.resolveBinding();
            }
        } else if (aSTNode instanceof FieldAccess) {
            object = (FieldAccess)aSTNode;
            name = object.getExpression();
            iBinding = object.getName().resolveBinding();
        }
        if (iBinding != null && name != null) {
            object = null;
            fieldAccess = CodeStyleFix.getDeclaringTypeBinding(iBinding);
            if (fieldAccess != null) {
                fieldAccess = fieldAccess.getTypeDeclaration();
                object = new ToStaticAccessOperation((ITypeBinding)fieldAccess, (Expression)name);
            }
            ToStaticAccessOperation toStaticAccessOperation = null;
            ITypeBinding iTypeBinding = Bindings.normalizeTypeBinding(name.resolveTypeBinding());
            if (iTypeBinding != null && (iTypeBinding = iTypeBinding.getTypeDeclaration()).getTypeDeclaration() != fieldAccess) {
                toStaticAccessOperation = new ToStaticAccessOperation(iTypeBinding, (Expression)name);
            }
            if (object != null && toStaticAccessOperation != null) {
                return new ToStaticAccessOperation[]{object, toStaticAccessOperation};
            }
            return new ToStaticAccessOperation[]{object};
        }
        return null;
    }

    private static ITypeBinding getDeclaringTypeBinding(IBinding iBinding) {
        if (iBinding instanceof IMethodBinding) {
            return ((IMethodBinding)iBinding).getDeclaringClass();
        }
        if (iBinding instanceof IVariableBinding) {
            return ((IVariableBinding)iBinding).getDeclaringClass();
        }
        return null;
    }

    private static AddThisQualifierOperation getUnqualifiedFieldAccessResolveOperation(CompilationUnit compilationUnit, IProblemLocation iProblemLocation) throws CoreException {
        SimpleName simpleName = CodeStyleFix.getName(compilationUnit, iProblemLocation);
        if (simpleName == null) {
            return null;
        }
        IBinding iBinding = simpleName.resolveBinding();
        if (iBinding == null || iBinding.getKind() != 3) {
            return null;
        }
        ImportRewrite importRewrite = StubUtility.createImportRewrite(compilationUnit, true);
        String string = CodeStyleFix.getQualifier((IVariableBinding)iBinding, importRewrite, simpleName);
        if (string == null) {
            return null;
        }
        return new AddThisQualifierOperation(string, simpleName);
    }

    private static String getQualifier(IVariableBinding iVariableBinding, ImportRewrite importRewrite, SimpleName simpleName) {
        ITypeBinding iTypeBinding = iVariableBinding.getDeclaringClass();
        if (Modifier.isStatic((int)iVariableBinding.getModifiers())) {
            IJavaElement iJavaElement = iTypeBinding.getJavaElement();
            if (iJavaElement instanceof IType) {
                return ((IType)iJavaElement).getElementName();
            }
        } else {
            return CodeStyleFix.getNonStaticQualifier(iTypeBinding, importRewrite, simpleName);
        }
        return null;
    }

    private static String getNonStaticQualifier(ITypeBinding iTypeBinding, ImportRewrite importRewrite, SimpleName simpleName) {
        ITypeBinding iTypeBinding2;
        ITypeBinding iTypeBinding3 = iTypeBinding2 = Bindings.getBindingOfParentType((ASTNode)simpleName);
        while (iTypeBinding3 != null && !Bindings.isSuperType(iTypeBinding, iTypeBinding3)) {
            iTypeBinding3 = iTypeBinding3.getDeclaringClass();
        }
        if (iTypeBinding3 == null) {
            iTypeBinding = iTypeBinding.getTypeDeclaration();
            iTypeBinding3 = iTypeBinding2;
            while (iTypeBinding3 != null && !Bindings.isSuperType(iTypeBinding, iTypeBinding3)) {
                iTypeBinding3 = iTypeBinding3.getDeclaringClass();
            }
        }
        if (iTypeBinding3 != iTypeBinding2) {
            if (iTypeBinding3 == null) {
                return null;
            }
            if (iTypeBinding3.isAnonymous()) {
                return null;
            }
            String string = importRewrite.addImport(iTypeBinding3);
            return String.valueOf(string) + ".this";
        }
        return "this";
    }

    private static SimpleName getName(CompilationUnit compilationUnit, IProblemLocation iProblemLocation) {
        ASTNode aSTNode = iProblemLocation.getCoveringNode(compilationUnit);
        while (aSTNode instanceof QualifiedName) {
            aSTNode = ((QualifiedName)aSTNode).getQualifier();
        }
        if (!(aSTNode instanceof SimpleName)) {
            return null;
        }
        return (SimpleName)aSTNode;
    }

    private CodeStyleFix(String string, CompilationUnit compilationUnit, IFixRewriteOperation[] iFixRewriteOperationArray) {
        super(string, compilationUnit, iFixRewriteOperationArray);
    }

    private static final class AddStaticQualifierOperation
    extends AbstractFix.AbstractFixRewriteOperation {
        private final SimpleName fName;
        private final ITypeBinding fDeclaringClass;

        public AddStaticQualifierOperation(ITypeBinding iTypeBinding, SimpleName simpleName) {
            this.fDeclaringClass = iTypeBinding;
            this.fName = simpleName;
        }

        public void rewriteAST(CompilationUnitRewrite compilationUnitRewrite, List list) throws CoreException {
            ASTRewrite aSTRewrite = compilationUnitRewrite.getASTRewrite();
            CompilationUnit compilationUnit = compilationUnitRewrite.getRoot();
            this.importType(this.fDeclaringClass, (ASTNode)this.fName, compilationUnitRewrite.getImportRewrite(), compilationUnit);
            TextEditGroup textEditGroup = this.fName.resolveBinding() instanceof IMethodBinding ? this.createTextEditGroup(FixMessages.CodeStyleFix_QualifyMethodWithDeclClass_description) : this.createTextEditGroup(FixMessages.CodeStyleFix_QualifyFieldWithDeclClass_description);
            list.add(textEditGroup);
            IJavaElement iJavaElement = this.fDeclaringClass.getJavaElement();
            if (iJavaElement instanceof IType) {
                Name name = compilationUnit.getAST().newName(((IType)iJavaElement).getElementName());
                SimpleName simpleName = (SimpleName)aSTRewrite.createMoveTarget((ASTNode)this.fName);
                QualifiedName qualifiedName = compilationUnit.getAST().newQualifiedName(name, simpleName);
                aSTRewrite.replace((ASTNode)this.fName, (ASTNode)qualifiedName, textEditGroup);
            }
        }
    }

    private static final class AddThisQualifierOperation
    extends AbstractFix.AbstractFixRewriteOperation {
        private final String fQualifier;
        private final SimpleName fName;

        public AddThisQualifierOperation(String string, SimpleName simpleName) {
            this.fQualifier = string;
            this.fName = simpleName;
        }

        public String getDescription() {
            return Messages.format(FixMessages.CodeStyleFix_QualifyWithThis_description, new Object[]{this.fName.getIdentifier(), this.fQualifier});
        }

        public void rewriteAST(CompilationUnitRewrite compilationUnitRewrite, List list) throws CoreException {
            ASTRewrite aSTRewrite = compilationUnitRewrite.getASTRewrite();
            TextEditGroup textEditGroup = this.fName.resolveBinding() instanceof IMethodBinding ? this.createTextEditGroup(FixMessages.CodeStyleFix_QualifyMethodWithThis_description) : this.createTextEditGroup(FixMessages.CodeStyleFix_QualifyFieldWithThis_description);
            list.add(textEditGroup);
            aSTRewrite.replace((ASTNode)this.fName, aSTRewrite.createStringPlaceholder(String.valueOf(this.fQualifier) + '.' + this.fName.getIdentifier(), 42), textEditGroup);
        }
    }

    private static final class CodeStyleVisitor
    extends GenericVisitor {
        private final List fResult;
        private final ImportRewrite fImportRewrite;
        private final boolean fFindUnqualifiedAccesses;
        private final boolean fFindUnqualifiedStaticAccesses;
        private final boolean fFindUnqualifiedMethodAccesses;
        private final boolean fFindUnqualifiedStaticMethodAccesses;

        public CodeStyleVisitor(CompilationUnit compilationUnit, boolean bl, boolean bl2, boolean bl3, boolean bl4, List list) throws CoreException {
            this.fFindUnqualifiedAccesses = bl;
            this.fFindUnqualifiedStaticAccesses = bl2;
            this.fFindUnqualifiedMethodAccesses = bl3;
            this.fFindUnqualifiedStaticMethodAccesses = bl4;
            this.fImportRewrite = StubUtility.createImportRewrite(compilationUnit, true);
            this.fResult = list;
        }

        public boolean visit(TypeDeclaration typeDeclaration) {
            if (!this.fFindUnqualifiedStaticAccesses && !this.fFindUnqualifiedStaticMethodAccesses && typeDeclaration.isInterface()) {
                return false;
            }
            return super.visit(typeDeclaration);
        }

        public boolean visit(QualifiedName qualifiedName) {
            if (this.fFindUnqualifiedAccesses || this.fFindUnqualifiedStaticAccesses) {
                QualifiedName qualifiedName2 = qualifiedName;
                while (qualifiedName2 instanceof QualifiedName) {
                    qualifiedName2 = qualifiedName2.getQualifier();
                }
                if (qualifiedName2 instanceof SimpleName) {
                    this.handleSimpleName((SimpleName)qualifiedName2);
                }
            }
            return false;
        }

        public boolean visit(SimpleName simpleName) {
            if (this.fFindUnqualifiedAccesses || this.fFindUnqualifiedStaticAccesses) {
                this.handleSimpleName(simpleName);
            }
            return false;
        }

        public boolean visit(MethodInvocation methodInvocation) {
            if (!this.fFindUnqualifiedMethodAccesses && !this.fFindUnqualifiedStaticMethodAccesses) {
                return true;
            }
            if (methodInvocation.getExpression() != null) {
                return true;
            }
            SimpleName simpleName = methodInvocation.getName();
            if (simpleName != null) {
                IBinding iBinding = simpleName.resolveBinding();
                if (!(iBinding instanceof IMethodBinding)) {
                    return true;
                }
                this.handleMethod(simpleName, (IMethodBinding)iBinding);
            }
            return true;
        }

        private void handleSimpleName(SimpleName simpleName) {
            ASTNode aSTNode = simpleName.getParent();
            if (aSTNode instanceof FieldAccess) {
                while (aSTNode instanceof FieldAccess) {
                    aSTNode = ((FieldAccess)aSTNode).getExpression();
                }
                if (!(aSTNode instanceof SimpleName)) {
                    return;
                }
                simpleName = (SimpleName)aSTNode;
            } else if (aSTNode instanceof SuperFieldAccess) {
                return;
            }
            StructuralPropertyDescriptor structuralPropertyDescriptor = simpleName.getLocationInParent();
            if (structuralPropertyDescriptor == VariableDeclarationFragment.NAME_PROPERTY || structuralPropertyDescriptor == SwitchCase.EXPRESSION_PROPERTY) {
                return;
            }
            IBinding iBinding = simpleName.resolveBinding();
            if (!(iBinding instanceof IVariableBinding)) {
                return;
            }
            this.handleVariable(simpleName, (IVariableBinding)iBinding);
        }

        private void handleVariable(SimpleName simpleName, IVariableBinding iVariableBinding) {
            if (!iVariableBinding.isField()) {
                return;
            }
            if (iVariableBinding.isEnumConstant()) {
                return;
            }
            ITypeBinding iTypeBinding = iVariableBinding.getDeclaringClass();
            if (Modifier.isStatic((int)iVariableBinding.getModifiers())) {
                if (this.fFindUnqualifiedStaticAccesses) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.Initializer");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Initializer initializer = (Initializer)ASTNodes.getParent((ASTNode)simpleName, clazz);
                    StructuralPropertyDescriptor structuralPropertyDescriptor = simpleName.getLocationInParent();
                    if (initializer != null && Modifier.isStatic((int)initializer.getModifiers()) && Modifier.isFinal((int)iVariableBinding.getModifiers()) && structuralPropertyDescriptor == Assignment.LEFT_HAND_SIDE_PROPERTY) {
                        return;
                    }
                    if (iTypeBinding.isAnonymous()) {
                        return;
                    }
                    this.fResult.add(new AddStaticQualifierOperation(iTypeBinding, simpleName));
                }
            } else if (this.fFindUnqualifiedAccesses) {
                String string = CodeStyleFix.getNonStaticQualifier(iTypeBinding, this.fImportRewrite, simpleName);
                if (string == null) {
                    return;
                }
                this.fResult.add(new AddThisQualifierOperation(string, simpleName));
            }
        }

        private void handleMethod(SimpleName simpleName, IMethodBinding iMethodBinding) {
            ITypeBinding iTypeBinding = iMethodBinding.getDeclaringClass();
            if (Modifier.isStatic((int)iMethodBinding.getModifiers())) {
                if (this.fFindUnqualifiedStaticMethodAccesses) {
                    if (iTypeBinding.isAnonymous()) {
                        return;
                    }
                    this.fResult.add(new AddStaticQualifierOperation(iTypeBinding, simpleName));
                }
            } else if (this.fFindUnqualifiedMethodAccesses) {
                String string = CodeStyleFix.getNonStaticQualifier(iTypeBinding, this.fImportRewrite, simpleName);
                if (string == null) {
                    return;
                }
                this.fResult.add(new AddThisQualifierOperation(string, simpleName));
            }
        }
    }

    private static class ThisQualifierVisitor
    extends GenericVisitor {
        private final CompilationUnit fCompilationUnit;
        private final List fOperations;
        private final boolean fRemoveFieldQualifiers;
        private final boolean fRemoveMethodQualifiers;

        public ThisQualifierVisitor(boolean bl, boolean bl2, CompilationUnit compilationUnit, List list) {
            this.fRemoveFieldQualifiers = bl;
            this.fRemoveMethodQualifiers = bl2;
            this.fCompilationUnit = compilationUnit;
            this.fOperations = list;
        }

        public boolean visit(FieldAccess fieldAccess) {
            if (!this.fRemoveFieldQualifiers) {
                return true;
            }
            Expression expression = fieldAccess.getExpression();
            if (!(expression instanceof ThisExpression)) {
                return true;
            }
            SimpleName simpleName = fieldAccess.getName();
            if (this.hasConflict(expression.getStartPosition(), simpleName, 2)) {
                return true;
            }
            this.fOperations.add(new AbstractFix.AbstractFixRewriteOperation(this, fieldAccess, simpleName){
                final /* synthetic */ ThisQualifierVisitor this$1;
                private final /* synthetic */ FieldAccess val$node;
                private final /* synthetic */ SimpleName val$name;
                {
                    this.this$1 = thisQualifierVisitor;
                    this.val$node = fieldAccess;
                    this.val$name = simpleName;
                }

                public void rewriteAST(CompilationUnitRewrite compilationUnitRewrite, List list) throws CoreException {
                    ASTRewrite aSTRewrite = compilationUnitRewrite.getASTRewrite();
                    TextEditGroup textEditGroup = this.createTextEditGroup(FixMessages.CodeStyleFix_removeThis_groupDescription);
                    list.add(textEditGroup);
                    aSTRewrite.replace((ASTNode)this.val$node, aSTRewrite.createCopyTarget((ASTNode)this.val$name), textEditGroup);
                }
            });
            return super.visit(fieldAccess);
        }

        public boolean visit(MethodInvocation methodInvocation) {
            if (!this.fRemoveMethodQualifiers) {
                return true;
            }
            Expression expression = methodInvocation.getExpression();
            if (!(expression instanceof ThisExpression)) {
                return true;
            }
            SimpleName simpleName = methodInvocation.getName();
            if (simpleName != null && simpleName.resolveBinding() == null) {
                return true;
            }
            if (this.hasConflict(expression.getStartPosition(), simpleName, 1)) {
                return true;
            }
            Name name = ((ThisExpression)expression).getQualifier();
            if (name != null) {
                ITypeBinding iTypeBinding = ((IMethodBinding)simpleName.resolveBinding()).getDeclaringClass();
                if (iTypeBinding == null) {
                    return true;
                }
                ITypeBinding iTypeBinding2 = this.getDeclaringType(methodInvocation);
                if (iTypeBinding2 == null) {
                    return true;
                }
                ITypeBinding iTypeBinding3 = (ITypeBinding)name.resolveBinding();
                if (iTypeBinding3 == null) {
                    return true;
                }
                if (iTypeBinding3.isAssignmentCompatible(iTypeBinding) && iTypeBinding2.isAssignmentCompatible(iTypeBinding)) {
                    return true;
                }
            }
            this.fOperations.add(new AbstractFix.AbstractFixRewriteOperation(this, methodInvocation){
                final /* synthetic */ ThisQualifierVisitor this$1;
                private final /* synthetic */ MethodInvocation val$node;
                {
                    this.this$1 = thisQualifierVisitor;
                    this.val$node = methodInvocation;
                }

                public void rewriteAST(CompilationUnitRewrite compilationUnitRewrite, List list) throws CoreException {
                    ASTRewrite aSTRewrite = compilationUnitRewrite.getASTRewrite();
                    TextEditGroup textEditGroup = this.createTextEditGroup(FixMessages.CodeStyleFix_removeThis_groupDescription);
                    list.add(textEditGroup);
                    aSTRewrite.remove((ASTNode)this.val$node.getExpression(), textEditGroup);
                }
            });
            return super.visit(methodInvocation);
        }

        private ITypeBinding getDeclaringType(MethodInvocation methodInvocation) {
            MethodInvocation methodInvocation2 = methodInvocation;
            while (methodInvocation2 != null) {
                if (!((methodInvocation2 = methodInvocation2.getParent()) instanceof AbstractTypeDeclaration)) continue;
                return ((AbstractTypeDeclaration)methodInvocation2).resolveBinding();
            }
            return null;
        }

        private boolean hasConflict(int n, SimpleName simpleName, int n2) {
            ScopeAnalyzer scopeAnalyzer = new ScopeAnalyzer(this.fCompilationUnit);
            IBinding[] iBindingArray = scopeAnalyzer.getDeclarationsInScope(n, n2);
            int n3 = 0;
            while (n3 < iBindingArray.length) {
                IBinding iBinding = iBindingArray[n3];
                if (iBinding.getName().equals(simpleName.getIdentifier()) && simpleName.resolveBinding() != iBinding) {
                    return true;
                }
                ++n3;
            }
            return false;
        }
    }

    private static final class ToStaticAccessOperation
    extends AbstractFix.AbstractFixRewriteOperation {
        private final ITypeBinding fDeclaringTypeBinding;
        private final Expression fQualifier;

        public ToStaticAccessOperation(ITypeBinding iTypeBinding, Expression expression) {
            this.fDeclaringTypeBinding = iTypeBinding;
            this.fQualifier = expression;
        }

        public String getAccessorName() {
            return this.fDeclaringTypeBinding.getName();
        }

        public void rewriteAST(CompilationUnitRewrite compilationUnitRewrite, List list) throws CoreException {
            Type type = this.importType(this.fDeclaringTypeBinding, (ASTNode)this.fQualifier, compilationUnitRewrite.getImportRewrite(), compilationUnitRewrite.getRoot());
            TextEditGroup textEditGroup = this.createTextEditGroup(FixMessages.CodeStyleFix_ChangeAccessUsingDeclaring_description);
            list.add(textEditGroup);
            compilationUnitRewrite.getASTRewrite().replace((ASTNode)this.fQualifier, (ASTNode)type, textEditGroup);
        }
    }
}

