/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.IRefactoringSearchRequestor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.SearchUtils;

public final class RefactoringSearchEngine2 {
    public static final int GRANULARITY_COMPILATION_UNIT = 2;
    public static final int GRANULARITY_SEARCH_MATCH = 1;
    private boolean fBinary = false;
    private RefactoringSearchCollector fCollector = null;
    private int fGranularity = 1;
    private boolean fGrouping = true;
    private boolean fInaccurate = true;
    private WorkingCopyOwner fOwner = null;
    private SearchPattern fPattern = null;
    private IRefactoringSearchRequestor fRequestor = new DefaultSearchRequestor();
    private IJavaSearchScope fScope = SearchEngine.createWorkspaceScope();
    private int fSeverity = 2;
    private RefactoringStatus fStatus = new RefactoringStatus();
    private ICompilationUnit[] fWorkingCopies = new ICompilationUnit[0];

    public RefactoringSearchEngine2() {
    }

    public RefactoringSearchEngine2(SearchPattern searchPattern) {
        Assert.isNotNull((Object)searchPattern);
        this.fPattern = searchPattern;
    }

    public final void clearResults() {
        this.getCollector().clearResults();
        this.fStatus = new RefactoringStatus();
    }

    public final ICompilationUnit[] getAffectedCompilationUnits() {
        if (this.fGranularity == 2) {
            Collection collection = this.getCollector().getCollectedMatches();
            ICompilationUnit[] iCompilationUnitArray = new ICompilationUnit[collection.size()];
            int n = 0;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                iCompilationUnitArray[n] = (ICompilationUnit)iterator.next();
                ++n;
            }
            return iCompilationUnitArray;
        }
        SearchResultGroup[] searchResultGroupArray = this.getGroupedMatches();
        ICompilationUnit[] iCompilationUnitArray = new ICompilationUnit[searchResultGroupArray.length];
        int n = 0;
        while (n < searchResultGroupArray.length) {
            iCompilationUnitArray[n] = searchResultGroupArray[n].getCompilationUnit();
            ++n;
        }
        return iCompilationUnitArray;
    }

    public final Map getAffectedProjects() {
        HashMap<IJavaProject, HashSet<Object>> hashMap = new HashMap<IJavaProject, HashSet<Object>>();
        IJavaProject iJavaProject = null;
        ICompilationUnit iCompilationUnit = null;
        if (this.fGranularity == 2) {
            ICompilationUnit[] iCompilationUnitArray = this.getAffectedCompilationUnits();
            int n = 0;
            while (n < iCompilationUnitArray.length) {
                iCompilationUnit = iCompilationUnitArray[n];
                iJavaProject = iCompilationUnit.getJavaProject();
                if (iJavaProject != null) {
                    HashSet<ICompilationUnit> hashSet = (HashSet<ICompilationUnit>)hashMap.get(iJavaProject);
                    if (hashSet == null) {
                        hashSet = new HashSet<ICompilationUnit>();
                        hashMap.put(iJavaProject, hashSet);
                    }
                    hashSet.add(iCompilationUnit);
                }
                ++n;
            }
        } else {
            SearchResultGroup[] searchResultGroupArray = this.getGroupedMatches();
            SearchResultGroup searchResultGroup = null;
            int n = 0;
            while (n < searchResultGroupArray.length) {
                searchResultGroup = searchResultGroupArray[n];
                iCompilationUnit = searchResultGroup.getCompilationUnit();
                if (iCompilationUnit != null && (iJavaProject = iCompilationUnit.getJavaProject()) != null) {
                    HashSet<SearchResultGroup> hashSet = (HashSet<SearchResultGroup>)hashMap.get(iJavaProject);
                    if (hashSet == null) {
                        hashSet = new HashSet<SearchResultGroup>();
                        hashMap.put(iJavaProject, hashSet);
                    }
                    hashSet.add(searchResultGroup);
                }
                ++n;
            }
        }
        return hashMap;
    }

    private RefactoringSearchCollector getCollector() {
        if (this.fCollector == null) {
            if (this.fGranularity == 2) {
                this.fCollector = new RefactoringCompilationUnitCollector();
            } else if (this.fGranularity == 1) {
                this.fCollector = new RefactoringSearchMatchCollector();
            } else {
                Assert.isTrue((boolean)false);
            }
        }
        return this.fCollector;
    }

    private SearchResultGroup[] getGroupedMatches() {
        HashMap hashMap = new HashMap();
        List list = null;
        IResource iResource = null;
        SearchMatch searchMatch = null;
        SearchResultGroup[] searchResultGroupArray = this.getSearchMatches().iterator();
        while (searchResultGroupArray.hasNext()) {
            searchMatch = (SearchMatch)searchResultGroupArray.next();
            iResource = searchMatch.getResource();
            if (!hashMap.containsKey(iResource)) {
                hashMap.put(iResource, new ArrayList(4));
            }
            list = (List)hashMap.get(iResource);
            list.add(searchMatch);
        }
        if (this.fBinary) {
            searchResultGroupArray = this.getCollector().getBinaryResources();
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                iResource = (IResource)iterator.next();
                if (!searchResultGroupArray.contains(iResource)) continue;
                iterator.remove();
            }
        }
        searchResultGroupArray = new SearchResultGroup[hashMap.keySet().size()];
        int n = 0;
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            iResource = (IResource)iterator.next();
            list = (List)hashMap.get(iResource);
            searchResultGroupArray[n++] = new SearchResultGroup(iResource, list.toArray(new SearchMatch[list.size()]));
        }
        return searchResultGroupArray;
    }

    public final SearchPattern getPattern() {
        return this.fPattern;
    }

    public final Object[] getResults() {
        if (this.fGranularity == 2) {
            return this.getAffectedCompilationUnits();
        }
        if (this.fGrouping) {
            return this.getGroupedMatches();
        }
        return this.getUngroupedMatches();
    }

    private Collection getSearchMatches() {
        LinkedList linkedList = null;
        if (this.fInaccurate) {
            linkedList = new LinkedList(this.getCollector().getCollectedMatches());
            Collection collection = this.getCollector().getInaccurateMatches();
            SearchMatch searchMatch = null;
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                searchMatch = (SearchMatch)iterator.next();
                if (!collection.contains(searchMatch)) continue;
                iterator.remove();
            }
        } else {
            linkedList = this.getCollector().getCollectedMatches();
        }
        return linkedList;
    }

    public final RefactoringStatus getStatus() {
        return this.fStatus;
    }

    private SearchMatch[] getUngroupedMatches() {
        Object object;
        LinkedList linkedList = null;
        if (this.fBinary) {
            linkedList = new LinkedList(this.getSearchMatches());
            object = this.getCollector().getBinaryResources();
            SearchMatch searchMatch = null;
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                searchMatch = (SearchMatch)iterator.next();
                if (!object.contains(searchMatch.getResource())) continue;
                iterator.remove();
            }
        } else {
            linkedList = this.getSearchMatches();
        }
        object = new SearchMatch[linkedList.size()];
        linkedList.toArray((T[])object);
        return object;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void searchPattern(IProgressMonitor iProgressMonitor) throws JavaModelException {
        Assert.isNotNull((Object)this.fPattern);
        try {
            iProgressMonitor.beginTask("", 1);
            iProgressMonitor.setTaskName(RefactoringCoreMessages.RefactoringSearchEngine_searching_occurrences);
            try {
                SearchEngine searchEngine = null;
                searchEngine = this.fOwner != null ? new SearchEngine(this.fOwner) : new SearchEngine(this.fWorkingCopies);
                searchEngine.search(this.fPattern, SearchUtils.getDefaultSearchParticipants(), this.fScope, (SearchRequestor)this.getCollector(), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1, 2));
            }
            catch (CoreException coreException) {
                throw new JavaModelException(coreException);
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var3_6 = null;
        }
        iProgressMonitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void searchReferencedFields(IJavaElement iJavaElement, IProgressMonitor iProgressMonitor) throws JavaModelException {
        Assert.isNotNull((Object)iJavaElement);
        try {
            iProgressMonitor.beginTask("", 1);
            iProgressMonitor.setTaskName(RefactoringCoreMessages.RefactoringSearchEngine_searching_referenced_fields);
            try {
                SearchEngine searchEngine = null;
                searchEngine = this.fOwner != null ? new SearchEngine(this.fOwner) : new SearchEngine(this.fWorkingCopies);
                searchEngine.searchDeclarationsOfAccessedFields(iJavaElement, (SearchRequestor)this.getCollector(), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1, 2));
            }
            catch (CoreException coreException) {
                throw new JavaModelException(coreException);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var4_7 = null;
        }
        iProgressMonitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void searchReferencedMethods(IJavaElement iJavaElement, IProgressMonitor iProgressMonitor) throws JavaModelException {
        Assert.isNotNull((Object)iJavaElement);
        try {
            iProgressMonitor.beginTask("", 1);
            iProgressMonitor.setTaskName(RefactoringCoreMessages.RefactoringSearchEngine_searching_referenced_methods);
            try {
                SearchEngine searchEngine = null;
                searchEngine = this.fOwner != null ? new SearchEngine(this.fOwner) : new SearchEngine(this.fWorkingCopies);
                searchEngine.searchDeclarationsOfSentMessages(iJavaElement, (SearchRequestor)this.getCollector(), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1, 2));
            }
            catch (CoreException coreException) {
                throw new JavaModelException(coreException);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var4_7 = null;
        }
        iProgressMonitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void searchReferencedTypes(IJavaElement iJavaElement, IProgressMonitor iProgressMonitor) throws JavaModelException {
        Assert.isNotNull((Object)iJavaElement);
        try {
            iProgressMonitor.beginTask("", 1);
            iProgressMonitor.setTaskName(RefactoringCoreMessages.RefactoringSearchEngine_searching_referenced_types);
            try {
                SearchEngine searchEngine = null;
                searchEngine = this.fOwner != null ? new SearchEngine(this.fOwner) : new SearchEngine(this.fWorkingCopies);
                searchEngine.searchDeclarationsOfReferencedTypes(iJavaElement, (SearchRequestor)this.getCollector(), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1, 2));
            }
            catch (CoreException coreException) {
                throw new JavaModelException(coreException);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var4_7 = null;
        }
        iProgressMonitor.done();
    }

    public final void setAndPattern(SearchPattern searchPattern, SearchPattern searchPattern2) {
        Assert.isNotNull((Object)searchPattern);
        Assert.isNotNull((Object)searchPattern2);
        this.fPattern = SearchPattern.createAndPattern((SearchPattern)searchPattern, (SearchPattern)searchPattern2);
    }

    public final void setFiltering(boolean bl, boolean bl2) {
        this.fInaccurate = bl;
        this.fBinary = bl2;
    }

    public final void setGranularity(int n) {
        Assert.isTrue((n == 2 || n == 1 ? 1 : 0) != 0);
        this.fGranularity = n;
    }

    public final void setWorkingCopies(ICompilationUnit[] iCompilationUnitArray) {
        Assert.isNotNull((Object)iCompilationUnitArray);
        this.fWorkingCopies = new ICompilationUnit[iCompilationUnitArray.length];
        System.arraycopy(iCompilationUnitArray, 0, this.fWorkingCopies, 0, iCompilationUnitArray.length);
    }

    public final void setGrouping(boolean bl) {
        this.fGrouping = bl;
    }

    public final void setOrPattern(SearchPattern searchPattern, SearchPattern searchPattern2) {
        Assert.isNotNull((Object)searchPattern);
        Assert.isNotNull((Object)searchPattern2);
        this.fPattern = SearchPattern.createOrPattern((SearchPattern)searchPattern, (SearchPattern)searchPattern2);
    }

    public final void setOwner(WorkingCopyOwner workingCopyOwner) {
        this.fOwner = workingCopyOwner;
    }

    public final void setPattern(IJavaElement[] iJavaElementArray, int n) {
        Assert.isNotNull((Object)iJavaElementArray);
        Assert.isTrue((iJavaElementArray.length > 0 ? 1 : 0) != 0);
        SearchPattern searchPattern = SearchPattern.createPattern((IJavaElement)iJavaElementArray[0], (int)n, (int)24);
        IJavaElement iJavaElement = null;
        int n2 = 1;
        while (n2 < iJavaElementArray.length) {
            iJavaElement = iJavaElementArray[n2];
            searchPattern = SearchPattern.createOrPattern((SearchPattern)searchPattern, (SearchPattern)SearchPattern.createPattern((IJavaElement)iJavaElement, (int)n, (int)24));
            ++n2;
        }
        this.setPattern(searchPattern);
    }

    public final void setPattern(SearchPattern searchPattern) {
        Assert.isNotNull((Object)searchPattern);
        this.fPattern = searchPattern;
    }

    public final void setRequestor(IRefactoringSearchRequestor iRefactoringSearchRequestor) {
        Assert.isNotNull((Object)iRefactoringSearchRequestor);
        this.fRequestor = iRefactoringSearchRequestor;
    }

    public final void setScope(IJavaSearchScope iJavaSearchScope) {
        Assert.isNotNull((Object)iJavaSearchScope);
        this.fScope = iJavaSearchScope;
    }

    public final void setSeverity(int n) {
        Assert.isTrue((n == 2 || n == 1 || n == 4 || n == 3 ? 1 : 0) != 0);
        this.fSeverity = n;
    }

    public final void setStatus(RefactoringStatus refactoringStatus) {
        Assert.isNotNull((Object)refactoringStatus);
        this.fStatus = refactoringStatus;
    }

    private static class DefaultSearchRequestor
    implements IRefactoringSearchRequestor {
        private DefaultSearchRequestor() {
        }

        public final SearchMatch acceptSearchMatch(SearchMatch searchMatch) {
            return searchMatch;
        }
    }

    private class RefactoringCompilationUnitCollector
    extends RefactoringSearchCollector {
        private final Set fCollectedUnits = new HashSet();
        private final Set fInaccurateMatches = new HashSet();

        private RefactoringCompilationUnitCollector() {
        }

        public final void acceptSearchMatch(SearchMatch searchMatch) throws CoreException {
            SearchMatch searchMatch2 = RefactoringSearchEngine2.this.fRequestor.acceptSearchMatch(searchMatch);
            if (searchMatch2 != null) {
                IJavaElement iJavaElement;
                IResource iResource = searchMatch2.getResource();
                if (!iResource.equals((Object)this.fLastResource) && (iJavaElement = JavaCore.create((IResource)iResource)) instanceof ICompilationUnit) {
                    this.fCollectedUnits.add(iJavaElement);
                }
                if (RefactoringSearchEngine2.this.fInaccurate && searchMatch2.getAccuracy() == 1 && !this.fInaccurateMatches.contains(searchMatch2)) {
                    RefactoringSearchEngine2.this.fStatus.addEntry(RefactoringSearchEngine2.this.fSeverity, Messages.format(RefactoringCoreMessages.RefactoringSearchEngine_inaccurate_match, searchMatch2.getResource().getName()), null, null, -1);
                    this.fInaccurateMatches.add(searchMatch2);
                }
            }
        }

        public final void clearResults() {
            super.clearResults();
            this.fCollectedUnits.clear();
            this.fInaccurateMatches.clear();
        }

        public final Collection getBinaryResources() {
            return Collections.EMPTY_SET;
        }

        public final Collection getCollectedMatches() {
            return this.fCollectedUnits;
        }

        public final Collection getInaccurateMatches() {
            return this.fInaccurateMatches;
        }
    }

    private abstract class RefactoringSearchCollector
    extends SearchRequestor {
        protected IResource fLastResource = null;

        private RefactoringSearchCollector() {
        }

        public void clearResults() {
            this.fLastResource = null;
        }

        public abstract Collection getBinaryResources();

        public abstract Collection getCollectedMatches();

        public abstract Collection getInaccurateMatches();
    }

    private class RefactoringSearchMatchCollector
    extends RefactoringSearchCollector {
        private final Set fBinaryResources = new HashSet();
        private final List fCollectedMatches = new ArrayList();
        private final Set fInaccurateMatches = new HashSet();

        private RefactoringSearchMatchCollector() {
        }

        public final void acceptSearchMatch(SearchMatch searchMatch) throws CoreException {
            SearchMatch searchMatch2 = RefactoringSearchEngine2.this.fRequestor.acceptSearchMatch(searchMatch);
            if (searchMatch2 != null) {
                this.fCollectedMatches.add(searchMatch2);
                IResource iResource = searchMatch2.getResource();
                if (!iResource.equals((Object)this.fLastResource)) {
                    IJavaElement iJavaElement;
                    if (RefactoringSearchEngine2.this.fBinary && !((iJavaElement = JavaCore.create((IResource)iResource)) instanceof ICompilationUnit)) {
                        IProject iProject = iResource.getProject();
                        if (!RefactoringSearchEngine2.this.fGrouping) {
                            RefactoringSearchEngine2.this.fStatus.addEntry(RefactoringSearchEngine2.this.fSeverity, Messages.format(RefactoringCoreMessages.RefactoringSearchEngine_binary_match_ungrouped, iProject.getName()), null, null, -1);
                        } else if (!this.fBinaryResources.contains(iResource)) {
                            RefactoringSearchEngine2.this.fStatus.addEntry(RefactoringSearchEngine2.this.fSeverity, Messages.format(RefactoringCoreMessages.RefactoringSearchEngine_binary_match_grouped, iProject.getName()), null, null, -1);
                        }
                        this.fBinaryResources.add(iResource);
                    }
                    if (RefactoringSearchEngine2.this.fInaccurate && searchMatch2.getAccuracy() == 1 && !this.fInaccurateMatches.contains(searchMatch2)) {
                        RefactoringSearchEngine2.this.fStatus.addEntry(RefactoringSearchEngine2.this.fSeverity, Messages.format(RefactoringCoreMessages.RefactoringSearchEngine_inaccurate_match, iResource.getName()), null, null, -1);
                        this.fInaccurateMatches.add(searchMatch2);
                    }
                }
            }
        }

        public final void clearResults() {
            super.clearResults();
            this.fCollectedMatches.clear();
            this.fInaccurateMatches.clear();
            this.fBinaryResources.clear();
        }

        public final Collection getBinaryResources() {
            return this.fBinaryResources;
        }

        public final Collection getCollectedMatches() {
            return this.fCollectedMatches;
        }

        public final Collection getInaccurateMatches() {
            return this.fInaccurateMatches;
        }
    }
}

