/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.binary;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeParameter;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;

public class StubCreator {
    protected StringBuffer fBuffer;
    protected final boolean fStubInvisible;

    public StubCreator(boolean bl) {
        this.fStubInvisible = bl;
    }

    protected void appendEnumConstants(IType iType) throws JavaModelException {
        IField[] iFieldArray = iType.getFields();
        ArrayList<IField> arrayList = new ArrayList<IField>(iFieldArray.length);
        int n = 0;
        while (n < iFieldArray.length) {
            IField iField = iFieldArray[n];
            if (Flags.isEnum((int)iField.getFlags())) {
                arrayList.add(iField);
            }
            ++n;
        }
        n = 0;
        while (n < arrayList.size()) {
            if (n > 0) {
                this.fBuffer.append(",");
            }
            this.fBuffer.append(((IField)arrayList.get(n)).getElementName());
            ++n;
        }
        this.fBuffer.append(";");
    }

    protected void appendExpression(String string) {
        switch (string.charAt(0)) {
            case 'Z': {
                this.fBuffer.append("false");
                break;
            }
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': {
                this.fBuffer.append("0");
                break;
            }
            default: {
                this.fBuffer.append("(");
                this.fBuffer.append(Signature.toString((String)string));
                this.fBuffer.append(")");
                this.fBuffer.append("null");
            }
        }
    }

    protected void appendFieldDeclaration(IField iField) throws JavaModelException {
        this.appendFlags((IMember)iField);
        this.fBuffer.append(" ");
        String string = iField.getTypeSignature();
        this.fBuffer.append(Signature.toString((String)string));
        this.fBuffer.append(" ");
        this.fBuffer.append(iField.getElementName());
        if (Flags.isFinal((int)iField.getFlags())) {
            this.fBuffer.append("=");
            this.appendExpression(string);
        }
        this.fBuffer.append(";");
    }

    protected void appendFlags(IMember iMember) throws JavaModelException {
        int n = iMember.getFlags();
        int n2 = iMember.getElementType();
        if (n2 == 7) {
            n &= 0xFFFFFFDF;
            IType iType = (IType)iMember;
            if (!iType.isMember()) {
                n &= 0xFFFFFFFD;
            }
        }
        if (Flags.isEnum((int)n)) {
            n &= 0xFFFFFFEF;
        }
        if (n2 == 9) {
            n &= 0xFFFFFF7F;
            n &= 0xFFFFFFBF;
        }
        if (n != 0) {
            this.fBuffer.append(Flags.toString((int)n));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void appendMembers(IType iType, IProgressMonitor iProgressMonitor) throws JavaModelException {
        try {
            iProgressMonitor.beginTask(RefactoringCoreMessages.StubCreationOperation_creating_type_stubs, 1);
            IJavaElement[] iJavaElementArray = iType.getChildren();
            int n = 0;
            while (n < iJavaElementArray.length) {
                block15: {
                    block13: {
                        int n2;
                        boolean bl;
                        int n3;
                        IMember iMember;
                        block14: {
                            block12: {
                                iMember = (IMember)iJavaElementArray[n];
                                n3 = iMember.getFlags();
                                boolean bl2 = Flags.isPrivate((int)n3);
                                boolean bl3 = !Flags.isPublic((int)n3) && !Flags.isProtected((int)n3) && !bl2;
                                boolean bl4 = bl = this.fStubInvisible || !bl2 && !bl3;
                                if (!(iMember instanceof IType)) break block12;
                                if (bl) {
                                    this.appendTypeDeclaration((IType)iMember, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                                }
                                break block13;
                            }
                            if (!(iMember instanceof IField)) break block14;
                            if (bl && !Flags.isEnum((int)n3) && !Flags.isSynthetic((int)n3)) {
                                this.appendFieldDeclaration((IField)iMember);
                            }
                            break block13;
                        }
                        if (!(iMember instanceof IMethod)) break block13;
                        IMethod iMethod = (IMethod)iMember;
                        String string = iMethod.getElementName();
                        if (iMethod.getDeclaringType() != null && iMethod.getDeclaringType().isEnum() && ((n2 = iMethod.getNumberOfParameters()) == 0 && "values".equals(string) || n2 == 1 && "valueOf".equals(string) && "Ljava.lang.String;".equals(iMethod.getParameterTypes()[0]) || iMethod.isConstructor())) break block15;
                        int n4 = n2 = bl && !string.equals("<clinit>") ? 0 : 1;
                        if (iMethod.isConstructor()) {
                            n2 = 0;
                        }
                        int n5 = n2 = n2 == 0 && !Flags.isSynthetic((int)n3) && !Flags.isBridge((int)n3) ? 0 : 1;
                        if (n2 == 0) {
                            this.appendMethodDeclaration(iMethod);
                        }
                    }
                    this.fBuffer.append("\n");
                }
                ++n;
            }
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var13_15 = null;
        }
        iProgressMonitor.done();
    }

    protected void appendMethodBody(IMethod iMethod) throws JavaModelException {
        if (iMethod.isConstructor()) {
            IType iType = iMethod.getDeclaringType();
            String string = iType.getSuperclassTypeSignature();
            if (string != null) {
                string = Signature.getTypeErasure((String)string);
                IType iType2 = iType.getJavaProject().findType(Signature.getSignatureQualifier((String)string), Signature.getSignatureSimpleName((String)string));
                if (iType2 != null) {
                    String[] stringArray;
                    int n;
                    IMethod[] iMethodArray = iType2.getMethods();
                    IMethod iMethod2 = null;
                    int n2 = iMethodArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        IMethod iMethod3 = iMethodArray[n3];
                        if (iMethod3.isConstructor() && !Flags.isPrivate((int)iMethod3.getFlags()) && (iMethod2 = iMethod3).getExceptionTypes().length == 0) break;
                        ++n3;
                    }
                    if (iMethod2 != null && (n = (stringArray = iMethod2.getParameterTypes()).length) != 0) {
                        this.fBuffer.append("super(");
                        int n4 = 0;
                        while (n4 < n) {
                            if (n4 > 0) {
                                this.fBuffer.append(",");
                            }
                            this.appendExpression(stringArray[n4]);
                            ++n4;
                        }
                        this.fBuffer.append(");");
                    }
                }
            }
        } else {
            String string = iMethod.getReturnType();
            if (!"V".equals(string)) {
                this.fBuffer.append("return ");
                this.appendExpression(string);
                this.fBuffer.append(";");
            }
        }
    }

    protected void appendMethodDeclaration(IMethod iMethod) throws JavaModelException {
        int n;
        Object[] objectArray;
        this.appendFlags((IMember)iMethod);
        this.fBuffer.append(" ");
        String string = iMethod.getReturnType();
        if (!iMethod.isConstructor()) {
            this.fBuffer.append(Signature.toString((String)string));
            this.fBuffer.append(" ");
            objectArray = iMethod.getTypeParameters();
            if (objectArray.length > 0) {
                this.appendTypeParameters((ITypeParameter[])objectArray);
                this.fBuffer.append(" ");
            }
        }
        this.fBuffer.append(iMethod.getElementName());
        this.fBuffer.append("(");
        objectArray = iMethod.getParameterTypes();
        int n2 = iMethod.getFlags();
        boolean bl = Flags.isVarargs((int)n2);
        int n3 = objectArray.length;
        int n4 = 0;
        while (n4 < n3) {
            if (n4 > 0) {
                this.fBuffer.append(",");
            }
            this.fBuffer.append(Signature.toString((String)objectArray[n4]));
            if (bl && n4 == n3 - 1) {
                n = this.fBuffer.length();
                if (n >= 2 && this.fBuffer.indexOf("[]", n - 2) >= 0) {
                    this.fBuffer.setLength(n - 2);
                }
                this.fBuffer.append("...");
            }
            this.fBuffer.append(" ");
            this.appendMethodParameterName(iMethod, n4);
            ++n4;
        }
        this.fBuffer.append(")");
        String[] stringArray = iMethod.getExceptionTypes();
        n = stringArray.length;
        if (n > 0) {
            this.fBuffer.append(" throws ");
        }
        int n5 = 0;
        while (n5 < n) {
            if (n5 > 0) {
                this.fBuffer.append(",");
            }
            this.fBuffer.append(Signature.toString((String)stringArray[n5]));
            ++n5;
        }
        if (Flags.isAbstract((int)n2) || Flags.isNative((int)n2)) {
            this.fBuffer.append(";");
        } else {
            this.fBuffer.append("{\n");
            this.appendMethodBody(iMethod);
            this.fBuffer.append("}");
        }
    }

    protected void appendMethodParameterName(IMethod iMethod, int n) {
        this.fBuffer.append("a");
        this.fBuffer.append(n);
    }

    protected void appendSuperInterfaceTypes(IType iType) throws JavaModelException {
        String[] stringArray = iType.getSuperInterfaceTypeSignatures();
        if (stringArray.length > 0) {
            if (iType.isInterface()) {
                this.fBuffer.append(" extends ");
            } else {
                this.fBuffer.append(" implements ");
            }
        }
        int n = 0;
        while (n < stringArray.length) {
            if (n > 0) {
                this.fBuffer.append(",");
            }
            this.fBuffer.append(Signature.toString((String)stringArray[n]));
            ++n;
        }
    }

    protected void appendTopLevelType(IType iType, IProgressMonitor iProgressMonitor) throws JavaModelException {
        String string = iType.getPackageFragment().getElementName();
        if (string.length() > 0) {
            this.fBuffer.append("package ");
            this.fBuffer.append(string);
            this.fBuffer.append(";\n");
        }
        this.appendTypeDeclaration(iType, iProgressMonitor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void appendTypeDeclaration(IType iType, IProgressMonitor iProgressMonitor) throws JavaModelException {
        try {
            iProgressMonitor.beginTask(RefactoringCoreMessages.StubCreationOperation_creating_type_stubs, 1);
            if (iType.isInterface()) {
                this.appendFlags((IMember)iType);
                this.fBuffer.append(" interface ");
                this.fBuffer.append(iType.getElementName());
                this.appendTypeParameters(iType.getTypeParameters());
                this.appendSuperInterfaceTypes(iType);
                this.fBuffer.append("{\n");
                this.appendMembers(iType, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                this.fBuffer.append("}");
            } else if (iType.isClass()) {
                this.appendFlags((IMember)iType);
                this.fBuffer.append(" class ");
                this.fBuffer.append(iType.getElementName());
                this.appendTypeParameters(iType.getTypeParameters());
                String string = iType.getSuperclassTypeSignature();
                if (string != null) {
                    this.fBuffer.append(" extends ");
                    this.fBuffer.append(Signature.toString((String)string));
                }
                this.appendSuperInterfaceTypes(iType);
                this.fBuffer.append("{\n");
                this.appendMembers(iType, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                this.fBuffer.append("}");
            } else if (iType.isAnnotation()) {
                this.appendFlags((IMember)iType);
                this.fBuffer.append(" @interface ");
                this.fBuffer.append(iType.getElementName());
                this.fBuffer.append("{\n");
                this.appendMembers(iType, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                this.fBuffer.append("}");
            } else if (iType.isEnum()) {
                this.appendFlags((IMember)iType);
                this.fBuffer.append(" enum ");
                this.fBuffer.append(iType.getElementName());
                this.appendSuperInterfaceTypes(iType);
                this.fBuffer.append("{\n");
                this.appendEnumConstants(iType);
                this.appendMembers(iType, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                this.fBuffer.append("}");
            }
            Object var4_6 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
    }

    protected void appendTypeParameters(ITypeParameter[] iTypeParameterArray) throws JavaModelException {
        int n = iTypeParameterArray.length;
        if (n > 0) {
            this.fBuffer.append("<");
        }
        int n2 = 0;
        while (n2 < n) {
            if (n2 > 0) {
                this.fBuffer.append(",");
            }
            ITypeParameter iTypeParameter = iTypeParameterArray[n2];
            this.fBuffer.append(iTypeParameter.getElementName());
            String[] stringArray = iTypeParameter.getBounds();
            int n3 = stringArray.length;
            if (n3 > 0) {
                this.fBuffer.append(" extends ");
            }
            int n4 = 0;
            while (n4 < n3) {
                if (n4 > 0) {
                    this.fBuffer.append(" & ");
                }
                this.fBuffer.append(stringArray[n4]);
                ++n4;
            }
            ++n2;
        }
        if (n > 0) {
            this.fBuffer.append(">");
        }
    }

    public String createStub(IType iType, IProgressMonitor iProgressMonitor) throws JavaModelException {
        Assert.isTrue((boolean)Checks.isTopLevel(iType));
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        this.fBuffer = new StringBuffer(2046);
        this.appendTopLevelType(iType, iProgressMonitor);
        String string = this.fBuffer.toString();
        this.fBuffer = null;
        return string;
    }
}

