/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.changes;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JDTChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.AddToClasspathChange;

public class DeleteFromClasspathChange
extends JDTChange {
    private final String fProjectHandle;
    private final IPath fPathToDelete;
    private IPath fPath;
    private IPath fSourceAttachmentPath;
    private IPath fSourceAttachmentRootPath;
    private int fEntryKind;

    public DeleteFromClasspathChange(IPackageFragmentRoot iPackageFragmentRoot) {
        this(iPackageFragmentRoot.getPath(), iPackageFragmentRoot.getJavaProject());
    }

    DeleteFromClasspathChange(IPath iPath, IJavaProject iJavaProject) {
        Assert.isNotNull((Object)iPath);
        this.fPathToDelete = iPath;
        this.fProjectHandle = iJavaProject.getHandleIdentifier();
    }

    public RefactoringStatus isValid(IProgressMonitor iProgressMonitor) throws CoreException {
        return super.isValid(iProgressMonitor, 3);
    }

    public Change perform(IProgressMonitor iProgressMonitor) throws CoreException {
        AddToClasspathChange addToClasspathChange;
        iProgressMonitor.beginTask(this.getName(), 1);
        try {
            IClasspathEntry iClasspathEntry;
            IJavaProject iJavaProject = this.getJavaProject();
            IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
            IClasspathEntry[] iClasspathEntryArray2 = new IClasspathEntry[iClasspathEntryArray.length - 1];
            int n = 0;
            int n2 = 0;
            while (n2 < iClasspathEntryArray2.length) {
                iClasspathEntry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)iClasspathEntryArray[n]);
                if (iClasspathEntry != null && this.toBeDeleted(iClasspathEntry)) {
                    ++n;
                    this.setDeletedEntryProperties(iClasspathEntry);
                }
                iClasspathEntryArray2[n2] = iClasspathEntryArray[n];
                ++n;
                ++n2;
            }
            iClasspathEntry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)iClasspathEntryArray[iClasspathEntryArray.length - 1]);
            if (iClasspathEntry != null && this.toBeDeleted(iClasspathEntry)) {
                this.setDeletedEntryProperties(iClasspathEntry);
            }
            iJavaProject.setRawClasspath(iClasspathEntryArray2, iProgressMonitor);
            addToClasspathChange = new AddToClasspathChange(this.getJavaProject(), this.fEntryKind, this.fPath, this.fSourceAttachmentPath, this.fSourceAttachmentRootPath);
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return addToClasspathChange;
    }

    private boolean toBeDeleted(IClasspathEntry iClasspathEntry) {
        if (iClasspathEntry == null) {
            return false;
        }
        return this.fPathToDelete.equals((Object)iClasspathEntry.getPath());
    }

    private void setDeletedEntryProperties(IClasspathEntry iClasspathEntry) {
        this.fEntryKind = iClasspathEntry.getEntryKind();
        this.fPath = iClasspathEntry.getPath();
        this.fSourceAttachmentPath = iClasspathEntry.getSourceAttachmentPath();
        this.fSourceAttachmentRootPath = iClasspathEntry.getSourceAttachmentRootPath();
    }

    private IJavaProject getJavaProject() {
        return (IJavaProject)JavaCore.create((String)this.fProjectHandle);
    }

    public String getName() {
        return String.valueOf(RefactoringCoreMessages.DeleteFromClassPathChange_remove) + this.getJavaProject().getElementName();
    }

    public Object getModifiedElement() {
        return this.getJavaProject();
    }
}

