/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.changes;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JDTChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.Utils;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.INewNameQuery;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ReorgUtils;

abstract class ResourceReorgChange
extends JDTChange {
    private final IPath fResourcePath;
    private final boolean fIsFile;
    private final IPath fDestinationPath;
    private final boolean fIsDestinationProject;
    private final INewNameQuery fNewNameQuery;
    static /* synthetic */ Class class$0;

    ResourceReorgChange(IResource iResource, IContainer iContainer, INewNameQuery iNewNameQuery) {
        Assert.isTrue((iResource instanceof IFile || iResource instanceof IFolder ? 1 : 0) != 0);
        this.fIsFile = iResource instanceof IFile;
        this.fResourcePath = Utils.getResourcePath(iResource);
        Assert.isTrue((iContainer instanceof IProject || iContainer instanceof IFolder ? 1 : 0) != 0);
        this.fIsDestinationProject = iContainer instanceof IProject;
        this.fDestinationPath = Utils.getResourcePath((IResource)iContainer);
        this.fNewNameQuery = iNewNameQuery;
    }

    protected abstract Change doPerformReorg(IPath var1, IProgressMonitor var2) throws CoreException;

    public final Change perform(IProgressMonitor iProgressMonitor) throws CoreException, OperationCanceledException {
        IResource iResource;
        String string;
        block3: {
            try {
                iProgressMonitor.beginTask(this.getName(), 2);
                string = this.getNewResourceName();
                iResource = this.getResource();
                boolean bl = this.deleteIfAlreadyExists((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), string);
                if (bl) break block3;
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                iProgressMonitor.done();
                throw throwable;
            }
            iProgressMonitor.done();
            return null;
        }
        Change change = this.doPerformReorg(this.getDestinationPath(string), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        this.markAsExecuted(iResource);
        Change change2 = change;
        Object var6_6 = null;
        iProgressMonitor.done();
        return change2;
    }

    protected IPath getDestinationPath(String string) {
        return this.getDestination().getFullPath().append(string);
    }

    private boolean deleteIfAlreadyExists(IProgressMonitor iProgressMonitor, String string) throws CoreException {
        iProgressMonitor.beginTask("", 1);
        IResource iResource = this.getDestination().findMember(string);
        if (iResource == null) {
            return true;
        }
        if (!iResource.exists()) {
            return true;
        }
        IResource iResource2 = this.getResource();
        Assert.isNotNull((Object)iResource2);
        if (ReorgUtils.areEqualInWorkspaceOrOnDisk(iResource2, iResource)) {
            return false;
        }
        if (iResource instanceof IFile) {
            ((IFile)iResource).delete(false, true, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        } else if (iResource instanceof IFolder) {
            ((IFolder)iResource).delete(false, true, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        } else {
            Assert.isTrue((boolean)false);
        }
        return true;
    }

    private String getNewResourceName() throws OperationCanceledException {
        if (this.fNewNameQuery == null) {
            return this.getResource().getName();
        }
        String string = this.fNewNameQuery.getNewName();
        if (string == null) {
            return this.getResource().getName();
        }
        return string;
    }

    public Object getModifiedElement() {
        return this.getResource();
    }

    private IFile getFile() {
        return Utils.getFile(this.fResourcePath);
    }

    private IFolder getFolder() {
        return Utils.getFolder(this.fResourcePath);
    }

    protected IResource getResource() {
        if (this.fIsFile) {
            return this.getFile();
        }
        return this.getFolder();
    }

    IContainer getDestination() {
        if (this.fIsDestinationProject) {
            return Utils.getProject(this.fDestinationPath);
        }
        return Utils.getFolder(this.fDestinationPath);
    }

    protected int getReorgFlags() {
        return 34;
    }

    private void markAsExecuted(IResource iResource) {
        ReorgExecutionLog reorgExecutionLog;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((reorgExecutionLog = (ReorgExecutionLog)this.getAdapter(clazz)) != null) {
            reorgExecutionLog.markAsProcessed((Object)iResource);
        }
    }
}

