/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.changes;

import org.eclipse.core.runtime.Assert;
import org.eclipse.ltk.core.refactoring.CategorizedTextEditGroup;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditChangeGroup;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class TextChangeCompatibility {
    public static void addTextEdit(TextChange textChange, String string, TextEdit textEdit) throws MalformedTreeException {
        Assert.isNotNull((Object)textChange);
        Assert.isNotNull((Object)string);
        Assert.isNotNull((Object)textEdit);
        TextEdit textEdit2 = textChange.getEdit();
        if (textEdit2 == null) {
            textEdit2 = new MultiTextEdit();
            textChange.setEdit(textEdit2);
        }
        TextChangeCompatibility.insert(textEdit2, textEdit);
        textChange.addTextEditGroup(new TextEditGroup(string, textEdit));
    }

    public static void addTextEdit(TextChange textChange, String string, TextEdit textEdit, GroupCategorySet groupCategorySet) throws MalformedTreeException {
        Assert.isNotNull((Object)textChange);
        Assert.isNotNull((Object)string);
        Assert.isNotNull((Object)textEdit);
        TextEdit textEdit2 = textChange.getEdit();
        if (textEdit2 == null) {
            textEdit2 = new MultiTextEdit();
            textChange.setEdit(textEdit2);
        }
        TextChangeCompatibility.insert(textEdit2, textEdit);
        textChange.addTextEditChangeGroup(new TextEditChangeGroup(textChange, (TextEditGroup)new CategorizedTextEditGroup(string, textEdit, groupCategorySet)));
    }

    public static void insert(TextEdit textEdit, TextEdit textEdit2) throws MalformedTreeException {
        if (!textEdit.hasChildren()) {
            textEdit.addChild(textEdit2);
            return;
        }
        TextEdit[] textEditArray = textEdit.getChildren();
        int n = 0;
        while (n < textEditArray.length) {
            TextEdit textEdit3 = textEditArray[n];
            if (TextChangeCompatibility.covers(textEdit3, textEdit2)) {
                TextChangeCompatibility.insert(textEdit3, textEdit2);
                return;
            }
            ++n;
        }
        n = 0;
        int n2 = 0;
        while (n2 < textEditArray.length) {
            TextEdit textEdit4 = textEditArray[n2];
            if (TextChangeCompatibility.covers(textEdit2, textEdit4)) {
                textEdit.removeChild(n2 - n++);
                textEdit2.addChild(textEdit4);
            }
            ++n2;
        }
        textEdit.addChild(textEdit2);
    }

    private static boolean covers(TextEdit textEdit, TextEdit textEdit2) {
        if (textEdit.getLength() == 0) {
            return false;
        }
        int n = textEdit.getOffset();
        int n2 = textEdit.getExclusiveEnd();
        if (textEdit2.getLength() == 0) {
            int n3 = textEdit2.getOffset();
            return n < n3 && n3 < n2;
        }
        int n4 = textEdit2.getOffset();
        int n5 = textEdit2.getExclusiveEnd();
        return n <= n4 && n5 <= n2;
    }
}

