/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.changes;

import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.ListenerList;

public class WorkspaceTracker {
    public static final WorkspaceTracker INSTANCE = new WorkspaceTracker();
    private ListenerList fListeners = new ListenerList();
    private ResourceListener fResourceListener;

    private WorkspaceTracker() {
    }

    private void workspaceChanged() {
        Object[] objectArray = this.fListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ((Listener)objectArray[n]).workspaceChanged();
            ++n;
        }
    }

    public void addListener(Listener listener) {
        this.fListeners.add((Object)listener);
        if (this.fResourceListener == null) {
            this.fResourceListener = new ResourceListener();
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fResourceListener);
        }
    }

    public void removeListener(Listener listener) {
        if (this.fListeners.size() == 0) {
            return;
        }
        this.fListeners.remove((Object)listener);
        if (this.fListeners.size() == 0) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fResourceListener);
            this.fResourceListener = null;
        }
    }

    public static interface Listener {
        public void workspaceChanged();
    }

    private class ResourceListener
    implements IResourceChangeListener {
        private ResourceListener() {
        }

        public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
            WorkspaceTracker.this.workspaceChanged();
        }
    }
}

