/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.EnumDeclaration;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.Javadoc;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeParameter;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTFlattener;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.BodyDeclarationRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.wst.jsdt.internal.corext.dom.Selection;
import org.eclipse.wst.jsdt.internal.corext.dom.StatementRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.ParameterInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ExtractMethodAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.SnippetFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.SelectionAwareSourceRangeComputer;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.wst.jsdt.ui.CodeGeneration;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public class ExtractMethodRefactoring
extends ScriptableRefactoring {
    private static final String ATTRIBUTE_VISIBILITY = "visibility";
    private static final String ATTRIBUTE_DESTINATION = "destination";
    private static final String ATTRIBUTE_COMMENTS = "comments";
    private static final String ATTRIBUTE_REPLACE = "replace";
    private static final String ATTRIBUTE_EXCEPTIONS = "exceptions";
    private ICompilationUnit fCUnit;
    private CompilationUnit fRoot;
    private ImportRewrite fImportRewriter;
    private int fSelectionStart;
    private int fSelectionLength;
    private AST fAST;
    private ASTRewrite fRewriter;
    private IDocument fDocument;
    private ExtractMethodAnalyzer fAnalyzer;
    private int fVisibility;
    private String fMethodName;
    private boolean fThrowRuntimeExceptions;
    private List fParameterInfos;
    private Set fUsedNames;
    private boolean fGenerateJavadoc;
    private boolean fReplaceDuplicates;
    private SnippetFinder.Match[] fDuplicates;
    private int fDestinationIndex = 0;
    private ASTNode fDestination;
    private ASTNode[] fDestinations;
    private static final String EMPTY = "";
    static /* synthetic */ Class class$0;

    public ExtractMethodRefactoring(ICompilationUnit iCompilationUnit, int n, int n2) throws CoreException {
        this.fCUnit = iCompilationUnit;
        this.fMethodName = "extracted";
        this.fSelectionStart = n;
        this.fSelectionLength = n2;
        this.fVisibility = -1;
        if (iCompilationUnit != null) {
            this.initialize(iCompilationUnit);
        }
    }

    private void initialize(ICompilationUnit iCompilationUnit) throws CoreException {
        this.fImportRewriter = StubUtility.createImportRewrite(iCompilationUnit, true);
    }

    public String getName() {
        return RefactoringCoreMessages.ExtractMethodRefactoring_name;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor iProgressMonitor) throws CoreException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        iProgressMonitor.beginTask(EMPTY, 100);
        if (this.fSelectionStart < 0 || this.fSelectionLength == 0) {
            return this.mergeTextSelectionStatus(refactoringStatus);
        }
        IFile[] iFileArray = ResourceUtil.getFiles(new ICompilationUnit[]{this.fCUnit});
        refactoringStatus.merge(Checks.validateModifiesFiles(iFileArray, this.getValidationContext()));
        if (refactoringStatus.hasFatalError()) {
            return refactoringStatus;
        }
        refactoringStatus.merge(ResourceChangeChecker.checkFilesToBeChanged((IFile[])iFileArray, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1)));
        this.fRoot = RefactoringASTParser.parseWithASTProvider((ITypeRoot)this.fCUnit, true, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 99));
        this.fAST = this.fRoot.getAST();
        this.fRoot.accept(this.createVisitor());
        refactoringStatus.merge(this.fAnalyzer.checkInitialConditions(this.fImportRewriter));
        if (refactoringStatus.hasFatalError()) {
            return refactoringStatus;
        }
        if (this.fVisibility == -1) {
            this.fVisibility = 0;
        }
        this.initializeParameterInfos();
        this.initializeUsedNames();
        this.initializeDuplicates();
        this.initializeDestinations();
        return refactoringStatus;
    }

    private ASTVisitor createVisitor() throws JavaModelException {
        this.fAnalyzer = new ExtractMethodAnalyzer(this.fCUnit, Selection.createFromStartLength(this.fSelectionStart, this.fSelectionLength));
        return this.fAnalyzer;
    }

    public void setMethodName(String string) {
        this.fMethodName = string;
    }

    public String getMethodName() {
        return this.fMethodName;
    }

    public void setVisibility(int n) {
        this.fVisibility = n;
    }

    public int getVisibility() {
        return this.fVisibility;
    }

    public List getParameterInfos() {
        return this.fParameterInfos;
    }

    public void setThrowRuntimeExceptions(boolean bl) {
        this.fThrowRuntimeExceptions = bl;
    }

    public RefactoringStatus checkMethodName() {
        return Checks.checkMethodName(this.fMethodName);
    }

    public ASTNode[] getDestinations() {
        return this.fDestinations;
    }

    public void setDestination(int n) {
        this.fDestination = this.fDestinations[n];
        this.fDestinationIndex = n;
    }

    public RefactoringStatus checkParameterNames() {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        Iterator iterator = this.fParameterInfos.iterator();
        while (iterator.hasNext()) {
            ParameterInfo parameterInfo = (ParameterInfo)iterator.next();
            refactoringStatus.merge(Checks.checkIdentifier(parameterInfo.getNewName()));
            Iterator iterator2 = this.fParameterInfos.iterator();
            while (iterator2.hasNext()) {
                ParameterInfo parameterInfo2 = (ParameterInfo)iterator2.next();
                if (parameterInfo == parameterInfo2 || !parameterInfo2.getNewName().equals(parameterInfo.getNewName())) continue;
                refactoringStatus.addError(Messages.format(RefactoringCoreMessages.ExtractMethodRefactoring_error_sameParameter, parameterInfo2.getNewName()));
                return refactoringStatus;
            }
            if (!parameterInfo.isRenamed() || !this.fUsedNames.contains(parameterInfo.getNewName())) continue;
            refactoringStatus.addError(Messages.format(RefactoringCoreMessages.ExtractMethodRefactoring_error_nameInUse, parameterInfo.getNewName()));
            return refactoringStatus;
        }
        return refactoringStatus;
    }

    public RefactoringStatus checkVarargOrder() {
        Iterator iterator = this.fParameterInfos.iterator();
        while (iterator.hasNext()) {
            ParameterInfo parameterInfo = (ParameterInfo)iterator.next();
            if (!parameterInfo.isOldVarargs() || !iterator.hasNext()) continue;
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.ExtractMethodRefactoring_error_vararg_ordering, parameterInfo.getOldName()));
        }
        return new RefactoringStatus();
    }

    public Set getUsedNames() {
        return this.fUsedNames;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor.beginTask(RefactoringCoreMessages.ExtractMethodRefactoring_checking_new_name, 2);
        iProgressMonitor.subTask(EMPTY);
        RefactoringStatus refactoringStatus = this.checkMethodName();
        refactoringStatus.merge(this.checkParameterNames());
        refactoringStatus.merge(this.checkVarargOrder());
        iProgressMonitor.worked(1);
        if (iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        BodyDeclaration bodyDeclaration = this.fAnalyzer.getEnclosingBodyDeclaration();
        if (bodyDeclaration != null) {
            this.fAnalyzer.checkInput(refactoringStatus, this.fMethodName, this.fAST);
            iProgressMonitor.worked(1);
        }
        iProgressMonitor.done();
        return refactoringStatus;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Change createChange(IProgressMonitor iProgressMonitor) throws CoreException {
        Object object;
        AbstractTypeDeclaration abstractTypeDeclaration;
        if (this.fMethodName == null) {
            return null;
        }
        iProgressMonitor.beginTask(EMPTY, 2);
        this.fAnalyzer.aboutToCreateChange();
        BodyDeclaration bodyDeclaration = this.fAnalyzer.getEnclosingBodyDeclaration();
        this.fRewriter = ASTRewrite.create((AST)bodyDeclaration.getAST());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = null;
        IJavaProject iJavaProject = this.fCUnit.getJavaProject();
        if (iJavaProject != null) {
            string = iJavaProject.getElementName();
        }
        ITypeBinding iTypeBinding = null;
        if (this.fDestination instanceof AbstractTypeDeclaration) {
            abstractTypeDeclaration = (AbstractTypeDeclaration)this.fDestination;
            iTypeBinding = abstractTypeDeclaration.resolveBinding();
        } else if (this.fDestination instanceof AnonymousClassDeclaration) {
            abstractTypeDeclaration = (AnonymousClassDeclaration)this.fDestination;
            iTypeBinding = abstractTypeDeclaration.resolveBinding();
        }
        abstractTypeDeclaration = null;
        BodyDeclaration bodyDeclaration2 = this.fAnalyzer.getEnclosingBodyDeclaration();
        if (bodyDeclaration2 instanceof MethodDeclaration) {
            object = (MethodDeclaration)bodyDeclaration2;
            abstractTypeDeclaration = object.resolveBinding();
        }
        object = Messages.format(RefactoringCoreMessages.ExtractMethodRefactoring_descriptor_description_short, this.fMethodName);
        String string2 = abstractTypeDeclaration != null ? BindingLabelProvider.getBindingLabel((IBinding)abstractTypeDeclaration, JavaElementLabels.ALL_FULLY_QUALIFIED) : "{...}";
        String string3 = Messages.format(RefactoringCoreMessages.ExtractMethodRefactoring_descriptor_description, new String[]{this.getSignature(), string2, BindingLabelProvider.getBindingLabel((IBinding)iTypeBinding, JavaElementLabels.ALL_FULLY_QUALIFIED)});
        JDTRefactoringDescriptorComment jDTRefactoringDescriptorComment = new JDTRefactoringDescriptorComment(string, this, string3);
        jDTRefactoringDescriptorComment.addSetting(Messages.format(RefactoringCoreMessages.ExtractMethodRefactoring_name_pattern, this.fMethodName));
        jDTRefactoringDescriptorComment.addSetting(Messages.format(RefactoringCoreMessages.ExtractMethodRefactoring_destination_pattern, BindingLabelProvider.getBindingLabel((IBinding)iTypeBinding, JavaElementLabels.ALL_FULLY_QUALIFIED)));
        if (this.fReplaceDuplicates) {
            jDTRefactoringDescriptorComment.addSetting(RefactoringCoreMessages.ExtractMethodRefactoring_replace_occurrences);
        }
        if (this.fGenerateJavadoc) {
            jDTRefactoringDescriptorComment.addSetting(RefactoringCoreMessages.ExtractMethodRefactoring_generate_comment);
        }
        JDTRefactoringDescriptor jDTRefactoringDescriptor = new JDTRefactoringDescriptor("org.eclipse.wst.jsdt.ui.extract.method", string, (String)object, jDTRefactoringDescriptorComment.asString(), hashMap, 786434);
        hashMap.put("input", jDTRefactoringDescriptor.elementToHandle((IJavaElement)this.fCUnit));
        hashMap.put("name", this.fMethodName);
        hashMap.put("selection", String.valueOf(new Integer(this.fSelectionStart).toString()) + " " + new Integer(this.fSelectionLength).toString());
        hashMap.put(ATTRIBUTE_DESTINATION, new Integer(this.fDestinationIndex).toString());
        hashMap.put(ATTRIBUTE_COMMENTS, Boolean.valueOf(this.fGenerateJavadoc).toString());
        hashMap.put(ATTRIBUTE_REPLACE, Boolean.valueOf(this.fReplaceDuplicates).toString());
        CompilationUnitChange compilationUnitChange = new CompilationUnitChange(RefactoringCoreMessages.ExtractMethodRefactoring_change_name, this.fCUnit);
        compilationUnitChange.setSaveMode(1);
        compilationUnitChange.setDescriptor((ChangeDescriptor)new RefactoringChangeDescriptor((RefactoringDescriptor)jDTRefactoringDescriptor));
        MultiTextEdit multiTextEdit = new MultiTextEdit();
        compilationUnitChange.setEdit((TextEdit)multiTextEdit);
        IPath iPath = ((IFile)this.fCUnit.getPrimary().getResource()).getFullPath();
        ITextFileBufferManager iTextFileBufferManager = FileBuffers.getTextFileBufferManager();
        try {
            try {
                Object object2;
                iTextFileBufferManager.connect(iPath, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                this.fDocument = iTextFileBufferManager.getTextFileBuffer(iPath, LocationKind.IFILE).getDocument();
                ASTNode[] aSTNodeArray = this.fAnalyzer.getSelectedNodes();
                this.fRewriter.setTargetSourceRangeComputer((TargetSourceRangeComputer)new SelectionAwareSourceRangeComputer(aSTNodeArray, this.fDocument, this.fSelectionStart, this.fSelectionLength));
                TextEditGroup textEditGroup = new TextEditGroup(Messages.format(RefactoringCoreMessages.ExtractMethodRefactoring_substitute_with_call, this.fMethodName));
                compilationUnitChange.addTextEditGroup(textEditGroup);
                MethodDeclaration methodDeclaration = this.createNewMethod(this.fMethodName, true, aSTNodeArray, this.fDocument.getLineDelimiter(0), textEditGroup);
                TextEditGroup textEditGroup2 = new TextEditGroup(Messages.format(RefactoringCoreMessages.ExtractMethodRefactoring_add_method, this.fMethodName));
                compilationUnitChange.addTextEditGroup(textEditGroup2);
                if (this.fDestination == this.fDestinations[0]) {
                    object2 = (ChildListPropertyDescriptor)bodyDeclaration.getLocationInParent();
                    ListRewrite listRewrite = this.fRewriter.getListRewrite(bodyDeclaration.getParent(), (ChildListPropertyDescriptor)object2);
                    listRewrite.insertAfter((ASTNode)methodDeclaration, (ASTNode)bodyDeclaration, textEditGroup2);
                } else {
                    object2 = BodyDeclarationRewrite.create(this.fRewriter, this.fDestination);
                    ((BodyDeclarationRewrite)object2).insert((BodyDeclaration)methodDeclaration, textEditGroup2);
                }
                this.replaceDuplicates(compilationUnitChange);
                if (this.fImportRewriter.hasRecordedChanges()) {
                    object2 = this.fImportRewriter.rewriteImports(null);
                    multiTextEdit.addChild((TextEdit)object2);
                    compilationUnitChange.addTextEditGroup(new TextEditGroup(RefactoringCoreMessages.ExtractMethodRefactoring_organize_imports, new TextEdit[]{object2}));
                }
                multiTextEdit.addChild(this.fRewriter.rewriteAST(this.fDocument, this.fCUnit.getJavaProject().getOptions(true)));
            }
            catch (BadLocationException badLocationException) {
                throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 4, badLocationException.getMessage(), (Throwable)badLocationException));
            }
        }
        catch (Throwable throwable) {
            Object var24_26 = null;
            iTextFileBufferManager.disconnect(iPath, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var24_27 = null;
        }
        iTextFileBufferManager.disconnect(iPath, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        iProgressMonitor.done();
        return compilationUnitChange;
    }

    public String getSignature() {
        return this.getSignature(this.fMethodName);
    }

    public String getSignature(String string) {
        MethodDeclaration methodDeclaration = null;
        try {
            methodDeclaration = this.createNewMethod(string, false, null, StubUtility.getLineDelimiterUsed((IJavaElement)this.fCUnit), null);
        }
        catch (CoreException coreException) {
            Assert.isTrue((boolean)false);
        }
        catch (BadLocationException badLocationException) {
            Assert.isTrue((boolean)false);
        }
        methodDeclaration.setBody(this.fAST.newBlock());
        ASTFlattener aSTFlattener = new ASTFlattener(){

            public boolean visit(Block block) {
                return false;
            }
        };
        methodDeclaration.accept((ASTVisitor)aSTFlattener);
        return aSTFlattener.getResult();
    }

    public int getNumberOfDuplicates() {
        if (this.fDuplicates == null) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.fDuplicates.length) {
            if (!this.fDuplicates[n2].isMethodBody()) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public boolean getReplaceDuplicates() {
        return this.fReplaceDuplicates;
    }

    public void setReplaceDuplicates(boolean bl) {
        this.fReplaceDuplicates = bl;
    }

    public void setGenerateJavadoc(boolean bl) {
        this.fGenerateJavadoc = bl;
    }

    public boolean getGenerateJavadoc() {
        return this.fGenerateJavadoc;
    }

    private void initializeParameterInfos() {
        IVariableBinding[] iVariableBindingArray = this.fAnalyzer.getArguments();
        this.fParameterInfos = new ArrayList(iVariableBindingArray.length);
        BodyDeclaration bodyDeclaration = this.fAnalyzer.getEnclosingBodyDeclaration();
        ParameterInfo parameterInfo = null;
        int n = 0;
        while (n < iVariableBindingArray.length) {
            IVariableBinding iVariableBinding = iVariableBindingArray[n];
            if (iVariableBinding != null) {
                VariableDeclaration variableDeclaration = ASTNodes.findVariableDeclaration(iVariableBinding, (ASTNode)bodyDeclaration);
                boolean bl = variableDeclaration instanceof SingleVariableDeclaration ? ((SingleVariableDeclaration)variableDeclaration).isVarargs() : false;
                ParameterInfo parameterInfo2 = new ParameterInfo(iVariableBinding, this.getType(variableDeclaration, bl), iVariableBinding.getName(), n);
                if (bl) {
                    parameterInfo = parameterInfo2;
                } else {
                    this.fParameterInfos.add(parameterInfo2);
                }
            }
            ++n;
        }
        if (parameterInfo != null) {
            this.fParameterInfos.add(parameterInfo);
        }
    }

    private void initializeUsedNames() {
        this.fUsedNames = UsedNamesCollector.perform(this.fAnalyzer.getSelectedNodes());
        Iterator iterator = this.fParameterInfos.iterator();
        while (iterator.hasNext()) {
            ParameterInfo parameterInfo = (ParameterInfo)iterator.next();
            this.fUsedNames.remove(parameterInfo.getOldName());
        }
    }

    private void initializeDuplicates() {
        BodyDeclaration bodyDeclaration = this.fAnalyzer.getEnclosingBodyDeclaration();
        while (!(bodyDeclaration instanceof CompilationUnit || bodyDeclaration instanceof AbstractTypeDeclaration || bodyDeclaration instanceof AnonymousClassDeclaration)) {
            bodyDeclaration = bodyDeclaration.getParent();
        }
        this.fDuplicates = SnippetFinder.perform((ASTNode)bodyDeclaration, this.fAnalyzer.getSelectedNodes());
        this.fReplaceDuplicates = this.fDuplicates.length > 0 && !this.fAnalyzer.isLiteralNodeSelected();
    }

    private void initializeDestinations() {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        BodyDeclaration bodyDeclaration = this.fAnalyzer.getEnclosingBodyDeclaration();
        ASTNode aSTNode = this.getNextParent((ASTNode)bodyDeclaration);
        arrayList.add(aSTNode);
        if (bodyDeclaration instanceof MethodDeclaration) {
            ITypeBinding iTypeBinding = ASTNodes.getEnclosingType(aSTNode);
            ASTNode aSTNode2 = this.getNextParent(aSTNode);
            while (aSTNode2 != null && iTypeBinding != null && iTypeBinding.isNested() && !Modifier.isStatic((int)iTypeBinding.getDeclaredModifiers())) {
                arrayList.add(aSTNode2);
                aSTNode = aSTNode2;
                iTypeBinding = ASTNodes.getEnclosingType(aSTNode);
                aSTNode2 = this.getNextParent(aSTNode2);
            }
        }
        this.fDestinations = arrayList.toArray(new ASTNode[arrayList.size()]);
        this.fDestination = this.fDestinations[this.fDestinationIndex];
    }

    private ASTNode getNextParent(ASTNode aSTNode) {
        while (!((aSTNode = aSTNode.getParent()) == null || aSTNode instanceof CompilationUnit || aSTNode instanceof AbstractTypeDeclaration || aSTNode instanceof AnonymousClassDeclaration)) {
        }
        return aSTNode;
    }

    private RefactoringStatus mergeTextSelectionStatus(RefactoringStatus refactoringStatus) {
        refactoringStatus.addFatalError(RefactoringCoreMessages.ExtractMethodRefactoring_no_set_of_statements);
        return refactoringStatus;
    }

    private String getType(VariableDeclaration variableDeclaration, boolean bl) {
        String string = ASTNodes.asString((ASTNode)ASTNodeFactory.newType(variableDeclaration.getAST(), variableDeclaration));
        if (bl) {
            return String.valueOf(string) + "...";
        }
        return string;
    }

    private ASTNode[] createCallNodes(SnippetFinder.Match match) {
        MethodInvocation methodInvocation;
        ArrayList<Object> arrayList = new ArrayList<Object>(2);
        IVariableBinding[] iVariableBindingArray = this.fAnalyzer.getCallerLocals();
        int n = 0;
        while (n < iVariableBindingArray.length) {
            arrayList.add(this.createDeclaration(iVariableBindingArray[n], null));
            ++n;
        }
        MethodInvocation methodInvocation2 = this.fAST.newMethodInvocation();
        methodInvocation2.setName(this.fAST.newSimpleName(this.fMethodName));
        List list = methodInvocation2.arguments();
        int n2 = 0;
        while (n2 < this.fParameterInfos.size()) {
            ParameterInfo parameterInfo = (ParameterInfo)this.fParameterInfos.get(n2);
            list.add(ASTNodeFactory.newName(this.fAST, this.getMappedName(match, parameterInfo)));
            ++n2;
        }
        int n3 = this.fAnalyzer.getReturnKind();
        switch (n3) {
            case 2: {
                IVariableBinding iVariableBinding = this.fAnalyzer.getReturnLocal();
                if (iVariableBinding != null) {
                    VariableDeclarationStatement variableDeclarationStatement = this.createDeclaration(this.getMappedBinding(match, iVariableBinding), (Expression)methodInvocation2);
                    methodInvocation = variableDeclarationStatement;
                    break;
                }
                Assignment assignment = this.fAST.newAssignment();
                assignment.setLeftHandSide((Expression)ASTNodeFactory.newName(this.fAST, this.getMappedBinding(match, this.fAnalyzer.getReturnValue()).getName()));
                assignment.setRightHandSide((Expression)methodInvocation2);
                methodInvocation = assignment;
                break;
            }
            case 4: {
                ReturnStatement returnStatement = this.fAST.newReturnStatement();
                returnStatement.setExpression((Expression)methodInvocation2);
                methodInvocation = returnStatement;
                break;
            }
            default: {
                methodInvocation = methodInvocation2;
            }
        }
        if (methodInvocation instanceof Expression && !this.fAnalyzer.isExpressionSelected()) {
            methodInvocation = this.fAST.newExpressionStatement((Expression)methodInvocation);
        }
        arrayList.add(methodInvocation);
        if (n3 == 3 && !this.fAnalyzer.isLastStatementSelected()) {
            arrayList.add(this.fAST.newReturnStatement());
        }
        return arrayList.toArray(new ASTNode[arrayList.size()]);
    }

    private IVariableBinding getMappedBinding(SnippetFinder.Match match, IVariableBinding iVariableBinding) {
        if (match == null) {
            return iVariableBinding;
        }
        return match.getMappedBinding(iVariableBinding);
    }

    private String getMappedName(SnippetFinder.Match match, ParameterInfo parameterInfo) {
        if (match == null) {
            return parameterInfo.getOldName();
        }
        return match.getMappedName(parameterInfo.getOldBinding()).getIdentifier();
    }

    private void replaceDuplicates(CompilationUnitChange compilationUnitChange) {
        int n = this.getNumberOfDuplicates();
        if (n == 0 || !this.fReplaceDuplicates) {
            return;
        }
        String string = null;
        string = n == 1 ? Messages.format(RefactoringCoreMessages.ExtractMethodRefactoring_duplicates_single, this.fMethodName) : Messages.format(RefactoringCoreMessages.ExtractMethodRefactoring_duplicates_multi, this.fMethodName);
        TextEditGroup textEditGroup = new TextEditGroup(string);
        compilationUnitChange.addTextEditGroup(textEditGroup);
        int n2 = 0;
        while (n2 < this.fDuplicates.length) {
            SnippetFinder.Match match = this.fDuplicates[n2];
            if (!match.isMethodBody()) {
                ASTNode[] aSTNodeArray = this.createCallNodes(match);
                new StatementRewrite(this.fRewriter, match.getNodes()).replace(aSTNodeArray, textEditGroup);
            }
            ++n2;
        }
    }

    private MethodDeclaration createNewMethod(String string, boolean bl, ASTNode[] aSTNodeArray, String string2, TextEditGroup textEditGroup) throws CoreException, BadLocationException {
        SingleVariableDeclaration singleVariableDeclaration;
        ITypeBinding[] iTypeBindingArray;
        MethodDeclaration methodDeclaration = this.fAST.newMethodDeclaration();
        int n = this.fVisibility;
        if (Modifier.isStatic((int)this.fAnalyzer.getEnclosingBodyDeclaration().getModifiers()) || this.fAnalyzer.getForceStatic()) {
            n |= 8;
        }
        ITypeBinding[] iTypeBindingArray2 = this.computeLocalTypeVariables();
        List list = methodDeclaration.typeParameters();
        int n2 = 0;
        while (n2 < iTypeBindingArray2.length) {
            TypeParameter typeParameter = this.fAST.newTypeParameter();
            typeParameter.setName(this.fAST.newSimpleName(iTypeBindingArray2[n2].getName()));
            list.add(typeParameter);
            ++n2;
        }
        methodDeclaration.modifiers().addAll(ASTNodeFactory.newModifiers(this.fAST, n));
        methodDeclaration.setReturnType2((Type)ASTNode.copySubtree((AST)this.fAST, (ASTNode)this.fAnalyzer.getReturnType()));
        methodDeclaration.setName(this.fAST.newSimpleName(string));
        List list2 = methodDeclaration.parameters();
        int n3 = 0;
        while (n3 < this.fParameterInfos.size()) {
            iTypeBindingArray = (ITypeBinding[])this.fParameterInfos.get(n3);
            VariableDeclaration variableDeclaration = this.getVariableDeclaration((ParameterInfo)iTypeBindingArray);
            singleVariableDeclaration = this.fAST.newSingleVariableDeclaration();
            singleVariableDeclaration.modifiers().addAll(ASTNodeFactory.newModifiers(this.fAST, ASTNodes.getModifiers(variableDeclaration)));
            singleVariableDeclaration.setType(ASTNodeFactory.newType(this.fAST, variableDeclaration));
            singleVariableDeclaration.setName(this.fAST.newSimpleName(iTypeBindingArray.getNewName()));
            singleVariableDeclaration.setVarargs(iTypeBindingArray.isNewVarargs());
            list2.add(singleVariableDeclaration);
            ++n3;
        }
        List list3 = methodDeclaration.thrownExceptions();
        iTypeBindingArray = this.fAnalyzer.getExceptions(this.fThrowRuntimeExceptions, this.fAST);
        int n4 = 0;
        while (n4 < iTypeBindingArray.length) {
            singleVariableDeclaration = iTypeBindingArray[n4];
            list3.add(ASTNodeFactory.newName(this.fAST, this.fImportRewriter.addImport((ITypeBinding)singleVariableDeclaration)));
            ++n4;
        }
        if (bl) {
            methodDeclaration.setBody(this.createMethodBody(methodDeclaration, aSTNodeArray, textEditGroup));
            if (this.fGenerateJavadoc) {
                AbstractTypeDeclaration abstractTypeDeclaration;
                String string3;
                BodyDeclaration bodyDeclaration = this.fAnalyzer.getEnclosingBodyDeclaration();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((string3 = CodeGeneration.getMethodComment(this.fCUnit, (String)(singleVariableDeclaration = (abstractTypeDeclaration = (AbstractTypeDeclaration)ASTNodes.getParent((ASTNode)bodyDeclaration, clazz)) != null ? abstractTypeDeclaration.getName().getIdentifier() : null), methodDeclaration, null, string2)) != null) {
                    Javadoc javadoc = (Javadoc)this.fRewriter.createStringPlaceholder(string3, 29);
                    methodDeclaration.setJavadoc(javadoc);
                }
            }
        }
        return methodDeclaration;
    }

    private ITypeBinding[] computeLocalTypeVariables() {
        ArrayList<ITypeBinding> arrayList = new ArrayList<ITypeBinding>(Arrays.asList(this.fAnalyzer.getTypeVariables()));
        int n = 0;
        while (n < this.fParameterInfos.size()) {
            ParameterInfo parameterInfo = (ParameterInfo)this.fParameterInfos.get(n);
            this.processVariable(arrayList, parameterInfo.getOldBinding());
            ++n;
        }
        IVariableBinding[] iVariableBindingArray = this.fAnalyzer.getMethodLocals();
        int n2 = 0;
        while (n2 < iVariableBindingArray.length) {
            this.processVariable(arrayList, iVariableBindingArray[n2]);
            ++n2;
        }
        return arrayList.toArray(new ITypeBinding[arrayList.size()]);
    }

    private void processVariable(List list, IVariableBinding iVariableBinding) {
        if (iVariableBinding == null) {
            return;
        }
        ITypeBinding iTypeBinding = iVariableBinding.getType();
        if (iTypeBinding != null && iTypeBinding.isParameterizedType()) {
            ITypeBinding[] iTypeBindingArray = iTypeBinding.getTypeArguments();
            int n = 0;
            while (n < iTypeBindingArray.length) {
                ASTNode aSTNode;
                ITypeBinding iTypeBinding2 = iTypeBindingArray[n];
                if (iTypeBinding2.isTypeVariable() && !list.contains(iTypeBinding2) && (aSTNode = this.fRoot.findDeclaringNode((IBinding)iTypeBinding2)) != null && aSTNode.getParent() instanceof MethodDeclaration) {
                    list.add(iTypeBinding2);
                }
                ++n;
            }
        }
    }

    private Block createMethodBody(MethodDeclaration methodDeclaration, ASTNode[] aSTNodeArray, TextEditGroup textEditGroup) throws BadLocationException, CoreException {
        ITypeBinding iTypeBinding;
        ASTNode[] aSTNodeArray2;
        Block block = this.fAST.newBlock();
        ListRewrite listRewrite = this.fRewriter.getListRewrite((ASTNode)block, Block.STATEMENTS_PROPERTY);
        IVariableBinding[] iVariableBindingArray = this.fAnalyzer.getMethodLocals();
        int n = 0;
        while (n < iVariableBindingArray.length) {
            if (iVariableBindingArray[n] != null) {
                block.statements().add(this.createDeclaration(iVariableBindingArray[n], null));
            }
            ++n;
        }
        Iterator iterator = this.fParameterInfos.iterator();
        while (iterator.hasNext()) {
            aSTNodeArray2 = (ASTNode[])iterator.next();
            if (!aSTNodeArray2.isRenamed()) continue;
            int n2 = 0;
            while (n2 < aSTNodeArray.length) {
                iTypeBinding = LinkedNodeFinder.findByBinding(aSTNodeArray[n2], (IBinding)aSTNodeArray2.getOldBinding());
                int n3 = 0;
                while (n3 < ((ITypeBinding)iTypeBinding).length) {
                    this.fRewriter.replace((ASTNode)iTypeBinding[n3], (ASTNode)this.fAST.newSimpleName(aSTNodeArray2.getNewName()), null);
                    ++n3;
                }
                ++n2;
            }
        }
        boolean bl = this.fAnalyzer.isExpressionSelected();
        aSTNodeArray2 = this.createCallNodes(null);
        ASTNode aSTNode = aSTNodeArray2.length == 1 ? aSTNodeArray2[0] : this.fRewriter.createGroupNode(aSTNodeArray2);
        if (bl) {
            iTypeBinding = this.fAnalyzer.getExpressionBinding();
            if (!(iTypeBinding == null || iTypeBinding.isPrimitive() && "void".equals(iTypeBinding.getName()))) {
                ReturnStatement returnStatement = this.fAST.newReturnStatement();
                returnStatement.setExpression((Expression)this.fRewriter.createMoveTarget(aSTNodeArray[0]));
                listRewrite.insertLast((ASTNode)returnStatement, null);
            } else {
                ExpressionStatement expressionStatement = this.fAST.newExpressionStatement((Expression)this.fRewriter.createMoveTarget(aSTNodeArray[0]));
                listRewrite.insertLast((ASTNode)expressionStatement, null);
            }
            this.fRewriter.replace(aSTNodeArray[0], aSTNode, textEditGroup);
        } else {
            if (aSTNodeArray.length == 1) {
                listRewrite.insertLast(this.fRewriter.createMoveTarget(aSTNodeArray[0]), textEditGroup);
                this.fRewriter.replace(aSTNodeArray[0], aSTNode, textEditGroup);
            } else {
                iTypeBinding = this.fRewriter.getListRewrite(aSTNodeArray[0].getParent(), (ChildListPropertyDescriptor)aSTNodeArray[0].getLocationInParent());
                ASTNode aSTNode2 = iTypeBinding.createMoveTarget(aSTNodeArray[0], aSTNodeArray[aSTNodeArray.length - 1], aSTNode, textEditGroup);
                listRewrite.insertLast(aSTNode2, textEditGroup);
            }
            iTypeBinding = this.fAnalyzer.getReturnValue();
            if (iTypeBinding != null) {
                ReturnStatement returnStatement = this.fAST.newReturnStatement();
                returnStatement.setExpression((Expression)this.fAST.newSimpleName(this.getName((IVariableBinding)iTypeBinding)));
                listRewrite.insertLast((ASTNode)returnStatement, null);
            }
        }
        return block;
    }

    private String getName(IVariableBinding iVariableBinding) {
        Iterator iterator = this.fParameterInfos.iterator();
        while (iterator.hasNext()) {
            ParameterInfo parameterInfo = (ParameterInfo)iterator.next();
            if (!Bindings.equals((IBinding)iVariableBinding, (IBinding)parameterInfo.getOldBinding())) continue;
            return parameterInfo.getNewName();
        }
        return iVariableBinding.getName();
    }

    private VariableDeclaration getVariableDeclaration(ParameterInfo parameterInfo) {
        return ASTNodes.findVariableDeclaration(parameterInfo.getOldBinding(), (ASTNode)this.fAnalyzer.getEnclosingBodyDeclaration());
    }

    private VariableDeclarationStatement createDeclaration(IVariableBinding iVariableBinding, Expression expression) {
        VariableDeclaration variableDeclaration = ASTNodes.findVariableDeclaration(iVariableBinding, (ASTNode)this.fAnalyzer.getEnclosingBodyDeclaration());
        VariableDeclarationFragment variableDeclarationFragment = this.fAST.newVariableDeclarationFragment();
        variableDeclarationFragment.setName((SimpleName)ASTNode.copySubtree((AST)this.fAST, (ASTNode)variableDeclaration.getName()));
        variableDeclarationFragment.setInitializer(expression);
        VariableDeclarationStatement variableDeclarationStatement = this.fAST.newVariableDeclarationStatement(variableDeclarationFragment);
        variableDeclarationStatement.modifiers().addAll(ASTNode.copySubtrees((AST)this.fAST, (List)ASTNodes.getModifiers(variableDeclaration)));
        variableDeclarationStatement.setType(ASTNodeFactory.newType(this.fAST, variableDeclaration));
        return variableDeclarationStatement;
    }

    public ICompilationUnit getCompilationUnit() {
        return this.fCUnit;
    }

    public RefactoringStatus initialize(RefactoringArguments refactoringArguments) {
        String string;
        if (refactoringArguments instanceof JavaRefactoringArguments) {
            String string2;
            String string3;
            Object object;
            int n;
            int n2;
            JavaRefactoringArguments javaRefactoringArguments = (JavaRefactoringArguments)refactoringArguments;
            String string4 = javaRefactoringArguments.getAttribute("selection");
            if (string4 != null) {
                n2 = -1;
                n = -1;
                StringTokenizer stringTokenizer = new StringTokenizer(string4);
                if (stringTokenizer.hasMoreTokens()) {
                    n2 = Integer.valueOf(stringTokenizer.nextToken());
                }
                if (stringTokenizer.hasMoreTokens()) {
                    n = Integer.valueOf(stringTokenizer.nextToken());
                }
                if (n2 < 0 || n < 0) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new Object[]{string4, "selection"}));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "selection"));
            }
            this.fSelectionStart = n2;
            this.fSelectionLength = n;
            String string5 = javaRefactoringArguments.getAttribute("input");
            if (string5 != null) {
                object = JDTRefactoringDescriptor.handleToElement(javaRefactoringArguments.getProject(), string5, false);
                if (object == null || !object.exists() || object.getElementType() != 5) {
                    return this.createInputFatalStatus(object, "org.eclipse.wst.jsdt.ui.extract.method");
                }
                this.fCUnit = (ICompilationUnit)object;
                try {
                    this.initialize(this.fCUnit);
                }
                catch (CoreException coreException) {
                    JavaPlugin.log(coreException);
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
            }
            object = javaRefactoringArguments.getAttribute(ATTRIBUTE_VISIBILITY);
            if (object != null && !EMPTY.equals(object)) {
                int n3 = 0;
                try {
                    n3 = Integer.parseInt((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_VISIBILITY));
                }
                this.fVisibility = n3;
            }
            if ((string3 = javaRefactoringArguments.getAttribute("name")) == null || EMPTY.equals(string3)) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
            }
            this.fMethodName = string3;
            String string6 = javaRefactoringArguments.getAttribute(ATTRIBUTE_DESTINATION);
            if (string6 != null && !EMPTY.equals(string6)) {
                int n4 = 0;
                try {
                    n4 = Integer.parseInt(string6);
                }
                catch (NumberFormatException numberFormatException) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_DESTINATION));
                }
                this.fDestinationIndex = n4;
            }
            if ((string2 = javaRefactoringArguments.getAttribute(ATTRIBUTE_REPLACE)) == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_REPLACE));
            }
            this.fReplaceDuplicates = Boolean.valueOf(string2);
            String string7 = javaRefactoringArguments.getAttribute(ATTRIBUTE_COMMENTS);
            if (string7 == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_COMMENTS));
            }
            this.fGenerateJavadoc = Boolean.valueOf(string7);
            string = javaRefactoringArguments.getAttribute(ATTRIBUTE_EXCEPTIONS);
            if (string == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_EXCEPTIONS));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        this.fThrowRuntimeExceptions = Boolean.valueOf(string);
        return new RefactoringStatus();
    }

    private static class UsedNamesCollector
    extends ASTVisitor {
        private Set result = new HashSet();
        private Set fIgnore = new HashSet();

        private UsedNamesCollector() {
        }

        public static Set perform(ASTNode[] aSTNodeArray) {
            UsedNamesCollector usedNamesCollector = new UsedNamesCollector();
            int n = 0;
            while (n < aSTNodeArray.length) {
                aSTNodeArray[n].accept((ASTVisitor)usedNamesCollector);
                ++n;
            }
            return usedNamesCollector.result;
        }

        public boolean visit(FieldAccess fieldAccess) {
            Expression expression = fieldAccess.getExpression();
            if (expression != null) {
                this.fIgnore.add(fieldAccess.getName());
            }
            return true;
        }

        public void endVisit(FieldAccess fieldAccess) {
            this.fIgnore.remove(fieldAccess.getName());
        }

        public boolean visit(MethodInvocation methodInvocation) {
            SimpleName simpleName;
            Expression expression = methodInvocation.getExpression();
            if (expression != null && (simpleName = methodInvocation.getName()) != null) {
                this.fIgnore.add(simpleName);
            }
            return true;
        }

        public void endVisit(MethodInvocation methodInvocation) {
            SimpleName simpleName = methodInvocation.getName();
            if (simpleName != null) {
                this.fIgnore.remove(simpleName);
            }
        }

        public boolean visit(QualifiedName qualifiedName) {
            this.fIgnore.add(qualifiedName.getName());
            return true;
        }

        public void endVisit(QualifiedName qualifiedName) {
            this.fIgnore.remove(qualifiedName.getName());
        }

        public boolean visit(SimpleName simpleName) {
            if (!this.fIgnore.contains(simpleName)) {
                this.result.add(simpleName.getIdentifier());
            }
            return true;
        }

        public boolean visit(TypeDeclaration typeDeclaration) {
            return this.visitType((AbstractTypeDeclaration)typeDeclaration);
        }

        public boolean visit(AnnotationTypeDeclaration annotationTypeDeclaration) {
            return this.visitType((AbstractTypeDeclaration)annotationTypeDeclaration);
        }

        public boolean visit(EnumDeclaration enumDeclaration) {
            return this.visitType((AbstractTypeDeclaration)enumDeclaration);
        }

        private boolean visitType(AbstractTypeDeclaration abstractTypeDeclaration) {
            this.result.add(abstractTypeDeclaration.getName().getIdentifier());
            return false;
        }
    }
}

