/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.code;

import java.util.HashMap;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.RangeMarker;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.ArrayCreation;
import org.eclipse.wst.jsdt.core.dom.ArrayInitializer;
import org.eclipse.wst.jsdt.core.dom.ArrayType;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.ParenthesizedExpression;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.internal.corext.SourceRange;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.CodeRefactoringUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.Invocations;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.TempAssignmentFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.TempDeclarationFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.TempOccurrenceAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public class InlineTempRefactoring
extends ScriptableRefactoring {
    private int fSelectionStart;
    private int fSelectionLength;
    private ICompilationUnit fCu;
    private VariableDeclaration fVariableDeclaration;
    private SimpleName[] fReferences;
    private CompilationUnit fASTRoot;

    public InlineTempRefactoring(ICompilationUnit iCompilationUnit, CompilationUnit compilationUnit, int n, int n2) {
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        Assert.isTrue((n2 >= 0 ? 1 : 0) != 0);
        this.fSelectionStart = n;
        this.fSelectionLength = n2;
        this.fCu = iCompilationUnit;
        this.fASTRoot = compilationUnit;
        this.fVariableDeclaration = null;
    }

    public InlineTempRefactoring(ICompilationUnit iCompilationUnit, int n, int n2) {
        this(iCompilationUnit, null, n, n2);
    }

    public InlineTempRefactoring(VariableDeclaration variableDeclaration) {
        this.fVariableDeclaration = variableDeclaration;
        ASTNode aSTNode = variableDeclaration.getRoot();
        Assert.isTrue((boolean)(aSTNode instanceof CompilationUnit));
        this.fASTRoot = (CompilationUnit)aSTNode;
        Assert.isTrue((boolean)(this.fASTRoot.getJavaElement() instanceof ICompilationUnit));
        this.fSelectionStart = variableDeclaration.getStartPosition();
        this.fSelectionLength = variableDeclaration.getLength();
        this.fCu = (ICompilationUnit)this.fASTRoot.getJavaElement();
    }

    public RefactoringStatus checkIfTempSelected() {
        VariableDeclaration variableDeclaration = this.getVariableDeclaration();
        if (variableDeclaration == null) {
            return CodeRefactoringUtil.checkMethodSyntaxErrors(this.fSelectionStart, this.fSelectionLength, this.getASTRoot(), RefactoringCoreMessages.InlineTempRefactoring_select_temp);
        }
        if (variableDeclaration.getParent() instanceof FieldDeclaration) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InlineTemRefactoring_error_message_fieldsCannotBeInlined);
        }
        return new RefactoringStatus();
    }

    private CompilationUnit getASTRoot() {
        if (this.fASTRoot == null) {
            this.fASTRoot = RefactoringASTParser.parseWithASTProvider((ITypeRoot)this.fCu, true, null);
        }
        return this.fASTRoot;
    }

    public VariableDeclaration getVariableDeclaration() {
        if (this.fVariableDeclaration == null) {
            this.fVariableDeclaration = TempDeclarationFinder.findTempDeclaration(this.getASTRoot(), this.fSelectionStart, this.fSelectionLength);
        }
        return this.fVariableDeclaration;
    }

    public String getName() {
        return RefactoringCoreMessages.InlineTempRefactoring_name;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor iProgressMonitor) throws CoreException {
        VariableDeclaration variableDeclaration;
        RefactoringStatus refactoringStatus;
        block5: {
            block4: {
                RefactoringStatus refactoringStatus2;
                try {
                    iProgressMonitor.beginTask("", 1);
                    refactoringStatus = Checks.validateModifiesFiles(ResourceUtil.getFiles(new ICompilationUnit[]{this.fCu}), this.getValidationContext());
                    if (!refactoringStatus.hasFatalError()) break block4;
                    refactoringStatus2 = refactoringStatus;
                    Object var4_6 = null;
                }
                catch (Throwable throwable) {
                    Object var4_9 = null;
                    iProgressMonitor.done();
                    throw throwable;
                }
                iProgressMonitor.done();
                return refactoringStatus2;
            }
            variableDeclaration = this.getVariableDeclaration();
            refactoringStatus.merge(this.checkSelection(variableDeclaration));
            if (!refactoringStatus.hasFatalError()) break block5;
            RefactoringStatus refactoringStatus3 = refactoringStatus;
            Object var4_7 = null;
            iProgressMonitor.done();
            return refactoringStatus3;
        }
        refactoringStatus.merge(this.checkInitializer(variableDeclaration));
        RefactoringStatus refactoringStatus4 = refactoringStatus;
        Object var4_8 = null;
        iProgressMonitor.done();
        return refactoringStatus4;
    }

    private RefactoringStatus checkInitializer(VariableDeclaration variableDeclaration) {
        if (variableDeclaration.getInitializer().getNodeType() == 33) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InlineTemRefactoring_error_message_nulLiteralsCannotBeInlined);
        }
        return null;
    }

    private RefactoringStatus checkSelection(VariableDeclaration variableDeclaration) {
        ASTNode aSTNode = variableDeclaration.getParent();
        if (aSTNode instanceof MethodDeclaration) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InlineTempRefactoring_method_parameter);
        }
        if (aSTNode instanceof CatchClause) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InlineTempRefactoring_exceptions_declared);
        }
        if (aSTNode instanceof VariableDeclarationExpression && aSTNode.getLocationInParent() == ForStatement.INITIALIZERS_PROPERTY) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InlineTempRefactoring_for_initializers);
        }
        if (variableDeclaration.getInitializer() == null) {
            String string = Messages.format(RefactoringCoreMessages.InlineTempRefactoring_not_initialized, variableDeclaration.getName().getIdentifier());
            return RefactoringStatus.createFatalErrorStatus((String)string);
        }
        return this.checkAssignments(variableDeclaration);
    }

    private RefactoringStatus checkAssignments(VariableDeclaration variableDeclaration) {
        TempAssignmentFinder tempAssignmentFinder = new TempAssignmentFinder(variableDeclaration);
        this.getASTRoot().accept((ASTVisitor)tempAssignmentFinder);
        if (!tempAssignmentFinder.hasAssignments()) {
            return new RefactoringStatus();
        }
        ASTNode aSTNode = tempAssignmentFinder.getFirstAssignment();
        int n = aSTNode.getStartPosition();
        int n2 = aSTNode.getLength();
        SourceRange sourceRange = new SourceRange(n, n2);
        RefactoringStatusContext refactoringStatusContext = JavaStatusContext.create((ITypeRoot)this.fCu, sourceRange);
        String string = Messages.format(RefactoringCoreMessages.InlineTempRefactoring_assigned_more_once, variableDeclaration.getName().getIdentifier());
        return RefactoringStatus.createFatalErrorStatus((String)string, (RefactoringStatusContext)refactoringStatusContext);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor iProgressMonitor) throws CoreException {
        RefactoringStatus refactoringStatus;
        try {
            iProgressMonitor.beginTask("", 1);
            refactoringStatus = new RefactoringStatus();
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return refactoringStatus;
    }

    public Change createChange(IProgressMonitor iProgressMonitor) throws CoreException {
        CompilationUnitChange compilationUnitChange;
        try {
            iProgressMonitor.beginTask(RefactoringCoreMessages.InlineTempRefactoring_preview, 2);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String string = null;
            IJavaProject iJavaProject = this.fCu.getJavaProject();
            if (iJavaProject != null) {
                string = iJavaProject.getElementName();
            }
            IVariableBinding iVariableBinding = this.getVariableDeclaration().resolveBinding();
            String string2 = null;
            IMethodBinding iMethodBinding = iVariableBinding.getDeclaringMethod();
            string2 = iMethodBinding != null ? BindingLabelProvider.getBindingLabel((IBinding)iMethodBinding, JavaElementLabels.ALL_FULLY_QUALIFIED) : "{...}";
            String string3 = Messages.format(RefactoringCoreMessages.InlineTempRefactoring_descriptor_description_short, iVariableBinding.getName());
            String string4 = Messages.format(RefactoringCoreMessages.InlineTempRefactoring_descriptor_description, new String[]{BindingLabelProvider.getBindingLabel((IBinding)iVariableBinding, JavaElementLabels.ALL_FULLY_QUALIFIED), string2});
            JDTRefactoringDescriptorComment jDTRefactoringDescriptorComment = new JDTRefactoringDescriptorComment(string, this, string4);
            jDTRefactoringDescriptorComment.addSetting(Messages.format(RefactoringCoreMessages.InlineTempRefactoring_original_pattern, BindingLabelProvider.getBindingLabel((IBinding)iVariableBinding, JavaElementLabels.ALL_FULLY_QUALIFIED)));
            JDTRefactoringDescriptor jDTRefactoringDescriptor = new JDTRefactoringDescriptor("org.eclipse.wst.jsdt.ui.inline.temp", string, string3, jDTRefactoringDescriptorComment.asString(), hashMap, 0);
            hashMap.put("input", jDTRefactoringDescriptor.elementToHandle((IJavaElement)this.fCu));
            hashMap.put("selection", String.valueOf(String.valueOf(this.fSelectionStart)) + ' ' + String.valueOf(this.fSelectionLength));
            CompilationUnitRewrite compilationUnitRewrite = new CompilationUnitRewrite(this.fCu, this.fASTRoot);
            this.inlineTemp(compilationUnitRewrite);
            this.removeTemp(compilationUnitRewrite);
            CompilationUnitChange compilationUnitChange2 = compilationUnitRewrite.createChange(RefactoringCoreMessages.InlineTempRefactoring_inline, false, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            compilationUnitChange2.setDescriptor((ChangeDescriptor)new RefactoringChangeDescriptor((RefactoringDescriptor)jDTRefactoringDescriptor));
            compilationUnitChange = compilationUnitChange2;
            Object var14_15 = null;
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return compilationUnitChange;
    }

    private void inlineTemp(CompilationUnitRewrite compilationUnitRewrite) throws JavaModelException {
        SimpleName[] simpleNameArray = this.getReferences();
        TextEditGroup textEditGroup = compilationUnitRewrite.createGroupDescription(RefactoringCoreMessages.InlineTempRefactoring_inline_edit_name);
        ASTRewrite aSTRewrite = compilationUnitRewrite.getASTRewrite();
        int n = 0;
        while (n < simpleNameArray.length) {
            SimpleName simpleName = simpleNameArray[n];
            Expression expression = this.getInitializerSource(compilationUnitRewrite, simpleName);
            aSTRewrite.replace((ASTNode)simpleName, (ASTNode)expression, textEditGroup);
            ++n;
        }
    }

    private boolean needsBrackets(SimpleName simpleName, VariableDeclaration variableDeclaration) {
        Expression expression = variableDeclaration.getInitializer();
        if (expression instanceof Assignment) {
            return true;
        }
        return ASTNodes.substituteMustBeParenthesized(expression, (Expression)simpleName);
    }

    private void removeTemp(CompilationUnitRewrite compilationUnitRewrite) throws JavaModelException {
        VariableDeclaration variableDeclaration = this.getVariableDeclaration();
        TextEditGroup textEditGroup = compilationUnitRewrite.createGroupDescription(RefactoringCoreMessages.InlineTempRefactoring_remove_edit_name);
        ASTNode aSTNode = variableDeclaration.getParent();
        ASTRewrite aSTRewrite = compilationUnitRewrite.getASTRewrite();
        if (aSTNode instanceof VariableDeclarationStatement && ((VariableDeclarationStatement)aSTNode).fragments().size() == 1) {
            aSTRewrite.remove(aSTNode, textEditGroup);
        } else {
            aSTRewrite.remove((ASTNode)variableDeclaration, textEditGroup);
        }
    }

    private Expression getInitializerSource(CompilationUnitRewrite compilationUnitRewrite, SimpleName simpleName) throws JavaModelException {
        Expression expression = this.getModifiedInitializerSource(compilationUnitRewrite, simpleName);
        boolean bl = this.needsBrackets(simpleName, this.getVariableDeclaration());
        if (bl) {
            ParenthesizedExpression parenthesizedExpression = compilationUnitRewrite.getAST().newParenthesizedExpression();
            parenthesizedExpression.setExpression(expression);
            return parenthesizedExpression;
        }
        return expression;
    }

    private Expression getModifiedInitializerSource(CompilationUnitRewrite compilationUnitRewrite, SimpleName simpleName) throws JavaModelException {
        VariableDeclaration variableDeclaration = this.getVariableDeclaration();
        Expression expression = variableDeclaration.getInitializer();
        ASTNode aSTNode = simpleName.getParent();
        if (InlineTempRefactoring.isInvocation(expression) && Invocations.isResolvedTypeInferredFromExpectedType(expression) && !(aSTNode instanceof VariableDeclarationFragment) && !(aSTNode instanceof SingleVariableDeclaration) && !(aSTNode instanceof Assignment)) {
            IMethodBinding iMethodBinding = Invocations.resolveBinding((ASTNode)expression);
            ITypeBinding[] iTypeBindingArray = iMethodBinding.getTypeArguments();
            Type[] typeArray = new Type[iTypeBindingArray.length];
            int n = 0;
            while (n < iTypeBindingArray.length) {
                typeArray[n] = compilationUnitRewrite.getImportRewrite().addImport(iTypeBindingArray[n], compilationUnitRewrite.getAST());
                ++n;
            }
            String string = this.createParameterizedInvocation(expression, typeArray);
            return (Expression)compilationUnitRewrite.getASTRewrite().createStringPlaceholder(string, expression.getNodeType());
        }
        Expression expression2 = (Expression)compilationUnitRewrite.getASTRewrite().createCopyTarget((ASTNode)expression);
        if (expression instanceof ArrayInitializer && ASTNodes.getDimensions(variableDeclaration) > 0) {
            ArrayType arrayType = (ArrayType)ASTNodeFactory.newType(compilationUnitRewrite.getAST(), variableDeclaration);
            ArrayCreation arrayCreation = compilationUnitRewrite.getAST().newArrayCreation();
            arrayCreation.setType(arrayType);
            arrayCreation.setInitializer((ArrayInitializer)expression2);
            return arrayCreation;
        }
        return expression2;
    }

    private String createParameterizedInvocation(Expression expression, Type[] typeArray) throws JavaModelException {
        ASTRewrite aSTRewrite = ASTRewrite.create((AST)expression.getAST());
        ListRewrite listRewrite = aSTRewrite.getListRewrite((ASTNode)expression, Invocations.getTypeArgumentsProperty(expression));
        int n = 0;
        while (n < typeArray.length) {
            listRewrite.insertLast((ASTNode)typeArray[n], null);
            ++n;
        }
        Document document = new Document(this.fCu.getBuffer().getContents());
        RangeMarker rangeMarker = new RangeMarker(expression.getStartPosition(), expression.getLength());
        IJavaProject iJavaProject = this.fCu.getJavaProject();
        TextEdit[] textEditArray = aSTRewrite.rewriteAST((IDocument)document, iJavaProject.getOptions(true)).removeChildren();
        rangeMarker.addChildren(textEditArray);
        try {
            rangeMarker.apply((IDocument)document, 2);
            String string = document.get(rangeMarker.getOffset(), rangeMarker.getLength());
            IRegion iRegion = document.getLineInformation(document.getLineOfOffset(rangeMarker.getOffset()));
            int n2 = Strings.computeIndentUnits(document.get(iRegion.getOffset(), iRegion.getLength()), iJavaProject);
            return Strings.changeIndent(string, n2, iJavaProject, "", TextUtilities.getDefaultLineDelimiter((IDocument)document));
        }
        catch (MalformedTreeException malformedTreeException) {
            JavaPlugin.log(malformedTreeException);
        }
        catch (BadLocationException badLocationException) {
            JavaPlugin.log(badLocationException);
        }
        return this.fCu.getBuffer().getText(expression.getStartPosition(), expression.getLength());
    }

    private static boolean isInvocation(Expression expression) {
        return expression instanceof MethodInvocation || expression instanceof SuperMethodInvocation;
    }

    public SimpleName[] getReferences() {
        if (this.fReferences != null) {
            return this.fReferences;
        }
        TempOccurrenceAnalyzer tempOccurrenceAnalyzer = new TempOccurrenceAnalyzer(this.getVariableDeclaration(), false);
        tempOccurrenceAnalyzer.perform();
        this.fReferences = tempOccurrenceAnalyzer.getReferenceNodes();
        return this.fReferences;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RefactoringStatus initialize(RefactoringArguments refactoringArguments) {
        if (!(refactoringArguments instanceof JavaRefactoringArguments)) return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        JavaRefactoringArguments javaRefactoringArguments = (JavaRefactoringArguments)refactoringArguments;
        String string = javaRefactoringArguments.getAttribute("selection");
        if (string == null) return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "selection"));
        int n = -1;
        int n2 = -1;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.hasMoreTokens()) {
            n = Integer.valueOf(stringTokenizer.nextToken());
        }
        if (stringTokenizer.hasMoreTokens()) {
            n2 = Integer.valueOf(stringTokenizer.nextToken());
        }
        if (n < 0 || n2 < 0) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new Object[]{string, "selection"}));
        }
        this.fSelectionStart = n;
        this.fSelectionLength = n2;
        String string2 = javaRefactoringArguments.getAttribute("input");
        if (string2 == null) return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
        IJavaElement iJavaElement = JDTRefactoringDescriptor.handleToElement(javaRefactoringArguments.getProject(), string2, false);
        if (iJavaElement == null || !iJavaElement.exists() || iJavaElement.getElementType() != 5) {
            return this.createInputFatalStatus(iJavaElement, "org.eclipse.wst.jsdt.ui.inline.temp");
        }
        this.fCu = (ICompilationUnit)iJavaElement;
        if (!this.checkIfTempSelected().hasFatalError()) return new RefactoringStatus();
        return this.createInputFatalStatus(iJavaElement, "org.eclipse.wst.jsdt.ui.inline.temp");
    }
}

