/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.RangeMarker;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditProcessor;
import org.eclipse.text.edits.UndoEdit;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.ConditionalExpression;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.ForInStatement;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.IfStatement;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.ThisExpression;
import org.eclipse.wst.jsdt.core.dom.WhileStatement;
import org.eclipse.wst.jsdt.core.dom.WithStatement;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.CodeScopeBuilder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.CallContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.Invocations;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ParameterData;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.SourceAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;

public class SourceProvider {
    private ITypeRoot fTypeRoot;
    private IDocument fDocument;
    private MethodDeclaration fDeclaration;
    private SourceAnalyzer fAnalyzer;
    private boolean fMustEvalReturnedExpression;
    private boolean fReturnValueNeedsLocalVariable;
    private List fReturnExpressions;
    private IDocument fSource;
    private static final int EXPRESSION_MODE = 1;
    private static final int STATEMENT_MODE = 2;
    private static final int RETURN_STATEMENT_MODE = 3;
    private int fMarkerMode;

    public SourceProvider(ITypeRoot iTypeRoot, MethodDeclaration methodDeclaration) {
        this.fTypeRoot = iTypeRoot;
        this.fDeclaration = methodDeclaration;
        List list = this.fDeclaration.parameters();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)iterator.next();
            ParameterData parameterData = new ParameterData(singleVariableDeclaration);
            singleVariableDeclaration.setProperty(ParameterData.PROPERTY, (Object)parameterData);
        }
        this.fAnalyzer = new SourceAnalyzer(this.fTypeRoot, this.fDeclaration);
        this.fReturnValueNeedsLocalVariable = true;
        this.fReturnExpressions = new ArrayList();
    }

    public SourceProvider(ITypeRoot iTypeRoot, IDocument iDocument, MethodDeclaration methodDeclaration) {
        this(iTypeRoot, methodDeclaration);
        this.fSource = iDocument;
    }

    public RefactoringStatus checkActivation() throws JavaModelException {
        return this.fAnalyzer.checkActivation();
    }

    public void initialize() throws JavaModelException {
        ASTNode aSTNode;
        this.fDocument = this.fSource == null ? new Document(this.fTypeRoot.getBuffer().getContents()) : this.fSource;
        this.fAnalyzer.initialize();
        if (this.hasReturnValue() && (aSTNode = this.getLastStatement()) != null) {
            ReturnAnalyzer returnAnalyzer = new ReturnAnalyzer();
            aSTNode.accept((ASTVisitor)returnAnalyzer);
        }
    }

    public boolean isExecutionFlowInterrupted() {
        return this.fAnalyzer.isExecutionFlowInterrupted();
    }

    public boolean isVariableReferenced(IVariableBinding iVariableBinding) {
        VariableReferenceFinder variableReferenceFinder = new VariableReferenceFinder(iVariableBinding);
        this.fDeclaration.accept((ASTVisitor)variableReferenceFinder);
        return variableReferenceFinder.getResult();
    }

    public boolean hasReturnValue() {
        IMethodBinding iMethodBinding = this.fDeclaration.resolveBinding();
        return iMethodBinding.getReturnType() != this.fDeclaration.getAST().resolveWellKnownType("void");
    }

    public boolean hasArrayAccess() {
        return this.fAnalyzer.hasArrayAccess();
    }

    public boolean hasSuperMethodInvocation() {
        return this.fAnalyzer.hasSuperMethodInvocation();
    }

    public boolean mustEvaluateReturnedExpression() {
        return this.fMustEvalReturnedExpression;
    }

    public boolean returnValueNeedsLocalVariable() {
        return this.fReturnValueNeedsLocalVariable;
    }

    public int getNumberOfStatements() {
        return this.fDeclaration.getBody().statements().size();
    }

    public boolean isSimpleFunction() {
        List list = this.fDeclaration.getBody().statements();
        if (list.size() != 1) {
            return false;
        }
        return list.get(0) instanceof ReturnStatement;
    }

    public boolean isLastStatementReturn() {
        List list = this.fDeclaration.getBody().statements();
        if (list.size() == 0) {
            return false;
        }
        return list.get(list.size() - 1) instanceof ReturnStatement;
    }

    public boolean isDangligIf() {
        List list = this.fDeclaration.getBody().statements();
        if (list.size() != 1) {
            return false;
        }
        Object e = list.get(0);
        if (!(e instanceof IfStatement)) {
            return false;
        }
        return ((IfStatement)e).getElseStatement() == null;
    }

    public MethodDeclaration getDeclaration() {
        return this.fDeclaration;
    }

    public String getMethodName() {
        return this.fDeclaration.getName().getIdentifier();
    }

    public ITypeBinding getReturnType() {
        return this.fDeclaration.resolveBinding().getReturnType();
    }

    public List getReturnExpressions() {
        return this.fReturnExpressions;
    }

    public boolean returnTypeMatchesReturnExpressions() {
        ITypeBinding iTypeBinding = this.getReturnType();
        Iterator iterator = this.fReturnExpressions.iterator();
        while (iterator.hasNext()) {
            Expression expression = (Expression)iterator.next();
            if (Bindings.equals((IBinding)iTypeBinding, (IBinding)expression.resolveTypeBinding())) continue;
            return false;
        }
        return true;
    }

    public ParameterData getParameterData(int n) {
        SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)this.fDeclaration.parameters().get(n);
        return (ParameterData)singleVariableDeclaration.getProperty(ParameterData.PROPERTY);
    }

    public ITypeRoot getTypeRoot() {
        return this.fTypeRoot;
    }

    public boolean needsReturnedExpressionParenthesis() {
        ASTNode aSTNode = this.getLastStatement();
        if (aSTNode instanceof ReturnStatement) {
            return ASTNodes.needsParentheses(((ReturnStatement)aSTNode).getExpression());
        }
        return false;
    }

    public boolean returnsConditionalExpression() {
        ASTNode aSTNode = this.getLastStatement();
        if (aSTNode instanceof ReturnStatement) {
            return ((ReturnStatement)aSTNode).getExpression() instanceof ConditionalExpression;
        }
        return false;
    }

    public int getReceiversToBeUpdated() {
        return this.fAnalyzer.getImplicitReceivers().size();
    }

    public boolean isVarargs() {
        return this.fDeclaration.isVarargs();
    }

    public int getVarargIndex() {
        return this.fDeclaration.parameters().size() - 1;
    }

    public TextEdit getDeleteEdit() {
        ASTRewrite aSTRewrite = ASTRewrite.create((AST)this.fDeclaration.getAST());
        aSTRewrite.remove((ASTNode)this.fDeclaration, null);
        return aSTRewrite.rewriteAST(this.fDocument, this.fTypeRoot.getJavaProject().getOptions(true));
    }

    public String[] getCodeBlocks(CallContext callContext) throws CoreException {
        TextEdit textEdit;
        TextEdit[] textEditArray;
        ASTNode aSTNode;
        ASTRewrite aSTRewrite = ASTRewrite.create((AST)this.fDeclaration.getAST());
        this.replaceParameterWithExpression(aSTRewrite, callContext.arguments);
        this.updateImplicitReceivers(aSTRewrite, callContext);
        this.makeNamesUnique(aSTRewrite, callContext.scope);
        this.updateTypeReferences(aSTRewrite, callContext);
        this.updateStaticReferences(aSTRewrite, callContext);
        this.updateTypeVariables(aSTRewrite, callContext);
        this.updateMethodTypeVariable(aSTRewrite, callContext);
        List list = null;
        list = this.hasReturnValue() ? (callContext.callMode == 41 ? this.getStatementRanges() : this.getExpressionRanges()) : ((aSTNode = this.getLastStatement()) != null && aSTNode.getNodeType() == 41 ? this.getReturnStatementRanges() : this.getStatementRanges());
        aSTNode = aSTRewrite.rewriteAST(this.fDocument, this.fTypeRoot.getJavaProject().getOptions(true));
        int n = list.size();
        RangeMarker[] rangeMarkerArray = new RangeMarker[n];
        int n2 = 0;
        while (n2 < rangeMarkerArray.length) {
            textEditArray = (TextEdit[])list.get(n2);
            rangeMarkerArray[n2] = new RangeMarker(textEditArray.getOffset(), textEditArray.getLength());
            ++n2;
        }
        if (n <= 1) {
            n2 = Integer.MAX_VALUE;
        } else {
            textEditArray = (IRegion)list.get(0);
            n2 = textEditArray.getOffset() + textEditArray.getLength();
        }
        textEditArray = aSTNode.removeChildren();
        int n3 = 0;
        while (n3 < textEditArray.length) {
            textEdit = textEditArray[n3];
            int n4 = textEdit.getOffset() >= n2 ? 1 : 0;
            rangeMarkerArray[n4].addChild(textEdit);
            ++n3;
        }
        MultiTextEdit multiTextEdit = new MultiTextEdit(0, this.fDocument.getLength());
        multiTextEdit.addChildren((TextEdit[])rangeMarkerArray);
        try {
            textEdit = new TextEditProcessor(this.fDocument, (TextEdit)multiTextEdit, 3);
            UndoEdit undoEdit = textEdit.performEdits();
            String[] stringArray = this.getBlocks(rangeMarkerArray);
            textEdit = new TextEditProcessor(this.fDocument, (TextEdit)undoEdit, 2);
            textEdit.performEdits();
            return stringArray;
        }
        catch (MalformedTreeException malformedTreeException) {
            JavaPlugin.log(malformedTreeException);
        }
        catch (BadLocationException badLocationException) {
            JavaPlugin.log(badLocationException);
        }
        return new String[0];
    }

    private void replaceParameterWithExpression(ASTRewrite aSTRewrite, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            ParameterData parameterData = this.getParameterData(n);
            List list = parameterData.references();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ASTNode aSTNode = (ASTNode)iterator.next();
                ASTNode aSTNode2 = aSTRewrite.createStringPlaceholder(string, aSTNode.getNodeType());
                aSTRewrite.replace(aSTNode, aSTNode2, null);
            }
            ++n;
        }
    }

    private void makeNamesUnique(ASTRewrite aSTRewrite, CodeScopeBuilder.Scope scope) {
        Collection collection = this.fAnalyzer.getUsedNames();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            SourceAnalyzer.NameData nameData = (SourceAnalyzer.NameData)iterator.next();
            if (!scope.isInUse(nameData.getName())) continue;
            String string = scope.createName(nameData.getName(), true);
            List list = nameData.references();
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                SimpleName simpleName = (SimpleName)iterator2.next();
                ASTNode aSTNode = aSTRewrite.createStringPlaceholder(string, 32);
                aSTRewrite.replace((ASTNode)simpleName, aSTNode, null);
            }
        }
    }

    private void updateImplicitReceivers(ASTRewrite aSTRewrite, CallContext callContext) {
        if (callContext.receiver == null) {
            return;
        }
        List list = this.fAnalyzer.getImplicitReceivers();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Expression expression;
            MethodInvocation methodInvocation;
            ASTNode aSTNode = (ASTNode)iterator.next();
            if (aSTNode instanceof MethodInvocation) {
                methodInvocation = (MethodInvocation)aSTNode;
                aSTRewrite.set((ASTNode)methodInvocation, (StructuralPropertyDescriptor)MethodInvocation.EXPRESSION_PROPERTY, (Object)this.createReceiver(aSTRewrite, callContext, (IMethodBinding)methodInvocation.getName().resolveBinding()), null);
                continue;
            }
            if (aSTNode instanceof ClassInstanceCreation) {
                methodInvocation = (ClassInstanceCreation)aSTNode;
                aSTRewrite.set((ASTNode)methodInvocation, (StructuralPropertyDescriptor)ClassInstanceCreation.EXPRESSION_PROPERTY, (Object)this.createReceiver(aSTRewrite, callContext, methodInvocation.resolveConstructorBinding()), null);
                continue;
            }
            if (aSTNode instanceof ThisExpression) {
                aSTRewrite.replace(aSTNode, aSTRewrite.createStringPlaceholder(callContext.receiver, 32), null);
                continue;
            }
            if (aSTNode instanceof FieldAccess) {
                methodInvocation = (FieldAccess)aSTNode;
                aSTRewrite.set((ASTNode)methodInvocation, (StructuralPropertyDescriptor)FieldAccess.EXPRESSION_PROPERTY, (Object)this.createReceiver(aSTRewrite, callContext, methodInvocation.resolveFieldBinding()), null);
                continue;
            }
            if (!(aSTNode instanceof SimpleName) || !(((SimpleName)aSTNode).resolveBinding() instanceof IVariableBinding) || !(methodInvocation = (IVariableBinding)((SimpleName)aSTNode).resolveBinding()).isField() || (expression = this.createReceiver(aSTRewrite, callContext, (IVariableBinding)methodInvocation)) == null) continue;
            FieldAccess fieldAccess = aSTNode.getAST().newFieldAccess();
            ASTNode aSTNode2 = aSTRewrite.createMoveTarget(aSTNode);
            fieldAccess.setName((SimpleName)aSTNode2);
            fieldAccess.setExpression(expression);
            aSTRewrite.replace(aSTNode, (ASTNode)fieldAccess, null);
        }
    }

    private void updateTypeReferences(ASTRewrite aSTRewrite, CallContext callContext) {
        ImportRewrite importRewrite = callContext.importer;
        Iterator iterator = this.fAnalyzer.getTypesToImport().iterator();
        while (iterator.hasNext()) {
            Name name = (Name)iterator.next();
            ITypeBinding iTypeBinding = ASTNodes.getTypeBinding(name);
            if (iTypeBinding == null || iTypeBinding.isLocal()) continue;
            if (iTypeBinding.isParameterizedType()) {
                iTypeBinding = iTypeBinding.getTypeDeclaration();
            }
            String string = importRewrite.addImport(iTypeBinding);
            if (ASTNodes.asString((ASTNode)name).equals(string)) continue;
            aSTRewrite.replace((ASTNode)name, aSTRewrite.createStringPlaceholder(string, 42), null);
        }
    }

    private void updateStaticReferences(ASTRewrite aSTRewrite, CallContext callContext) {
        ImportRewrite importRewrite = callContext.importer;
        Iterator iterator = this.fAnalyzer.getStaticsToImport().iterator();
        while (iterator.hasNext()) {
            Name name = (Name)iterator.next();
            IBinding iBinding = name.resolveBinding();
            if (iBinding == null) continue;
            String string = importRewrite.addStaticImport(iBinding);
            if (ASTNodes.asString((ASTNode)name).equals(string)) continue;
            aSTRewrite.replace((ASTNode)name, aSTRewrite.createStringPlaceholder(string, 42), null);
        }
    }

    private Expression createReceiver(ASTRewrite aSTRewrite, CallContext callContext, IMethodBinding iMethodBinding) {
        String string = this.getReceiver(callContext, iMethodBinding.getModifiers());
        if (string == null) {
            return null;
        }
        return (Expression)aSTRewrite.createStringPlaceholder(string, 32);
    }

    private Expression createReceiver(ASTRewrite aSTRewrite, CallContext callContext, IVariableBinding iVariableBinding) {
        String string = this.getReceiver(callContext, iVariableBinding.getModifiers());
        if (string == null) {
            return null;
        }
        return (Expression)aSTRewrite.createStringPlaceholder(string, 42);
    }

    private String getReceiver(CallContext callContext, int n) {
        String string = callContext.receiver;
        ITypeBinding iTypeBinding = ASTNodes.getEnclosingType(callContext.invocation);
        ITypeBinding iTypeBinding2 = this.fDeclaration.resolveBinding().getDeclaringClass();
        if (!callContext.receiverIsStatic && Modifier.isStatic((int)n)) {
            string = "this".equals(string) && iTypeBinding != null && Bindings.equals((IBinding)iTypeBinding, (IBinding)iTypeBinding2) ? null : callContext.importer.addImport(iTypeBinding2);
        }
        return string;
    }

    private void updateTypeVariables(ASTRewrite aSTRewrite, CallContext callContext) {
        ITypeBinding iTypeBinding = callContext.getReceiverType();
        if (iTypeBinding == null) {
            return;
        }
        this.rewriteReferences(aSTRewrite, iTypeBinding.getTypeArguments(), this.fAnalyzer.getTypeParameterReferences());
    }

    private void updateMethodTypeVariable(ASTRewrite aSTRewrite, CallContext callContext) {
        IMethodBinding iMethodBinding = Invocations.resolveBinding(callContext.invocation);
        if (iMethodBinding == null) {
            return;
        }
        this.rewriteReferences(aSTRewrite, iMethodBinding.getTypeArguments(), this.fAnalyzer.getMethodTypeParameterReferences());
    }

    private void rewriteReferences(ASTRewrite aSTRewrite, ITypeBinding[] iTypeBindingArray, List list) {
        if (iTypeBindingArray.length == 0) {
            return;
        }
        Assert.isTrue((iTypeBindingArray.length == list.size() ? 1 : 0) != 0);
        int n = 0;
        while (n < iTypeBindingArray.length) {
            SourceAnalyzer.NameData nameData = (SourceAnalyzer.NameData)list.get(n);
            List list2 = nameData.references();
            String string = iTypeBindingArray[n].getName();
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                SimpleName simpleName = (SimpleName)iterator.next();
                aSTRewrite.replace((ASTNode)simpleName, aSTRewrite.createStringPlaceholder(string, 42), null);
            }
            ++n;
        }
    }

    private ASTNode getLastStatement() {
        List list = this.fDeclaration.getBody().statements();
        if (list.isEmpty()) {
            return null;
        }
        return (ASTNode)list.get(list.size() - 1);
    }

    private List getReturnStatementRanges() {
        this.fMarkerMode = 3;
        ArrayList<IRegion> arrayList = new ArrayList<IRegion>(1);
        List list = this.fDeclaration.getBody().statements();
        int n = list.size();
        if (n <= 1) {
            return arrayList;
        }
        arrayList.add(this.createRange(list, n - 2));
        return arrayList;
    }

    private List getStatementRanges() {
        this.fMarkerMode = 2;
        ArrayList<IRegion> arrayList = new ArrayList<IRegion>(1);
        List list = this.fDeclaration.getBody().statements();
        int n = list.size();
        if (n == 0) {
            return arrayList;
        }
        arrayList.add(this.createRange(list, n - 1));
        return arrayList;
    }

    private List getExpressionRanges() {
        this.fMarkerMode = 1;
        ArrayList<Object> arrayList = new ArrayList<Object>(2);
        List list = this.fDeclaration.getBody().statements();
        ReturnStatement returnStatement = null;
        int n = list.size();
        switch (n) {
            case 0: {
                return arrayList;
            }
            case 1: {
                ASTNode aSTNode = (ASTNode)list.get(0);
                if (aSTNode.getNodeType() == 41) {
                    returnStatement = (ReturnStatement)aSTNode;
                    break;
                }
                arrayList.add(new Region(aSTNode.getStartPosition(), aSTNode.getLength()));
                break;
            }
            default: {
                ASTNode aSTNode = (ASTNode)list.get(n - 1);
                if (aSTNode.getNodeType() == 41) {
                    arrayList.add(this.createRange(list, n - 2));
                    returnStatement = (ReturnStatement)aSTNode;
                    break;
                }
                arrayList.add(this.createRange(list, n - 1));
            }
        }
        if (returnStatement != null) {
            Expression expression = returnStatement.getExpression();
            arrayList.add(new Region(expression.getStartPosition(), expression.getLength()));
        }
        return arrayList;
    }

    private IRegion createRange(List list, int n) {
        ASTNode aSTNode = (ASTNode)list.get(0);
        ASTNode aSTNode2 = aSTNode.getRoot();
        if (aSTNode2 instanceof CompilationUnit) {
            CompilationUnit compilationUnit = (CompilationUnit)aSTNode2;
            int n2 = compilationUnit.getExtendedStartPosition(aSTNode);
            ASTNode aSTNode3 = (ASTNode)list.get(n);
            int n3 = compilationUnit.getExtendedStartPosition(aSTNode3) - n2 + compilationUnit.getExtendedLength(aSTNode3);
            Region region = new Region(n2, n3);
            return region;
        }
        int n4 = aSTNode.getStartPosition();
        ASTNode aSTNode4 = (ASTNode)list.get(n);
        int n5 = aSTNode4.getStartPosition() - n4 + aSTNode4.getLength();
        Region region = new Region(n4, n5);
        return region;
    }

    private String[] getBlocks(RangeMarker[] rangeMarkerArray) throws BadLocationException {
        String[] stringArray = new String[rangeMarkerArray.length];
        int n = 0;
        while (n < rangeMarkerArray.length) {
            RangeMarker rangeMarker = rangeMarkerArray[n];
            String string = this.fDocument.get(rangeMarker.getOffset(), rangeMarker.getLength());
            String[] stringArray2 = Strings.convertIntoLines(string);
            Strings.trimIndentation(stringArray2, this.fTypeRoot.getJavaProject(), false);
            if (this.fMarkerMode == 2 && stringArray2.length == 2 && this.isSingleControlStatementWithoutBlock()) {
                stringArray2[1] = String.valueOf(CodeFormatterUtil.createIndentString(1, this.fTypeRoot.getJavaProject())) + stringArray2[1];
            }
            stringArray[n] = Strings.concatenate(stringArray2, TextUtilities.getDefaultLineDelimiter((IDocument)this.fDocument));
            ++n;
        }
        return stringArray;
    }

    private boolean isSingleControlStatementWithoutBlock() {
        List list = this.fDeclaration.getBody().statements();
        int n = list.size();
        if (n != 1) {
            return false;
        }
        Statement statement = (Statement)list.get(n - 1);
        int n2 = statement.getNodeType();
        if (n2 == 25) {
            IfStatement ifStatement = (IfStatement)statement;
            return !(ifStatement.getThenStatement() instanceof Block) && !(ifStatement.getElseStatement() instanceof Block);
        }
        if (n2 == 24) {
            return !(((ForStatement)statement).getBody() instanceof Block);
        }
        if (n2 == 61) {
            return !(((WhileStatement)statement).getBody() instanceof Block);
        }
        if (n2 == 90) {
            return !(((WithStatement)statement).getBody() instanceof Block);
        }
        if (n2 == 83) {
            return !(((ForInStatement)statement).getBody() instanceof Block);
        }
        return false;
    }

    private class ReturnAnalyzer
    extends ASTVisitor {
        private ReturnAnalyzer() {
        }

        public boolean visit(ReturnStatement returnStatement) {
            Expression expression = returnStatement.getExpression();
            if (!ASTNodes.isLiteral(expression) && !(expression instanceof Name)) {
                SourceProvider.this.fMustEvalReturnedExpression = true;
            }
            if (Invocations.isInvocation((ASTNode)expression) || expression instanceof ClassInstanceCreation) {
                SourceProvider.this.fReturnValueNeedsLocalVariable = false;
            }
            SourceProvider.this.fReturnExpressions.add(expression);
            return false;
        }
    }

    static class VariableReferenceFinder
    extends ASTVisitor {
        private boolean fResult;
        private IVariableBinding fBinding;

        public VariableReferenceFinder(IVariableBinding iVariableBinding) {
            this.fBinding = iVariableBinding;
        }

        public boolean getResult() {
            return this.fResult;
        }

        public boolean visit(SimpleName simpleName) {
            if (!this.fResult) {
                this.fResult = Bindings.equals((IBinding)this.fBinding, simpleName.resolveBinding());
            }
            return false;
        }
    }
}

