/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.TryStatement;

public class FlowContext {
    public static final Enum MERGE = new Enum();
    public static final Enum ARGUMENTS = new Enum();
    public static final Enum RETURN_VALUES = new Enum();
    private int fStart;
    private int fLength;
    private boolean fConsiderAccessMode;
    private boolean fLoopReentranceMode;
    private Enum fComputeMode;
    private IVariableBinding[] fLocals;
    private List fExceptionStack;
    private static final List EMPTY_CATCH_CLAUSE = new ArrayList(0);

    public FlowContext(int n, int n2) {
        this.fStart = n;
        this.fLength = n2;
        this.fExceptionStack = new ArrayList(3);
    }

    public void setConsiderAccessMode(boolean bl) {
        this.fConsiderAccessMode = bl;
    }

    public void setComputeMode(Enum enum_) {
        this.fComputeMode = enum_;
    }

    void setLoopReentranceMode(boolean bl) {
        this.fLoopReentranceMode = bl;
    }

    int getArrayLength() {
        return this.fLength;
    }

    int getStartingIndex() {
        return this.fStart;
    }

    boolean considerAccessMode() {
        return this.fConsiderAccessMode;
    }

    boolean isLoopReentranceMode() {
        return this.fLoopReentranceMode;
    }

    boolean computeMerge() {
        return this.fComputeMode == MERGE;
    }

    boolean computeArguments() {
        return this.fComputeMode == ARGUMENTS;
    }

    boolean computeReturnValues() {
        return this.fComputeMode == RETURN_VALUES;
    }

    public IVariableBinding getLocalFromId(int n) {
        return this.getLocalFromIndex(n - this.fStart);
    }

    public IVariableBinding getLocalFromIndex(int n) {
        if (this.fLocals == null || n > this.fLocals.length) {
            return null;
        }
        return this.fLocals[n];
    }

    public int getIndexFromLocal(IVariableBinding iVariableBinding) {
        if (this.fLocals == null) {
            return -1;
        }
        int n = 0;
        while (n < this.fLocals.length) {
            if (this.fLocals[n] == iVariableBinding) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    void manageLocal(IVariableBinding iVariableBinding) {
        if (this.fLocals == null) {
            this.fLocals = new IVariableBinding[this.fLength];
        }
        this.fLocals[iVariableBinding.getVariableId() - this.fStart] = iVariableBinding;
    }

    void pushExcptions(TryStatement tryStatement) {
        List list = tryStatement.catchClauses();
        if (list == null) {
            list = EMPTY_CATCH_CLAUSE;
        }
        this.fExceptionStack.add(list);
    }

    void popExceptions() {
        Assert.isTrue((this.fExceptionStack.size() > 0 ? 1 : 0) != 0);
        this.fExceptionStack.remove(this.fExceptionStack.size() - 1);
    }

    boolean isExceptionCaught(ITypeBinding iTypeBinding) {
        Iterator iterator = this.fExceptionStack.iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = ((List)iterator.next()).iterator();
            while (iterator2.hasNext()) {
                SingleVariableDeclaration singleVariableDeclaration = ((CatchClause)iterator2.next()).getException();
                IVariableBinding iVariableBinding = singleVariableDeclaration.resolveBinding();
                if (iVariableBinding == null) continue;
                ITypeBinding iTypeBinding2 = iVariableBinding.getType();
                while (iTypeBinding2 != null) {
                    if (iTypeBinding2 == iTypeBinding) {
                        return true;
                    }
                    iTypeBinding2 = iTypeBinding2.getSuperclass();
                }
            }
        }
        return false;
    }

    private static class Enum {
        private Enum() {
        }
    }
}

