/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.TryStatement;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.FlowContext;

public abstract class FlowInfo {
    protected static final int NOT_POSSIBLE = 0;
    protected static final int UNDEFINED = 1;
    protected static final int NO_RETURN = 2;
    protected static final int PARTIAL_RETURN = 3;
    protected static final int VOID_RETURN = 4;
    protected static final int VALUE_RETURN = 5;
    protected static final int THROW = 6;
    public static final int UNUSED = 1;
    public static final int READ = 2;
    public static final int READ_POTENTIAL = 4;
    public static final int WRITE = 8;
    public static final int WRITE_POTENTIAL = 16;
    public static final int UNKNOWN = 32;
    private static final int[][] ACCESS_MODE_CONDITIONAL_TABLE = new int[][]{{1, 4, 4, 16, 16, 32}, {4, 2, 4, 32, 32, 32}, {4, 4, 4, 32, 32, 32}, {16, 32, 32, 8, 16, 32}, {16, 32, 32, 16, 16, 32}, {32, 32, 32, 32, 32, 32}};
    private static final int[] ACCESS_MODE_OPEN_BRANCH_TABLE = new int[]{1, 4, 4, 16, 16, 32};
    private static final int[][] RETURN_KIND_CONDITIONAL_TABLE;
    private static final int[][] RETURN_KIND_SEQUENTIAL_TABLE;
    protected static final String UNLABELED = "@unlabeled";
    protected static final IVariableBinding[] EMPTY_ARRAY;
    protected int fReturnKind;
    protected int[] fAccessModes;
    protected Set fBranches;
    protected Set fExceptions;
    protected Set fTypeVariables;

    static {
        int[][] nArrayArray = new int[7][];
        nArrayArray[0] = new int[7];
        int[] nArray = new int[7];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArrayArray[1] = nArray;
        int[] nArray2 = new int[7];
        nArray2[1] = 2;
        nArray2[2] = 2;
        nArray2[3] = 3;
        nArray2[4] = 3;
        nArray2[5] = 3;
        nArray2[6] = 2;
        nArrayArray[2] = nArray2;
        int[] nArray3 = new int[7];
        nArray3[1] = 3;
        nArray3[2] = 3;
        nArray3[3] = 3;
        nArray3[4] = 3;
        nArray3[5] = 3;
        nArray3[6] = 3;
        nArrayArray[3] = nArray3;
        int[] nArray4 = new int[7];
        nArray4[1] = 4;
        nArray4[2] = 3;
        nArray4[3] = 3;
        nArray4[4] = 4;
        nArray4[6] = 4;
        nArrayArray[4] = nArray4;
        int[] nArray5 = new int[7];
        nArray5[1] = 5;
        nArray5[2] = 3;
        nArray5[3] = 3;
        nArray5[5] = 5;
        nArray5[6] = 5;
        nArrayArray[5] = nArray5;
        int[] nArray6 = new int[7];
        nArray6[1] = 6;
        nArray6[2] = 2;
        nArray6[3] = 3;
        nArray6[4] = 4;
        nArray6[5] = 5;
        nArray6[6] = 6;
        nArrayArray[6] = nArray6;
        RETURN_KIND_CONDITIONAL_TABLE = nArrayArray;
        int[][] nArrayArray2 = new int[7][];
        nArrayArray2[0] = new int[7];
        int[] nArray7 = new int[7];
        nArray7[1] = 1;
        nArray7[2] = 2;
        nArray7[3] = 3;
        nArray7[4] = 4;
        nArray7[5] = 5;
        nArray7[6] = 6;
        nArrayArray2[1] = nArray7;
        int[] nArray8 = new int[7];
        nArray8[1] = 2;
        nArray8[2] = 2;
        nArray8[3] = 3;
        nArray8[4] = 4;
        nArray8[5] = 5;
        nArray8[6] = 6;
        nArrayArray2[2] = nArray8;
        int[] nArray9 = new int[7];
        nArray9[1] = 3;
        nArray9[2] = 3;
        nArray9[3] = 3;
        nArray9[4] = 4;
        nArray9[5] = 5;
        nArray9[6] = 6;
        nArrayArray2[3] = nArray9;
        int[] nArray10 = new int[7];
        nArray10[1] = 4;
        nArray10[2] = 4;
        nArray10[3] = 3;
        nArray10[4] = 4;
        nArrayArray2[4] = nArray10;
        int[] nArray11 = new int[7];
        nArray11[1] = 5;
        nArray11[2] = 5;
        nArray11[3] = 3;
        nArray11[5] = 5;
        nArrayArray2[5] = nArray11;
        int[] nArray12 = new int[7];
        nArray12[1] = 6;
        nArray12[2] = 6;
        nArray12[3] = 3;
        nArray12[4] = 4;
        nArray12[5] = 5;
        nArray12[6] = 6;
        nArrayArray2[6] = nArray12;
        RETURN_KIND_SEQUENTIAL_TABLE = nArrayArray2;
        EMPTY_ARRAY = new IVariableBinding[0];
    }

    protected FlowInfo() {
        this(1);
    }

    protected FlowInfo(int n) {
        this.fReturnKind = n;
    }

    protected void assignExecutionFlow(FlowInfo flowInfo) {
        this.fReturnKind = flowInfo.fReturnKind;
        this.fBranches = flowInfo.fBranches;
        this.fExceptions = flowInfo.fExceptions;
    }

    protected void assignAccessMode(FlowInfo flowInfo) {
        this.fAccessModes = flowInfo.fAccessModes;
    }

    protected void assign(FlowInfo flowInfo) {
        this.assignExecutionFlow(flowInfo);
        this.assignAccessMode(flowInfo);
    }

    protected void mergeConditional(FlowInfo flowInfo, FlowContext flowContext) {
        this.mergeAccessModeConditional(flowInfo, flowContext);
        this.mergeExecutionFlowConditional(flowInfo, flowContext);
        this.mergeTypeVariablesConditional(flowInfo, flowContext);
    }

    protected void mergeSequential(FlowInfo flowInfo, FlowContext flowContext) {
        this.mergeAccessModeSequential(flowInfo, flowContext);
        this.mergeExecutionFlowSequential(flowInfo, flowContext);
        this.mergeTypeVariablesSequential(flowInfo, flowContext);
    }

    public void setNoReturn() {
        this.fReturnKind = 2;
    }

    public boolean isUndefined() {
        return this.fReturnKind == 1;
    }

    public boolean isNoReturn() {
        return this.fReturnKind == 2;
    }

    public boolean isPartialReturn() {
        return this.fReturnKind == 3;
    }

    public boolean isVoidReturn() {
        return this.fReturnKind == 4;
    }

    public boolean isValueReturn() {
        return this.fReturnKind == 5;
    }

    public boolean isThrow() {
        return this.fReturnKind == 6;
    }

    public boolean isReturn() {
        return this.fReturnKind == 4 || this.fReturnKind == 5;
    }

    public boolean branches() {
        return this.fBranches != null && !this.fBranches.isEmpty();
    }

    protected Set getBranches() {
        return this.fBranches;
    }

    protected void removeLabel(SimpleName simpleName) {
        if (this.fBranches != null) {
            this.fBranches.remove(FlowInfo.makeString(simpleName));
            if (this.fBranches.isEmpty()) {
                this.fBranches = null;
            }
        }
    }

    protected static String makeString(SimpleName simpleName) {
        if (simpleName == null) {
            return UNLABELED;
        }
        return simpleName.getIdentifier();
    }

    public ITypeBinding[] getExceptions() {
        if (this.fExceptions == null) {
            return new ITypeBinding[0];
        }
        return this.fExceptions.toArray(new ITypeBinding[this.fExceptions.size()]);
    }

    protected boolean hasUncaughtException() {
        return this.fExceptions != null && !this.fExceptions.isEmpty();
    }

    protected void addException(ITypeBinding iTypeBinding) {
        if (this.fExceptions == null) {
            this.fExceptions = new HashSet(2);
        }
        this.fExceptions.add(iTypeBinding);
    }

    protected void removeExceptions(TryStatement tryStatement) {
        if (this.fExceptions == null) {
            return;
        }
        List list = tryStatement.catchClauses();
        if (list.isEmpty()) {
            return;
        }
        ITypeBinding[] iTypeBindingArray = this.fExceptions.toArray(new ITypeBinding[this.fExceptions.size()]);
        int n = 0;
        while (n < iTypeBindingArray.length) {
            this.handleException(list, iTypeBindingArray[n]);
            ++n;
        }
        if (this.fExceptions.isEmpty()) {
            this.fExceptions = null;
        }
    }

    private void handleException(List list, ITypeBinding iTypeBinding) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IVariableBinding iVariableBinding = ((CatchClause)iterator.next()).getException().resolveBinding();
            if (iVariableBinding == null) continue;
            ITypeBinding iTypeBinding2 = iVariableBinding.getType();
            while (iTypeBinding2 != null) {
                if (iTypeBinding2 == iTypeBinding) {
                    this.fExceptions.remove(iTypeBinding);
                    return;
                }
                iTypeBinding2 = iTypeBinding2.getSuperclass();
            }
        }
    }

    public ITypeBinding[] getTypeVariables() {
        if (this.fTypeVariables == null) {
            return new ITypeBinding[0];
        }
        return this.fTypeVariables.toArray(new ITypeBinding[this.fTypeVariables.size()]);
    }

    protected void addTypeVariable(ITypeBinding iTypeBinding) {
        if (this.fTypeVariables == null) {
            this.fTypeVariables = new HashSet();
        }
        this.fTypeVariables.add(iTypeBinding);
    }

    private void mergeTypeVariablesSequential(FlowInfo flowInfo, FlowContext flowContext) {
        this.fTypeVariables = FlowInfo.mergeSets(this.fTypeVariables, flowInfo.fTypeVariables);
    }

    private void mergeTypeVariablesConditional(FlowInfo flowInfo, FlowContext flowContext) {
        this.fTypeVariables = FlowInfo.mergeSets(this.fTypeVariables, flowInfo.fTypeVariables);
    }

    private void mergeExecutionFlowSequential(FlowInfo flowInfo, FlowContext flowContext) {
        int n = flowInfo.fReturnKind;
        if (this.branches() && n == 5) {
            n = 3;
        }
        this.fReturnKind = RETURN_KIND_SEQUENTIAL_TABLE[this.fReturnKind][n];
        this.mergeBranches(flowInfo, flowContext);
        this.mergeExceptions(flowInfo, flowContext);
    }

    private void mergeExecutionFlowConditional(FlowInfo flowInfo, FlowContext flowContext) {
        this.fReturnKind = RETURN_KIND_CONDITIONAL_TABLE[this.fReturnKind][flowInfo.fReturnKind];
        this.mergeBranches(flowInfo, flowContext);
        this.mergeExceptions(flowInfo, flowContext);
    }

    private void mergeBranches(FlowInfo flowInfo, FlowContext flowContext) {
        this.fBranches = FlowInfo.mergeSets(this.fBranches, flowInfo.fBranches);
    }

    private void mergeExceptions(FlowInfo flowInfo, FlowContext flowContext) {
        this.fExceptions = FlowInfo.mergeSets(this.fExceptions, flowInfo.fExceptions);
    }

    private static Set mergeSets(Set set, Set set2) {
        if (set2 != null) {
            if (set == null) {
                set = set2;
            } else {
                Iterator iterator = set2.iterator();
                while (iterator.hasNext()) {
                    set.add(iterator.next());
                }
            }
        }
        return set;
    }

    public IVariableBinding[] get(FlowContext flowContext, int n) {
        ArrayList<IVariableBinding> arrayList = new ArrayList<IVariableBinding>();
        int[] nArray = this.getAccessModes();
        if (nArray == null) {
            return EMPTY_ARRAY;
        }
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = nArray[n2];
            if ((n3 & n) != 0) {
                arrayList.add(flowContext.getLocalFromIndex(n2));
            }
            ++n2;
        }
        return arrayList.toArray(new IVariableBinding[arrayList.size()]);
    }

    public boolean hasAccessMode(FlowContext flowContext, IVariableBinding iVariableBinding, int n) {
        boolean bl;
        boolean bl2 = bl = (n & 1) != 0;
        if (this.fAccessModes == null && bl) {
            return true;
        }
        int n2 = flowContext.getIndexFromLocal(iVariableBinding);
        if (n2 == -1) {
            return bl;
        }
        return (this.fAccessModes[n2] & n) != 0;
    }

    public int getAccessMode(FlowContext flowContext, IVariableBinding iVariableBinding) {
        if (this.fAccessModes == null) {
            return 1;
        }
        int n = flowContext.getIndexFromLocal(iVariableBinding);
        if (n == -1) {
            return 1;
        }
        return this.fAccessModes[n];
    }

    protected int[] getAccessModes() {
        return this.fAccessModes;
    }

    protected void clearAccessMode(IVariableBinding iVariableBinding, FlowContext flowContext) {
        if (this.fAccessModes == null) {
            return;
        }
        this.fAccessModes[iVariableBinding.getVariableId() - flowContext.getStartingIndex()] = 1;
    }

    protected void mergeAccessModeSequential(FlowInfo flowInfo, FlowContext flowContext) {
        if (!flowContext.considerAccessMode()) {
            return;
        }
        int[] nArray = flowInfo.fAccessModes;
        if (nArray == null) {
            return;
        }
        if (this.branches() || this.hasUncaughtException()) {
            int n = 0;
            while (n < nArray.length) {
                nArray[n] = ACCESS_MODE_OPEN_BRANCH_TABLE[FlowInfo.getIndex(nArray[n])];
                ++n;
            }
        }
        if (this.fAccessModes == null) {
            this.fAccessModes = nArray;
            return;
        }
        if (flowContext.computeArguments()) {
            this.handleComputeArguments(nArray);
        } else if (flowContext.computeReturnValues()) {
            this.handleComputeReturnValues(nArray);
        } else if (flowContext.computeMerge()) {
            this.handleMergeValues(nArray);
        }
    }

    private void handleComputeReturnValues(int[] nArray) {
        int n = 0;
        while (n < this.fAccessModes.length) {
            int n2 = this.fAccessModes[n];
            int n3 = nArray[n];
            if (n2 != 8) {
                if (n2 == 16) {
                    if (n3 == 8) {
                        this.fAccessModes[n] = 8;
                    }
                } else if (nArray[n] != 1) {
                    this.fAccessModes[n] = n3;
                }
            }
            ++n;
        }
    }

    private void handleComputeArguments(int[] nArray) {
        int n = 0;
        while (n < this.fAccessModes.length) {
            int n2 = this.fAccessModes[n];
            int n3 = nArray[n];
            if (n2 == 1) {
                this.fAccessModes[n] = n3;
            } else if (n2 == 16 && (n3 == 2 || n3 == 4)) {
                this.fAccessModes[n] = n3;
            } else if (n2 == 16 && n3 == 8) {
                this.fAccessModes[n] = 8;
            }
            ++n;
        }
    }

    private void handleMergeValues(int[] nArray) {
        int n = 0;
        while (n < this.fAccessModes.length) {
            this.fAccessModes[n] = ACCESS_MODE_CONDITIONAL_TABLE[FlowInfo.getIndex(this.fAccessModes[n])][FlowInfo.getIndex(nArray[n])];
            ++n;
        }
    }

    protected void createAccessModeArray(FlowContext flowContext) {
        this.fAccessModes = new int[flowContext.getArrayLength()];
        int n = 0;
        while (n < this.fAccessModes.length) {
            this.fAccessModes[n] = 1;
            ++n;
        }
    }

    protected void mergeAccessModeConditional(FlowInfo flowInfo, FlowContext flowContext) {
        if (!flowContext.considerAccessMode()) {
            return;
        }
        int[] nArray = flowInfo.fAccessModes;
        if (this.fAccessModes == null) {
            if (nArray != null) {
                this.fAccessModes = nArray;
            } else {
                this.createAccessModeArray(flowContext);
            }
            return;
        }
        if (nArray == null) {
            int n = 0;
            while (n < this.fAccessModes.length) {
                int n2 = FlowInfo.getIndex(1);
                this.fAccessModes[n] = ACCESS_MODE_CONDITIONAL_TABLE[FlowInfo.getIndex(this.fAccessModes[n])][n2];
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.fAccessModes.length) {
                this.fAccessModes[n] = ACCESS_MODE_CONDITIONAL_TABLE[FlowInfo.getIndex(this.fAccessModes[n])][FlowInfo.getIndex(nArray[n])];
                ++n;
            }
        }
    }

    protected void mergeEmptyCondition(FlowContext flowContext) {
        if (this.fReturnKind == 5 || this.fReturnKind == 4) {
            this.fReturnKind = 3;
        }
        if (!flowContext.considerAccessMode()) {
            return;
        }
        if (this.fAccessModes == null) {
            this.createAccessModeArray(flowContext);
            return;
        }
        int n = FlowInfo.getIndex(1);
        int n2 = 0;
        while (n2 < this.fAccessModes.length) {
            this.fAccessModes[n2] = ACCESS_MODE_CONDITIONAL_TABLE[FlowInfo.getIndex(this.fAccessModes[n2])][n];
            ++n2;
        }
    }

    private static int getIndex(int n) {
        switch (n) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 8: {
                return 3;
            }
            case 16: {
                return 4;
            }
            case 32: {
                return 5;
            }
        }
        return -1;
    }
}

