/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.delegates;

import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.MemberRef;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.delegates.DelegateCreator;

public class DelegateFieldCreator
extends DelegateCreator {
    private VariableDeclarationFragment fOldFieldFragment;

    protected void initialize() {
        Assert.isTrue((boolean)(this.getDeclaration() instanceof FieldDeclaration));
        Assert.isTrue((((FieldDeclaration)this.getDeclaration()).fragments().size() == 1 ? 1 : 0) != 0);
        this.fOldFieldFragment = (VariableDeclarationFragment)((FieldDeclaration)this.getDeclaration()).fragments().get(0);
        if (this.getNewElementName() == null) {
            this.setNewElementName(this.fOldFieldFragment.getName().getIdentifier());
        }
        this.setInsertBefore(false);
    }

    protected ASTNode createBody(BodyDeclaration bodyDeclaration) throws JavaModelException {
        FieldDeclaration fieldDeclaration = (FieldDeclaration)bodyDeclaration;
        Expression expression = this.createDelegateFieldInitializer(fieldDeclaration);
        return expression;
    }

    protected ASTNode createDocReference(BodyDeclaration bodyDeclaration) {
        MemberRef memberRef = this.getAst().newMemberRef();
        memberRef.setName(this.getAst().newSimpleName(this.getNewElementName()));
        if (this.isMoveToAnotherFile()) {
            memberRef.setQualifier(this.createDestinationTypeName());
        }
        return memberRef;
    }

    protected ASTNode getBodyHead(BodyDeclaration bodyDeclaration) {
        return this.fOldFieldFragment;
    }

    protected ChildPropertyDescriptor getJavaDocProperty() {
        return FieldDeclaration.JAVADOC_PROPERTY;
    }

    protected ChildPropertyDescriptor getBodyProperty() {
        return VariableDeclarationFragment.INITIALIZER_PROPERTY;
    }

    protected IBinding getDeclarationBinding() {
        return this.fOldFieldFragment.resolveBinding();
    }

    protected String getTextEditGroupLabel() {
        return RefactoringCoreMessages.DelegateFieldCreator_text_edit_group_label;
    }

    private Expression createDelegateFieldInitializer(FieldDeclaration fieldDeclaration) throws JavaModelException {
        Assert.isNotNull((Object)fieldDeclaration);
        Expression expression = this.getAccess();
        if (expression != null) {
            FieldAccess fieldAccess = this.getAst().newFieldAccess();
            fieldAccess.setExpression(expression);
            fieldAccess.setName(this.getAst().newSimpleName(this.getNewElementName()));
            return fieldAccess;
        }
        SimpleName simpleName = this.getAst().newSimpleName(this.getNewElementName());
        return simpleName;
    }
}

