/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.rename;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.ToolFactory;
import org.eclipse.wst.jsdt.core.compiler.IScanner;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;

public class RefactoringScanner {
    private static int NO_MATCH = 0;
    private static int MATCH_QUALIFIED = 1;
    private static int MATCH_UNQUALIFIED = 2;
    private final String fName;
    private final String fQualifier;
    private IScanner fScanner;
    private Set fMatches;

    public RefactoringScanner(String string, String string2) {
        Assert.isNotNull((Object)string);
        Assert.isNotNull((Object)string2);
        this.fName = string;
        this.fQualifier = string2;
    }

    public void scan(ICompilationUnit iCompilationUnit) throws JavaModelException {
        char[] cArray = iCompilationUnit.getBuffer().getCharacters();
        this.fMatches = new HashSet();
        this.fScanner = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)false, (boolean)true);
        this.fScanner.setSource(cArray);
        this.doScan();
        this.fScanner = null;
    }

    public void scan(String string) {
        char[] cArray = string.toCharArray();
        this.fMatches = new HashSet();
        this.fScanner = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)false, (boolean)true);
        this.fScanner.setSource(cArray);
        this.doScan();
        this.fScanner = null;
    }

    private void doScan() {
        try {
            int n = this.fScanner.getNextToken();
            while (n != 158) {
                switch (n) {
                    case 45: 
                    case 1001: 
                    case 1002: 
                    case 1003: {
                        this.parseCurrentToken();
                    }
                }
                n = this.fScanner.getNextToken();
            }
        }
        catch (InvalidInputException invalidInputException) {}
    }

    private static boolean isWholeWord(String string, int n, int n2) {
        char c;
        if (n > 0 && (Character.isLetterOrDigit(c = string.charAt(n - 1)) || c == '_')) {
            return false;
        }
        return n2 >= string.length() || !Character.isLetterOrDigit(c = string.charAt(n2)) && c != '_';
    }

    private void parseCurrentToken() {
        String string = new String(this.fScanner.getRawTokenSource());
        int n = this.fScanner.getCurrentTokenStartPosition();
        int n2 = string.indexOf(this.fName);
        while (n2 != -1) {
            int n3;
            if (RefactoringScanner.isWholeWord(string, n2, n2 + this.fName.length()) && (n3 = this.isQualifierOK(string, n2)) > NO_MATCH) {
                this.addMatch(n + n2, n3);
            }
            n2 = string.indexOf(this.fName, n2 + 1);
        }
    }

    private int isQualifierOK(String string, int n) {
        char c;
        char c2;
        int n2 = n - 1;
        if (n2 < 0) {
            return MATCH_UNQUALIFIED;
        }
        char c3 = string.charAt(n2);
        if (!this.isQualifierSeparator(c3)) {
            return MATCH_UNQUALIFIED;
        }
        boolean bl = c3 == '#';
        int n3 = 0;
        while (n3 < this.fQualifier.length()) {
            char c4;
            c2 = n2 - 1 - n3;
            if (c2 < '\u0000') {
                return bl ? MATCH_UNQUALIFIED : NO_MATCH;
            }
            c = string.charAt(c2);
            if (c != (c4 = this.fQualifier.charAt(this.fQualifier.length() - 1 - n3))) {
                return bl && !this.isQualifierPart(c) ? MATCH_UNQUALIFIED : NO_MATCH;
            }
            bl = !this.isQualifierSeparator(c);
            ++n3;
        }
        n3 = n2 - this.fQualifier.length() - 1;
        if (n3 >= 0) {
            c2 = string.charAt(n3);
            if (Character.isJavaIdentifierPart(c2)) {
                return NO_MATCH;
            }
            if (this.isQualifierSeparator(c2) && n3 > 0 && Character.isJavaIdentifierPart(c = string.charAt(n3 - 1))) {
                return NO_MATCH;
            }
            return MATCH_QUALIFIED;
        }
        return MATCH_QUALIFIED;
    }

    private boolean isQualifierPart(char c) {
        return Character.isJavaIdentifierPart(c) || this.isQualifierSeparator(c);
    }

    private boolean isQualifierSeparator(char c) {
        return ".#".indexOf(c) != -1;
    }

    private void addMatch(int n, int n2) {
        this.fMatches.add(new TextMatch(n, n2 == MATCH_QUALIFIED));
    }

    public Set getMatches() {
        return this.fMatches;
    }

    public static class TextMatch {
        private int fStartPosition;
        private boolean fQualified;

        private TextMatch(int n, boolean bl) {
            this.fStartPosition = n;
            this.fQualified = bl;
        }

        public int getStartPosition() {
            return this.fStartPosition;
        }

        public boolean isQualified() {
            return this.fQualified;
        }
    }
}

