/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.rename;

import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.internal.corext.dom.Selection;
import org.eclipse.wst.jsdt.internal.corext.dom.SelectionAnalyzer;

public class TempDeclarationFinder {
    private TempDeclarationFinder() {
    }

    public static VariableDeclaration findTempDeclaration(CompilationUnit compilationUnit, int n, int n2) {
        TempSelectionAnalyzer tempSelectionAnalyzer = new TempSelectionAnalyzer(n, n2);
        compilationUnit.accept((ASTVisitor)tempSelectionAnalyzer);
        ASTNode[] aSTNodeArray = tempSelectionAnalyzer.getSelectedNodes();
        if (aSTNodeArray == null || aSTNodeArray.length != 1) {
            return null;
        }
        ASTNode aSTNode = aSTNodeArray[0];
        if (aSTNode instanceof VariableDeclaration) {
            return (VariableDeclaration)aSTNode;
        }
        if (aSTNode instanceof Name) {
            Name name = (Name)aSTNode;
            IBinding iBinding = name.resolveBinding();
            if (iBinding == null) {
                return null;
            }
            ASTNode aSTNode2 = compilationUnit.findDeclaringNode(iBinding);
            if (aSTNode2 instanceof VariableDeclaration) {
                return (VariableDeclaration)aSTNode2;
            }
            return null;
        }
        if (aSTNode instanceof VariableDeclarationStatement) {
            VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)aSTNode;
            if (variableDeclarationStatement.fragments().size() != 1) {
                return null;
            }
            return (VariableDeclaration)variableDeclarationStatement.fragments().get(0);
        }
        return null;
    }

    private static class TempSelectionAnalyzer
    extends SelectionAnalyzer {
        private ASTNode fNode;

        TempSelectionAnalyzer(int n, int n2) {
            super(Selection.createFromStartLength(n, n2), true);
        }

        public boolean visitNode(ASTNode aSTNode) {
            if (aSTNode instanceof VariableDeclaration) {
                return this.visitVariableDeclaration((VariableDeclaration)aSTNode);
            }
            if (aSTNode instanceof SimpleName) {
                return this.visitSimpleName((SimpleName)aSTNode);
            }
            return super.visitNode(aSTNode);
        }

        private boolean addNodeAndStop(ASTNode aSTNode) {
            this.fNode = aSTNode;
            return false;
        }

        private boolean visitSimpleName(SimpleName simpleName) {
            if (this.getSelection().coveredBy((ASTNode)simpleName)) {
                return this.addNodeAndStop((ASTNode)simpleName);
            }
            return super.visitNode((ASTNode)simpleName);
        }

        private boolean visitVariableDeclaration(VariableDeclaration variableDeclaration) {
            if (variableDeclaration.getInitializer() != null) {
                int n = variableDeclaration.getStartPosition();
                Region region = new Region(n, variableDeclaration.getInitializer().getStartPosition() - n);
                if (this.getSelection().coveredBy((IRegion)region)) {
                    return this.addNodeAndStop((ASTNode)variableDeclaration);
                }
                return super.visitNode((ASTNode)variableDeclaration);
            }
            if (this.getSelection().coveredBy((ASTNode)variableDeclaration)) {
                return this.addNodeAndStop((ASTNode)variableDeclaration);
            }
            return super.visitNode((ASTNode)variableDeclaration);
        }

        public ASTNode[] getSelectedNodes() {
            if (this.fNode != null) {
                return new ASTNode[]{this.fNode};
            }
            return super.getSelectedNodes();
        }
    }
}

