/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.ISourceManipulation;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DeleteFileChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DeleteFolderChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DeleteFromClasspathChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DeletePackageFragmentRootChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DeleteSourceManipulationChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.UndoablePackageDeleteChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ASTNodeDeleteUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringFileBuffers;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.TextChangeManager;

class DeleteChangeCreator {
    private DeleteChangeCreator() {
    }

    static Change createDeleteChange(TextChangeManager textChangeManager, IResource[] iResourceArray, IJavaElement[] iJavaElementArray, String string, List list) throws CoreException {
        Object object;
        DynamicValidationStateChange dynamicValidationStateChange = list.size() > 0 ? new UndoablePackageDeleteChange(string, list) : new DynamicValidationStateChange(string);
        int n = 0;
        while (n < iJavaElementArray.length) {
            object = iJavaElementArray[n];
            if (!ReorgUtils.isInsideCompilationUnit((IJavaElement)object)) {
                dynamicValidationStateChange.add(DeleteChangeCreator.createDeleteChange((IJavaElement)object));
            }
            ++n;
        }
        n = 0;
        while (n < iResourceArray.length) {
            dynamicValidationStateChange.add(DeleteChangeCreator.createDeleteChange(iResourceArray[n]));
            ++n;
        }
        Map map = ReorgUtils.groupByCompilationUnit(DeleteChangeCreator.getElementsSmallerThanCu(iJavaElementArray));
        if (map.size() != 0) {
            Assert.isNotNull((Object)textChangeManager);
            object = map.keySet().iterator();
            while (object.hasNext()) {
                ICompilationUnit iCompilationUnit = (ICompilationUnit)object.next();
                dynamicValidationStateChange.add(DeleteChangeCreator.createDeleteChange(iCompilationUnit, (List)map.get(iCompilationUnit), textChangeManager));
            }
        }
        return dynamicValidationStateChange;
    }

    private static Change createDeleteChange(IResource iResource) {
        Assert.isTrue((!(iResource instanceof IWorkspaceRoot) ? 1 : 0) != 0);
        Assert.isTrue((!(iResource instanceof IProject) ? 1 : 0) != 0);
        if (iResource instanceof IFile) {
            return new DeleteFileChange((IFile)iResource, true);
        }
        if (iResource instanceof IFolder) {
            return new DeleteFolderChange((IFolder)iResource, true);
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    private static Change createDeleteChange(ICompilationUnit iCompilationUnit, List list, TextChangeManager textChangeManager) throws CoreException {
        CompilationUnit compilationUnit = RefactoringASTParser.parseWithASTProvider((ITypeRoot)iCompilationUnit, false, null);
        CompilationUnitRewrite compilationUnitRewrite = new CompilationUnitRewrite(iCompilationUnit, compilationUnit);
        IJavaElement[] iJavaElementArray = list.toArray(new IJavaElement[list.size()]);
        ASTNodeDeleteUtil.markAsDeleted(iJavaElementArray, compilationUnitRewrite, null);
        return DeleteChangeCreator.addTextEditFromRewrite(textChangeManager, iCompilationUnit, compilationUnitRewrite.getASTRewrite());
    }

    private static TextChange addTextEditFromRewrite(TextChangeManager textChangeManager, ICompilationUnit iCompilationUnit, ASTRewrite aSTRewrite) throws CoreException {
        TextChange textChange;
        try {
            String string;
            ITextFileBuffer iTextFileBuffer = RefactoringFileBuffers.acquire(iCompilationUnit);
            TextEdit textEdit = aSTRewrite.rewriteAST(iTextFileBuffer.getDocument(), iCompilationUnit.getJavaProject().getOptions(true));
            TextChange textChange2 = textChangeManager.get(iCompilationUnit);
            if (textChange2 instanceof TextFileChange) {
                string = (TextFileChange)textChange2;
                if (iCompilationUnit.isWorkingCopy()) {
                    string.setSaveMode(4);
                }
            }
            string = RefactoringCoreMessages.DeleteChangeCreator_1;
            TextChangeCompatibility.addTextEdit(textChange2, string, textEdit);
            textChange = textChange2;
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            RefactoringFileBuffers.release(iCompilationUnit);
            throw throwable;
        }
        RefactoringFileBuffers.release(iCompilationUnit);
        return textChange;
    }

    private static List getElementsSmallerThanCu(IJavaElement[] iJavaElementArray) {
        ArrayList<IJavaElement> arrayList = new ArrayList<IJavaElement>();
        int n = 0;
        while (n < iJavaElementArray.length) {
            IJavaElement iJavaElement = iJavaElementArray[n];
            if (ReorgUtils.isInsideCompilationUnit(iJavaElement)) {
                arrayList.add(iJavaElement);
            }
            ++n;
        }
        return arrayList;
    }

    private static Change createDeleteChange(IJavaElement iJavaElement) {
        Assert.isTrue((!ReorgUtils.isInsideCompilationUnit(iJavaElement) ? 1 : 0) != 0);
        switch (iJavaElement.getElementType()) {
            case 3: {
                return DeleteChangeCreator.createPackageFragmentRootDeleteChange((IPackageFragmentRoot)iJavaElement);
            }
            case 4: {
                return DeleteChangeCreator.createSourceManipulationDeleteChange((ISourceManipulation)((IPackageFragment)iJavaElement));
            }
            case 5: {
                return DeleteChangeCreator.createSourceManipulationDeleteChange((ISourceManipulation)((ICompilationUnit)iJavaElement));
            }
            case 6: {
                Assert.isTrue((boolean)(((IClassFile)iJavaElement).getResource() instanceof IFile));
                return DeleteChangeCreator.createDeleteChange(((IClassFile)iJavaElement).getResource());
            }
            case 1: {
                Assert.isTrue((boolean)false);
                return null;
            }
            case 2: {
                Assert.isTrue((boolean)false);
                return null;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                Assert.isTrue((boolean)false);
            }
        }
        Assert.isTrue((boolean)false);
        return new NullChange();
    }

    private static Change createSourceManipulationDeleteChange(ISourceManipulation iSourceManipulation) {
        IResource iResource;
        if ((iSourceManipulation instanceof ICompilationUnit || iSourceManipulation instanceof IPackageFragment) && (iResource = iSourceManipulation instanceof ICompilationUnit ? ReorgUtils.getResource((IJavaElement)((ICompilationUnit)iSourceManipulation)) : ((IPackageFragment)iSourceManipulation).getResource()) != null && iResource.isLinked()) {
            return DeleteChangeCreator.createDeleteChange(iResource);
        }
        return new DeleteSourceManipulationChange(iSourceManipulation, true);
    }

    private static Change createPackageFragmentRootDeleteChange(IPackageFragmentRoot iPackageFragmentRoot) {
        IResource iResource = iPackageFragmentRoot.getResource();
        if (iResource != null && iResource.isLinked()) {
            DynamicValidationStateChange dynamicValidationStateChange = new DynamicValidationStateChange(RefactoringCoreMessages.DeleteRefactoring_delete_package_fragment_root);
            dynamicValidationStateChange.add(new DeleteFromClasspathChange(iPackageFragmentRoot));
            Assert.isTrue((!Checks.isClasspathDelete(iPackageFragmentRoot) ? 1 : 0) != 0);
            dynamicValidationStateChange.add(DeleteChangeCreator.createDeleteChange(iResource));
            return dynamicValidationStateChange;
        }
        Assert.isTrue((!iPackageFragmentRoot.isExternal() ? 1 : 0) != 0);
        return new DeletePackageFragmentRootChange(iPackageFragmentRoot, true, null);
    }
}

