/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.reorg;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.IConfirmQuery;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.IReorgQueries;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.wst.jsdt.internal.corext.util.Resources;

class ReadOnlyResourceFinder {
    private ReadOnlyResourceFinder() {
    }

    static boolean confirmDeleteOfReadOnlyElements(IJavaElement[] iJavaElementArray, IResource[] iResourceArray, IReorgQueries iReorgQueries) throws CoreException {
        String string = RefactoringCoreMessages.ReadOnlyResourceFinder_0;
        String string2 = RefactoringCoreMessages.ReadOnlyResourceFinder_1;
        return ReadOnlyResourceFinder.confirmOperationOnReadOnlyElements(string, string2, iJavaElementArray, iResourceArray, iReorgQueries);
    }

    static boolean confirmMoveOfReadOnlyElements(IJavaElement[] iJavaElementArray, IResource[] iResourceArray, IReorgQueries iReorgQueries) throws CoreException {
        String string = RefactoringCoreMessages.ReadOnlyResourceFinder_2;
        String string2 = RefactoringCoreMessages.ReadOnlyResourceFinder_3;
        return ReadOnlyResourceFinder.confirmOperationOnReadOnlyElements(string, string2, iJavaElementArray, iResourceArray, iReorgQueries);
    }

    private static boolean confirmOperationOnReadOnlyElements(String string, String string2, IJavaElement[] iJavaElementArray, IResource[] iResourceArray, IReorgQueries iReorgQueries) throws CoreException {
        boolean bl = ReadOnlyResourceFinder.hasReadOnlyResourcesAndSubResources(iJavaElementArray, iResourceArray);
        if (bl) {
            IConfirmQuery iConfirmQuery = iReorgQueries.createYesNoQuery(string, false, 5);
            return iConfirmQuery.confirm(string2);
        }
        return true;
    }

    private static boolean hasReadOnlyResourcesAndSubResources(IJavaElement[] iJavaElementArray, IResource[] iResourceArray) throws CoreException {
        return ReadOnlyResourceFinder.hasReadOnlyResourcesAndSubResources(iResourceArray) || ReadOnlyResourceFinder.hasReadOnlyResourcesAndSubResources(iJavaElementArray);
    }

    private static boolean hasReadOnlyResourcesAndSubResources(IJavaElement[] iJavaElementArray) throws CoreException {
        int n = 0;
        while (n < iJavaElementArray.length) {
            if (ReadOnlyResourceFinder.hasReadOnlyResourcesAndSubResources(iJavaElementArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static boolean hasReadOnlyResourcesAndSubResources(IJavaElement iJavaElement) throws CoreException {
        switch (iJavaElement.getElementType()) {
            case 6: {
                Assert.isTrue((boolean)(((IClassFile)iJavaElement).getResource() instanceof IFile));
            }
            case 5: {
                IResource iResource = ReorgUtils.getResource(iJavaElement);
                return iResource != null && Resources.isReadOnly(iResource);
            }
            case 4: {
                IResource iResource = ReorgUtils.getResource(iJavaElement);
                if (iResource == null) {
                    return false;
                }
                IPackageFragment iPackageFragment = (IPackageFragment)iJavaElement;
                if (Resources.isReadOnly(iResource)) {
                    return true;
                }
                Object[] objectArray = iPackageFragment.getNonJavaResources();
                int n = 0;
                while (n < objectArray.length) {
                    Object object = objectArray[n];
                    if (object instanceof IResource && ReadOnlyResourceFinder.hasReadOnlyResourcesAndSubResources((IResource)object)) {
                        return true;
                    }
                    ++n;
                }
                return ReadOnlyResourceFinder.hasReadOnlyResourcesAndSubResources(iPackageFragment.getChildren());
            }
            case 3: {
                IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)iJavaElement;
                if (iPackageFragmentRoot.isArchive()) {
                    return false;
                }
                IResource iResource = ReorgUtils.getResource(iJavaElement);
                if (iResource == null) {
                    return false;
                }
                if (Resources.isReadOnly(iResource)) {
                    return true;
                }
                Object[] objectArray = iPackageFragmentRoot.getNonJavaResources();
                int n = 0;
                while (n < objectArray.length) {
                    Object object = objectArray[n];
                    if (object instanceof IResource && ReadOnlyResourceFinder.hasReadOnlyResourcesAndSubResources((IResource)object)) {
                        return true;
                    }
                    ++n;
                }
                return ReadOnlyResourceFinder.hasReadOnlyResourcesAndSubResources(iPackageFragmentRoot.getChildren());
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return false;
            }
        }
        Assert.isTrue((boolean)false);
        return false;
    }

    private static boolean hasReadOnlyResourcesAndSubResources(IResource[] iResourceArray) throws CoreException {
        int n = 0;
        while (n < iResourceArray.length) {
            if (ReadOnlyResourceFinder.hasReadOnlyResourcesAndSubResources(iResourceArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static boolean hasReadOnlyResourcesAndSubResources(IResource iResource) throws CoreException {
        if (iResource.isLinked()) {
            return false;
        }
        if (Resources.isReadOnly(iResource)) {
            return true;
        }
        if (iResource instanceof IContainer) {
            return ReadOnlyResourceFinder.hasReadOnlyResourcesAndSubResources(((IContainer)iResource).members());
        }
        return false;
    }
}

