/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.CategorizedTextEditGroup;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ImportRemover;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;

public class CompilationUnitRewrite {
    private ICompilationUnit fCu;
    private List fTextEditGroups = new ArrayList();
    private CompilationUnit fRoot;
    private ASTRewrite fRewrite;
    private ImportRewrite fImportRewrite;
    private ImportRemover fImportRemover;
    private boolean fResolveBindings = true;
    private boolean fStatementsRecovery = false;
    private boolean fBindingsRecovery = false;
    private final WorkingCopyOwner fOwner;
    private IDocument fRememberContent = null;
    static /* synthetic */ Class class$0;

    public CompilationUnitRewrite(ICompilationUnit iCompilationUnit) {
        this(null, iCompilationUnit, null);
    }

    public CompilationUnitRewrite(WorkingCopyOwner workingCopyOwner, ICompilationUnit iCompilationUnit) {
        this(workingCopyOwner, iCompilationUnit, null);
    }

    public CompilationUnitRewrite(ICompilationUnit iCompilationUnit, CompilationUnit compilationUnit) {
        this(null, iCompilationUnit, compilationUnit);
    }

    public CompilationUnitRewrite(WorkingCopyOwner workingCopyOwner, ICompilationUnit iCompilationUnit, CompilationUnit compilationUnit) {
        this.fOwner = workingCopyOwner;
        this.fCu = iCompilationUnit;
        this.fRoot = compilationUnit;
    }

    public void rememberContent() {
        this.fRememberContent = new Document();
    }

    public void setResolveBindings(boolean bl) {
        this.fResolveBindings = bl;
    }

    public void setStatementsRecovery(boolean bl) {
        this.fStatementsRecovery = bl;
    }

    public void setBindingRecovery(boolean bl) {
        this.fBindingsRecovery = bl;
    }

    public void clearASTRewrite() {
        this.fRewrite = null;
        this.fTextEditGroups = new ArrayList();
    }

    public void clearImportRewrites() {
        this.fImportRewrite = null;
    }

    public void clearASTAndImportRewrites() {
        this.clearASTRewrite();
        this.fImportRewrite = null;
    }

    public CategorizedTextEditGroup createCategorizedGroupDescription(String string, GroupCategorySet groupCategorySet) {
        CategorizedTextEditGroup categorizedTextEditGroup = new CategorizedTextEditGroup(string, groupCategorySet);
        this.fTextEditGroups.add(categorizedTextEditGroup);
        return categorizedTextEditGroup;
    }

    public TextEditGroup createGroupDescription(String string) {
        TextEditGroup textEditGroup = new TextEditGroup(string);
        this.fTextEditGroups.add(textEditGroup);
        return textEditGroup;
    }

    public CompilationUnitChange createChange() throws CoreException {
        return this.createChange(true, null);
    }

    public CompilationUnitChange createChange(boolean bl, IProgressMonitor iProgressMonitor) throws CoreException {
        return this.createChange(this.fCu.getElementName(), bl, iProgressMonitor);
    }

    public CompilationUnitChange createChange(String string, boolean bl, IProgressMonitor iProgressMonitor) throws CoreException {
        CompilationUnitChange compilationUnitChange = new CompilationUnitChange(string, this.fCu);
        MultiTextEdit multiTextEdit = new MultiTextEdit();
        compilationUnitChange.setEdit((TextEdit)multiTextEdit);
        return this.attachChange(compilationUnitChange, bl, iProgressMonitor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CompilationUnitChange attachChange(CompilationUnitChange compilationUnitChange, boolean bl, IProgressMonitor iProgressMonitor) throws CoreException {
        CompilationUnitChange compilationUnitChange2;
        try {
            block13: {
                block12: {
                    Object object;
                    TextEdit textEdit;
                    boolean bl2;
                    boolean bl3;
                    boolean bl4;
                    block11: {
                        bl4 = this.fRewrite != null;
                        bl3 = this.fImportRemover != null && this.fImportRemover.hasRemovedNodes();
                        boolean bl5 = bl2 = this.fImportRewrite != null && this.fImportRewrite.hasRecordedChanges() || bl3;
                        if (bl4 || bl3 || bl2) break block11;
                        break block12;
                    }
                    MultiTextEdit multiTextEdit = (MultiTextEdit)compilationUnitChange.getEdit();
                    if (multiTextEdit == null) {
                        multiTextEdit = new MultiTextEdit();
                        compilationUnitChange.setEdit((TextEdit)multiTextEdit);
                    }
                    if (bl4 && !CompilationUnitRewrite.isEmptyEdit(textEdit = this.fRememberContent != null ? this.fRewrite.rewriteAST(this.fRememberContent, this.fCu.getJavaProject().getOptions(true)) : this.fRewrite.rewriteAST())) {
                        multiTextEdit.addChild(textEdit);
                        if (bl) {
                            object = this.fTextEditGroups.iterator();
                            while (object.hasNext()) {
                                TextEditGroup textEditGroup = (TextEditGroup)object.next();
                                compilationUnitChange.addTextEditGroup(textEditGroup);
                            }
                        }
                    }
                    if (bl3) {
                        this.fImportRemover.applyRemoves(this.getImportRewrite());
                    }
                    if (bl2 && !CompilationUnitRewrite.isEmptyEdit(textEdit = this.fImportRewrite.rewriteImports(iProgressMonitor))) {
                        multiTextEdit.addChild(textEdit);
                        object = RefactoringCoreMessages.ASTData_update_imports;
                        compilationUnitChange.addTextEditGroup(new TextEditGroup((String)object, textEdit));
                    }
                    if (!CompilationUnitRewrite.isEmptyEdit((TextEdit)multiTextEdit)) break block13;
                }
                Object var11_7 = null;
                if (iProgressMonitor == null) return null;
                iProgressMonitor.done();
                return null;
            }
            compilationUnitChange2 = compilationUnitChange;
            Object var11_8 = null;
            if (iProgressMonitor == null) return compilationUnitChange2;
        }
        catch (Throwable throwable) {
            Object var11_9 = null;
            if (iProgressMonitor == null) throw throwable;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return compilationUnitChange2;
    }

    private static boolean isEmptyEdit(TextEdit textEdit) {
        Class<?> clazz = textEdit.getClass();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.text.edits.MultiTextEdit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz == clazz2 && !textEdit.hasChildren();
    }

    public ICompilationUnit getCu() {
        return this.fCu;
    }

    public CompilationUnit getRoot() {
        if (this.fRoot == null) {
            this.fRoot = new RefactoringASTParser(3).parse((ITypeRoot)this.fCu, this.fOwner, this.fResolveBindings, this.fStatementsRecovery, this.fBindingsRecovery, null);
        }
        return this.fRoot;
    }

    public AST getAST() {
        return this.getRoot().getAST();
    }

    public ASTRewrite getASTRewrite() {
        if (this.fRewrite == null) {
            this.fRewrite = ASTRewrite.create((AST)this.getRoot().getAST());
            if (this.fRememberContent != null) {
                try {
                    this.fRememberContent.set(this.fCu.getSource());
                }
                catch (JavaModelException javaModelException) {
                    this.fRememberContent = null;
                }
            }
        }
        return this.fRewrite;
    }

    public ImportRewrite getImportRewrite() {
        if (this.fImportRewrite == null) {
            try {
                this.fImportRewrite = this.fRoot == null ? StubUtility.createImportRewrite(this.fCu, true) : StubUtility.createImportRewrite(this.getRoot(), true);
            }
            catch (CoreException coreException) {
                JavaPlugin.log(coreException);
                throw new IllegalStateException(coreException.getMessage());
            }
        }
        return this.fImportRewrite;
    }

    public ImportRemover getImportRemover() {
        if (this.fImportRemover == null) {
            this.fImportRemover = new ImportRemover(this.fCu.getJavaProject(), this.getRoot());
        }
        return this.fImportRemover;
    }
}

