/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;

class MemberCheckUtil {
    private MemberCheckUtil() {
    }

    public static RefactoringStatus checkMembersInDestinationType(IMember[] iMemberArray, IType iType) throws JavaModelException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        int n = 0;
        while (n < iMemberArray.length) {
            if (iMemberArray[n].getElementType() == 9) {
                MemberCheckUtil.checkMethodInType(iType, refactoringStatus, (IMethod)iMemberArray[n]);
            } else if (iMemberArray[n].getElementType() == 8) {
                MemberCheckUtil.checkFieldInType(iType, refactoringStatus, (IField)iMemberArray[n]);
            } else if (iMemberArray[n].getElementType() == 7) {
                MemberCheckUtil.checkTypeInType(iType, refactoringStatus, (IType)iMemberArray[n]);
            }
            ++n;
        }
        return refactoringStatus;
    }

    private static void checkMethodInType(IType iType, RefactoringStatus refactoringStatus, IMethod iMethod) throws JavaModelException {
        IMethod[] iMethodArray = iType.getMethods();
        IMethod iMethod2 = MemberCheckUtil.findMethod(iMethod, iMethodArray);
        if (iMethod2 != null) {
            RefactoringStatusContext refactoringStatusContext = JavaStatusContext.create((ITypeRoot)iType.getCompilationUnit(), iMethod2.getSourceRange());
            String string = Messages.format(RefactoringCoreMessages.MemberCheckUtil_signature_exists, new String[]{iMethod.getElementName(), JavaModelUtil.getFullyQualifiedName(iType)});
            refactoringStatus.addError(string, refactoringStatusContext);
        } else {
            IMethod iMethod3 = Checks.findMethod(iMethod, iType);
            if (iMethod3 != null) {
                String string = Messages.format(RefactoringCoreMessages.MemberCheckUtil_same_param_count, new String[]{iMethod.getElementName(), JavaModelUtil.getFullyQualifiedName(iType)});
                RefactoringStatusContext refactoringStatusContext = JavaStatusContext.create((ITypeRoot)iType.getCompilationUnit(), iMethod3.getSourceRange());
                refactoringStatus.addWarning(string, refactoringStatusContext);
            }
        }
    }

    private static void checkFieldInType(IType iType, RefactoringStatus refactoringStatus, IField iField) throws JavaModelException {
        IField iField2 = iType.getField(iField.getElementName());
        if (!iField2.exists()) {
            return;
        }
        String string = Messages.format(RefactoringCoreMessages.MemberCheckUtil_field_exists, new String[]{iField.getElementName(), JavaModelUtil.getFullyQualifiedName(iType)});
        RefactoringStatusContext refactoringStatusContext = JavaStatusContext.create((ITypeRoot)iType.getCompilationUnit(), iField2.getSourceRange());
        refactoringStatus.addError(string, refactoringStatusContext);
    }

    private static void checkTypeInType(IType iType, RefactoringStatus refactoringStatus, IType iType2) throws JavaModelException {
        String string = iType2.getElementName();
        IType iType3 = iType.getType(string);
        if (iType3.exists()) {
            String string2 = Messages.format(RefactoringCoreMessages.MemberCheckUtil_type_name_conflict0, new String[]{string, JavaModelUtil.getFullyQualifiedName(iType)});
            RefactoringStatusContext refactoringStatusContext = JavaStatusContext.create((ITypeRoot)iType.getCompilationUnit(), iType3.getNameRange());
            refactoringStatus.addError(string2, refactoringStatusContext);
        } else {
            RefactoringStatusContext refactoringStatusContext;
            String string3;
            if (iType.getElementName().equals(string)) {
                string3 = Messages.format(RefactoringCoreMessages.MemberCheckUtil_type_name_conflict1, new String[]{JavaModelUtil.getFullyQualifiedName(iType2)});
                refactoringStatusContext = JavaStatusContext.create((ITypeRoot)iType.getCompilationUnit(), iType.getNameRange());
                refactoringStatus.addError(string3, refactoringStatusContext);
            }
            if (MemberCheckUtil.typeNameExistsInEnclosingTypeChain(iType, string)) {
                string3 = Messages.format(RefactoringCoreMessages.MemberCheckUtil_type_name_conflict2, new String[]{JavaModelUtil.getFullyQualifiedName(iType2)});
                refactoringStatusContext = JavaStatusContext.create((ITypeRoot)iType.getCompilationUnit(), iType.getNameRange());
                refactoringStatus.addError(string3, refactoringStatusContext);
            }
            MemberCheckUtil.checkHierarchyOfEnclosedTypes(iType, refactoringStatus, iType2);
        }
    }

    private static void checkHierarchyOfEnclosedTypes(IType iType, RefactoringStatus refactoringStatus, IType iType2) throws JavaModelException {
        IType[] iTypeArray = MemberCheckUtil.getAllEnclosedTypes(iType2);
        int n = 0;
        while (n < iTypeArray.length) {
            RefactoringStatusContext refactoringStatusContext;
            String string;
            IType iType3 = iTypeArray[n];
            if (iType.getElementName().equals(iType3.getElementName())) {
                string = Messages.format(RefactoringCoreMessages.MemberCheckUtil_type_name_conflict3, new String[]{JavaModelUtil.getFullyQualifiedName(iType3), JavaModelUtil.getFullyQualifiedName(iType2)});
                refactoringStatusContext = JavaStatusContext.create((ITypeRoot)iType.getCompilationUnit(), iType.getNameRange());
                refactoringStatus.addError(string, refactoringStatusContext);
            }
            if (MemberCheckUtil.typeNameExistsInEnclosingTypeChain(iType, iType3.getElementName())) {
                string = Messages.format(RefactoringCoreMessages.MemberCheckUtil_type_name_conflict4, new String[]{JavaModelUtil.getFullyQualifiedName(iType3), JavaModelUtil.getFullyQualifiedName(iType2)});
                refactoringStatusContext = JavaStatusContext.create((ITypeRoot)iType.getCompilationUnit(), iType.getNameRange());
                refactoringStatus.addError(string, refactoringStatusContext);
            }
            ++n;
        }
    }

    private static IType[] getAllEnclosedTypes(IType iType) throws JavaModelException {
        ArrayList<IType> arrayList = new ArrayList<IType>(2);
        IType[] iTypeArray = iType.getTypes();
        arrayList.addAll(Arrays.asList(iTypeArray));
        int n = 0;
        while (n < iTypeArray.length) {
            IType iType2 = iTypeArray[n];
            arrayList.addAll(Arrays.asList(MemberCheckUtil.getAllEnclosedTypes(iType2)));
            ++n;
        }
        return arrayList.toArray(new IType[arrayList.size()]);
    }

    private static boolean typeNameExistsInEnclosingTypeChain(IType iType, String string) {
        IType iType2 = iType.getDeclaringType();
        while (iType2 != null) {
            if (iType2.getElementName().equals(string)) {
                return true;
            }
            iType2 = iType2.getDeclaringType();
        }
        return false;
    }

    public static IMethod findMethod(IMethod iMethod, IMethod[] iMethodArray) throws JavaModelException {
        String string = iMethod.getElementName();
        String[] stringArray = iMethod.getParameterTypes();
        boolean bl = iMethod.isConstructor();
        int n = 0;
        while (n < iMethodArray.length) {
            if (JavaModelUtil.isSameMethodSignature(string, stringArray, bl, iMethodArray[n])) {
                return iMethodArray[n];
            }
            ++n;
        }
        return null;
    }
}

