/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.dom.ArrayCreation;
import org.eclipse.wst.jsdt.core.dom.ArrayInitializer;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.CastExpression;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.ConditionalExpression;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.InstanceofExpression;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.ParenthesizedExpression;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.SuperFieldAccess;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.ThisExpression;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.ConstraintCreator;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.ConstraintVariable;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.ConstraintVariableFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.DeclaringTypeVariable;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.IConstraintVariableFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.IContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.ITypeConstraint;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.ITypeConstraintFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.NullContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.ParameterTypeVariable;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.RawBindingVariable;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.ReturnTypeVariable;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.TypeConstraintFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.TypeVariable;

public class FullConstraintCreator
extends ConstraintCreator {
    private final IConstraintVariableFactory fConstraintVariableFactory;
    private final ITypeConstraintFactory fTypeConstraintFactory;
    private IContext fContext;

    public FullConstraintCreator() {
        this(new ConstraintVariableFactory(), new TypeConstraintFactory());
    }

    public FullConstraintCreator(IConstraintVariableFactory iConstraintVariableFactory, ITypeConstraintFactory iTypeConstraintFactory) {
        Assert.isTrue((iConstraintVariableFactory != null ? 1 : 0) != 0);
        this.fConstraintVariableFactory = iConstraintVariableFactory;
        this.fTypeConstraintFactory = iTypeConstraintFactory;
        this.fContext = new NullContext();
    }

    public IContext getContext() {
        return this.fContext;
    }

    public void setContext(IContext iContext) {
        this.fContext = iContext;
    }

    public ITypeConstraintFactory getConstraintFactory() {
        return this.fTypeConstraintFactory;
    }

    public IConstraintVariableFactory getConstraintVariableFactory() {
        return this.fConstraintVariableFactory;
    }

    public ITypeConstraint[] create(ArrayInitializer arrayInitializer) {
        ITypeBinding iTypeBinding = arrayInitializer.resolveTypeBinding();
        Assert.isTrue((boolean)iTypeBinding.isArray());
        List list = arrayInitializer.expressions();
        ArrayList<ITypeConstraint> arrayList = new ArrayList<ITypeConstraint>();
        Type type = FullConstraintCreator.getTypeParent(arrayInitializer);
        TypeVariable typeVariable = this.fConstraintVariableFactory.makeTypeVariable(type);
        int n = 0;
        while (n < list.size()) {
            Expression expression = (Expression)list.get(n);
            ITypeConstraint[] iTypeConstraintArray = this.fTypeConstraintFactory.createSubtypeConstraint(this.fConstraintVariableFactory.makeExpressionOrTypeVariable(expression, this.getContext()), typeVariable);
            arrayList.addAll(Arrays.asList(iTypeConstraintArray));
            ++n;
        }
        return arrayList.toArray(new ITypeConstraint[arrayList.size()]);
    }

    public ITypeConstraint[] create(Assignment assignment) {
        return this.fTypeConstraintFactory.createSubtypeConstraint(this.fConstraintVariableFactory.makeExpressionOrTypeVariable(assignment.getRightHandSide(), this.getContext()), this.fConstraintVariableFactory.makeExpressionOrTypeVariable(assignment.getLeftHandSide(), this.getContext()));
    }

    public ITypeConstraint[] create(CastExpression castExpression) {
        Expression expression = castExpression.getExpression();
        Type type = castExpression.getType();
        ITypeConstraint[] iTypeConstraintArray = this.fTypeConstraintFactory.createDefinesConstraint(this.fConstraintVariableFactory.makeExpressionOrTypeVariable((Expression)castExpression, this.getContext()), this.fConstraintVariableFactory.makeTypeVariable(castExpression.getType()));
        if (FullConstraintCreator.isClassBinding(expression.resolveTypeBinding()) && FullConstraintCreator.isClassBinding(type.resolveBinding())) {
            ConstraintVariable constraintVariable = this.fConstraintVariableFactory.makeExpressionOrTypeVariable(expression, this.getContext());
            ConstraintVariable constraintVariable2 = this.fConstraintVariableFactory.makeExpressionOrTypeVariable((Expression)castExpression, this.getContext());
            ITypeConstraint[] iTypeConstraintArray2 = this.createOrOrSubtypeConstraint(constraintVariable, constraintVariable2);
            if (iTypeConstraintArray.length == 0) {
                return iTypeConstraintArray2;
            }
            ITypeConstraint iTypeConstraint = iTypeConstraintArray[0];
            ArrayList<ITypeConstraint> arrayList = new ArrayList<ITypeConstraint>();
            arrayList.add(iTypeConstraint);
            arrayList.addAll(Arrays.asList(iTypeConstraintArray2));
            return arrayList.toArray(new ITypeConstraint[arrayList.size()]);
        }
        return iTypeConstraintArray;
    }

    public ITypeConstraint[] create(CatchClause catchClause) {
        SingleVariableDeclaration singleVariableDeclaration = catchClause.getException();
        ConstraintVariable constraintVariable = this.fConstraintVariableFactory.makeExpressionOrTypeVariable((Expression)singleVariableDeclaration.getName(), this.getContext());
        ITypeConstraint[] iTypeConstraintArray = this.fTypeConstraintFactory.createDefinesConstraint(constraintVariable, this.fConstraintVariableFactory.makeTypeVariable(singleVariableDeclaration.getType()));
        ITypeBinding iTypeBinding = catchClause.getAST().resolveWellKnownType("java.lang.Throwable");
        ITypeConstraint[] iTypeConstraintArray2 = this.fTypeConstraintFactory.createSubtypeConstraint(constraintVariable, this.fConstraintVariableFactory.makeRawBindingVariable(iTypeBinding));
        ArrayList<ITypeConstraint> arrayList = new ArrayList<ITypeConstraint>();
        arrayList.addAll(Arrays.asList(iTypeConstraintArray));
        arrayList.addAll(Arrays.asList(iTypeConstraintArray2));
        return arrayList.toArray(new ITypeConstraint[arrayList.size()]);
    }

    public ITypeConstraint[] create(ClassInstanceCreation classInstanceCreation) {
        List list = classInstanceCreation.arguments();
        ArrayList<ITypeConstraint> arrayList = new ArrayList<ITypeConstraint>(list.size());
        IMethodBinding iMethodBinding = classInstanceCreation.resolveConstructorBinding();
        arrayList.addAll(Arrays.asList(this.getArgumentConstraints(list, iMethodBinding)));
        if (classInstanceCreation.getAnonymousClassDeclaration() == null) {
            ConstraintVariable constraintVariable = this.fConstraintVariableFactory.makeExpressionOrTypeVariable((Expression)classInstanceCreation, this.getContext());
            RawBindingVariable rawBindingVariable = this.fConstraintVariableFactory.makeRawBindingVariable(classInstanceCreation.resolveTypeBinding());
            arrayList.addAll(Arrays.asList(this.fTypeConstraintFactory.createDefinesConstraint(constraintVariable, rawBindingVariable)));
        }
        return arrayList.toArray(new ITypeConstraint[arrayList.size()]);
    }

    public ITypeConstraint[] create(ConstructorInvocation constructorInvocation) {
        List list = constructorInvocation.arguments();
        ArrayList<ITypeConstraint> arrayList = new ArrayList<ITypeConstraint>(list.size());
        IMethodBinding iMethodBinding = constructorInvocation.resolveConstructorBinding();
        arrayList.addAll(Arrays.asList(this.getArgumentConstraints(list, iMethodBinding)));
        return arrayList.toArray(new ITypeConstraint[arrayList.size()]);
    }

    public ITypeConstraint[] create(FieldAccess fieldAccess) {
        Expression expression = fieldAccess.getExpression();
        SimpleName simpleName = fieldAccess.getName();
        IBinding iBinding = simpleName.resolveBinding();
        if (!(iBinding instanceof IVariableBinding)) {
            return new ITypeConstraint[0];
        }
        IVariableBinding iVariableBinding = (IVariableBinding)iBinding;
        return this.createConstraintsForAccessToField(iVariableBinding, expression, (Expression)fieldAccess);
    }

    public ITypeConstraint[] create(FieldDeclaration fieldDeclaration) {
        ArrayList<ITypeConstraint> arrayList = new ArrayList<ITypeConstraint>();
        arrayList.addAll(Arrays.asList(this.getConstraintsFromFragmentList(fieldDeclaration.fragments(), fieldDeclaration.getType())));
        arrayList.addAll(this.getConstraintsForHiding(fieldDeclaration));
        arrayList.addAll(this.getConstraintsForFieldDeclaringTypes(fieldDeclaration));
        return arrayList.toArray(new ITypeConstraint[arrayList.size()]);
    }

    public ITypeConstraint[] create(InstanceofExpression instanceofExpression) {
        Expression expression = instanceofExpression.getLeftOperand();
        Type type = instanceofExpression.getRightOperand();
        if (FullConstraintCreator.isClassBinding(expression.resolveTypeBinding()) && FullConstraintCreator.isClassBinding(type.resolveBinding())) {
            ConstraintVariable constraintVariable = this.fConstraintVariableFactory.makeExpressionOrTypeVariable(expression, this.getContext());
            TypeVariable typeVariable = this.fConstraintVariableFactory.makeTypeVariable(type);
            return this.createOrOrSubtypeConstraint(constraintVariable, typeVariable);
        }
        return new ITypeConstraint[0];
    }

    public ITypeConstraint[] create(ConditionalExpression conditionalExpression) {
        ArrayList<ITypeConstraint> arrayList = new ArrayList<ITypeConstraint>();
        Expression expression = conditionalExpression.getThenExpression();
        Expression expression2 = conditionalExpression.getElseExpression();
        ConstraintVariable constraintVariable = this.fConstraintVariableFactory.makeExpressionOrTypeVariable((Expression)conditionalExpression, this.getContext());
        ConstraintVariable constraintVariable2 = this.fConstraintVariableFactory.makeExpressionOrTypeVariable(expression, this.getContext());
        ConstraintVariable constraintVariable3 = this.fConstraintVariableFactory.makeExpressionOrTypeVariable(expression2, this.getContext());
        ITypeConstraint[] iTypeConstraintArray = this.fTypeConstraintFactory.createEqualsConstraint(constraintVariable2, constraintVariable3);
        ITypeConstraint[] iTypeConstraintArray2 = this.fTypeConstraintFactory.createSubtypeConstraint(constraintVariable2, constraintVariable);
        ITypeConstraint[] iTypeConstraintArray3 = this.fTypeConstraintFactory.createSubtypeConstraint(constraintVariable3, constraintVariable);
        arrayList.addAll(Arrays.asList(iTypeConstraintArray));
        arrayList.addAll(Arrays.asList(iTypeConstraintArray2));
        arrayList.addAll(Arrays.asList(iTypeConstraintArray3));
        return arrayList.toArray(new ITypeConstraint[arrayList.size()]);
    }

    public ITypeConstraint[] create(MethodDeclaration methodDeclaration) {
        ITypeConstraint[] iTypeConstraintArray;
        ArrayList<ITypeConstraint> arrayList = new ArrayList<ITypeConstraint>();
        IMethodBinding iMethodBinding = methodDeclaration.resolveBinding();
        if (iMethodBinding == null) {
            return new ITypeConstraint[0];
        }
        ITypeConstraint[] iTypeConstraintArray2 = this.fTypeConstraintFactory.createDefinesConstraint(this.fConstraintVariableFactory.makeDeclaringTypeVariable(iMethodBinding), this.fConstraintVariableFactory.makeRawBindingVariable(iMethodBinding.getDeclaringClass()));
        arrayList.addAll(Arrays.asList(iTypeConstraintArray2));
        if (!iMethodBinding.isConstructor() && !iMethodBinding.getReturnType().isPrimitive()) {
            ReturnTypeVariable returnTypeVariable = this.fConstraintVariableFactory.makeReturnTypeVariable(iMethodBinding);
            TypeVariable typeVariable = this.fConstraintVariableFactory.makeTypeVariable(methodDeclaration.getReturnType2());
            iTypeConstraintArray = this.fTypeConstraintFactory.createDefinesConstraint(returnTypeVariable, typeVariable);
            arrayList.addAll(Arrays.asList(iTypeConstraintArray));
        }
        int n = 0;
        int n2 = methodDeclaration.parameters().size();
        while (n < n2) {
            iTypeConstraintArray = (ITypeConstraint[])methodDeclaration.parameters().get(n);
            ParameterTypeVariable parameterTypeVariable = this.fConstraintVariableFactory.makeParameterTypeVariable(iMethodBinding, n);
            ConstraintVariable constraintVariable = this.fConstraintVariableFactory.makeExpressionOrTypeVariable((Expression)iTypeConstraintArray.getName(), this.getContext());
            ITypeConstraint[] iTypeConstraintArray3 = this.fTypeConstraintFactory.createDefinesConstraint(parameterTypeVariable, constraintVariable);
            arrayList.addAll(Arrays.asList(iTypeConstraintArray3));
            ++n;
        }
        if (MethodChecks.isVirtual(iMethodBinding)) {
            Collection collection = this.getConstraintsForOverriding(iMethodBinding);
            arrayList.addAll(collection);
        }
        return arrayList.toArray(new ITypeConstraint[arrayList.size()]);
    }

    public ITypeConstraint[] create(ParenthesizedExpression parenthesizedExpression) {
        ConstraintVariable constraintVariable = this.fConstraintVariableFactory.makeExpressionOrTypeVariable((Expression)parenthesizedExpression, this.getContext());
        ConstraintVariable constraintVariable2 = this.fConstraintVariableFactory.makeExpressionOrTypeVariable(parenthesizedExpression.getExpression(), this.getContext());
        ITypeConstraint[] iTypeConstraintArray = this.fTypeConstraintFactory.createEqualsConstraint(constraintVariable, constraintVariable2);
        return iTypeConstraintArray;
    }

    public ITypeConstraint[] create(MethodInvocation methodInvocation) {
        List list = methodInvocation.arguments();
        ArrayList<ITypeConstraint> arrayList = new ArrayList<ITypeConstraint>(list.size());
        IMethodBinding iMethodBinding = methodInvocation.resolveMethodBinding();
        if (iMethodBinding == null) {
            return new ITypeConstraint[0];
        }
        ITypeConstraint[] iTypeConstraintArray = this.getReturnTypeConstraint((Expression)methodInvocation, iMethodBinding);
        arrayList.addAll(Arrays.asList(iTypeConstraintArray));
        arrayList.addAll(Arrays.asList(this.getArgumentConstraints(list, iMethodBinding)));
        if (methodInvocation.getExpression() != null) {
            if (MethodChecks.isVirtual(iMethodBinding)) {
                IMethodBinding[] iMethodBindingArray = FullConstraintCreator.getRootDefs(iMethodBinding);
                Assert.isTrue((iMethodBindingArray.length > 0 ? 1 : 0) != 0);
                ConstraintVariable constraintVariable = this.fConstraintVariableFactory.makeExpressionOrTypeVariable(methodInvocation.getExpression(), this.getContext());
                if (iMethodBindingArray.length == 1) {
                    arrayList.addAll(Arrays.asList(this.fTypeConstraintFactory.createSubtypeConstraint(constraintVariable, this.fConstraintVariableFactory.makeDeclaringTypeVariable(iMethodBindingArray[0]))));
                } else {
                    ArrayList<ITypeConstraint> arrayList2 = new ArrayList<ITypeConstraint>();
                    int n = 0;
                    while (n < iMethodBindingArray.length) {
                        DeclaringTypeVariable declaringTypeVariable = this.fConstraintVariableFactory.makeDeclaringTypeVariable(iMethodBindingArray[n]);
                        ITypeConstraint[] iTypeConstraintArray2 = this.fTypeConstraintFactory.createSubtypeConstraint(constraintVariable, declaringTypeVariable);
                        arrayList2.addAll(Arrays.asList(iTypeConstraintArray2));
                        ++n;
                    }
                    ITypeConstraint[] iTypeConstraintArray3 = arrayList2.toArray(new ITypeConstraint[arrayList2.size()]);
                    if (iTypeConstraintArray3.length > 0) {
                        arrayList.add(this.fTypeConstraintFactory.createCompositeOrTypeConstraint(iTypeConstraintArray3));
                    }
                }
            } else {
                DeclaringTypeVariable declaringTypeVariable = this.fConstraintVariableFactory.makeDeclaringTypeVariable(iMethodBinding);
                ConstraintVariable constraintVariable = this.fConstraintVariableFactory.makeExpressionOrTypeVariable(methodInvocation.getExpression(), this.getContext());
                arrayList.addAll(Arrays.asList(this.fTypeConstraintFactory.createSubtypeConstraint(constraintVariable, declaringTypeVariable)));
            }
        }
        return arrayList.toArray(new ITypeConstraint[arrayList.size()]);
    }

    public ITypeConstraint[] create(QualifiedName qualifiedName) {
        IVariableBinding iVariableBinding;
        SimpleName simpleName = qualifiedName.getName();
        Name name = qualifiedName.getQualifier();
        IBinding iBinding = simpleName.resolveBinding();
        if (iBinding instanceof IVariableBinding && (iVariableBinding = (IVariableBinding)iBinding).isField()) {
            return this.createConstraintsForAccessToField(iVariableBinding, (Expression)name, (Expression)qualifiedName);
        }
        return new ITypeConstraint[0];
    }

    public ITypeConstraint[] create(ReturnStatement returnStatement) {
        if (returnStatement.getExpression() == null) {
            return new ITypeConstraint[0];
        }
        ReturnTypeVariable returnTypeVariable = this.fConstraintVariableFactory.makeReturnTypeVariable(returnStatement);
        return this.fTypeConstraintFactory.createSubtypeConstraint(this.fConstraintVariableFactory.makeExpressionOrTypeVariable(returnStatement.getExpression(), this.getContext()), returnTypeVariable);
    }

    public ITypeConstraint[] create(SingleVariableDeclaration singleVariableDeclaration) {
        ITypeConstraint[] iTypeConstraintArray = this.fTypeConstraintFactory.createDefinesConstraint(this.fConstraintVariableFactory.makeExpressionOrTypeVariable((Expression)singleVariableDeclaration.getName(), this.getContext()), this.fConstraintVariableFactory.makeTypeVariable(singleVariableDeclaration.getType()));
        if (singleVariableDeclaration.getInitializer() == null) {
            return iTypeConstraintArray;
        }
        ITypeConstraint[] iTypeConstraintArray2 = this.fTypeConstraintFactory.createSubtypeConstraint(this.fConstraintVariableFactory.makeExpressionOrTypeVariable(singleVariableDeclaration.getInitializer(), this.getContext()), this.fConstraintVariableFactory.makeExpressionOrTypeVariable((Expression)singleVariableDeclaration.getName(), this.getContext()));
        if (iTypeConstraintArray.length == 0 && iTypeConstraintArray2.length == 0) {
            return new ITypeConstraint[0];
        }
        if (iTypeConstraintArray.length == 0) {
            return iTypeConstraintArray2;
        }
        if (iTypeConstraintArray2.length == 0) {
            return iTypeConstraintArray;
        }
        ArrayList<ITypeConstraint> arrayList = new ArrayList<ITypeConstraint>();
        arrayList.addAll(Arrays.asList(iTypeConstraintArray));
        arrayList.addAll(Arrays.asList(iTypeConstraintArray2));
        return (ITypeConstraint[])arrayList.toArray();
    }

    public ITypeConstraint[] create(SuperConstructorInvocation superConstructorInvocation) {
        List list = superConstructorInvocation.arguments();
        ArrayList<ITypeConstraint> arrayList = new ArrayList<ITypeConstraint>(list.size());
        IMethodBinding iMethodBinding = superConstructorInvocation.resolveConstructorBinding();
        arrayList.addAll(Arrays.asList(this.getArgumentConstraints(list, iMethodBinding)));
        return arrayList.toArray(new ITypeConstraint[arrayList.size()]);
    }

    public ITypeConstraint[] create(SuperFieldAccess superFieldAccess) {
        SimpleName simpleName = superFieldAccess.getName();
        IBinding iBinding = simpleName.resolveBinding();
        if (!(iBinding instanceof IVariableBinding)) {
            return new ITypeConstraint[0];
        }
        IVariableBinding iVariableBinding = (IVariableBinding)iBinding;
        return this.createConstraintsForAccessToField(iVariableBinding, null, (Expression)superFieldAccess);
    }

    public ITypeConstraint[] create(SuperMethodInvocation superMethodInvocation) {
        List list = superMethodInvocation.arguments();
        ArrayList<ITypeConstraint> arrayList = new ArrayList<ITypeConstraint>(list.size());
        IMethodBinding iMethodBinding = superMethodInvocation.resolveMethodBinding();
        ITypeConstraint[] iTypeConstraintArray = this.getReturnTypeConstraint((Expression)superMethodInvocation, iMethodBinding);
        arrayList.addAll(Arrays.asList(iTypeConstraintArray));
        arrayList.addAll(Arrays.asList(this.getArgumentConstraints(list, iMethodBinding)));
        return arrayList.toArray(new ITypeConstraint[arrayList.size()]);
    }

    public ITypeConstraint[] create(ThisExpression thisExpression) {
        ConstraintVariable constraintVariable = this.fConstraintVariableFactory.makeExpressionOrTypeVariable((Expression)thisExpression, this.getContext());
        RawBindingVariable rawBindingVariable = this.fConstraintVariableFactory.makeRawBindingVariable(thisExpression.resolveTypeBinding());
        return this.fTypeConstraintFactory.createDefinesConstraint(constraintVariable, rawBindingVariable);
    }

    public ITypeConstraint[] create(VariableDeclarationExpression variableDeclarationExpression) {
        return this.getConstraintsFromFragmentList(variableDeclarationExpression.fragments(), variableDeclarationExpression.getType());
    }

    public ITypeConstraint[] create(VariableDeclarationFragment variableDeclarationFragment) {
        if (variableDeclarationFragment.getInitializer() == null) {
            return new ITypeConstraint[0];
        }
        return this.fTypeConstraintFactory.createSubtypeConstraint(this.fConstraintVariableFactory.makeExpressionOrTypeVariable(variableDeclarationFragment.getInitializer(), this.getContext()), this.fConstraintVariableFactory.makeExpressionOrTypeVariable((Expression)variableDeclarationFragment.getName(), this.getContext()));
    }

    public ITypeConstraint[] create(VariableDeclarationStatement variableDeclarationStatement) {
        return this.getConstraintsFromFragmentList(variableDeclarationStatement.fragments(), variableDeclarationStatement.getType());
    }

    private Collection getConstraintsForFieldDeclaringTypes(FieldDeclaration fieldDeclaration) {
        ArrayList<ITypeConstraint> arrayList = new ArrayList<ITypeConstraint>(fieldDeclaration.fragments().size());
        Iterator iterator = fieldDeclaration.fragments().iterator();
        while (iterator.hasNext()) {
            VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)iterator.next();
            IVariableBinding iVariableBinding = variableDeclarationFragment.resolveBinding();
            Assert.isTrue((boolean)iVariableBinding.isField());
            arrayList.addAll(Arrays.asList(this.fTypeConstraintFactory.createDefinesConstraint(this.fConstraintVariableFactory.makeDeclaringTypeVariable(iVariableBinding), this.fConstraintVariableFactory.makeRawBindingVariable(iVariableBinding.getDeclaringClass()))));
        }
        return arrayList;
    }

    private Collection getConstraintsForHiding(FieldDeclaration fieldDeclaration) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = fieldDeclaration.fragments().iterator();
        while (iterator.hasNext()) {
            arrayList.addAll(this.getConstraintsForHiding((VariableDeclarationFragment)iterator.next()));
        }
        return arrayList;
    }

    private Collection getConstraintsForHiding(VariableDeclarationFragment variableDeclarationFragment) {
        ArrayList<ITypeConstraint> arrayList = new ArrayList<ITypeConstraint>();
        IVariableBinding iVariableBinding = variableDeclarationFragment.resolveBinding();
        Assert.isTrue((boolean)iVariableBinding.isField());
        Set set = FullConstraintCreator.getDeclaringSuperTypes(iVariableBinding);
        DeclaringTypeVariable declaringTypeVariable = this.fConstraintVariableFactory.makeDeclaringTypeVariable(iVariableBinding);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ITypeBinding iTypeBinding = (ITypeBinding)iterator.next();
            IVariableBinding iVariableBinding2 = FullConstraintCreator.findField(iVariableBinding, iTypeBinding);
            Assert.isTrue((boolean)iVariableBinding2.isField());
            DeclaringTypeVariable declaringTypeVariable2 = this.fConstraintVariableFactory.makeDeclaringTypeVariable(iVariableBinding2);
            arrayList.addAll(Arrays.asList(this.fTypeConstraintFactory.createStrictSubtypeConstraint(declaringTypeVariable, declaringTypeVariable2)));
        }
        return arrayList;
    }

    private ITypeConstraint[] getConstraintsFromFragmentList(List list, Type type) {
        int n = list.size();
        TypeVariable typeVariable = this.fConstraintVariableFactory.makeTypeVariable(type);
        ArrayList<ITypeConstraint> arrayList = new ArrayList<ITypeConstraint>(n * (n - 1) / 2);
        int n2 = 0;
        while (n2 < n) {
            VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)list.get(n2);
            SimpleName simpleName = variableDeclarationFragment.getName();
            arrayList.addAll(Arrays.asList(this.fTypeConstraintFactory.createDefinesConstraint(this.fConstraintVariableFactory.makeExpressionOrTypeVariable((Expression)simpleName, this.getContext()), typeVariable)));
            int n3 = n2 + 1;
            while (n3 < n) {
                VariableDeclarationFragment variableDeclarationFragment2 = (VariableDeclarationFragment)list.get(n3);
                arrayList.addAll(Arrays.asList(this.fTypeConstraintFactory.createEqualsConstraint(this.fConstraintVariableFactory.makeExpressionOrTypeVariable((Expression)simpleName, this.getContext()), this.fConstraintVariableFactory.makeExpressionOrTypeVariable((Expression)variableDeclarationFragment2.getName(), this.getContext()))));
                ++n3;
            }
            ++n2;
        }
        return arrayList.toArray(new ITypeConstraint[arrayList.size()]);
    }

    private Collection getConstraintsForOverriding(IMethodBinding iMethodBinding) {
        ArrayList<ITypeConstraint> arrayList = new ArrayList<ITypeConstraint>();
        Set set = FullConstraintCreator.getDeclaringSuperTypes(iMethodBinding);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ITypeBinding iTypeBinding = (ITypeBinding)iterator.next();
            IMethodBinding iMethodBinding2 = FullConstraintCreator.findMethod(iMethodBinding, iTypeBinding);
            Assert.isNotNull((Object)iMethodBinding2);
            if (Bindings.equals((IBinding)iMethodBinding, (IBinding)iMethodBinding2)) continue;
            ITypeConstraint[] iTypeConstraintArray = this.fTypeConstraintFactory.createEqualsConstraint(this.fConstraintVariableFactory.makeReturnTypeVariable(iMethodBinding2), this.fConstraintVariableFactory.makeReturnTypeVariable(iMethodBinding));
            arrayList.addAll(Arrays.asList(iTypeConstraintArray));
            Assert.isTrue((iMethodBinding2.getParameterTypes().length == iMethodBinding.getParameterTypes().length ? 1 : 0) != 0);
            int n = 0;
            int n2 = iMethodBinding2.getParameterTypes().length;
            while (n < n2) {
                ITypeConstraint[] iTypeConstraintArray2 = this.fTypeConstraintFactory.createEqualsConstraint(this.fConstraintVariableFactory.makeParameterTypeVariable(iMethodBinding2, n), this.fConstraintVariableFactory.makeParameterTypeVariable(iMethodBinding, n));
                arrayList.addAll(Arrays.asList(iTypeConstraintArray2));
                ++n;
            }
            ITypeConstraint[] iTypeConstraintArray3 = this.fTypeConstraintFactory.createStrictSubtypeConstraint(this.fConstraintVariableFactory.makeDeclaringTypeVariable(iMethodBinding), this.fConstraintVariableFactory.makeDeclaringTypeVariable(iMethodBinding2));
            arrayList.addAll(Arrays.asList(iTypeConstraintArray3));
        }
        return arrayList;
    }

    private ITypeConstraint[] getReturnTypeConstraint(Expression expression, IMethodBinding iMethodBinding) {
        if (iMethodBinding == null || iMethodBinding.isConstructor() || iMethodBinding.getReturnType().isPrimitive()) {
            return new ITypeConstraint[0];
        }
        ReturnTypeVariable returnTypeVariable = this.fConstraintVariableFactory.makeReturnTypeVariable(iMethodBinding);
        ConstraintVariable constraintVariable = this.fConstraintVariableFactory.makeExpressionOrTypeVariable(expression, this.getContext());
        return this.fTypeConstraintFactory.createDefinesConstraint(constraintVariable, returnTypeVariable);
    }

    private ITypeConstraint[] getArgumentConstraints(List list, IMethodBinding iMethodBinding) {
        ArrayList<ITypeConstraint> arrayList = new ArrayList<ITypeConstraint>(list.size());
        int n = 0;
        int n2 = list.size();
        while (n < n2) {
            Expression expression = (Expression)list.get(n);
            ConstraintVariable constraintVariable = this.fConstraintVariableFactory.makeExpressionOrTypeVariable(expression, this.getContext());
            ParameterTypeVariable parameterTypeVariable = this.fConstraintVariableFactory.makeParameterTypeVariable(iMethodBinding, n);
            ITypeConstraint[] iTypeConstraintArray = this.fTypeConstraintFactory.createSubtypeConstraint(constraintVariable, parameterTypeVariable);
            arrayList.addAll(Arrays.asList(iTypeConstraintArray));
            ++n;
        }
        return arrayList.toArray(new ITypeConstraint[arrayList.size()]);
    }

    private static Type getTypeParent(ArrayInitializer arrayInitializer) {
        if (arrayInitializer.getParent() instanceof ArrayCreation) {
            return ((ArrayCreation)arrayInitializer.getParent()).getType().getElementType();
        }
        if (arrayInitializer.getParent() instanceof ArrayInitializer) {
            return FullConstraintCreator.getTypeParent((ArrayInitializer)arrayInitializer.getParent());
        }
        if (arrayInitializer.getParent() instanceof VariableDeclaration) {
            VariableDeclaration variableDeclaration = (VariableDeclaration)arrayInitializer.getParent();
            if (variableDeclaration.getParent() instanceof VariableDeclarationStatement) {
                Type type = ((VariableDeclarationStatement)variableDeclaration.getParent()).getType();
                return ASTNodes.getElementType(type);
            }
            if (variableDeclaration.getParent() instanceof VariableDeclarationExpression) {
                Type type = ((VariableDeclarationExpression)variableDeclaration.getParent()).getType();
                return ASTNodes.getElementType(type);
            }
            if (variableDeclaration.getParent() instanceof FieldDeclaration) {
                Type type = ((FieldDeclaration)variableDeclaration.getParent()).getType();
                return ASTNodes.getElementType(type);
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    private ITypeConstraint[] createOrOrSubtypeConstraint(ConstraintVariable constraintVariable, ConstraintVariable constraintVariable2) {
        ITypeConstraint[] iTypeConstraintArray = this.fTypeConstraintFactory.createSubtypeConstraint(constraintVariable, constraintVariable2);
        ITypeConstraint[] iTypeConstraintArray2 = this.fTypeConstraintFactory.createSubtypeConstraint(constraintVariable2, constraintVariable);
        if (iTypeConstraintArray.length == 0 && iTypeConstraintArray2.length == 0) {
            return new ITypeConstraint[0];
        }
        return new ITypeConstraint[]{this.fTypeConstraintFactory.createCompositeOrTypeConstraint(new ITypeConstraint[]{iTypeConstraintArray[0], iTypeConstraintArray2[0]})};
    }

    private ITypeConstraint[] createConstraintsForAccessToField(IVariableBinding iVariableBinding, Expression expression, Expression expression2) {
        Assert.isTrue((boolean)iVariableBinding.isField());
        ITypeConstraint[] iTypeConstraintArray = this.fTypeConstraintFactory.createDefinesConstraint(this.fConstraintVariableFactory.makeExpressionOrTypeVariable(expression2, this.getContext()), this.fConstraintVariableFactory.makeRawBindingVariable(iVariableBinding.getType()));
        if (expression == null) {
            return iTypeConstraintArray;
        }
        ITypeConstraint[] iTypeConstraintArray2 = this.fTypeConstraintFactory.createSubtypeConstraint(this.fConstraintVariableFactory.makeExpressionOrTypeVariable(expression, this.getContext()), this.fConstraintVariableFactory.makeDeclaringTypeVariable(iVariableBinding));
        if (iTypeConstraintArray.length == 0) {
            return iTypeConstraintArray2;
        }
        if (iTypeConstraintArray2.length == 0) {
            return iTypeConstraintArray;
        }
        return new ITypeConstraint[]{iTypeConstraintArray[0], iTypeConstraintArray2[0]};
    }

    private static IVariableBinding findField(IVariableBinding iVariableBinding, ITypeBinding iTypeBinding) {
        if (iVariableBinding.getDeclaringClass().equals((Object)iTypeBinding)) {
            return iVariableBinding;
        }
        return Bindings.findFieldInType(iTypeBinding, iVariableBinding.getName());
    }

    private static Set getDeclaringSuperTypes(IVariableBinding iVariableBinding) {
        ITypeBinding[] iTypeBindingArray = Bindings.getAllSuperTypes(iVariableBinding.getDeclaringClass());
        HashSet<ITypeBinding> hashSet = new HashSet<ITypeBinding>();
        int n = 0;
        while (n < iTypeBindingArray.length) {
            ITypeBinding iTypeBinding = iTypeBindingArray[n];
            if (FullConstraintCreator.findField(iVariableBinding, iTypeBinding) != null) {
                hashSet.add(iTypeBinding);
            }
            ++n;
        }
        return hashSet;
    }

    protected static IMethodBinding[] getRootDefs(IMethodBinding iMethodBinding) {
        Set set = FullConstraintCreator.getDeclaringSuperTypes(iMethodBinding);
        LinkedHashSet<IMethodBinding> linkedHashSet = new LinkedHashSet<IMethodBinding>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ITypeBinding iTypeBinding = (ITypeBinding)iterator.next();
            if (FullConstraintCreator.containsASuperType(iTypeBinding, set)) continue;
            linkedHashSet.add(FullConstraintCreator.findMethod(iMethodBinding, iTypeBinding));
        }
        if (linkedHashSet.size() == 0) {
            linkedHashSet.add(iMethodBinding);
        }
        return linkedHashSet.toArray(new IMethodBinding[linkedHashSet.size()]);
    }

    private static boolean containsASuperType(ITypeBinding iTypeBinding, Set set) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ITypeBinding iTypeBinding2 = (ITypeBinding)iterator.next();
            if (Bindings.equals((IBinding)iTypeBinding2, (IBinding)iTypeBinding) || !Bindings.isSuperType(iTypeBinding2, iTypeBinding)) continue;
            return true;
        }
        return false;
    }

    protected static Set getDeclaringSuperTypes(IMethodBinding iMethodBinding) {
        ITypeBinding iTypeBinding = iMethodBinding.getDeclaringClass();
        LinkedHashSet<ITypeBinding> linkedHashSet = new LinkedHashSet<ITypeBinding>();
        linkedHashSet.addAll(Arrays.asList(Bindings.getAllSuperTypes(iTypeBinding)));
        if (linkedHashSet.isEmpty()) {
            linkedHashSet.add(iMethodBinding.getDeclaringClass());
        }
        HashSet<ITypeBinding> hashSet = new HashSet<ITypeBinding>();
        Iterator iterator = linkedHashSet.iterator();
        while (iterator.hasNext()) {
            ITypeBinding iTypeBinding2 = (ITypeBinding)iterator.next();
            if (FullConstraintCreator.findMethod(iMethodBinding, iTypeBinding2) == null) continue;
            hashSet.add(iTypeBinding2);
        }
        return hashSet;
    }

    protected static IMethodBinding findMethod(IMethodBinding iMethodBinding, ITypeBinding iTypeBinding) {
        if (iMethodBinding.getDeclaringClass().equals((Object)iTypeBinding)) {
            return iMethodBinding;
        }
        return Bindings.findOverriddenMethodInType(iTypeBinding, iMethodBinding);
    }

    private static boolean isClassBinding(ITypeBinding iTypeBinding) {
        return iTypeBinding != null && iTypeBinding.isClass();
    }
}

