/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types;

import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.StandardType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TypeEnvironment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TypeTuple;

public abstract class HierarchyType
extends TType {
    private HierarchyType fSuperclass;
    private HierarchyType[] fInterfaces;
    private IType fJavaElementType;

    protected HierarchyType(TypeEnvironment typeEnvironment) {
        super(typeEnvironment);
    }

    protected void initialize(ITypeBinding iTypeBinding, IType iType) {
        super.initialize(iTypeBinding);
        Assert.isNotNull((Object)iType);
        this.fJavaElementType = iType;
        TypeEnvironment typeEnvironment = this.getEnvironment();
        ITypeBinding iTypeBinding2 = iTypeBinding.getSuperclass();
        if (iTypeBinding2 != null) {
            this.fSuperclass = (HierarchyType)typeEnvironment.create(iTypeBinding2);
        }
        ITypeBinding[] iTypeBindingArray = iTypeBinding.getInterfaces();
        this.fInterfaces = new HierarchyType[iTypeBindingArray.length];
        int n = 0;
        while (n < iTypeBindingArray.length) {
            this.fInterfaces[n] = (HierarchyType)typeEnvironment.create(iTypeBindingArray[n]);
            ++n;
        }
    }

    public TType getSuperclass() {
        return this.fSuperclass;
    }

    public TType[] getInterfaces() {
        return this.fInterfaces;
    }

    public IType getJavaElementType() {
        return this.fJavaElementType;
    }

    public boolean isSubType(HierarchyType hierarchyType) {
        if (this.getEnvironment() == hierarchyType.getEnvironment()) {
            TypeTuple typeTuple;
            Map map = this.getEnvironment().getSubTypeCache();
            Boolean bl = (Boolean)map.get(typeTuple = new TypeTuple(this, hierarchyType));
            if (bl != null) {
                return bl;
            }
            boolean bl2 = this.doIsSubType(hierarchyType);
            bl = bl2;
            map.put(typeTuple, bl);
            return bl2;
        }
        return this.doIsSubType(hierarchyType);
    }

    private boolean doIsSubType(HierarchyType hierarchyType) {
        if (this.fSuperclass != null && (hierarchyType.isTypeEquivalentTo(this.fSuperclass) || this.fSuperclass.doIsSubType(hierarchyType))) {
            return true;
        }
        int n = 0;
        while (n < this.fInterfaces.length) {
            if (hierarchyType.isTypeEquivalentTo(this.fInterfaces[n]) || this.fInterfaces[n].doIsSubType(hierarchyType)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected boolean canAssignToStandardType(StandardType standardType) {
        if (standardType.isJavaLangObject()) {
            return true;
        }
        return this.isSubType(standardType);
    }
}

