/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets;

import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.ArrayType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.EnumeratedTypeSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.SingletonTypeSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.SubTypesSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.TypeSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.TypeSetEnvironment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.TTypes;

public class SubTypesOfSingleton
extends TypeSet {
    private final TType fUpperBound;
    private EnumeratedTypeSet fEnumCache = null;

    protected SubTypesOfSingleton(TType tType, TypeSetEnvironment typeSetEnvironment) {
        super(typeSetEnvironment);
        Assert.isNotNull((Object)tType);
        this.fUpperBound = tType;
    }

    public boolean isUniverse() {
        return this.fUpperBound.equals(this.getJavaLangObject());
    }

    public TypeSet makeClone() {
        return this;
    }

    public TypeSet subTypes() {
        return this;
    }

    public TypeSet specialCasesIntersectedWith(TypeSet typeSet) {
        if (typeSet.isSingleton() && typeSet.anyMember().equals(this.fUpperBound)) {
            return typeSet;
        }
        if (typeSet instanceof SubTypesOfSingleton) {
            SubTypesOfSingleton subTypesOfSingleton = (SubTypesOfSingleton)typeSet;
            if (TTypes.canAssignTo(subTypesOfSingleton.fUpperBound, this.fUpperBound)) {
                return subTypesOfSingleton;
            }
            if (TTypes.canAssignTo(this.fUpperBound, subTypesOfSingleton.fUpperBound)) {
                return this;
            }
        } else if (typeSet.hasUniqueLowerBound()) {
            TType tType = typeSet.uniqueLowerBound();
            if (tType.equals(this.fUpperBound)) {
                return new SingletonTypeSet(this.fUpperBound, this.getTypeSetEnvironment());
            }
            if (tType != this.fUpperBound && TTypes.canAssignTo(this.fUpperBound, tType) || !TTypes.canAssignTo(tType, this.fUpperBound)) {
                return this.getTypeSetEnvironment().getEmptyTypeSet();
            }
        }
        return null;
    }

    public boolean isEmpty() {
        return false;
    }

    public TypeSet upperBound() {
        return new SingletonTypeSet(this.fUpperBound, this.getTypeSetEnvironment());
    }

    public TypeSet lowerBound() {
        EnumeratedTypeSet enumeratedTypeSet = this.enumerate();
        return enumeratedTypeSet.lowerBound();
    }

    public boolean hasUniqueLowerBound() {
        return false;
    }

    public boolean hasUniqueUpperBound() {
        return true;
    }

    public TType uniqueLowerBound() {
        TypeSet typeSet = this.lowerBound();
        return typeSet.anyMember();
    }

    public TType uniqueUpperBound() {
        return this.fUpperBound;
    }

    public boolean contains(TType tType) {
        if (tType.equals(this.fUpperBound)) {
            return true;
        }
        return TTypes.canAssignTo(tType, this.fUpperBound);
    }

    public boolean containsAll(TypeSet typeSet) {
        if (this.isUniverse()) {
            return true;
        }
        if (typeSet instanceof SubTypesOfSingleton) {
            SubTypesOfSingleton subTypesOfSingleton = (SubTypesOfSingleton)typeSet;
            return TTypes.canAssignTo(subTypesOfSingleton.fUpperBound, this.fUpperBound);
        }
        if (typeSet instanceof SubTypesSet) {
            SubTypesSet subTypesSet = (SubTypesSet)typeSet;
            TypeSet typeSet2 = subTypesSet.upperBound();
            Iterator iterator = typeSet2.iterator();
            while (iterator.hasNext()) {
                TType tType = (TType)iterator.next();
                if (TTypes.canAssignTo(tType, this.fUpperBound)) continue;
                return false;
            }
            return true;
        }
        Iterator iterator = typeSet.iterator();
        while (iterator.hasNext()) {
            TType tType = (TType)iterator.next();
            if (TTypes.canAssignTo(tType, this.fUpperBound)) continue;
            return false;
        }
        return true;
    }

    public Iterator iterator() {
        return this.enumerate().iterator();
    }

    private TType getElementTypeOf(TType tType) {
        if (tType instanceof ArrayType) {
            return ((ArrayType)tType).getElementType();
        }
        return tType;
    }

    public boolean isSingleton() {
        return this.getElementTypeOf(this.fUpperBound).getSubTypes().length == 0;
    }

    public TType anyMember() {
        return this.fUpperBound;
    }

    public EnumeratedTypeSet enumerate() {
        if (this.fEnumCache == null) {
            if (this.fUpperBound instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)this.fUpperBound;
                this.fEnumCache = EnumeratedTypeSet.makeArrayTypesForElements(TTypes.getAllSubTypesIterator(arrayType.getComponentType()), this.getTypeSetEnvironment());
            } else {
                this.fEnumCache = new EnumeratedTypeSet(TTypes.getAllSubTypesIterator(this.fUpperBound), this.getTypeSetEnvironment());
            }
            this.fEnumCache.add(this.fUpperBound);
            this.fEnumCache.initComplete();
        }
        return this.fEnumCache;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SubTypesOfSingleton)) {
            return false;
        }
        SubTypesOfSingleton subTypesOfSingleton = (SubTypesOfSingleton)object;
        return subTypesOfSingleton.fUpperBound.equals(this.fUpperBound);
    }

    public String toString() {
        return "<" + this.fID + ": subTypes(" + this.fUpperBound.getPrettySignature() + ")>";
    }
}

