/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.util;

import org.eclipse.core.runtime.Assert;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.ToolFactory;
import org.eclipse.wst.jsdt.core.compiler.IScanner;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;
import org.eclipse.wst.jsdt.internal.corext.dom.Selection;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;

public class CommentAnalyzer {
    private CommentAnalyzer() {
    }

    public static RefactoringStatus perform(Selection selection, IScanner iScanner, int n, int n2) {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        if (n2 <= 0) {
            return refactoringStatus;
        }
        new CommentAnalyzer().check(refactoringStatus, selection, iScanner, n, n + n2 - 1);
        return refactoringStatus;
    }

    private void check(RefactoringStatus refactoringStatus, Selection selection, IScanner iScanner, int n, int n2) {
        char[] cArray = iScanner.getSource();
        selection = this.adjustSelection(cArray, selection, n2);
        iScanner.resetTo(n, n2);
        int n3 = 0;
        try {
            block5: while (n3 != 158) {
                n3 = iScanner.getNextToken();
                switch (n3) {
                    case 1001: 
                    case 1002: 
                    case 1003: {
                        if (this.checkStart(iScanner, selection.getOffset())) {
                            refactoringStatus.addFatalError(RefactoringCoreMessages.CommentAnalyzer_starts_inside_comment);
                            break;
                        }
                        if (this.checkEnd(iScanner, selection.getInclusiveEnd())) {
                            refactoringStatus.addFatalError(RefactoringCoreMessages.CommentAnalyzer_ends_inside_comment);
                            break;
                        }
                    }
                    default: {
                        continue block5;
                    }
                }
                break;
            }
        }
        catch (InvalidInputException invalidInputException) {
            refactoringStatus.addFatalError(RefactoringCoreMessages.CommentAnalyzer_internal_error);
        }
    }

    private boolean checkStart(IScanner iScanner, int n) {
        return iScanner.getCurrentTokenStartPosition() < n && n <= iScanner.getCurrentTokenEndPosition();
    }

    private boolean checkEnd(IScanner iScanner, int n) {
        return iScanner.getCurrentTokenStartPosition() <= n && n < iScanner.getCurrentTokenEndPosition();
    }

    private Selection adjustSelection(char[] cArray, Selection selection, int n) {
        int n2 = selection.getInclusiveEnd();
        int n3 = selection.getExclusiveEnd();
        while (n3 <= n) {
            char c = cArray[n3];
            if (c != '\n' && c != '\r') break;
            ++n2;
            ++n3;
        }
        return Selection.createFromStartEnd(selection.getOffset(), n2);
    }

    public static String normalizeReference(String string) {
        IScanner iScanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        iScanner.setSource(string.toCharArray());
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n = iScanner.getNextToken();
            while (n != 158) {
                stringBuffer.append(iScanner.getRawTokenSource());
                n = iScanner.getNextToken();
            }
        }
        catch (InvalidInputException invalidInputException) {
            Assert.isTrue((boolean)false, (String)string);
        }
        string = stringBuffer.toString();
        return string;
    }
}

