/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.template.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.jsdt.core.CompletionProposal;
import org.eclipse.wst.jsdt.core.CompletionRequestor;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.ITypeParameter;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.internal.corext.template.java.SignatureUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;

final class CompilationUnitCompletion
extends CompletionRequestor {
    private ICompilationUnit fUnit;
    private List fLocalVariables = new ArrayList();
    private List fFields = new ArrayList();
    private Map fLocalTypes = new HashMap();
    private boolean fError;

    CompilationUnitCompletion(ICompilationUnit iCompilationUnit) {
        this.reset(iCompilationUnit);
        this.setIgnored(1, true);
        this.setIgnored(3, true);
        this.setIgnored(4, true);
        this.setIgnored(7, true);
        this.setIgnored(12, true);
        this.setIgnored(6, true);
        this.setIgnored(8, true);
        this.setIgnored(11, true);
        this.setIgnored(10, true);
        this.setIgnored(9, true);
    }

    private void reset(ICompilationUnit iCompilationUnit) {
        this.fUnit = iCompilationUnit;
        this.fLocalVariables.clear();
        this.fFields.clear();
        this.fLocalTypes.clear();
        if (this.fUnit != null) {
            try {
                IType[] iTypeArray = this.fUnit.getAllTypes();
                int n = 0;
                while (n < iTypeArray.length) {
                    String string = iTypeArray[n].getFullyQualifiedName();
                    String string2 = Signature.createTypeSignature((String)string, (boolean)true);
                    this.fLocalTypes.put(string2, iTypeArray[n].getElementName());
                    ++n;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        this.fError = false;
    }

    public void accept(CompletionProposal completionProposal) {
        String string = String.valueOf(completionProposal.getCompletion());
        String string2 = String.valueOf(completionProposal.getSignature());
        switch (completionProposal.getKind()) {
            case 5: {
                this.fLocalVariables.add(new Variable(string, string2));
                break;
            }
            case 2: {
                this.fFields.add(new Variable(string, string2));
                break;
            }
        }
    }

    public void completionFailure(IProblem iProblem) {
        this.fError = true;
    }

    public boolean hasErrors() {
        return this.fError;
    }

    public String[] getLocalVariableNames() {
        String[] stringArray = new String[this.fLocalVariables.size()];
        int n = 0;
        ListIterator listIterator = this.fLocalVariables.listIterator(this.fLocalVariables.size());
        while (listIterator.hasPrevious()) {
            Variable variable = (Variable)listIterator.previous();
            stringArray[n++] = variable.getName();
        }
        return stringArray;
    }

    public String[] getFieldNames() {
        String[] stringArray = new String[this.fFields.size()];
        int n = 0;
        ListIterator listIterator = this.fFields.listIterator(this.fFields.size());
        while (listIterator.hasPrevious()) {
            Variable variable = (Variable)listIterator.previous();
            stringArray[n++] = variable.getName();
        }
        return stringArray;
    }

    public Variable[] findLocalArrays() {
        ArrayList<Variable> arrayList = new ArrayList<Variable>();
        ListIterator listIterator = this.fLocalVariables.listIterator(this.fLocalVariables.size());
        while (listIterator.hasPrevious()) {
            Variable variable = (Variable)listIterator.previous();
            if (!variable.isArray()) continue;
            arrayList.add(variable);
        }
        return arrayList.toArray(new Variable[arrayList.size()]);
    }

    public Variable[] findLocalVariables(String string) {
        ArrayList<Variable> arrayList = new ArrayList<Variable>();
        ListIterator listIterator = this.fLocalVariables.listIterator(this.fLocalVariables.size());
        while (listIterator.hasPrevious()) {
            Variable variable = (Variable)listIterator.previous();
            if (!variable.isSubtypeOf(string)) continue;
            arrayList.add(variable);
        }
        return arrayList.toArray(new Variable[arrayList.size()]);
    }

    public Variable[] findFieldVariables(String string) {
        ArrayList<Variable> arrayList = new ArrayList<Variable>();
        ListIterator listIterator = this.fFields.listIterator(this.fFields.size());
        while (listIterator.hasPrevious()) {
            Variable variable = (Variable)listIterator.previous();
            if (!variable.isSubtypeOf(string)) continue;
            arrayList.add(variable);
        }
        return arrayList.toArray(new Variable[arrayList.size()]);
    }

    public Variable[] findLocalIterables() {
        ArrayList<Variable> arrayList = new ArrayList<Variable>();
        ListIterator listIterator = this.fLocalVariables.listIterator(this.fLocalVariables.size());
        while (listIterator.hasPrevious()) {
            Variable variable = (Variable)listIterator.previous();
            if (!variable.isArray() && !variable.isIterable()) continue;
            arrayList.add(variable);
        }
        return arrayList.toArray(new Variable[arrayList.size()]);
    }

    private final class TypeParameterResolver {
        private static final String OBJECT_SIGNATURE = "Ljava.lang.Object;";
        private final ITypeHierarchy fHierarchy;
        private final Variable fVariable;
        private final IType fType;
        private final List fBounds = new ArrayList();

        public TypeParameterResolver(Variable variable) throws JavaModelException {
            String string = SignatureUtil.stripSignatureToFQN(variable.signature);
            IJavaProject iJavaProject = CompilationUnitCompletion.this.fUnit.getJavaProject();
            this.fType = iJavaProject.findType(string);
            this.fHierarchy = this.fType.newSupertypeHierarchy(null);
            this.fVariable = variable;
        }

        public String[] computeBinding(String string, int n) throws JavaModelException, IndexOutOfBoundsException {
            IJavaProject iJavaProject = CompilationUnitCompletion.this.fUnit.getJavaProject();
            IType iType = iJavaProject.findType(string);
            if (iType == null) {
                throw new JavaModelException(new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, "No such type", null)));
            }
            return this.computeBinding(iType, n);
        }

        public String[] computeBinding(IType iType, int n) throws JavaModelException, IndexOutOfBoundsException {
            this.initBounds();
            this.computeTypeParameterBinding(iType, n);
            return this.fBounds.toArray(new String[this.fBounds.size()]);
        }

        private void computeTypeParameterBinding(IType iType, int n) throws JavaModelException, IndexOutOfBoundsException {
            int n2 = iType.getTypeParameters().length;
            if (n2 <= n) {
                throw new IndexOutOfBoundsException();
            }
            IType[] iTypeArray = this.fHierarchy.getSubtypes(iType);
            if (iTypeArray.length == 0) {
                Assert.isTrue((boolean)iType.equals(this.fType));
                String string = this.findMatchingTypeArgument(this.fVariable.signature, n, CompilationUnitCompletion.this.fUnit.findPrimaryType());
                String string2 = SignatureUtil.getUpperBound(string);
                this.addBound(string2);
                return;
            }
            IType iType2 = iTypeArray[0];
            String string = this.findMatchingSuperTypeSignature(iType2, iType);
            String string3 = this.findMatchingTypeArgument(string, n, iType2);
            if (this.isConcreteType(string3, iType2)) {
                this.addBound(string3);
                return;
            }
            ITypeParameter[] iTypeParameterArray = iType2.getTypeParameters();
            int n3 = 0;
            while (n3 < iTypeParameterArray.length) {
                ITypeParameter iTypeParameter = iTypeParameterArray[n3];
                if (iTypeParameter.getElementName().equals(SignatureUtil.stripSignatureToFQN(string3))) {
                    String[] stringArray = iTypeParameter.getBounds();
                    int n4 = 0;
                    while (n4 < stringArray.length) {
                        String string4 = Signature.createTypeSignature((String)stringArray[n4], (boolean)true);
                        this.addBound(SignatureUtil.qualifySignature(string4, iType2));
                        ++n4;
                    }
                    this.computeTypeParameterBinding(iType2, n3);
                    return;
                }
                ++n3;
            }
            this.addBound(string3);
        }

        private String findMatchingTypeArgument(String string, int n, IType iType) throws IndexOutOfBoundsException {
            String[] stringArray = Signature.getTypeArguments((String)string);
            if (stringArray.length > 0 && stringArray.length <= n) {
                throw new IndexOutOfBoundsException();
            }
            if (stringArray.length == 0) {
                return OBJECT_SIGNATURE;
            }
            String string2 = SignatureUtil.getUpperBound(stringArray[n]);
            return SignatureUtil.qualifySignature(string2, iType);
        }

        private String findMatchingSuperTypeSignature(IType iType, IType iType2) throws JavaModelException {
            String[] stringArray = this.getSuperTypeSignatures(iType, iType2);
            int n = 0;
            while (n < stringArray.length) {
                String string;
                String string2 = stringArray[n];
                String string3 = SignatureUtil.qualifySignature(string2, iType);
                String string4 = SignatureUtil.stripSignatureToFQN(string3);
                if (string4.equals(string = iType2.getFullyQualifiedName())) {
                    return string2;
                }
                if (CompilationUnitCompletion.this.fLocalTypes.containsValue(string4)) {
                    return string2;
                }
                ++n;
            }
            throw new JavaModelException(new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, "Illegal hierarchy", null)));
        }

        private String[] getSuperTypeSignatures(IType iType, IType iType2) throws JavaModelException {
            if (iType2.isInterface()) {
                return iType.getSuperInterfaceTypeSignatures();
            }
            return new String[]{iType.getSuperclassTypeSignature()};
        }

        private void initBounds() {
            this.fBounds.clear();
            this.fBounds.add(OBJECT_SIGNATURE);
        }

        private void addBound(String string) {
            if (SignatureUtil.isJavaLangObject(string)) {
                return;
            }
            boolean bl = false;
            ListIterator<String> listIterator = this.fBounds.listIterator();
            while (listIterator.hasNext()) {
                String string2 = (String)listIterator.next();
                if (!this.isTrueSubtypeOf(string, string2)) continue;
                if (!bl) {
                    listIterator.set(string);
                    bl = true;
                    continue;
                }
                listIterator.remove();
            }
            if (!bl) {
                this.fBounds.add(string);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean isTrueSubtypeOf(String string, String string2) {
            if (string.equals(string2)) {
                return true;
            }
            if (SignatureUtil.isJavaLangObject(string)) {
                return false;
            }
            if (Signature.getTypeSignatureKind((String)string) != 2 && SignatureUtil.isJavaLangObject(string2)) {
                return true;
            }
            IJavaProject iJavaProject = CompilationUnitCompletion.this.fUnit.getJavaProject();
            try {
                if ((Signature.getTypeSignatureKind((String)string) & 3) == 0) {
                    return false;
                }
                IType iType = iJavaProject.findType(SignatureUtil.stripSignatureToFQN(string));
                if (iType == null) {
                    return false;
                }
                if ((Signature.getTypeSignatureKind((String)string2) & 3) == 0) {
                    return false;
                }
                IType iType2 = iJavaProject.findType(SignatureUtil.stripSignatureToFQN(string2));
                if (iType2 == null) {
                    return false;
                }
                ITypeHierarchy iTypeHierarchy = iType.newSupertypeHierarchy(null);
                IType[] iTypeArray = iTypeHierarchy.getAllSupertypes(iType);
                int n = 0;
                while (true) {
                    if (n >= iTypeArray.length) {
                        return false;
                    }
                    if (iTypeArray[n].equals(iType2)) {
                        return true;
                    }
                    ++n;
                }
            }
            catch (JavaModelException javaModelException) {}
            return false;
        }

        private boolean isConcreteType(String string, IType iType) throws JavaModelException {
            if (3 == Signature.getTypeSignatureKind((String)string)) {
                return false;
            }
            if (iType.isBinary()) {
                return CompilationUnitCompletion.this.fUnit.getJavaProject().findType(SignatureUtil.stripSignatureToFQN(string)) != null;
            }
            return iType.resolveType(SignatureUtil.stripSignatureToFQN(string)) != null;
        }
    }

    public final class Variable {
        private static final int UNKNOWN = 0;
        private static final int NONE = 0;
        private static final int ARRAY = 1;
        private static final int COLLECTION = 2;
        private static final int ITERABLE = 4;
        private final String name;
        private final String signature;
        private int fType = 0;
        private int fChecked = 0;
        private String[] fMemberTypes;

        private Variable(String string, String string2) {
            this.name = string;
            this.signature = string2;
        }

        public String getName() {
            return this.name;
        }

        public boolean isArray() {
            if (this.fType == 0 && (this.fChecked & 1) == 0 && Signature.getTypeSignatureKind((String)this.signature) == 4) {
                this.fType = 1;
            }
            this.fChecked |= 1;
            return this.fType == 1;
        }

        public boolean isCollection() {
            if ((this.fType == 0 || this.fType == 4) && (this.fChecked & 2) == 0 && this.isSubtypeOf("java.util.Collection")) {
                this.fType = 2;
            }
            this.fChecked |= 2;
            return this.fType == 2;
        }

        public boolean isIterable() {
            if (this.fType == 0 && (this.fChecked & 4) == 0 && this.isSubtypeOf("java.lang.Iterable")) {
                this.fType = 4;
            }
            this.fChecked |= 4;
            return this.fType == 4 || this.fType == 2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean isSubtypeOf(String string) {
            String string2 = SignatureUtil.stripSignatureToFQN(this.signature);
            if (string2.length() == 0) {
                return false;
            }
            boolean bl = string.indexOf(46) != -1;
            if (string2.equals(string)) return true;
            if (!bl && Signature.getSimpleName((String)string2).equals(string)) {
                return true;
            }
            if (CompilationUnitCompletion.this.fUnit == null) {
                return false;
            }
            IJavaProject iJavaProject = CompilationUnitCompletion.this.fUnit.getJavaProject();
            try {
                IType iType = iJavaProject.findType(string2);
                if (iType == null) {
                    return false;
                }
                if (bl) {
                    IType iType2 = iJavaProject.findType(string);
                    if (iType2 == null) {
                        return false;
                    }
                    ITypeHierarchy iTypeHierarchy = iType.newSupertypeHierarchy(null);
                    return iTypeHierarchy.contains(iType2);
                }
                ITypeHierarchy iTypeHierarchy = iType.newSupertypeHierarchy(null);
                IType[] iTypeArray = iTypeHierarchy.getAllTypes();
                int n = 0;
                while (true) {
                    if (n >= iTypeArray.length) {
                        return false;
                    }
                    IType iType3 = iTypeArray[n];
                    if (iType3.getElementName().equals(string)) {
                        return true;
                    }
                    ++n;
                }
            }
            catch (JavaModelException javaModelException) {}
            return false;
        }

        private IType[] getSupertypes(String string) {
            boolean bl;
            IType[] iTypeArray = new IType[]{};
            String string2 = SignatureUtil.stripSignatureToFQN(this.signature);
            if (string2.length() == 0) {
                return iTypeArray;
            }
            boolean bl2 = bl = string.indexOf(46) != -1;
            if (CompilationUnitCompletion.this.fUnit == null) {
                return iTypeArray;
            }
            IJavaProject iJavaProject = CompilationUnitCompletion.this.fUnit.getJavaProject();
            try {
                IType iType = iJavaProject.findType(string2);
                if (iType == null) {
                    return iTypeArray;
                }
                if (bl) {
                    IType iType2 = iJavaProject.findType(string);
                    if (iType2 == null) {
                        return iTypeArray;
                    }
                    return new IType[]{iType2};
                }
                ITypeHierarchy iTypeHierarchy = iType.newSupertypeHierarchy(null);
                IType[] iTypeArray2 = iTypeHierarchy.getAllTypes();
                ArrayList<IType> arrayList = new ArrayList<IType>();
                int n = 0;
                while (n < iTypeArray2.length) {
                    IType iType3 = iTypeArray2[n];
                    if (iType3.getElementName().equals(string)) {
                        arrayList.add(iType3);
                    }
                    ++n;
                }
                return arrayList.toArray(new IType[arrayList.size()]);
            }
            catch (JavaModelException javaModelException) {
                return iTypeArray;
            }
        }

        public String getMemberTypeSignature() {
            return this.getMemberTypeSignatures()[0];
        }

        public String[] getMemberTypeSignatures() {
            if (this.isArray()) {
                return new String[]{Signature.createArraySignature((String)Signature.getElementType((String)this.signature), (int)(Signature.getArrayCount((String)this.signature) - 1))};
            }
            if (CompilationUnitCompletion.this.fUnit != null && (this.isIterable() || this.isCollection())) {
                if (this.fMemberTypes == null) {
                    try {
                        try {
                            TypeParameterResolver typeParameterResolver = new TypeParameterResolver(this);
                            this.fMemberTypes = typeParameterResolver.computeBinding("java.lang.Iterable", 0);
                        }
                        catch (JavaModelException javaModelException) {
                            try {
                                TypeParameterResolver typeParameterResolver = new TypeParameterResolver(this);
                                this.fMemberTypes = typeParameterResolver.computeBinding("java.util.Collection", 0);
                            }
                            catch (JavaModelException javaModelException2) {
                                this.fMemberTypes = new String[0];
                            }
                        }
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        this.fMemberTypes = new String[0];
                    }
                }
                if (this.fMemberTypes.length > 0) {
                    return this.fMemberTypes;
                }
            }
            return new String[]{Signature.createTypeSignature((String)"java.lang.Object", (boolean)true)};
        }

        public String[] getMemberTypeNames() {
            String[] stringArray = this.getMemberTypeSignatures();
            String[] stringArray2 = new String[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                String string2 = (String)CompilationUnitCompletion.this.fLocalTypes.get(Signature.getElementType((String)string));
                int n2 = Signature.getArrayCount((String)string);
                if (string2 != null && n2 > 0) {
                    StringBuffer stringBuffer = new StringBuffer(string2);
                    int n3 = 0;
                    while (n3 < n2) {
                        stringBuffer.append("[]");
                        ++n3;
                    }
                    string2 = stringBuffer.toString();
                }
                stringArray2[n] = string2 != null ? string2 : Signature.getSimpleName((String)Signature.getSignatureSimpleName((String)string));
                ++n;
            }
            return stringArray2;
        }

        public String[] getTypeArgumentBoundSignatures(String string, int n) {
            ArrayList<String> arrayList = new ArrayList<String>();
            IType[] iTypeArray = this.getSupertypes(string);
            if (CompilationUnitCompletion.this.fUnit != null) {
                int n2 = 0;
                while (n2 < iTypeArray.length) {
                    try {
                        TypeParameterResolver typeParameterResolver = new TypeParameterResolver(this);
                        String[] stringArray = typeParameterResolver.computeBinding(iTypeArray[n2].getFullyQualifiedName(), n);
                        arrayList.addAll(Arrays.asList(stringArray));
                    }
                    catch (JavaModelException javaModelException) {
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                    ++n2;
                }
            }
            if (arrayList.isEmpty()) {
                return new String[]{Signature.createTypeSignature((String)"java.lang.Object", (boolean)true)};
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }

        public String toString() {
            String string;
            switch (this.fType) {
                case 4: {
                    string = "ITERABLE";
                    break;
                }
                case 2: {
                    string = "COLLECTION";
                    break;
                }
                case 1: {
                    string = "ARRAY";
                    break;
                }
                default: {
                    string = "UNKNOWN";
                }
            }
            return "LocalVariable [name=\"" + this.name + "\" signature=\"" + this.signature + "\" type=\"" + string + "\" member=\"" + this.getMemberTypeSignature() + "\"]";
        }
    }
}

