/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.template.java;

import java.util.Arrays;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;

public final class SignatureUtil {
    private static final String NULL_TYPE_SIGNATURE = "Tnull;";
    private static final char[] NULL_TYPE_SIGNATURE_ARRAY = "Tnull;".toCharArray();
    private static final String OBJECT_SIGNATURE = "Ljava.lang.Object;";
    private static final char[] OBJECT_SIGNATURE_ARRAY = "Ljava.lang.Object;".toCharArray();

    private SignatureUtil() {
    }

    public static boolean isJavaLangObject(String string) {
        return OBJECT_SIGNATURE.equals(string);
    }

    public static String getUpperBound(String string) {
        return String.valueOf(SignatureUtil.getUpperBound(string.toCharArray()));
    }

    public static char[] getUpperBound(char[] cArray) {
        if (cArray.length < 1) {
            return cArray;
        }
        if (cArray[0] == '*') {
            return OBJECT_SIGNATURE_ARRAY;
        }
        int n = SignatureUtil.indexOf(cArray, '-');
        if (n == 0) {
            return OBJECT_SIGNATURE_ARRAY;
        }
        if (n != -1) {
            char c = cArray[n + 1];
            if (c == '*') {
                char[] cArray2 = new char[cArray.length - 1];
                System.arraycopy(cArray, 0, cArray2, 0, n);
                cArray2[n] = 42;
                System.arraycopy(cArray, n + 2, cArray2, n + 1, cArray.length - n - 2);
                return SignatureUtil.getUpperBound(cArray2);
            }
            if (c == '+') {
                int n2 = SignatureUtil.typeEnd(cArray, n + 1);
                char[] cArray3 = new char[cArray.length - (n2 - n - 1)];
                System.arraycopy(cArray, 0, cArray3, 0, n);
                cArray3[n] = 42;
                System.arraycopy(cArray, n2, cArray3, n + 1, cArray.length - n2);
                return SignatureUtil.getUpperBound(cArray3);
            }
        }
        if (cArray[0] == '+') {
            char[] cArray4 = new char[cArray.length - 1];
            System.arraycopy(cArray, 1, cArray4, 0, cArray.length - 1);
            return cArray4;
        }
        return cArray;
    }

    public static String getLowerBound(String string) {
        return String.valueOf(SignatureUtil.getLowerBound(string.toCharArray()));
    }

    public static char[] getLowerBound(char[] cArray) {
        char c;
        if (cArray.length < 1) {
            return cArray;
        }
        if (cArray.length == 1 && cArray[0] == '*') {
            return cArray;
        }
        int n = SignatureUtil.indexOf(cArray, '+');
        if (n == 0) {
            return NULL_TYPE_SIGNATURE_ARRAY;
        }
        if (n != -1 && ((c = cArray[n + 1]) == '*' || c == '+')) {
            return NULL_TYPE_SIGNATURE_ARRAY;
        }
        char[][] cArray2 = Signature.getTypeArguments((char[])cArray);
        int n2 = 0;
        while (n2 < cArray2.length) {
            if (Arrays.equals(cArray2[n2], NULL_TYPE_SIGNATURE_ARRAY)) {
                return NULL_TYPE_SIGNATURE_ARRAY;
            }
            ++n2;
        }
        if (cArray[0] == '-') {
            char[] cArray3 = new char[cArray.length - 1];
            System.arraycopy(cArray, 1, cArray3, 0, cArray.length - 1);
            return cArray3;
        }
        return cArray;
    }

    private static int indexOf(char[] cArray, char c) {
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] == c) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static String stripSignatureToFQN(String string) throws IllegalArgumentException {
        string = Signature.getTypeErasure((String)string);
        string = Signature.getElementType((String)string);
        return Signature.toString((String)string);
    }

    public static String qualifySignature(String string, IType iType) {
        Object object;
        if (iType == null) {
            return string;
        }
        String string2 = Signature.getSignatureQualifier((String)string);
        if (string2.length() > 0) {
            return string;
        }
        String string3 = Signature.getElementType((String)string);
        String string4 = Signature.getTypeErasure((String)string3);
        String string5 = Signature.getSignatureSimpleName((String)string4);
        String string6 = Signature.getSignatureSimpleName((String)string3);
        int n = Signature.getArrayCount((String)string);
        try {
            object = iType.resolveType(string5);
            if (object != null && ((String[][])object).length > 0) {
                string2 = object[0][0];
            }
        }
        catch (JavaModelException javaModelException) {}
        if (string2.length() == 0) {
            return string;
        }
        object = Signature.toQualifiedName((String[])new String[]{string2, string6});
        String string7 = Signature.createTypeSignature((String)object, (boolean)true);
        String string8 = Signature.createArraySignature((String)string7, (int)n);
        return string8;
    }

    public static char[] unboundedSignature(char[] cArray) {
        if (cArray == null || cArray.length < 2) {
            return cArray;
        }
        cArray = SignatureUtil.fix83600(cArray);
        StringBuffer stringBuffer = new StringBuffer("(");
        char[][] cArray2 = Signature.getParameterTypes((char[])cArray);
        int n = 0;
        while (n < cArray2.length) {
            char[] cArray3 = cArray2[n];
            stringBuffer.append(SignatureUtil.getLowerBound(cArray3));
            ++n;
        }
        stringBuffer.append(')');
        stringBuffer.append(SignatureUtil.getUpperBound(Signature.getReturnType((char[])cArray)));
        return stringBuffer.toString().toCharArray();
    }

    public static char[] fix83600(char[] cArray) {
        if (cArray == null || cArray.length < 2) {
            return cArray;
        }
        return Signature.removeCapture((char[])cArray);
    }

    private static int typeEnd(char[] cArray, int n) {
        int n2 = 0;
        while (n < cArray.length) {
            switch (cArray[n]) {
                case '<': {
                    ++n2;
                    break;
                }
                case '>': {
                    --n2;
                    break;
                }
                case ';': {
                    if (n2 != 0) break;
                    return n + 1;
                }
            }
            ++n;
        }
        return n + 1;
    }
}

