/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.template.java;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.wst.jsdt.internal.corext.template.java.JavaTemplateMessages;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TemplateSet {
    private static final String NAME_ATTRIBUTE = "name";
    private static final String DESCRIPTION_ATTRIBUTE = "description";
    private static final String CONTEXT_ATTRIBUTE = "context";
    private List fTemplates = new ArrayList();
    private String fTemplateTag;
    private static final int TEMPLATE_PARSE_EXCEPTION = 10002;
    private static final int TEMPLATE_IO_EXCEPTION = 10005;
    private ContextTypeRegistry fRegistry;

    public TemplateSet(String string, ContextTypeRegistry contextTypeRegistry) {
        this.fTemplateTag = string;
        this.fRegistry = contextTypeRegistry;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addFromFile(File file, boolean bl) throws CoreException {
        FileInputStream fileInputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(file);
                this.addFromStream(fileInputStream, bl);
            }
            catch (IOException iOException) {
                TemplateSet.throwReadException(iOException);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                if (fileInputStream == null) throw throwable;
                ((InputStream)fileInputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        if (fileInputStream == null) return;
        ((InputStream)fileInputStream).close();
    }

    public String getTemplateTag() {
        return this.fTemplateTag;
    }

    public void addFromStream(InputStream inputStream, boolean bl) throws CoreException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(inputStream));
            NodeList nodeList = document.getElementsByTagName(this.getTemplateTag());
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 != n) {
                Node node = nodeList.item(n2);
                NamedNodeMap namedNodeMap = node.getAttributes();
                if (namedNodeMap != null) {
                    String string = this.getAttributeValue(namedNodeMap, NAME_ATTRIBUTE);
                    String string2 = this.getAttributeValue(namedNodeMap, DESCRIPTION_ATTRIBUTE);
                    if (string != null && string2 != null) {
                        String string3;
                        String string4 = this.getAttributeValue(namedNodeMap, CONTEXT_ATTRIBUTE);
                        if (string == null || string2 == null || string4 == null) {
                            throw new SAXException(JavaTemplateMessages.TemplateSet_error_missing_attribute);
                        }
                        StringBuffer stringBuffer = new StringBuffer();
                        NodeList nodeList2 = node.getChildNodes();
                        int n3 = 0;
                        while (n3 != nodeList2.getLength()) {
                            string3 = nodeList2.item(n3).getNodeValue();
                            if (string3 != null) {
                                stringBuffer.append(string3);
                            }
                            ++n3;
                        }
                        String string5 = stringBuffer.toString().trim();
                        string3 = new Template(string, string2, string4, string5);
                        String string6 = this.validateTemplate((Template)string3);
                        if (string6 == null) {
                            if (!bl) {
                                Template[] templateArray = this.getTemplates(string);
                                int n4 = 0;
                                while (n4 < templateArray.length) {
                                    this.remove(templateArray[n4]);
                                    ++n4;
                                }
                            }
                            this.add((Template)string3);
                        } else {
                            TemplateSet.throwReadException(null);
                        }
                    }
                }
                ++n2;
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            TemplateSet.throwReadException(parserConfigurationException);
        }
        catch (IOException iOException) {
            TemplateSet.throwReadException(iOException);
        }
        catch (SAXException sAXException) {
            TemplateSet.throwReadException(sAXException);
        }
    }

    protected String validateTemplate(Template template) {
        TemplateContextType templateContextType = this.fRegistry.getContextType(template.getContextTypeId());
        if (templateContextType == null) {
            return "Unknown context type: " + template.getContextTypeId();
        }
        try {
            templateContextType.validate(template.getPattern());
            return null;
        }
        catch (TemplateException templateException) {
            return templateException.getMessage();
        }
    }

    private String getAttributeValue(NamedNodeMap namedNodeMap, String string) {
        Node node = namedNodeMap.getNamedItem(string);
        return node == null ? null : node.getNodeValue();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveToFile(File file) throws CoreException {
        FileOutputStream fileOutputStream = null;
        try {
            try {
                fileOutputStream = new FileOutputStream(file);
                this.saveToStream(fileOutputStream);
            }
            catch (IOException iOException) {
                TemplateSet.throwWriteException(iOException);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                if (fileOutputStream == null) throw throwable;
                ((OutputStream)fileOutputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        if (fileOutputStream == null) return;
        ((OutputStream)fileOutputStream).close();
    }

    public void saveToStream(OutputStream outputStream) throws CoreException {
        try {
            Object object;
            Object object2;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement("templates");
            document.appendChild(element);
            int n = 0;
            while (n != this.fTemplates.size()) {
                object2 = (Template)this.fTemplates.get(n);
                object = document.createElement(this.getTemplateTag());
                element.appendChild((Node)object);
                NamedNodeMap namedNodeMap = object.getAttributes();
                Attr attr = document.createAttribute(NAME_ATTRIBUTE);
                attr.setValue(object2.getName());
                namedNodeMap.setNamedItem(attr);
                Attr attr2 = document.createAttribute(DESCRIPTION_ATTRIBUTE);
                attr2.setValue(object2.getDescription());
                namedNodeMap.setNamedItem(attr2);
                Attr attr3 = document.createAttribute(CONTEXT_ATTRIBUTE);
                attr3.setValue(object2.getContextTypeId());
                namedNodeMap.setNamedItem(attr3);
                Text text = document.createTextNode(object2.getPattern());
                object.appendChild(text);
                ++n;
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            object2 = new DOMSource(document);
            object = new StreamResult(outputStream);
            transformer.transform((Source)object2, (Result)object);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            TemplateSet.throwWriteException(parserConfigurationException);
        }
        catch (TransformerException transformerException) {
            TemplateSet.throwWriteException(transformerException);
        }
    }

    private static void throwReadException(Throwable throwable) throws CoreException {
        int n = throwable instanceof SAXException ? 10002 : 10005;
        throw new CoreException((IStatus)new Status(4, "org.eclipse.jface.text", n, JavaTemplateMessages.TemplateSet_error_read, throwable));
    }

    private static void throwWriteException(Throwable throwable) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.jface.text", 10005, JavaTemplateMessages.TemplateSet_error_write, throwable));
    }

    public void add(Template template) {
        if (this.exists(template)) {
            return;
        }
        this.fTemplates.add(template);
    }

    private boolean exists(Template template) {
        Iterator iterator = this.fTemplates.iterator();
        while (iterator.hasNext()) {
            Template template2 = (Template)iterator.next();
            if (!template.equals((Object)template2)) continue;
            return true;
        }
        return false;
    }

    public void remove(Template template) {
        this.fTemplates.remove(template);
    }

    public void clear() {
        this.fTemplates.clear();
    }

    public Template[] getTemplates() {
        return this.fTemplates.toArray(new Template[this.fTemplates.size()]);
    }

    public Template[] getTemplates(String string) {
        ArrayList<Template> arrayList = new ArrayList<Template>();
        Iterator iterator = this.fTemplates.iterator();
        while (iterator.hasNext()) {
            Template template = (Template)iterator.next();
            if (!template.getName().equals(string)) continue;
            arrayList.add(template);
        }
        return arrayList.toArray(new Template[arrayList.size()]);
    }

    public Template getFirstTemplate(String string) {
        Iterator iterator = this.fTemplates.iterator();
        while (iterator.hasNext()) {
            Template template = (Template)iterator.next();
            if (!template.getName().equals(string)) continue;
            return template;
        }
        return null;
    }
}

