/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.util;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.Position;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.ToolFactory;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;

public class CodeFormatterUtil {
    public static String createIndentString(int n, IJavaProject iJavaProject) {
        Hashtable hashtable = iJavaProject != null ? iJavaProject.getOptions(true) : JavaCore.getOptions();
        return ToolFactory.createCodeFormatter((Map)hashtable).createIndentationString(n);
    }

    public static int getTabWidth(IJavaProject iJavaProject) {
        String string = "space".equals(CodeFormatterUtil.getCoreOption(iJavaProject, "org.eclipse.wst.jsdt.core.formatter.tabulation.char")) ? "org.eclipse.wst.jsdt.core.formatter.indentation.size" : "org.eclipse.wst.jsdt.core.formatter.tabulation.size";
        return CodeFormatterUtil.getCoreOption(iJavaProject, string, 4);
    }

    public static int getIndentWidth(IJavaProject iJavaProject) {
        String string = "mixed".equals(CodeFormatterUtil.getCoreOption(iJavaProject, "org.eclipse.wst.jsdt.core.formatter.tabulation.char")) ? "org.eclipse.wst.jsdt.core.formatter.indentation.size" : "org.eclipse.wst.jsdt.core.formatter.tabulation.size";
        return CodeFormatterUtil.getCoreOption(iJavaProject, string, 4);
    }

    private static String getCoreOption(IJavaProject iJavaProject, String string) {
        if (iJavaProject == null) {
            return JavaCore.getOption((String)string);
        }
        return iJavaProject.getOption(string, true);
    }

    private static int getCoreOption(IJavaProject iJavaProject, String string, int n) {
        try {
            return Integer.parseInt(CodeFormatterUtil.getCoreOption(iJavaProject, string));
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public static String format(int n, String string, int n2, int[] nArray, String string2, Map map) {
        return CodeFormatterUtil.format(n, string, 0, string.length(), n2, nArray, string2, map);
    }

    public static String format(int n, String string, int n2, int[] nArray, String string2, IJavaProject iJavaProject) {
        Map map = iJavaProject != null ? iJavaProject.getOptions(true) : null;
        return CodeFormatterUtil.format(n, string, 0, string.length(), n2, nArray, string2, map);
    }

    public static String format(int n, String string, int n2, int n3, int n4, int[] nArray, String string2, Map map) {
        TextEdit textEdit = CodeFormatterUtil.format2(n, string, n2, n3, n4, string2, map);
        if (textEdit == null) {
            return string.substring(n2, n2 + n3);
        }
        String string3 = CodeFormatterUtil.getOldAPICompatibleResult(string, textEdit, n4, nArray, string2, map);
        return string3.substring(n2, string3.length() - (string.length() - (n2 + n3)));
    }

    public static String format(ASTNode aSTNode, String string, int n, int[] nArray, String string2, Map map) {
        TextEdit textEdit = CodeFormatterUtil.format2(aSTNode, string, n, string2, map);
        if (textEdit == null) {
            return string;
        }
        return CodeFormatterUtil.getOldAPICompatibleResult(string, textEdit, n, nArray, string2, map);
    }

    private static String getOldAPICompatibleResult(String string, TextEdit textEdit, int n, int[] nArray, String string2, Map map) {
        Position[] positionArray = null;
        if (nArray != null) {
            positionArray = new Position[nArray.length];
            int n2 = 0;
            while (n2 < nArray.length) {
                positionArray[n2] = new Position(nArray[n2], 0);
                ++n2;
            }
        }
        String string3 = CodeFormatterUtil.evaluateFormatterEdit(string, textEdit, positionArray);
        if (nArray != null) {
            int n3 = 0;
            while (n3 < nArray.length) {
                Position position = positionArray[n3];
                nArray[n3] = position.getOffset();
                ++n3;
            }
        }
        return string3;
    }

    public static String evaluateFormatterEdit(String string, TextEdit textEdit, Position[] positionArray) {
        try {
            Document document = CodeFormatterUtil.createDocument(string, positionArray);
            textEdit.apply((IDocument)document, 0);
            if (positionArray != null) {
                int n = 0;
                while (n < positionArray.length) {
                    Assert.isTrue((!positionArray[n].isDeleted ? 1 : 0) != 0, (String)"Position got deleted");
                    ++n;
                }
            }
            return document.get();
        }
        catch (BadLocationException badLocationException) {
            JavaPlugin.log(badLocationException);
            Assert.isTrue((boolean)false, (String)("Formatter created edits with wrong positions: " + badLocationException.getMessage()));
            return null;
        }
    }

    public static TextEdit format2(int n, String string, int n2, int n3, int n4, String string2, Map map) {
        if (n2 < 0 || n3 < 0 || n2 + n3 > string.length()) {
            throw new IllegalArgumentException("offset or length outside of string. offset: " + n2 + ", length: " + n3 + ", string size: " + string.length());
        }
        return ToolFactory.createCodeFormatter((Map)map).format(n, string, n2, n3, n4, string2);
    }

    public static TextEdit format2(int n, String string, int n2, String string2, Map map) {
        return CodeFormatterUtil.format2(n, string, 0, string.length(), n2, string2, map);
    }

    public static TextEdit reformat(int n, String string, int n2, int n3, int n4, String string2, Map map) {
        if (n2 < 0 || n3 < 0 || n2 + n3 > string.length()) {
            throw new IllegalArgumentException("offset or length outside of string. offset: " + n2 + ", length: " + n3 + ", string size: " + string.length());
        }
        return ToolFactory.createCodeFormatter((Map)map, (int)ToolFactory.M_FORMAT_EXISTING).format(n, string, n2, n3, n4, string2);
    }

    public static TextEdit reformat(int n, String string, int n2, String string2, Map map) {
        return CodeFormatterUtil.reformat(n, string, 0, string.length(), n2, string2, map);
    }

    public static TextEdit format2(ASTNode aSTNode, String string, int n, String string2, Map map) {
        int n2;
        String string3 = "";
        String string4 = "";
        if (aSTNode instanceof Statement) {
            n2 = 2;
            if (aSTNode.getNodeType() == 49) {
                string3 = "switch(1) {";
                string4 = "}";
                n2 = 2;
            }
        } else if (aSTNode instanceof Expression && aSTNode.getNodeType() != 58) {
            n2 = 1;
        } else if (aSTNode instanceof BodyDeclaration) {
            n2 = 4;
        } else {
            switch (aSTNode.getNodeType()) {
                case 5: 
                case 39: 
                case 43: 
                case 74: 
                case 75: {
                    string4 = " x;";
                    n2 = 4;
                    break;
                }
                case 76: {
                    string3 = "A<";
                    string4 = "> x;";
                    n2 = 4;
                    break;
                }
                case 15: {
                    n2 = 8;
                    break;
                }
                case 44: 
                case 58: {
                    string4 = ";";
                    n2 = 2;
                    break;
                }
                case 59: {
                    string3 = "A ";
                    string4 = ";";
                    n2 = 2;
                    break;
                }
                case 26: 
                case 35: {
                    string4 = "\nclass A {}";
                    n2 = 8;
                    break;
                }
                case 29: {
                    string4 = "void foo();";
                    n2 = 4;
                    break;
                }
                case 12: {
                    string3 = "try {}";
                    n2 = 2;
                    break;
                }
                case 1: {
                    string3 = "new A()";
                    string4 = ";";
                    n2 = 2;
                    break;
                }
                case 80: {
                    string3 = "@Author(";
                    string4 = ") class x {}";
                    n2 = 8;
                    break;
                }
                case 100: {
                    string4 = " class x {}";
                    n2 = 8;
                    break;
                }
                case 73: {
                    string3 = "class X<";
                    string4 = "> {}";
                    n2 = 8;
                    break;
                }
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: {
                    return null;
                }
                default: {
                    return null;
                }
            }
        }
        String string5 = String.valueOf(string3) + string + string4;
        TextEdit textEdit = ToolFactory.createCodeFormatter((Map)map).format(n2, string5, string3.length(), string.length(), n, string2);
        if (string3.length() > 0) {
            textEdit = CodeFormatterUtil.shifEdit(textEdit, string3.length());
        }
        return textEdit;
    }

    private static TextEdit shifEdit(TextEdit textEdit, int n) {
        MultiTextEdit multiTextEdit;
        TextEdit[] textEditArray;
        if (textEdit instanceof ReplaceEdit) {
            textEditArray = (TextEdit[])textEdit;
            multiTextEdit = new ReplaceEdit(textEditArray.getOffset() - n, textEditArray.getLength(), textEditArray.getText());
        } else if (textEdit instanceof InsertEdit) {
            textEditArray = (InsertEdit)textEdit;
            multiTextEdit = new InsertEdit(textEditArray.getOffset() - n, textEditArray.getText());
        } else if (textEdit instanceof DeleteEdit) {
            textEditArray = (DeleteEdit)textEdit;
            multiTextEdit = new DeleteEdit(textEditArray.getOffset() - n, textEditArray.getLength());
        } else if (textEdit instanceof MultiTextEdit) {
            multiTextEdit = new MultiTextEdit();
        } else {
            return null;
        }
        textEditArray = textEdit.getChildren();
        int n2 = 0;
        while (n2 < textEditArray.length) {
            TextEdit textEdit2 = CodeFormatterUtil.shifEdit(textEditArray[n2], n);
            if (textEdit2 != null) {
                multiTextEdit.addChild(textEdit2);
            }
            ++n2;
        }
        return multiTextEdit;
    }

    private static Document createDocument(String string, Position[] positionArray) throws IllegalArgumentException {
        Document document;
        block5: {
            document = new Document(string);
            try {
                if (positionArray == null) break block5;
                document.addPositionCategory("myCategory");
                document.addPositionUpdater((IPositionUpdater)new DefaultPositionUpdater("myCategory"){

                    protected boolean notDeleted() {
                        if (this.fOffset < this.fPosition.offset && this.fPosition.offset + this.fPosition.length < this.fOffset + this.fLength) {
                            this.fPosition.offset = this.fOffset + this.fLength;
                            return false;
                        }
                        return true;
                    }
                });
                int n = 0;
                while (n < positionArray.length) {
                    try {
                        document.addPosition("myCategory", positionArray[n]);
                    }
                    catch (BadLocationException badLocationException) {
                        throw new IllegalArgumentException("Position outside of string. offset: " + positionArray[n].offset + ", length: " + positionArray[n].length + ", string size: " + string.length());
                    }
                    ++n;
                }
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
        }
        return document;
    }
}

