/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.jsdt.internal.corext.CorextMessages;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaUIException;
import org.eclipse.wst.jsdt.internal.ui.JavaUIStatus;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class History {
    private static final String DEFAULT_ROOT_NODE_NAME = "histroyRootNode";
    private static final String DEFAULT_INFO_NODE_NAME = "infoNode";
    private static final int MAX_HISTORY_SIZE = 60;
    private final Map fHistory = new LinkedHashMap(80, 0.75f, true){
        private static final long serialVersionUID = 1L;

        protected boolean removeEldestEntry(Map.Entry entry) {
            return this.size() > 60;
        }
    };
    private final Hashtable fPositions;
    private final String fFileName;
    private final String fRootNodeName;
    private final String fInfoNodeName;

    private static JavaUIException createException(Throwable throwable, String string) {
        return new JavaUIException(JavaUIStatus.createError(4, string, throwable));
    }

    public History(String string, String string2, String string3) {
        this.fFileName = string;
        this.fRootNodeName = string2;
        this.fInfoNodeName = string3;
        this.fPositions = new Hashtable(60);
    }

    public History(String string) {
        this(string, DEFAULT_ROOT_NODE_NAME, DEFAULT_INFO_NODE_NAME);
    }

    public synchronized void accessed(Object object) {
        this.fHistory.put(this.getKey(object), object);
        this.rebuildPositions();
    }

    public synchronized boolean contains(Object object) {
        return this.fHistory.containsKey(this.getKey(object));
    }

    public synchronized boolean containsKey(Object object) {
        return this.fHistory.containsKey(object);
    }

    public synchronized boolean isEmpty() {
        return this.fHistory.isEmpty();
    }

    public synchronized Object remove(Object object) {
        Object v = this.fHistory.remove(this.getKey(object));
        this.rebuildPositions();
        return v;
    }

    public synchronized Object removeKey(Object object) {
        Object v = this.fHistory.remove(object);
        this.rebuildPositions();
        return v;
    }

    public synchronized float getNormalizedPosition(Object object) {
        if (!this.containsKey(object)) {
            return 0.0f;
        }
        int n = (Integer)this.fPositions.get(object) + 1;
        return (float)n / (float)this.fHistory.size();
    }

    public synchronized int getPosition(Object object) {
        if (!this.containsKey(object)) {
            return -1;
        }
        return (Integer)this.fPositions.get(object);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void load() {
        IPath iPath = JavaPlugin.getDefault().getStateLocation().append(this.fFileName);
        File file = new File(iPath.toOSString());
        if (!file.exists()) return;
        InputStreamReader inputStreamReader = null;
        try {
            try {
                inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), "utf-8");
                this.load(new InputSource(inputStreamReader));
            }
            catch (IOException iOException) {
                JavaPlugin.log(iOException);
            }
            catch (CoreException coreException) {
                JavaPlugin.log(coreException);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            try {
                if (inputStreamReader == null) throw throwable;
                inputStreamReader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                JavaPlugin.log(iOException);
            }
            throw throwable;
        }
        {
            Object var5_8 = null;
        }
        try {}
        catch (IOException iOException) {
            JavaPlugin.log(iOException);
            return;
        }
        if (inputStreamReader == null) return;
        inputStreamReader.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void save() {
        IPath iPath = JavaPlugin.getDefault().getStateLocation().append(this.fFileName);
        File file = new File(iPath.toOSString());
        FileOutputStream fileOutputStream = null;
        try {
            try {
                fileOutputStream = new FileOutputStream(file);
                this.save(fileOutputStream);
            }
            catch (IOException iOException) {
                JavaPlugin.log(iOException);
            }
            catch (CoreException coreException) {
                JavaPlugin.log(coreException);
            }
            catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
                JavaPlugin.log(transformerFactoryConfigurationError);
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            try {
                if (fileOutputStream == null) throw throwable;
                ((OutputStream)fileOutputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {
                JavaPlugin.log(iOException);
            }
            throw throwable;
        }
        {
            Object var5_9 = null;
        }
        try {}
        catch (IOException iOException) {
            JavaPlugin.log(iOException);
            return;
        }
        if (fileOutputStream == null) return;
        ((OutputStream)fileOutputStream).close();
    }

    protected Set getKeys() {
        return this.fHistory.keySet();
    }

    protected Collection getValues() {
        return this.fHistory.values();
    }

    protected abstract void setAttributes(Object var1, Element var2);

    protected abstract Object createFromElement(Element var1);

    protected abstract Object getKey(Object var1);

    private void rebuildPositions() {
        this.fPositions.clear();
        Collection collection = this.fHistory.values();
        int n = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object v = iterator.next();
            this.fPositions.put(this.getKey(v), new Integer(n));
            ++n;
        }
    }

    private void load(InputSource inputSource) throws CoreException {
        Element element;
        Object object;
        try {
            object = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            element = ((DocumentBuilder)object).parse(inputSource).getDocumentElement();
        }
        catch (SAXException sAXException) {
            throw History.createException(sAXException, Messages.format(CorextMessages.History_error_read, this.fFileName));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw History.createException(parserConfigurationException, Messages.format(CorextMessages.History_error_read, this.fFileName));
        }
        catch (IOException iOException) {
            throw History.createException(iOException, Messages.format(CorextMessages.History_error_read, this.fFileName));
        }
        if (element == null) {
            return;
        }
        if (!element.getNodeName().equalsIgnoreCase(this.fRootNodeName)) {
            return;
        }
        object = element.getChildNodes();
        int n = object.getLength();
        int n2 = 0;
        while (n2 < n) {
            Object object2;
            Element element2;
            Node node = object.item(n2);
            if (node.getNodeType() == 1 && (element2 = (Element)node).getNodeName().equalsIgnoreCase(this.fInfoNodeName) && (object2 = this.createFromElement(element2)) != null) {
                this.fHistory.put(this.getKey(object2), object2);
            }
            ++n2;
        }
        this.rebuildPositions();
    }

    private void save(OutputStream outputStream) throws CoreException {
        try {
            Object object;
            Transformer transformer;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement(this.fRootNodeName);
            document.appendChild(element);
            Iterator iterator = this.getValues().iterator();
            while (iterator.hasNext()) {
                transformer = iterator.next();
                object = document.createElement(this.fInfoNodeName);
                this.setAttributes(transformer, (Element)object);
                element.appendChild((Node)object);
            }
            transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            object = new DOMSource(document);
            StreamResult streamResult = new StreamResult(outputStream);
            transformer.transform((Source)object, streamResult);
        }
        catch (TransformerException transformerException) {
            throw History.createException(transformerException, Messages.format(CorextMessages.History_error_serialize, this.fFileName));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw History.createException(parserConfigurationException, Messages.format(CorextMessages.History_error_serialize, this.fFileName));
        }
    }
}

