/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.util;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.formatter.IndentManipulation;
import org.eclipse.wst.jsdt.internal.corext.util.CodeFormatterUtil;

public class Strings {
    private Strings() {
    }

    public static boolean isLowerCase(char c) {
        return Character.toLowerCase(c) == c;
    }

    public static boolean startsWithIgnoreCase(String string, String string2) {
        int n;
        int n2 = string.length();
        if (n2 < (n = string2.length())) {
            return false;
        }
        int n3 = n - 1;
        while (n3 >= 0) {
            if (Character.toLowerCase(string2.charAt(n3)) != Character.toLowerCase(string.charAt(n3))) {
                return false;
            }
            --n3;
        }
        return true;
    }

    public static String removeNewLine(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string.indexOf(10, 0);
        while (n2 != -1) {
            stringBuffer.append(string.substring(n, n2));
            if (n < n2 && n2 != 0) {
                stringBuffer.append(' ');
            }
            n = n2 + 1;
            n2 = string.indexOf(10, n);
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    public static String[] convertIntoLines(String string) {
        try {
            DefaultLineTracker defaultLineTracker = new DefaultLineTracker();
            defaultLineTracker.set(string);
            int n = defaultLineTracker.getNumberOfLines();
            String[] stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                IRegion iRegion = defaultLineTracker.getLineInformation(n2);
                int n3 = iRegion.getOffset();
                stringArray[n2] = string.substring(n3, n3 + iRegion.getLength());
                ++n2;
            }
            return stringArray;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public static boolean containsOnlyWhitespaces(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (!Character.isWhitespace(string.charAt(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static String trimLeadingTabsAndSpaces(String string) {
        int n;
        int n2 = n = string.length();
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            if (!IndentManipulation.isIndentChar((char)c)) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        if (n2 == 0) {
            return string;
        }
        if (n2 == n) {
            return "";
        }
        return string.substring(n2);
    }

    public static String trimTrailingTabsAndSpaces(String string) {
        int n;
        int n2 = n = string.length();
        int n3 = n - 1;
        while (n3 >= 0) {
            char c = string.charAt(n3);
            if (!IndentManipulation.isIndentChar((char)c)) break;
            n2 = n3--;
        }
        if (n2 == n) {
            return string;
        }
        if (n2 == 0) {
            return "";
        }
        return string.substring(0, n2);
    }

    public static int computeIndentUnits(String string, IJavaProject iJavaProject) {
        return IndentManipulation.measureIndentUnits((CharSequence)string, (int)CodeFormatterUtil.getTabWidth(iJavaProject), (int)CodeFormatterUtil.getIndentWidth(iJavaProject));
    }

    public static int computeIndentUnits(String string, int n, int n2) {
        return IndentManipulation.measureIndentUnits((CharSequence)string, (int)n, (int)n2);
    }

    public static int measureIndentLength(CharSequence charSequence, int n) {
        return IndentManipulation.measureIndentInSpaces((CharSequence)charSequence, (int)n);
    }

    public static String trimIndent(String string, int n, IJavaProject iJavaProject) {
        return IndentManipulation.trimIndent((String)string, (int)n, (int)CodeFormatterUtil.getTabWidth(iJavaProject), (int)CodeFormatterUtil.getIndentWidth(iJavaProject));
    }

    public static String trimIndent(String string, int n, int n2, int n3) {
        return IndentManipulation.trimIndent((String)string, (int)n, (int)n2, (int)n3);
    }

    public static void trimIndentation(String[] stringArray, IJavaProject iJavaProject) {
        Strings.trimIndentation(stringArray, CodeFormatterUtil.getTabWidth(iJavaProject), CodeFormatterUtil.getIndentWidth(iJavaProject), true);
    }

    public static void trimIndentation(String[] stringArray, int n, int n2) {
        Strings.trimIndentation(stringArray, n, n2, true);
    }

    public static void trimIndentation(String[] stringArray, IJavaProject iJavaProject, boolean bl) {
        Strings.trimIndentation(stringArray, CodeFormatterUtil.getTabWidth(iJavaProject), CodeFormatterUtil.getIndentWidth(iJavaProject), bl);
    }

    public static void trimIndentation(String[] stringArray, int n, int n2, boolean bl) {
        String string;
        String[] stringArray2 = new String[stringArray.length];
        int n3 = Integer.MAX_VALUE;
        int n4 = bl ? 0 : 1;
        while (n4 < stringArray.length) {
            string = stringArray[n4];
            if (!Strings.containsOnlyWhitespaces(string)) {
                stringArray2[n4] = string;
                int n5 = Strings.computeIndentUnits(string, n, n2);
                if (n5 < n3) {
                    n3 = n5;
                }
            }
            ++n4;
        }
        if (n3 > 0) {
            n4 = bl ? 0 : 1;
            while (n4 < stringArray2.length) {
                String string2;
                int n6;
                string = stringArray2[n4];
                stringArray[n4] = string != null ? Strings.trimIndent(string, n3, n, n2) : ((n6 = Strings.computeIndentUnits(string2 = stringArray[n4], n, n2)) > n3 ? Strings.trimIndent(string2, n3, n, n2) : Strings.trimLeadingTabsAndSpaces(string2));
                ++n4;
            }
        }
    }

    public static String getIndentString(String string, IJavaProject iJavaProject) {
        return IndentManipulation.extractIndentString((String)string, (int)CodeFormatterUtil.getTabWidth(iJavaProject), (int)CodeFormatterUtil.getIndentWidth(iJavaProject));
    }

    public static String getIndentString(String string, int n, int n2) {
        return IndentManipulation.extractIndentString((String)string, (int)n, (int)n2);
    }

    public static String[] removeTrailingEmptyLines(String[] stringArray) {
        int n = Strings.findLastNonEmptyLineIndex(stringArray);
        String[] stringArray2 = new String[n + 1];
        int n2 = 0;
        while (n2 < stringArray2.length) {
            stringArray2[n2] = stringArray[n2];
            ++n2;
        }
        return stringArray2;
    }

    private static int findLastNonEmptyLineIndex(String[] stringArray) {
        int n = stringArray.length - 1;
        while (n >= 0) {
            if (!stringArray[n].trim().equals("")) {
                return n;
            }
            --n;
        }
        return -1;
    }

    public static String changeIndent(String string, int n, IJavaProject iJavaProject, String string2, String string3) {
        return IndentManipulation.changeIndent((String)string, (int)n, (int)CodeFormatterUtil.getTabWidth(iJavaProject), (int)CodeFormatterUtil.getIndentWidth(iJavaProject), (String)string2, (String)string3);
    }

    public static String changeIndent(String string, int n, int n2, int n3, String string2, String string3) {
        return IndentManipulation.changeIndent((String)string, (int)n, (int)n2, (int)n3, (String)string2, (String)string3);
    }

    public static String trimIndentation(String string, IJavaProject iJavaProject, boolean bl) {
        return Strings.trimIndentation(string, CodeFormatterUtil.getTabWidth(iJavaProject), CodeFormatterUtil.getIndentWidth(iJavaProject), bl);
    }

    public static String trimIndentation(String string, int n, int n2, boolean bl) {
        try {
            int n3;
            DefaultLineTracker defaultLineTracker = new DefaultLineTracker();
            defaultLineTracker.set(string);
            int n4 = defaultLineTracker.getNumberOfLines();
            if (n4 == 1) {
                return string;
            }
            String[] stringArray = new String[n4];
            int n5 = 0;
            while (n5 < n4) {
                IRegion iRegion = defaultLineTracker.getLineInformation(n5);
                n3 = iRegion.getOffset();
                stringArray[n5] = string.substring(n3, n3 + iRegion.getLength());
                ++n5;
            }
            Strings.trimIndentation(stringArray, n, n2, bl);
            StringBuffer stringBuffer = new StringBuffer();
            int n6 = n4 - 1;
            n3 = 0;
            while (n3 < n4) {
                stringBuffer.append(stringArray[n3]);
                if (n3 < n6) {
                    stringBuffer.append(defaultLineTracker.getLineDelimiter(n3));
                }
                ++n3;
            }
            return stringBuffer.toString();
        }
        catch (BadLocationException badLocationException) {
            Assert.isTrue((boolean)false, (String)"Can not happend");
            return null;
        }
    }

    public static String concatenate(String[] stringArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            if (n > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static boolean equals(String string, char[] cArray) {
        if (string.length() != cArray.length) {
            return false;
        }
        int n = cArray.length;
        while (--n >= 0) {
            if (string.charAt(n) == cArray[n]) continue;
            return false;
        }
        return true;
    }

    public static String removeTrailingCharacters(String string, char c) {
        int n;
        int n2 = n = string.length();
        int n3 = n - 1;
        while (n3 >= 0) {
            char c2 = string.charAt(n3);
            if (c2 != c) break;
            n2 = n3--;
        }
        if (n2 == n) {
            return string;
        }
        if (n2 == 0) {
            return "";
        }
        return string.substring(0, n2);
    }

    public static String removeMnemonicIndicator(String string) {
        return LegacyActionTools.removeMnemonics((String)string);
    }
}

