/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IParent;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public class JavaWorkbenchAdapter
implements IWorkbenchAdapter {
    protected static final Object[] NO_CHILDREN = new Object[0];
    private JavaElementImageProvider fImageProvider = new JavaElementImageProvider();

    public Object[] getChildren(Object object) {
        IJavaElement iJavaElement = this.getJavaElement(object);
        if (iJavaElement instanceof IParent) {
            try {
                return ((IParent)iJavaElement).getChildren();
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException);
            }
        }
        return NO_CHILDREN;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        IJavaElement iJavaElement = this.getJavaElement(object);
        if (iJavaElement != null) {
            return this.fImageProvider.getJavaImageDescriptor(iJavaElement, 3);
        }
        return null;
    }

    public String getLabel(Object object) {
        return JavaElementLabels.getTextLabel(this.getJavaElement(object), JavaElementLabels.ALL_DEFAULT);
    }

    public Object getParent(Object object) {
        IJavaElement iJavaElement = this.getJavaElement(object);
        return iJavaElement != null ? iJavaElement.getParent() : null;
    }

    private IJavaElement getJavaElement(Object object) {
        if (object instanceof IJavaElement) {
            return (IJavaElement)object;
        }
        if (object instanceof IClassFileEditorInput) {
            return ((IClassFileEditorInput)object).getClassFile().getPrimaryElement();
        }
        return null;
    }
}

