/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.actions;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;

public class ActionUtil {
    private ActionUtil() {
    }

    public static boolean mustDisableJavaModelAction(Shell shell, Object object) {
        if (!(object instanceof IPackageFragment) && !(object instanceof IPackageFragmentRoot)) {
            return false;
        }
        IResource iResource = ResourceUtil.getResource(object);
        if (iResource == null || !(iResource instanceof IFolder) || !iResource.isLinked()) {
            return false;
        }
        MessageDialog.openInformation((Shell)shell, (String)ActionMessages.ActionUtil_not_possible, (String)ActionMessages.ActionUtil_no_linked);
        return true;
    }

    public static boolean isProcessable(JavaEditor javaEditor) {
        if (javaEditor == null) {
            return true;
        }
        Shell shell = javaEditor.getSite().getShell();
        IJavaElement iJavaElement = SelectionConverter.getInput(javaEditor);
        if (iJavaElement == null) {
            MessageDialog.openInformation((Shell)shell, (String)ActionMessages.ActionUtil_notOnBuildPath_title, (String)ActionMessages.ActionUtil_notOnBuildPath_message);
            return false;
        }
        return ActionUtil.isProcessable(shell, iJavaElement);
    }

    public static boolean isProcessable(Shell shell, IJavaElement iJavaElement) {
        if (iJavaElement == null) {
            return true;
        }
        if (ActionUtil.isOnBuildPath(iJavaElement)) {
            return true;
        }
        MessageDialog.openInformation((Shell)shell, (String)ActionMessages.ActionUtil_notOnBuildPath_title, (String)ActionMessages.ActionUtil_notOnBuildPath_message);
        return false;
    }

    public static boolean isOnBuildPath(IJavaElement iJavaElement) {
        IProject iProject;
        block5: {
            if (iJavaElement.getElementType() == 2) {
                return true;
            }
            IJavaProject iJavaProject = iJavaElement.getJavaProject();
            try {
                iProject = iJavaProject.getProject();
                if (iProject != null) break block5;
                return false;
            }
            catch (CoreException coreException) {}
        }
        IProjectNature iProjectNature = iProject.getNature("org.eclipse.wst.jsdt.core.jsNature");
        if (iProjectNature != null) {
            return true;
        }
        return false;
    }

    public static boolean areProcessable(Shell shell, IJavaElement[] iJavaElementArray) {
        int n = 0;
        while (n < iJavaElementArray.length) {
            if (!ActionUtil.isOnBuildPath(iJavaElementArray[n])) {
                MessageDialog.openInformation((Shell)shell, (String)ActionMessages.ActionUtil_notOnBuildPath_title, (String)Messages.format(ActionMessages.ActionUtil_notOnBuildPath_resource_message, new Object[]{iJavaElementArray[n].getPath()}));
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean isEditable(JavaEditor javaEditor, Shell shell, IJavaElement iJavaElement) {
        if (javaEditor != null) {
            IJavaElement iJavaElement2 = SelectionConverter.getInput(javaEditor);
            if (iJavaElement2 != null && iJavaElement2.equals(iJavaElement.getAncestor(5))) {
                return ActionUtil.isEditable(javaEditor);
            }
            return ActionUtil.isEditable(javaEditor) && ActionUtil.isEditable(shell, iJavaElement);
        }
        return ActionUtil.isEditable(shell, iJavaElement);
    }

    public static boolean isEditable(JavaEditor javaEditor) {
        if (!ActionUtil.isProcessable(javaEditor)) {
            return false;
        }
        return javaEditor.validateEditorInputState();
    }

    public static boolean isEditable(Shell shell, IJavaElement iJavaElement) {
        IResource iResource;
        if (!ActionUtil.isProcessable(shell, iJavaElement)) {
            return false;
        }
        IJavaElement iJavaElement2 = iJavaElement.getAncestor(5);
        if (iJavaElement2 != null && (iResource = iJavaElement2.getResource()) != null && iResource.isDerived()) {
            IPreferenceStore iPreferenceStore = EditorsUI.getPreferenceStore();
            if (!iPreferenceStore.getBoolean("warn_if_input_derived")) {
                return true;
            }
            MessageDialogWithToggle messageDialogWithToggle = MessageDialogWithToggle.openYesNoQuestion((Shell)shell, (String)ActionMessages.ActionUtil_warning_derived_title, (String)Messages.format(ActionMessages.ActionUtil_warning_derived_message, iResource.getFullPath().toString()), (String)ActionMessages.ActionUtil_warning_derived_dontShowAgain, (boolean)false, null, null);
            EditorsUI.getPreferenceStore().setValue("warn_if_input_derived", !messageDialogWithToggle.getToggleState());
            return messageDialogWithToggle.getReturnCode() == 2;
        }
        return true;
    }
}

