/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.browsing.LogicalPackage;
import org.eclipse.wst.jsdt.internal.ui.fix.ICleanUp;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.util.ElementValidator;
import org.eclipse.wst.jsdt.ui.JavaUI;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public abstract class CleanUpAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public CleanUpAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
    }

    public CleanUpAction(JavaEditor javaEditor) {
        this((IWorkbenchSite)javaEditor.getEditorSite());
        this.fEditor = javaEditor;
        this.setEnabled(CleanUpAction.getCompilationUnit(this.fEditor) != null);
    }

    protected abstract String getActionName();

    protected abstract ICleanUp[] createCleanUps(ICompilationUnit[] var1);

    protected void performRefactoring(ICompilationUnit[] iCompilationUnitArray, ICleanUp[] iCleanUpArray) throws JavaModelException, InvocationTargetException {
        RefactoringExecutionStarter.startCleanupRefactoring(iCompilationUnitArray, iCleanUpArray, this.getShell(), false, this.getActionName());
    }

    public void run(ITextSelection iTextSelection) {
        ICompilationUnit iCompilationUnit = CleanUpAction.getCompilationUnit(this.fEditor);
        if (iCompilationUnit != null) {
            this.run(iCompilationUnit);
        }
    }

    public void run(IStructuredSelection iStructuredSelection) {
        ICompilationUnit[] iCompilationUnitArray = this.getCompilationUnits(iStructuredSelection);
        if (iCompilationUnitArray.length == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)this.getActionName(), (String)ActionMessages.CleanUpAction_EmptySelection_description);
        } else if (iCompilationUnitArray.length == 1) {
            this.run(iCompilationUnitArray[0]);
        } else {
            this.runOnMultiple(iCompilationUnitArray);
        }
    }

    public void selectionChanged(ITextSelection iTextSelection) {
        this.setEnabled(CleanUpAction.getCompilationUnit(this.fEditor) != null);
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        this.setEnabled(this.isEnabled(iStructuredSelection));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isEnabled(IStructuredSelection iStructuredSelection) {
        Object[] objectArray = iStructuredSelection.toArray();
        int n = 0;
        while (n < objectArray.length) {
            block13: {
                try {
                    if (objectArray[n] instanceof IJavaElement) {
                        IJavaElement iJavaElement = (IJavaElement)objectArray[n];
                        if (iJavaElement.exists()) {
                            switch (iJavaElement.getElementType()) {
                                case 7: {
                                    return iJavaElement.getParent().getElementType() == 5;
                                }
                                case 5: {
                                    return true;
                                }
                                case 12: {
                                    return true;
                                }
                                case 3: 
                                case 4: {
                                    IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)iJavaElement.getAncestor(3);
                                    return iPackageFragmentRoot.getKind() == 1;
                                }
                                case 2: {
                                    return true;
                                }
                            }
                        }
                        break block13;
                    }
                    if (objectArray[n] instanceof LogicalPackage) {
                        return true;
                    }
                }
                catch (JavaModelException javaModelException) {
                    if (javaModelException.isDoesNotExist()) break block13;
                    JavaPlugin.log(javaModelException);
                }
            }
            ++n;
        }
        return false;
    }

    private void run(ICompilationUnit iCompilationUnit) {
        if (!ActionUtil.isEditable(this.fEditor, this.getShell(), (IJavaElement)iCompilationUnit)) {
            return;
        }
        ICleanUp[] iCleanUpArray = this.createCleanUps(new ICompilationUnit[]{iCompilationUnit});
        if (iCleanUpArray == null) {
            return;
        }
        if (!ElementValidator.check((IJavaElement)iCompilationUnit, this.getShell(), this.getActionName(), this.fEditor != null)) {
            return;
        }
        try {
            this.performRefactoring(new ICompilationUnit[]{iCompilationUnit}, iCleanUpArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            JavaPlugin.log(invocationTargetException);
            if (invocationTargetException.getCause() instanceof CoreException) {
                this.showUnexpectedError((CoreException)invocationTargetException.getCause());
            }
        }
        catch (JavaModelException javaModelException) {
            this.showUnexpectedError((CoreException)((Object)javaModelException));
        }
    }

    private void runOnMultiple(ICompilationUnit[] iCompilationUnitArray) {
        ICleanUp[] iCleanUpArray = this.createCleanUps(iCompilationUnitArray);
        if (iCleanUpArray == null) {
            return;
        }
        MultiStatus multiStatus = new MultiStatus("org.eclipse.wst.jsdt.ui", 0, ActionMessages.CleanUpAction_MultiStateErrorTitle, null);
        int n = 0;
        while (n < iCompilationUnitArray.length) {
            ICompilationUnit iCompilationUnit = iCompilationUnitArray[n];
            if (!ActionUtil.isOnBuildPath((IJavaElement)iCompilationUnit)) {
                String string = iCompilationUnit.getPath().makeRelative().toString();
                String string2 = Messages.format(ActionMessages.CleanUpAction_CUNotOnBuildpathMessage, string);
                multiStatus.add((IStatus)new Status(1, "org.eclipse.wst.jsdt.ui", 4, string2, null));
            }
            ++n;
        }
        if (!multiStatus.isOK()) {
            ErrorDialog.openError((Shell)this.getShell(), (String)this.getActionName(), null, (IStatus)multiStatus);
            return;
        }
        try {
            this.performRefactoring(iCompilationUnitArray, iCleanUpArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            JavaPlugin.log(invocationTargetException);
            if (invocationTargetException.getCause() instanceof CoreException) {
                this.showUnexpectedError((CoreException)invocationTargetException.getCause());
            }
        }
        catch (JavaModelException javaModelException) {
            this.showUnexpectedError((CoreException)((Object)javaModelException));
        }
    }

    private void showUnexpectedError(CoreException coreException) {
        String string = Messages.format(ActionMessages.CleanUpAction_UnexpectedErrorMessage, coreException.getStatus().getMessage());
        Status status = new Status(4, "org.eclipse.wst.jsdt.ui", 4, string, null);
        ErrorDialog.openError((Shell)this.getShell(), (String)this.getActionName(), null, (IStatus)status);
    }

    public ICompilationUnit[] getCompilationUnits(IStructuredSelection iStructuredSelection) {
        HashSet<Object> hashSet = new HashSet<Object>();
        Object[] objectArray = iStructuredSelection.toArray();
        int n = 0;
        while (n < objectArray.length) {
            block17: {
                try {
                    IPackageFragment[] iPackageFragmentArray;
                    if (objectArray[n] instanceof IJavaElement) {
                        iPackageFragmentArray = (IPackageFragment[])objectArray[n];
                        if (!iPackageFragmentArray.exists()) break block17;
                        switch (iPackageFragmentArray.getElementType()) {
                            case 7: {
                                if (iPackageFragmentArray.getParent().getElementType() == 5) {
                                    hashSet.add(iPackageFragmentArray.getParent());
                                    break;
                                }
                                break block17;
                            }
                            case 5: {
                                hashSet.add(iPackageFragmentArray);
                                break;
                            }
                            case 12: {
                                hashSet.add(iPackageFragmentArray.getParent());
                                break;
                            }
                            case 4: {
                                this.collectCompilationUnits((IPackageFragment)iPackageFragmentArray, hashSet);
                                break;
                            }
                            case 3: {
                                this.collectCompilationUnits((IPackageFragmentRoot)iPackageFragmentArray, hashSet);
                                break;
                            }
                            case 2: {
                                IPackageFragmentRoot[] iPackageFragmentRootArray = ((IJavaProject)iPackageFragmentArray).getPackageFragmentRoots();
                                int n2 = 0;
                                while (n2 < iPackageFragmentRootArray.length) {
                                    this.collectCompilationUnits(iPackageFragmentRootArray[n2], hashSet);
                                    ++n2;
                                }
                                break block1;
                            }
                        }
                        break block17;
                    }
                    if (objectArray[n] instanceof LogicalPackage) {
                        iPackageFragmentArray = ((LogicalPackage)((Object)objectArray[n])).getFragments();
                        int n3 = 0;
                        while (n3 < iPackageFragmentArray.length) {
                            IPackageFragment iPackageFragment = iPackageFragmentArray[n3];
                            if (iPackageFragment.exists()) {
                                this.collectCompilationUnits(iPackageFragment, hashSet);
                            }
                            ++n3;
                        }
                    }
                }
                catch (JavaModelException javaModelException) {
                    if (!JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)javaModelException))) break block17;
                    JavaPlugin.log(javaModelException);
                }
            }
            ++n;
        }
        return hashSet.toArray(new ICompilationUnit[hashSet.size()]);
    }

    private void collectCompilationUnits(IPackageFragment iPackageFragment, Collection collection) throws JavaModelException {
        collection.addAll(Arrays.asList(iPackageFragment.getCompilationUnits()));
    }

    private void collectCompilationUnits(IPackageFragmentRoot iPackageFragmentRoot, Collection collection) throws JavaModelException {
        if (iPackageFragmentRoot.getKind() == 1) {
            IJavaElement[] iJavaElementArray = iPackageFragmentRoot.getChildren();
            int n = 0;
            while (n < iJavaElementArray.length) {
                this.collectCompilationUnits((IPackageFragment)iJavaElementArray[n], collection);
                ++n;
            }
        }
    }

    private static ICompilationUnit getCompilationUnit(JavaEditor javaEditor) {
        IJavaElement iJavaElement = JavaUI.getEditorInputJavaElement(javaEditor.getEditorInput());
        if (!(iJavaElement instanceof ICompilationUnit)) {
            return null;
        }
        return (ICompilationUnit)iJavaElement;
    }
}

