/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.actions;

import java.util.ResourceBundle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.ResourceAction;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.FoldingMessages;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;

public class FoldingActionGroup
extends ActionGroup {
    private ProjectionViewer fViewer;
    private final PreferenceAction fToggle;
    private final TextOperationAction fExpand;
    private final TextOperationAction fCollapse;
    private final TextOperationAction fExpandAll;
    private final IProjectionListener fProjectionListener;
    private final PreferenceAction fRestoreDefaults;
    private final FoldingAction fCollapseMembers;
    private final FoldingAction fCollapseComments;
    private final TextOperationAction fCollapseAll;
    static /* synthetic */ Class class$0;

    public FoldingActionGroup(final ITextEditor iTextEditor, ITextViewer iTextViewer) {
        if (!(iTextViewer instanceof ProjectionViewer)) {
            this.fToggle = null;
            this.fExpand = null;
            this.fCollapse = null;
            this.fExpandAll = null;
            this.fCollapseAll = null;
            this.fRestoreDefaults = null;
            this.fCollapseMembers = null;
            this.fCollapseComments = null;
            this.fProjectionListener = null;
            return;
        }
        this.fViewer = (ProjectionViewer)iTextViewer;
        this.fProjectionListener = new IProjectionListener(){

            public void projectionEnabled() {
                FoldingActionGroup.this.update();
            }

            public void projectionDisabled() {
                FoldingActionGroup.this.update();
            }
        };
        this.fViewer.addProjectionListener(this.fProjectionListener);
        this.fToggle = new PreferenceAction(FoldingMessages.getResourceBundle(), "Projection.Toggle.", 2){

            public void run() {
                IPreferenceStore iPreferenceStore;
                boolean bl = (iPreferenceStore = JavaPlugin.getDefault().getPreferenceStore()).getBoolean("editor_folding_enabled");
                iPreferenceStore.setValue("editor_folding_enabled", !bl);
            }

            public void update() {
                ITextOperationTarget iTextOperationTarget;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.jface.text.ITextOperationTarget");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                boolean bl = (iTextOperationTarget = (ITextOperationTarget)iTextEditor.getAdapter((Class)clazz)) != null && iTextOperationTarget.canDoOperation(19);
                this.setEnabled(bl);
            }
        };
        this.fToggle.setChecked(true);
        this.fToggle.setActionDefinitionId("org.eclipse.ui.edit.text.folding.toggle");
        iTextEditor.setAction("FoldingToggle", (IAction)this.fToggle);
        this.fExpandAll = new TextOperationAction(FoldingMessages.getResourceBundle(), "Projection.ExpandAll.", iTextEditor, 20, true);
        this.fExpandAll.setActionDefinitionId("org.eclipse.ui.edit.text.folding.expand_all");
        iTextEditor.setAction("FoldingExpandAll", (IAction)this.fExpandAll);
        this.fCollapseAll = new TextOperationAction(FoldingMessages.getResourceBundle(), "Projection.CollapseAll.", iTextEditor, 21, true);
        this.fCollapseAll.setActionDefinitionId("org.eclipse.ui.edit.text.folding.collapse_all");
        iTextEditor.setAction("FoldingCollapseAll", (IAction)this.fCollapseAll);
        this.fExpand = new TextOperationAction(FoldingMessages.getResourceBundle(), "Projection.Expand.", iTextEditor, 17, true);
        this.fExpand.setActionDefinitionId("org.eclipse.ui.edit.text.folding.expand");
        iTextEditor.setAction("FoldingExpand", (IAction)this.fExpand);
        this.fCollapse = new TextOperationAction(FoldingMessages.getResourceBundle(), "Projection.Collapse.", iTextEditor, 18, true);
        this.fCollapse.setActionDefinitionId("org.eclipse.ui.edit.text.folding.collapse");
        iTextEditor.setAction("FoldingCollapse", (IAction)this.fCollapse);
        this.fRestoreDefaults = new FoldingAction(FoldingMessages.getResourceBundle(), "Projection.Restore."){

            public void run() {
                if (iTextEditor instanceof JavaEditor) {
                    JavaEditor javaEditor = (JavaEditor)iTextEditor;
                    javaEditor.resetProjection();
                }
            }
        };
        this.fRestoreDefaults.setActionDefinitionId("org.eclipse.ui.edit.text.folding.restore");
        iTextEditor.setAction("FoldingRestore", (IAction)this.fRestoreDefaults);
        this.fCollapseMembers = new FoldingAction(FoldingMessages.getResourceBundle(), "Projection.CollapseMembers."){

            public void run() {
                if (iTextEditor instanceof JavaEditor) {
                    JavaEditor javaEditor = (JavaEditor)iTextEditor;
                    javaEditor.collapseMembers();
                }
            }
        };
        this.fCollapseMembers.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.folding.collapseMembers");
        iTextEditor.setAction("FoldingCollapseMembers", (IAction)this.fCollapseMembers);
        this.fCollapseComments = new FoldingAction(FoldingMessages.getResourceBundle(), "Projection.CollapseComments."){

            public void run() {
                if (iTextEditor instanceof JavaEditor) {
                    JavaEditor javaEditor = (JavaEditor)iTextEditor;
                    javaEditor.collapseComments();
                }
            }
        };
        this.fCollapseComments.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.folding.collapseComments");
        iTextEditor.setAction("FoldingCollapseComments", (IAction)this.fCollapseComments);
    }

    protected boolean isEnabled() {
        return this.fViewer != null;
    }

    public void dispose() {
        if (this.isEnabled()) {
            this.fViewer.removeProjectionListener(this.fProjectionListener);
            this.fViewer = null;
        }
        super.dispose();
    }

    protected void update() {
        if (this.isEnabled()) {
            this.fToggle.update();
            this.fToggle.setChecked(this.fViewer.isProjectionMode());
            this.fExpand.update();
            this.fExpandAll.update();
            this.fCollapse.update();
            this.fCollapseAll.update();
            this.fRestoreDefaults.update();
            this.fCollapseMembers.update();
            this.fCollapseComments.update();
        }
    }

    public void fillMenu(IMenuManager iMenuManager) {
        if (this.isEnabled()) {
            this.update();
            iMenuManager.add((IAction)this.fToggle);
            iMenuManager.add((IAction)this.fExpandAll);
            iMenuManager.add((IAction)this.fExpand);
            iMenuManager.add((IAction)this.fCollapse);
            iMenuManager.add((IAction)this.fCollapseAll);
            iMenuManager.add((IAction)this.fRestoreDefaults);
            iMenuManager.add((IAction)this.fCollapseMembers);
            iMenuManager.add((IAction)this.fCollapseComments);
        }
    }

    public void updateActionBars() {
        this.update();
    }

    private class FoldingAction
    extends PreferenceAction {
        FoldingAction(ResourceBundle resourceBundle, String string) {
            super(resourceBundle, string, 1);
        }

        public void update() {
            this.setEnabled(FoldingActionGroup.this.isEnabled() && FoldingActionGroup.this.fViewer.isProjectionMode());
        }
    }

    private static abstract class PreferenceAction
    extends ResourceAction
    implements IUpdate {
        PreferenceAction(ResourceBundle resourceBundle, String string, int n) {
            super(resourceBundle, string, n);
        }
    }
}

